 ;--------------------------------------------------------------------------
 ; The following section are modifiable values through DFCONFIG
 ;   Basically any size changes in this section have implications for
 ;   DFCONFIG.
 ;--------------------------------------------------------------------------

 MARKER        DB      "%(&#@)"                ;marker to locate attributes
 REV_CONTROL   DB      'D'    ;Rev control byte.  Tells DFCONFIG things

 C_NORMAL      DB      2                       ;dir text attribute
 C_INTENSE     DB      03h                     ;path name attribute
 C_MENU_ATT    DB      1EH                     ;menu text attribute
 C_BORDER      DB      10H                     ;menu border attribute
 C_INVERSE     DB      74H                     ;high-lighted dir entry
 c_menu2_attr  db	   17h

 SWITCH                DB      '/'
 STATUS_REG    DW      0FFH
 SORT_DEFAULT  DB      'N'
 VERIFY_DEFAULT DB	   'F'	;Maybe means don't change existing state
						;Yes means on, No means off; /V switch has priority
						;F means off except on copy to floppy
 SOUND_DEFAULT  DB	  0		;0 means standard DOS '07' services beep
						;1 means softer BIOS beep
 EXT_KYBD_FLAG  DB    2       ;1 use extended keyboard bios funcs, 0 don't
						;2 autosenses -- change to 0 or 1 by check_keyboard
 USE_EXT_MENUS      DB   1    ;0 LAlt=RAlt=Alt
                              ;  LCtrl=RCtrl=Ctrl
                              ;1 Distinguish
 INIT_VIDEO_MODE	DB	0	; 0 = 80x25; 1 = 80x43/50

 SEARCH_ATTRIB  DB   17H      ;what attrib files to display (10111b)
						;We use this to screen display -- but note that DOS
						;FIND_FIRST/FIND_NEXT functions don't actually screen
						;like you might expect.  Manual screening done
						;in READ_DIR
                              ;        Bit
                              ;76543210
                              ;       1      Read-only
                              ;      1       Hidden
                              ;     1        System
                              ;    1         Volume label
                              ;   1          Subdirectory
                              ;  1           Archive

 printer_port  db      9      ;0 = LPT1, 1=LPT2, 2=LPT3, 9=PRN
 m_vertical    Db      5
               db      0
 mouse_on      db      1      ;set to 0 to deactivate mouse
 SORT_UP_FLAG  DB     01100b  ;1 if descending order sort, 0 if ascending order
                              ;bit 0: Name
                              ;    1: Extension
                              ;    2: Size
                              ;    3: Date
                              ;    4: Attribute
 no_cfg        db      0      ;make 1 to bypass all cfg file stuff
 mem_swap      db      0b      ;Controls memory swap options
                              ;bit 0: 0 if try to use XMS
                              ;bit 1: 0 if try to use EMS
                              ;bit 2: 0 if try to use conventional memory
                              ;bit 3: 0 if try to use disk (reserved)
 VIEW_FLAGS    DB      WRAP_BIT ;=1 (make 0 for no initial wrap w/ internal viewer)
 save_mouse_state  db  0      ;1 to save/restore mouse driver state
      ;does double-duty after initialization of indicating whether the
      ;save was successful
 use_logical   db      0      ;0 = default.  Use logical drives (less A&B) if
                              ;              drive table not filled in
                              ;1 = don't
 bypass_si     db      1      ;if =1, bypass select portions of sysinfo
 PAD_CHARS db   5
 dos_override  db      0h      ;1 to override pre-DOS 3 error message
 hw_reset      db      0h      ;1 to force mouse hardware reset rather than s/w
 lowercase_dir db      0h      ;1 for lowercase filenames
 seconds_show  db      0h      ;1 to show seconds on time display
 intl_use      db      0h      ;code TBD
 videopage     db      0FFh     ;video page to use
 SubtreeDel    db      1h      ;1 to allow subtree deletion
 CopyOverWarn  db      0h      ;1 to warn on copy,forced move overwrites
 SecSortOff    db      0h      ;1 to turn off "intelligent" secondary sorts
 nobadkey      db      0h      ;1 to not beep on invalid keystrokes
 siset         db      0b     ;used to shut off some sysinfo settings
                               ;bit 0 = 1
                               ;  Prevent test which require the use of protected
                               ;  mode instructions, which might not be handled
                               ;  correctly V86 mode.

 ;reserved space for key choices
 BLANKS        DB      20 DUP(0) ;for future expansion w/o messing up DFCONFIG

 KeyDefines    db      20 DUP(0)

; this shouldn't really be in the user area, but removing them caused
; all sorts of problems not all of which I was able to track down.
; in the end, just easier to leave and adjust config accordingly

 LIST_CMD_LINE DB  0,'/C ',100 DUP(' '),13  ;command line entered
 LENGTH_CMD    EQU $-LIST_CMD_LINE-1
 VIEWER_LINE   DB  'l ~                               ',0
 VIEWER_LINE_SEC DB  'show ~                            ',0

 UFUNC_LINE label byte
                DB 'pkzip -ao @%z `                   ',0
                DB 'q ~                               ',0
                DB 'arj e ~                           ',0
                DB 'pkunzip ~                         ',0
                DB 'nd ~                              ',0
                DB 'fv ~                              ',0
                DB 'copy ~ %p\`.%e                    ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0

 VIEW2_LINE     DB 'ar ~                              ',0
 VIEW3_LINE     DB 'vpic ~                            ',0
 VIEW4_LINE     DB 'zr ~                              ',0
 VIEW5_LINE     DB 'zor ~                             ',0
 VIEW6_LINE     DB 'lr ~                              ',0
 VIEW7_LINE     DB '                                  ',0
 VIEW8_LINE     DB '                                  ',0
 VIEW9_LINE     DB '                                  ',0
 VIEW10_LINE    DB '                                  ',0
 VIEW11_LINE    DB '                                  ',0
 VIEW12_LINE    DB '                                  ',0
 VIEW13_LINE    DB '                                  ',0
 VIEW14_LINE    DB '                                  ',0
 VIEW15_LINE    DB '                                  ',0
 VIEW16_LINE    DB '                                  ',0
 VIEW17_LINE    DB '                                  ',0
 VIEW18_LINE    DB '                                  ',0
 VIEW19_LINE    DB '                                  ',0
 VIEW20_LINE    DB '                                  ',0
 VIEW21_LINE    DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB '                                  ',0
                DB ' '
 VIEW2_EXT      db 'ARJ        ',0
 VIEW3_EXT      db 'GIF PCX    ',0
 VIEW4_EXT      db 'ZIP QW?    ',0
 VIEW5_EXT      db 'ZOO        ',0
 VIEW6_EXT      db 'LZH        ',0
 VIEW7_EXT      db '           ',0
 VIEW8_EXT      db '           ',0
 VIEW9_EXT      db '           ',0
 VIEW10_EXT     db '           ',0
 VIEW11_EXT     db '           ',0
 VIEW12_EXT     db '           ',0
 VIEW13_EXT     db '           ',0
 VIEW14_EXT     db '           ',0
 VIEW15_EXT     db '           ',0
 VIEW16_EXT     db '           ',0
 VIEW17_EXT     db '           ',0
 VIEW18_EXT     db '           ',0
 VIEW19_EXT     db '           ',0
 VIEW20_EXT     db '           ',0
 VIEW21_EXT     db '           ',0
                db '           ',0
                db '           ',0
                db '           ',0
                db '           ',0
                db '           ',0
                db '           ',0
                db '           ',0
                db '           ',0
                db '           ',0
                db '           ',0

 VEXT_LEN      EQU     11              ;length of stored extension for viewers


 ; Status variables for functions
 ;      (numbered from low bit)
 ; bit 0
 ;	0 do not pause before return to DF
 ;   1 pause
 ; bit 1
 ;   0 do not read directory on return to DF
 ;   1 read directory
 ; bit 2
 ;   0 Act on highlighted file only -- ignore marks
 ;   1 Act on marked files only -- sequentially
 ;

 FUNC_STAT label byte
               DB 1
               DB 1
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 1
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0
               DB 0


 VIEW2_STAT  db     0
 VIEW3_STAT  db     0
 VIEW4_STAT  db     0
 VIEW5_STAT  db     0
 VIEW6_STAT  db     0
 VIEW7_STAT  db     0
 VIEW8_STAT  db     0
 VIEW9_STAT  db     0
 VIEW10_STAT  db     0b
 VIEW11_STAT  db     0
 VIEW12_STAT  db     0
 VIEW13_STAT  db     0
 VIEW14_STAT  db     0
 VIEW15_STAT  db     0
 VIEW16_STAT  db     0
 VIEW17_STAT  db     0
 VIEW18_STAT  db     0
 VIEW19_STAT  db     0
 VIEW20_STAT  db     0
 VIEW21_STAT  db     0b
              DB 0
              DB 0
              DB 0
              DB 0
              DB 0
              DB 0
              DB 0
              DB 0
              DB 0
              DB 0

 drive_table   db '                          ',0  ;table for cursor key drives
 drive_exclude db '                          ',0  ;table of drive letters to exclude
 zip_temp      db "DFZIP998    ",0
 ReturnPath1   db 'acd                               ',0
 ReturnPath2   db '                                  ',0


;Main menus moved here DF 5.00 to allow full menu modifications
;*****************************************************************

 MENU_STRT     EQU     49 CROW 2
 LOGO  DB  "   Directory Freedom    "
 MENU_WIDTH    EQU     $ - OFFSET LOGO
       DB  "      Version 5.001    "
       DB  " Copr. Gordon Haff 1995 "
 LOGO_ROWS     EQU     ($ - OFFSET LOGO)/MENU_WIDTH

 MENU1  LABEL  BYTE
       DB  " F1   Copy              "
       DB  " F2   Delete            "
       DB  " F3   Move              "
       DB  " F4   Rename            "
       DB  " F5   Clear marks       "
       DB  " F6   Mark remainder    "
       DB  " F7   Swap Mark/Unmark  "
       DB  " F8   Swap Source/Target"
       DB  " F9   Change Source     "
       DB  " F10  Change Target     "
       DB  " F11  Re-Mark files     "
       DB  " F12  Secondary Viewer  "
       DB  "       Ctl-Z  Help      "
       DB  "  Esc or Ctl-Q to Exit  "
 MENU1_ROWS    EQU     ($ - OFFSET MENU1)/MENU_WIDTH
 MENU_ROWS     EQU     3 + LOGO_ROWS + MENU1_ROWS

 BEG_DOS               EQU          (2+MENU_ROWS) * 100h
 BEG_WINDOW    EQU     47 + (2+MENU_ROWS) * 100h              ;

 ;This is a Left-CTRL key menu

 LCTRL_MENU  LABEL  BYTE
       DB  " F1   Edit (Qedit)      "
       DB  " F2   Extract ARJ       "
       DB  " F3   Extract ZIP       "
       DB  " F4   Name -> Date      "
       DB  " F5   Archive View      "
       DB  " F6   Test......        "
       DB  " F7   These definitions "
       DB  " F8   are examples only "
       DB  " F9   and require other "
       DB  " F10  software to work  "
       DB  " F11  Left Control      "
       DB  " F12                    "
       DB  " Sort down: N,E,D,S,T,O "
       DB  " Del attribute: A,R,H,Y "

 ;This is the Right-Control key menu

 RCTRL_MENU  LABEL  BYTE
       DB  " F1   User defined      "
       DB  " F2   User defined      "
       DB  " F3   User defined      "
       DB  " F4   User defined      "
       DB  " F5   User defined      "
       DB  " F6   User defined      "
       DB  " F7   User defined      "
       DB  " F8   User defined      "
       DB  " F9   User defined      "
       DB  " F10  User defined      "
       DB  " F11  User defined      "
       DB  " F12  User defined      "
       DB  " Right Control          "
       DB  "                        "

 ;This is the Left-Shift key menu

 LSHIFT_MENU  LABEL  BYTE
       DB  " F1   User defined      "
       DB  " F2   User defined      "
       DB  " F3   User defined      "
       DB  " F4   User defined      "
       DB  " F5   User defined      "
       DB  " F6   User defined      "
       DB  " F7   User defined      "
       DB  " F8   User defined      "
       DB  " F9   User defined      "
       DB  " F10  User defined      "
       DB  " F11  User defined      "
       DB  " F12  User defined      "
       DB  "                        "
       DB  " Left Shift             "

  ;This is a Right-Shift key menu

 RSHIFT_MENU  LABEL  BYTE
       DB  " F1   User defined      "
       DB  " F2   User defined      "
       DB  " F3   User defined      "
       DB  " F4   User defined      "
       DB  " F5   User defined      "
       DB  " F6   User defined      "
       DB  "      Right Shift       "
       DB  "                        "
       DB  "                        "
       DB  " F10  Create Archive 2  "
       DB  " F11  User defined      "
       DB  " F12  User defined      "
       DB  "    DF is Shareware.    "
       DB  "    $25 registration    "


 ;This is a LALT key menu

 LALT_MENU  LABEL  BYTE
       DB  " F1   Protected Copy    "
       DB  " F2   DOS Shell         "
       DB  " F3   Forced Move       "
       DB  " F4   Refresh           "
       DB  " F5   Run Program     LA"
       DB  " F6   Create Dir        "
       DB  " F7   System Info       "
       DB  " F8   Swap Video Mode   "
       DB  " F9   Edit Date/Time    "
       DB  " F10  Create Archive    "
       DB  " F11  Edit Volume Name  "
       DB  " F12  Print File List   "
       DB  "  Sort Up: N,E,D,S,T,O  "
       DB  " Add attribute: A,R,H,Y "

 ;This is the Right-Alt key menu

 RALT_MENU  LABEL  BYTE
       DB  " F1   User defined      "
       DB  " F2   User defined      "
       DB  " F3   User defined      "
       DB  " F4   User defined      "
       DB  " F5   User defined      "
       DB  " F6   User defined      "
       DB  " F7   User defined      "
       DB  " F8   User defined      "
       DB  " F9   User defined      "
       DB  " F10  User defined      "
       DB  " F11  User defined      "
       DB  " F12  User defined      "
       DB  "                        "
       DB  "Right Alt               "

 ;string constants and screen locations

 ENTRY_CUR     EQU     47 + (3 + MENU_ROWS) * 100h
 PROMPT_LOC    EQU     47 CROW (2 + MENU_ROWS)
 PROMPT_LOC2   EQU     47 CROW (3 + MENU_ROWS)
 PROMPT_LOC3   EQU     47 CROW (4 + MENU_ROWS)
 PROMPT_LOC2_RC  EQU	(3 + MENU_ROWS)*100h + 47
 PROMPT_LOC3_RC  EQU	(4 + MENU_ROWS)*100h + 47

;***************************************************************************

;below is the help screen.  DONT'T mess with the length of the lines (including
;the top 5 -- which aren't user modifiable) unless you plan to change DFCONFIG
;as well!
prog_name db   'Directory Freedom     Version 5.00   ',0
full_copr db   'Copyright 1995 Gordon Haff and Bit Masons Consulting.  All Rights Reserved. ',0
address   db   '2403 Main Street, Lancaster MA 01523.    http://www.channel1.com/users/ghaff',0
help1	db	' ',0
help2     db   ' DF d:\source-path\mask d:\dest-path /O,N,E,D,T,S[+/-] /F /V /M[0,C,P,T]    ',0
help3     db   '                                                                            ',0
help4     db   ' SORT OPTIONS         MISCELLANEOUS COMMANDS           TO MARK FILES        ',0
help5     db   ' ----------------     ------------------------------   -------------------- ',0
help6     db   ' N  Name              ^C  Copy (F1)                    <+> or <Ins>  Mark   ',0
help7     db   ' E  Extension         ^M  Move (F3)                    <-> or <Del>  Unmark ',0
help8     db   ' D  Date              ^F  Toggle files-only display    Space         Toggle ',0
help9     db   ' S  Size              ^L  Edit volume name (@F11)                           ',0
help10    db   ' T  Attribute         ^P  Print directory  (@F12)      TO CHANGE DRIVES     ',0
help11    db   ' O  DOS (Unsorted)    ^B  Secondary viewer (F12)       -------------------- ',0
help12    db   '                       [  Make Source Dir = Target     Use Left and Right   ',0
help13    db   '                       ]  Make Target Dir = Source      cursor (arrow) keys ',0
help14    db   ' FILE ATTRIBUTES                                                            ',0
help15    db   ' ----------------     FILE VIEWERS                     TO EXIT              ',0
help16    db   ' A  Archive           ------------------------------   -------------------- ',0
help17    db   ' R  Read-only         Enter or ^V uses a SmartViewer   <Esc> to original    ',0
help18    db   ' Y  System            <Enter> or ^Enter uses default   ^Q to source         ',0
help19    db   ' H  Hidden             viewer (internal or defined)                         ',0
help20    db   '                                                                            ',0
help21    db   '   @ <Alt> or <Left-Shift>     ^ <Ctrl>     <> Grey key (on numeric keypad) ',0
help22    db   '   Directory Freedom is Shareware. ($25)  Thank you if you have registered. ',0

include dfdiskey.asm

USER_LENGTH = $-MARKER

;------------------------------------------------------------------------------
; End of modifiable section
;------------------------------------------------------------------------------