INCLUDE DFSA.INC
INCLUDE DFMACROS.asm

;program equates:
 nul   equ     00h
 tab   equ     09h
 cr    equ     0dh
 lf    equ     0ah
 space equ     20h
 hyphen equ    '-'

;equates for sharing modes (MS-DOS function 3Dh)
;added DF 4.60 because of possible SHARE conflicts -- though this shouldn't
;be the issue, it seems to work
 FULLACCESSPERMITTED equ 01000000b  ;read only/deny none


 ;macro equate to calculate position in display memory
 CROW  EQU     * 2 + 2 * 80 *

 SCR_WIDTH	EQU	80
 NUM_VIEWERS   EQU  30        ;number of supplementary (extension specific) viewers

 DOSINT                EQU     21h
 COPY_MARK     EQU     26
 ZIP_MARK     EQU     29
 MEMNEEDED     EQU  2000H ; 128K NEEDED TO RUN PROGRAM

 ALT_SHIFT     EQU     08H
 CTRL_SHIFT    EQU     04H
 LSHIFT_SHIFT  EQU     02H
 RSHIFT_SHIFT	EQU	   01H

 NAME_MASK     EQU     01B
 EXT_MASK      EQU     010B
 SIZE_MASK     EQU     0100B
 DATE_MASK     EQU     01000B
 ATTR_MASK     EQU     010000B

 ROW1          EQU     2
 ROW_LEN       EQU     0 CROW 1
 BAR_START     EQU     1 + 1 CROW ROW1

 WHERE_LOC     EQU     14      ;col to display current location in view
 WHERE_LEN     EQU     08      ;col's allocated


 ;     locations of data within DTA after FIND_FIRST
 F_ATTR                EQU     21
 F_TIME                EQU     22
 F_DATE                EQU     24
 F_SIZE                EQU     26
 F_NAME                EQU     30

 DIR_RECORD    STRUC
       D_MRK   DB      ?
       D_NAME  DB      8 DUP (?)
               DB      ?
       D_EXT   DB      3 DUP (?)
               DB      ?
       D_SIZE  DB      8 DUP (?)
               DB      ?,?
       D_DATE  DB      8 DUP (?)
               DB      ?,?
       D_TIME  DB      6 DUP (?)
               DB      3 DUP (?)
;       D_TIME  DB      6 DUP(?)
       D_HID   DB      ?
       D_SYS   DB      ?
       D_RO    DB      ?
       D_ARC   DB      ?
               DB      2 DUP (?)
 DIR_RECORD    ENDS

 FIELD_SIZE    EQU     1 + D_ARC - D_MRK
 BAR_LEN               EQU     D_HID - D_NAME


;Masks for mem_swap
     XMS_MASK  EQU    01b
     EMS_MASK  EQU    010b
     CONV_MASK EQU    0100b

NOWARN UNI
 DUMMY_SEG     SEGMENT AT 1000H
               ORG 00H
 PAGES         DW      7F0h DUP (?)    ;table of screen page sizes
 FILE_BUFF     DB      ?

               ORG     0FFF0H
 END_BUFF      DW      0       ;dummy place holder
 READ_SIZE     EQU     ((END_BUFF - FILE_BUFF)/2) AND 0F800h

 FILE_PTR      DW      ?
               DW      ?
 FILE_END      DW      ?
 LAST_PAGE     DW      ?
 LAST_COL      DW      ?
 ROW           DB      ?
 DUMMY_SEG     ENDS
WARN UNI


 _TEXT SEGMENT word PUBLIC 'CODE'
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT

 ;
	  ORG	0
 seg_org		EQU	   $

       ORG     2
 PSP_TOP_MEM   LABEL   WORD            ;last paragraph of available mem
       ORG     6
 PSP_TOP_SEG   LABEL   WORD
       ORG     2Ch
 PSP_ENV_SEG   LABEL   WORD

       ORG     5CH
 PSP_FCB       DB      ?

       ORG     80H
 CMD_LINE      LABEL   BYTE
 DTA           LABEL   BYTE

 SUBTTL Data area
 page
       ORG     100H
 START:        JMP     MAIN

 COMMAND_LINE_MAX  EQU  34

;***************************************************************************
;***************************************************************************

 INCLUDE DFUSERD.ASM

;Protected User Data Section included here
;***************************************************************************
;***************************************************************************



 NORMAL                DB      07H
 INTENSE               DB      0FH
 MENU_ATT      DB      07H
 BORDER                DB      0FH
 INVERSE               DB      70H
 COLORS                EQU     $ - OFFSET NORMAL
 BAR_ATTRIBUTE DB      70H
 ORIG_ATT      DB      ?                       ;original screen attribute

 DISPLAY_BIT   EQU     80H
 WRAP_BIT      EQU     1
 ASCII_BIT     EQU     2

 BLANK_BIT     EQU     4       ;comment out this line to eliminate this option

 STAR_MASK     DB      0FFH
; VIEW_FLAGS    DB      0
 OPTIONS               DB      ' WA'
 ifdef BLANK_BIT
               DB      'B'
 endif
 OPTIONS_LEN   EQU     $ - OPTIONS

 N_SEGS                DB      ?
 SEG_COUNT     DB      ?
 MEM_BUF_SEG   DW      0F000H
 DIR_BUF_SEG   DW      ?

 FUNCTION      DB      0               ;flag byte to identify function request
 COPY_BIT      EQU     1               ;read/write file
 DELETE_BIT    EQU     2               ;delete file (may follow a move)
 MOVE_BIT      EQU     4               ;across dir move via rename
 RENAME_BIT    EQU     8               ;simple rename
 PROTECT_BIT   EQU     10H             ;check if file already exists on dest
 DIR_OK_BIT    EQU     20H             ;allow function on directory
 HID_OK_BIT    EQU     40H             ;allow function on hidden file
 UPD_CNT_BIT   EQU     80H             ;force update of bytes free display

 VERIFY_STAT   DB      0           ;saves entry condition of verify flag
 VERIFY_STAT_FL DB	   0		     ;saves in-program condition of verify
							;flag do can be turned on for floppy writes
 BREAK_STAT    DB      0
 SORT_LEN      DB      12
 SORT_OPT      DB      "NESDTO"
 SORT_OPT_CNT  EQU     $ - SORT_OPT
               EVEN
 ;table contains offset of field to be sorted within file info field and
 ; length of the relevant info
 SORT_TABLE    DW      1200h           ;name
               DW      309h            ;extension
               DW      800h + 13       ;size
               DW      29              ;date
               DW      400h + 39       ;attribute
               DW      -1              ;no sort
 SORT_TABLE_END        EQU     $ - 2
 SORT_OFFSET   DW      0               ;start of field on which to sort
 SORT_INDEX    DW      0               ;index into SORT_TABLE of chosen sort

 CURSOR_TYPE   DW      ?
 VIDEO_SEG     DW      0B000H

 CUR_OFFSET    DW      ?               ;ptr to first entry on displayed page
 CUR_FILE      DW      ?               ;GET_NAME returned ptr to dir record
 END_OFFSET    DW      ?
 DIR_DISP_END  DW      ?
 LINE          DW      ?
 COUNT         DW      ?
 MARK_CNT      DW      ?
 SEARCH_COUNT  DW      ?
 FILE_CNT      DW      ?
 FILENAME_END  DW      ?
 READ_HANDLE   DW      ?
 WRITE_HANDLE  DW      ?
 SOURCE_ATTRIB DW      ?
 TARGET_ATTRIB DW      ?
 SIZE_LOW      DW      ?
 SIZE_HIGH     DW      ?
 SOURCE_TIME   DW      ?
 SOURCE_DATE   DW      ?
 FILE_NAME     DW      ?
 WORK_BYTES_FREE DW    ?
               DW      ?
 WORK_CLUSTER  DW      ?
 DEST_BYTES_FREE DW    ?
               DW      ?
 DEST_CLUSTER  DW      ?
 TARG_BYTES_FREE       DW      ?
               DW      ?
 TARG_CLUSTER  DW      ?
 MARK_BYTES    DW      ?
               DW      ?
 MARK_BYTES_FD DW      ?
               DW      ?
 ENTRY_COUNT		DW	?
 SUB_BYTES_COUNT	DW	?
				DW	?

 CURRENT_MARK  DB   COPY_MARK

 FD_CLUSTER    EQU      400H   ;size of floppy cluster (1024 bytes)
               ;changed from 512 bytes in DF 4.50


 STK_SEG               DW      ?               ;original SS contents for CALL_DOS
 STK_PTR               DW      ?               ;original SP contents for CALL_DOS
 DOS_LINE      DB      ?,' '            ;command tail for CALL_DOS
 ENV_SEG               DW      ?               ;segment containing environment block
 COM_VAR               DB      'COMSPEC=',0    ;environment variable to match
       ;Parameter block for CALL_DOS
 PAR_BLK               DW      0               ;Use parent's environment
               DW      OFFSET DOS_LINE ;Point to empty command tail
 OFFDOSLINE    DW      ?
               DW      4 DUP (0FFh)    ;FCP pointers (dummies!)


INCLUDE DFDISTAB.ASM    ;Dispatch function table
                        ;keys are at end of user-modifiable area

even
COMP_FUNCS label word
       DW comp1,comp2,comp3,comp4,comp5

 CTRL_PRESSED  DB ?                     ;for attribute functions - flag to indicate CTRL or ALT
 ;rshift_pressed db  ?
 ;lshift_pressed db ?
 ATTR_BYTE_VAL  DW ?                     ;value of attribute location

 COMSPEC       DB  'COMSPEC=',0
 ENVIRONMENT   DW  ?
 CMD_LINE_PTR  DD  ?
 STACK_SEG     DW  ?
 STACK_PTR     DW  ?
 LIST_FLAG     DW  0
 MENU_STATUS   DW  0   ;Menu state flag =0 for main menu, 1 for ALT_Menu
 param1_msg       DB  'Enter parameters (',17,196,217,' for none)',0
 param2_msg	   db  'Enter archive filename:',0
 ent_volume_msg   db  'Enter new Volume (',17,196,217,' to accept)',0
 doing_zip	   db  0		;Flag that the zip operation being performed
 BS	       DB  8,32,8,0
 LEN_SOURCE    DW  ?


 ENV_ERR_MSG   DB  "Function key not defined",0
 UNALLOC_ERR   DB  0DH,0AH,'DF requires 64K free memory',0DH,0AH,'press a key...$'
 BAD_EXEC_MSG  DB  205,205,16,' Insufficient memory - press a key ',17,205,205,0
 RET_TO_DF_MSG DB  205,205,16,' PRESS ANY KEY TO RETURN TO DF ',17,205,205,0
 OVERRUN_MSG   DB  'Command line overrun',0
 EXEC_ERROR    DB  0
 BAR_COLOR     DB  4FH


 ;error messages
 NOT_ENOUGH    DB  "Requires 128K free RAM",13,10,"$"
 TOO_MANY      DB  "Too many files$"
 NO_COMSPEC    DB  "No COMSPEC variable in environment",13,10
			DB  "Full instructions are given in the manual.  You require a",13,10
			DB  "line such as SET COMSPEC=C:\COMMAND.COM in your AUTOEXEC.BAT file",13,10,13,10,"$"
 PRESS_A_KEY	DB	".... Press a key to Continue ....",13,10,"$"
 BAD_CFG_FILE  DB   "Specified configuration file seems invalid",13,10,"$"
 MISS_CFG_FILE DB   "Specified configuration file not found",13,10,"$"
 WRONG_DOS     DB   "Requires DOS 3.0 or later",13,10,"$"
 BAD_MEMORY    DB  "Fatal memory allocation/deallocation error",13,10,"$"

 ;main menu
 ;Graphics border characters:
 GB_TL         EQU     201     ;Top left
 GB_TH         EQU     205     ;Top horizontal
 GB_TR         EQU     187     ;Top right
 GB_L_TEE      EQU     199     ;Left Tee
 GB_R_TEE      EQU     182     ;Right Tee
 GB_MH         EQU     196     ;Middle line horizontal
 GB_BL         EQU     200     ;Bottom left
 GB_BR         EQU     188     ;Bottom right
 GB_BH         EQU     205     ;Bottom Horizontal;
 GB_V          EQU     186     ;Vertical border



 TOO_MANY_FILES  DB        "Too many files.  List truncated.",0
 INVALID               DB  "Error: Invalid drive or directory",0
 LOAD_SORT_MSG DB  "Loading and "
 SORT_MSG      DB  "Sorting directory.",0
 LOAD_SORT_LOC EQU  (40 - ($-LOAD_SORT_MSG)/2) CROW 12
 SORT_LOC      EQU  PROMPT_LOC+8
 LOAD_MSG      DB  "Loading directory.",0
 LOAD_LOC      EQU  (40 - ($-LOAD_MSG)/2) CROW 12

 DIRECTORY     DB  "Dir of Source ",0
 DIRECT_LOC    EQU 2 CROW 0

 VOL_NAME      DB  "Volume: "
;space shifted slightly 4.61
 VOL_INS       DB  11 DUP(space)
 W_FREE        DB  12 DUP (space)
               DB  " bytes free",0
 FILES_LOC     dw   2 CROW 22
;this and other bottom location variables are not adjusted by video_init
;on non-EGA/VGA systems.  1 col indent added 4.60 to be like EGA/VGA

 DEST_MSG      DB  "Target ",0                 ;line up paths 4.0
 DEST_LOC      EQU  9 CROW 1

 DEST_FREE     DB  "Target disk has   "
 D_FREE                DB  13 DUP(space)
               DB  " bytes free",0
 D_FREE_LOC     dw 2 CROW 23

 SUBDIR_MSG      DB ""
 SUB_ENTRY_LOC        DB 4 DUP(space)
			  DB " of "
 SUB_TOTAL_LOC        DB 4 DUP(space)
                 DB "."
 SUB_BYTES_LOC        DB 12 DUP(space)
			  DB " bytes/"
 FILES           DB 4 DUP(space)
			  DB " files",0
 SUBDIR_LOC    dw   2 CROW 24

 BYTES_MRKD_MSG        DB 11 DUP(space)
               DB " Bytes in"
 FILES_MRKD_MSG        DB  4 DUP(space)
               DB  " "
               DB  " files",0
 MARKED_MSG    DB  "Marked files",0
 MARKED_LOC    EQU 48 CROW 24
 MARKED_WIN    EQU 47 + 24 * 100h
 BYTES_SIZE_MSG        DB 11 DUP(space)
               DB " Bytes in"
 FILES_SIZE_MSG        DB  4 DUP(space)
               DB  " "
 SIZE_MSG_1    DB  "files",0
 SIZE_LOC      EQU 48 CROW 23
 SIZE_LOC_2    EQU 50 CROW 24
 FLOPPY_SIZE_MSG  DB 11 DUP (space)
			DB " Bytes on floppy",0

 DELETE_MSG    DB  " will be deleted.",0
               DB  "Do you wish to delete?  Y/N",0
 DDIR_MSG		DB  "Do you wish to delete dir?  Y/N",0
 NODIR_COPY	db	"Destination not directory.",0
			db	"Do you wish to continue? Y/N",0
 FMOVE_MSG	DB  "F-Move ",0
 PCOPY_MSG     DB  "P-"
 COPY_MSG      DB  "Copy ",0
 MOVE_MSG      DB  "Move ",0
 RENAME_MSG    DB  "Rename ",0
 CD_MSG                DB  "Change directory",0
 CHDEST_MSG    DB  "Change default destination",0
 TO_MSG                DB  " to...",0
			DB  "\"
 FILE_MASK	DB  "*.*",10 DUP(0)
 STAR_DOT_STAR DB  "*.*",0
 DIRECTORIES   DB  "<DIR>"
 CREATE_DIR_MSG DB	"  New Dir name: ",0
 NO_DRAW_FLAG	DB  0    ;set flag to 1 to skip screen draw routines
				    ;used by some of the directory routines
 CLR_MSG_FLAG DB  0
 SIZE_FLAG 	DB	0			;set to 1 if doing subdir size func
 NO_DDIR_FLAG	DB	0
 ABORT_DELETE_FLAG	DB	0
 DIR_CONF_FLAG DB	0
 FILE_NAME_BUFF	DB	13 DUP(0)
 SAVED_LINE	DW	?
 BIOS_KYBD_00  DB   0    ;Used with ext_kybd_flag, int 16h func 00 used if extended funcs not wanted
 BIOS_KYBD_01  DB   1    ; ditto function 01 or 11h
 MAX_PARAM	EQU  32
 PARAM_LENGTH	dw	?
 PATH_LENGTH_MSG DB "Path length is"
			  DB 3 DUP(space)
			  DB " with"
			  DB 4 DUP(space)
			  DB "LEFT.",0
 SHELL_MSG	  DB 'Type <EXIT> to return to DF',13,10,'$'
 HOT_SHIFT       DB CTRL_SHIFT+RSHIFT_SHIFT   ;sum of SECOND_SHIFT (added in initialization)
									 ;and CTRL_SHIFT
 PARENT_DIR	  DB '..',0
 DOS_VERSION	  DW	?			;contains DOS version AL=major,AH=minor
 LINE_CNT_DISP	  DB	1			;don't display running line count flag (no = 0)

; variables to parse and set file control blocks (R4)
 DELIMITERS 	DB	9,13,32,"/<>."
 date_delimit  db	":-/"
 FCB_1ST		DW	FCB_5CH,?
 FCB_2ND		DW	FCB_6CH,?

 SCR_HT		Dw	25
 START_SCR_HT  dw   ?
 SCR_WID		Dw	80
 VOFFSET		DW	?
 DIR_ROWS      dw     20
 VIEW_ROWS	dw	   24

 DIR_ROW_END	dw	   BAR_START + 0 CROW 20

 IS_EGA		db	0
 IS_VGA		db	0

 ON_COMMAND_LINE	db 1	;used to tell critical error handler that
					;the error occured on the command line and
					;therefore it should abort if critical error
					;occured (not all initialization has taken place)
 SYS_TIME			dw	?    ;date and time in packed form for
 SYS_DATE			dw	?    ;set date/time function
 s_year			dw	?	;year (1980-2099)
 s_md			dw	?	;month/day
 s_hm			dw	?	;hour/minutes

 uv_mode_save		db	?    ;used to save the starting UV mode
 no_dir_store		db	0	;flag used in READ_DIR to control storage
						;of directory entries to prevent dupes (4.0)

 error_msg		dw	?		;stored location of relevant error message
 zip_handle		dw	?	;handle for temporary zip file
 zip_end_line		db	13,10	;end of line stuff for temp file
 file_err_msg		db	"Error creating temp file",0

 me_flag			db	0	;multi-execute flag
 first_time         db   0    ;changes to 1 after first time through multi-execute

 is_mouse			db	0	;0 if no mouse prsent; 1 if yes
 mouse_but		db	?	;number of mouse buttons

 touch_prompt       DB  'Enter date/time (',17,196,217,' to accept)',0
 date_prompt		db	'Date: ',0
 time_prompt		db	'Time: ',0
 pseudo_16a		dw	?
 pseudo_8a		db	?
 lsh_label		db	"LSh"	;used for altering menus

 xfcb			db	0ffh		;flag signifying extended fcb
				db	5 dup (0) ;reserved(should be zeros)
				db	8		;volume attribute byte
				db	0		;drive code (set by program)
				db	11 dup('?') ;wildcard filename and extension
				db	25 dup(0)	;remainder of fcb (not used)

 tmp_default_drive	db	?	;used by edit volume function

 open_print_err	db	"Error opening "
 printer_name		db	"LPT1",0
 term_flag		db	0  ;set to 1 while program terminating
					   ;used for changing to non-existent drive
 illegal_dir		db	'Unable to change to initial directory.',13,10
				db	'You may have deleted or renamed it.',13,10,"$"
 but_press_mask	db	0
 m_movement		dw	0
 drive_table_pointer db  -1 ;pointer to drive letter in drive table
                           ;starts w/1.  -1 means no drives defined.
                           ;0 means drives defined, but initial drive isn't.
 num_drive_entries  db   0
 second_var           db   ? ;Variable to store byte (e.g. from command line)
 error_flag         db   0    ;general purpose variable to hold error condition

 cfg_file           db 'df.cfg',0   ;default cfg file
 is_cfg             db   0    ;used to flag cfg file read stuff

 skip_dir_flag      db   0
 highmem_flag       db   0    ;bit 0 set if XMS available
                              ;bit 1 set if EMS available

 MenuOffsets label word
     dw   MENU1,LCTRL_MENU,RCTRL_MENU,LALT_MENU,RALT_MENU,LSHIFT_MENU,RSHIFT_MENU

 videopage_on_entry db   0h

cpu_val  db     0                  ; CPU value from CPUVALUE
                                   ;   0 = 8088/8086 or V20/V30
                                   ;   1 = 80186/80188
                                   ;   2 = 80286
                                   ;   3 = 80386
                                   ;   4 = 80486
                                   ;   5 = Pentium

cpu_info db     0                  ; flags from CPUVALUE
                                   ;   bit 0 = 1 if CPUID ok
                                   ;       1 = 1 if V20/V30 CPU

cpu_mfg  db     0                  ; CPU manufacturer
                                   ;   0 = unknown
                                   ;   1 = string from CPUID
                                   ;   2 = NEC
                                   ;   4 = likely Intel or AMD
                                   ;   3 = Intel
                                   ;   5 = AMD
                                   ;   6 = IBM
                                   ;   7 = Cyrix or TI

cpuid_txt db    '               '

cpu_prot db     0                  ; protected state
                                   ;   0 = no protected mode
                                   ;   1 = real mode
                                   ;   2 = protected mode
                                   ;   3 = V86 mode

cpu_priv db     0                  ; privledge level 0-3

fpu_val  db     0                  ; FPU value from FPUTYPE
                                   ;   0 = none
                                   ;   1 = 8087
                                   ;   2 = 80287
                                   ;   3 = 80387
                                   ;   4 = 80486DX or
                                   ;         80486SX with 80387
                                   ;   5 = Pentium

fpu_info db     0                  ; FPU flags (when present)
                                   ;   bit 0 = 1 if FPU is in CPU

cpu_cmd  db     0                  ; "-" = skip problem tests
                                   ; "+" = show cache timings
                                   ; "c" = cpu info only
                                   ; "u" = undoc info only


old_int6_seg dw 0                  ; temp storage for old int 6
old_int6_off dw 0                  ;  vector (bad opcode)
old_intD_seg dw 0                  ; temp storage for old int D
old_intD_off dw 0                  ;  vector (protection fault)

badoff       dw 0                  ; temp return offset if bad offset
                                   ;  interrupt 6 called

int_mask     db 0                  ; save area for interrupt mask


;  strings for CPU type

cpumsg   db      '           '
cpun    db      'NEC V20/V30'
fpun    db      '            ',0


cpuname db      '8088/8086  '
cpunend db      '80186/80188'
        db      '80286      '
        db      '80386      '
        db      '80486SX    '
        db      'Pentium    '

fpuname db      ' without FPU'
fpunend db      ' with 8087  '
        db      ' with 80287 '
        db      ' with 80387 '

fpuin2  db      ' w/ FPU      '
fpuin   db      ' (FPU in CPU)'
fpuine  label   byte

;  strings for CPU vendor

cpuvend db      '            ',0

vendors db      'Running at  ',0  ; 8088 to 80286
vendend db      'From CPUID  ',0  ; vendor in CPUID string
        db      'NEC         ',0  ; V20/V30
        db      'Intel or AMD',0  ; Not IBM or Cyrix
        db      'Intel       ',0  ; Pentium CPUID=Intel
        db      'AMD         ',0  ; only one to make 40Mhz 386
        db      'IBM         ',0  ; only 386/486 with RDMSR
        db      'Cyrix or TI ',0  ; no UMOV support


idstring db     '123456780123',0     ; 12 byte CPUID string

cpuvval db      0



;  strings for CPU speed

cpuspd  db      ''
cpusval db      '   ',0

; Data Speed table - The first word is the number of times
;   to repeat the loop.  Larger numbers take longer, and are
;   used to compensate for faster CPUs.  The second word is a
;   factor adjustment to end up with the speed in Mhz.  For
;   example, on a 80486 at 33Mhz, the 2nd word is 16550 = (33
;   * 2006 ticks)/4.  Three tables are used, since instruction
;   timing is different on these CPUs

intelspd dw      1, 10848       ; 8088  - loop duration, factor adjust
         dw      1, 10848       ; 80186  (5Mhz =  ~8345 ticks)
         dw      2, 3234        ; 80286  (12Mhz = ~1035 ticks)
         dw     10, 16200       ; 80386  (33Mhz = ~1917 ticks)
         dw     10, 16550       ; 80486  (33Mhz = ~2006 ticks)
         dw     20, 34318       ; Pentium (60Mhz = ~2269 ticks)

cyrixspd dw      1, 10848       ; not used
         dw      1, 10848       ; not used
         dw      2, 3234        ; not used
         dw     10, 16200       ; not used
         dw     10, 16550       ; 80486  (33Mhz = ~2006 ticks)
         dw     20, 34318       ; not used

ibmspd   dw      1, 10848       ; not used
         dw      1, 10848       ; not used
         dw      2, 3234        ; not used
         dw     10, 16200       ; 80386  (33Mhz = ~1917 ticks)
         dw     10, 16550       ; 80486  (33Mhz = ~2006 ticks)
         dw     20, 34318       ; not used



;  strings for BIOS routine - step saved after reset

bver    db      'Ver: '
bvernum db      '    h  '
bvercom db      '                '
        db      0

novermg db      'Step detect not suprtd',0

idtxtmg db      'CPUID: '
idtext  db      '             ', 0
cpustepmsg db      'Step: '
modval  db      '   ',0
penthasbug db   'FDIV bug',0

stepa   db      ''
        db      'Step: Step A'
        db      0

; table of step values and what they mean

bvt     dw      303h
        db      '(80386 step B1)'
bvte    dw      305h
        db      '(80386 step D0)'
        dw      308h
        db      '(80386 step D1)'
        dw      400h
        db      '(80486 step A0)'
        dw      401h
        db      '(80486 step B2)'
        dw      403h
        db      '(80486 step B3)'
        dw      404h
        db      '(80486 step B4)'
        dw      405h
        db      '(80486 step B5)'
        dw      406h
        db      '(80486 step B6)'
        dw      407h
        db      '(80486 step C1)'
        dw      2300h
        db      '(80386SX)      '
        dw      0A301h
        db      '(386SLC step 1)'       ; IBM
        dw      0A412h
        db      '(486SLC)       '       ; IBM
        dw      0A422h
        db      '(486SLC2)      '       ; IBM
        dw      0FFFFh

;  text for CPU mode (286 or greater only)

mode_V  db      'V86 (Prot, Virt 8086)', 0
mode_R  db      'Real mode', 0
mode_P  db      'Prot, Priv level '
mode_Pa db      '  ', 0

;  text for internal

cache_D db      'Disabled',0
cache_N db      'Enabld,no WT',0
cache_W db      'Enabld, WT', 0
cache_X db      'None',0


cSize1      db                            '     ',0
cSize2      db                            '     ',0

cSizeNone   db  'Ext cache masks int size'
            db  0

cache_time  db  '    Timings (.5 to 32K): '
cache_time1 db  '                                                     '
            db  CR, LF, '$'

; storage for test durations, data cache tests

timings     dw  0               ; .5K timing
            dw  0               ; 1K
            dw  0               ; 2K
            dw  0               ; 4K
            dw  0               ; 8K
            dw  0               ; 16K
            dw  0               ; 32K

windows1    db  'Windows disables',0
windows2    db  '  other tests.  ',0

systyp  db      ''
systypm db      '                  '
        db      0

sysmsg  db      0
        db      'PC (8088 based)   '
sysend  db      1
        db      'XT (8088 based)   '
        db      2
        db      'PC convert (8088) '
        db      3
        db      'PC jr (8088 based)'
        db      4
        db      'unknown pre-80286 '
        db      8
        db      'XT (80286 based)  '
        db      10h
        db      'AT / ISA (16-bit) '
        db      20h
        db      'EISA arch         '
        db      40h
        db      'MCA (Microchannel)'
        db      0FFh
        db      'unknown           '

;used by sertype and the dfsi display routines
comports db  "    ???"
         db  "   8250","  16450","16C1450","  16550"," 16550A","16C1550"
         db  "  16552","  82510"

HdriveAddr db  0,0,0,0,0,0,0,0,0     ;store up to 8 hard drive addresses
                                   ;(Usually 0 offset=80h, 1=81h, etc.)
num_hdrive db  0
 drive0             db   0
 drive1             db   0
CMOSmsg    db '   ',0

noCMOSmsg db   ', No CMOS found',0
NoCMOSsense db ', CMOS sense off',0

dcachesize_msg db 'Data cache size: ',0
intcachesize_msg db 'Int cache size: ',0

hdrvnum db      '0        ',0
hdrvtxt db      'PC/XT Type ',0
hsize   db      '         ',0
hcyldr  db      '      ',0
hheads  db      '      ',0
hsector db      '      ',0


hdrvtyp db      'PC/XT Type '
hdrvend db      'AT Type    '
        db      'SCSI Type  '
        db      'PS/2 ESDI  '
        db      'Unknown    '

;----------------------------------------------------------------------------
; Data from System Info Area
;----------------------------------------------------------------------------
  in_sysinfo   db   0
  CPUCODE      dw   0    ;code for CPU and NDP
  stepping386  db   0
  cpuclock     dw   0    ;cpu clock rate x 10 (i.e. div by 10 and insert .)
  bit32        db   0
  xmsver       dw   0
  xmmver       dw   0
  hmaavail     db   0    ;left at 0 if no HMA
                         ;set to 1 if HMA exists but in use
                         ;       2               and free
                         ;       3               but in use by DOS 5
  dos5hma      db   0
  hmafree      dw   0
  basemem      dw   0    ;total base mem in KB (040h:13h)
  extmem       dw   0    ;KB of extended memory from BIOS call
  bustype      db   0    ;1=XT bus -- does not currently distinguish
                         ;2=ISA
                         ;3=EISA
                         ;4=MCA
  commport_addr     dw   0,0,0,0
  commport_type     db   0,0,0,0
  printport_addr    dw   0,0,0
  printport_ext     db   0,0,0     ;=1 for extended mode
  printport_text    db   'Extnd',0
  ext_kybd_bios     db   0
  siFlags           db   0
                         ;bit 0    Soundblaster
                         ;bit 1    Adlib
                         ;bit 2    MPU-401
                         ;bit 3    Game Port (from read attempt)
                         ;bit 4    Game Port (from equip flag)
                         ;bit 5    Weitek
                         ;bit 6
  SBLASTER_MASK     EQU  01b
  ADLIB_MASK        EQU  10b
  MPU_MASK          EQU  100b
  GAME_MASK         EQU  1000b
  GAMEB_MASK        EQU  10000b
  WEITEK_MASK       EQU  100000b

  sbport            dw   0    ;note: This variable contains garbage if
                              ;sound blaster not found
  ems_active        db   0
  qemm_version      dw   0
  memm_present      db   0

 ; floppies          db   0    ;high nibble is drive 0
                              ;low nibble is drive 1
                              ;0 = none
                              ;1 = 360K
                              ;2 = 1.2M
                              ;3 = 720K
                              ;4 = 1.44
                              ;5 = 2.88
  FloppyType        db   0,0,0,0
                               ;0 = no drive
                               ;1 = 360KB
                               ;2 = 1.2MB
                               ;3 = 720KB
                               ;4 = 1.44MB
                               ;5 = 2.88MB
                               ;6 = 320KB  (obsolete)
                               ;7 = unknown type

  num_floppies      db   0
  FloppyLetter      db   0,0,0,0   ;floppy letters aren't necessarily
                                   ;sequential (C is usually a HD)

 dfprog_mem    dw   0
 dfdir_mem     dw   0
 dfshell_mem   dw   0

 bios_video    dw   0h        ;video codes from int 10h, function 1A00h
                              ;low = inactive, high = active
 dos_files     dw   0
 dos_buff      dw   0
 dos_env       dw   0
 dos_env_used  dw   0

 temp              db   0
 cdrive        db   0         ;current drive
 cpdrive       db   0         ;current physical drive
 restoredrive  db   0         ;current DF drive
                              ;reset when exit sysinfo
  portok    db   0

  none              db   "none",0
  notcmos           db   "BIOS",0
 logical_count      dw   0

 LARROW   EQU       75
 RARROW   EQU       77
 CLARROW  EQU       115
 CRARROW  EQU       116
 UARROW   EQU       72
 DARROW   EQU       80
 F1_KEY   EQU       59

 subwin_state  db   0    ;saves current subwindow state
 logical_drives     db 27 dup(0)

;OS/2 compatibility box stuff
 os2msg   db 'OS/2 version:',0
 os2msg1x db ' 1.x',0
 os2msg2x db ' 2.x',0
 isos2flag db 0

 serial    STRUC
          info_level     dw   ?
          serial_num     dd   ?
          svolume        db   11 dup (?)
          fsystem        db   8 dup (?)
 serial    ENDS

 serial_info serial <>
 fatid     db   0
 fatid1    db "    Fixed",0
 fatid2    db "Removable",0
 fatid3    db "Networked",0
 fatid4    db " Substitd",0
 fatid5    db "DblSpaced",0
; fatid6    db "  Stacked",0  ;have code to do stacker detect but it
                              ;uses absolute disk writes and I
                              ;don't like that
 fatid7    db "   CD-ROM",0

ReturnPathFlag db   0

;removed from user-defined data area in 5.0
END_WINDOW    dw     79 + 24 * 100h                          ;LENGTH1
 FUNC_LNGTH    DB      COMMAND_LINE_MAX+1
 FILL_CMD_LNGTH DB	   104
