
 videopage_on_entry db   0h

cpu_val  db     0                  ; CPU value from CPUVALUE
                                   ;   0 = 8088/8086 or V20/V30
                                   ;   1 = 80186/80188
                                   ;   2 = 80286
                                   ;   3 = 80386
                                   ;   4 = 80486
                                   ;   5 = Pentium

cpu_info db     0                  ; flags from CPUVALUE
                                   ;   bit 0 = 1 if CPUID ok
                                   ;       1 = 1 if V20/V30 CPU

cpu_mfg  db     0                  ; CPU manufacturer
                                   ;   0 = unknown
                                   ;   1 = string from CPUID
                                   ;   2 = NEC
                                   ;   4 = likely Intel or AMD
                                   ;   3 = Intel
                                   ;   5 = AMD
                                   ;   6 = IBM
                                   ;   7 = Cyrix or TI

cpuid_txt db    '               '

cpu_prot db     0                  ; protected state
                                   ;   0 = no protected mode
                                   ;   1 = real mode
                                   ;   2 = protected mode
                                   ;   3 = V86 mode

cpu_priv db     0                  ; privledge level 0-3

fpu_val  db     0                  ; FPU value from FPUTYPE
                                   ;   0 = none
                                   ;   1 = 8087
                                   ;   2 = 80287
                                   ;   3 = 80387
                                   ;   4 = 80486DX or
                                   ;         80486SX with 80387
                                   ;   5 = Pentium

fpu_info db     0                  ; FPU flags (when present)
                                   ;   bit 0 = 1 if FPU is in CPU

cpu_cmd  db     0                  ; "-" = skip problem tests
                                   ; "+" = show cache timings
                                   ; "c" = cpu info only
                                   ; "u" = undoc info only


old_int6_seg dw 0                  ; temp storage for old int 6
old_int6_off dw 0                  ;  vector (bad opcode)
old_intD_seg dw 0                  ; temp storage for old int D
old_intD_off dw 0                  ;  vector (protection fault)

badoff       dw 0                  ; temp return offset if bad offset
                                   ;  interrupt 6 called

int_mask     db 0                  ; save area for interrupt mask


;  strings for CPU type

cpumsg   db      '           '
cpun    db      'NEC V20/V30'
fpun    db      '            ',0


cpuname db      '8088/8086  '
cpunend db      '80186/80188'
        db      '80286      '
        db      '80386      '
        db      '80486SX    '
        db      'Pentium    '

fpuname db      ' without FPU'
fpunend db      ' with 8087  '
        db      ' with 80287 '
        db      ' with 80387 '

fpuin2  db      ' w/ FPU      '
fpuin   db      ' (FPU in CPU)'
fpuine  label   byte

;  strings for CPU vendor

cpuvend db      '            ',0

vendors db      'Running at  ',0  ; 8088 to 80286
vendend db      'From CPUID  ',0  ; vendor in CPUID string
        db      'NEC         ',0  ; V20/V30
        db      'Intel or AMD',0  ; Not IBM or Cyrix
        db      'Intel       ',0  ; Pentium CPUID=Intel
        db      'AMD         ',0  ; only one to make 40Mhz 386
        db      'IBM         ',0  ; only 386/486 with RDMSR
        db      'Cyrix or TI ',0  ; no UMOV support


idstring db     '123456780123',0     ; 12 byte CPUID string

cpuvval db      0



;  strings for CPU speed

cpuspd  db      ''
cpusval db      '   ',0

; Data Speed table - The first word is the number of times
;   to repeat the loop.  Larger numbers take longer, and are
;   used to compensate for faster CPUs.  The second word is a
;   factor adjustment to end up with the speed in Mhz.  For
;   example, on a 80486 at 33Mhz, the 2nd word is 16550 = (33
;   * 2006 ticks)/4.  Three tables are used, since instruction
;   timing is different on these CPUs

intelspd dw      1, 10848       ; 8088  - loop duration, factor adjust
         dw      1, 10848       ; 80186  (5Mhz =  ~8345 ticks)
         dw      2, 3234        ; 80286  (12Mhz = ~1035 ticks)
         dw     10, 16200       ; 80386  (33Mhz = ~1917 ticks)
         dw     10, 16550       ; 80486  (33Mhz = ~2006 ticks)
         dw     20, 34318       ; Pentium (60Mhz = ~2269 ticks)

cyrixspd dw      1, 10848       ; not used
         dw      1, 10848       ; not used
         dw      2, 3234        ; not used
         dw     10, 16200       ; not used
         dw     10, 16550       ; 80486  (33Mhz = ~2006 ticks)
         dw     20, 34318       ; not used

ibmspd   dw      1, 10848       ; not used
         dw      1, 10848       ; not used
         dw      2, 3234        ; not used
         dw     10, 16200       ; 80386  (33Mhz = ~1917 ticks)
         dw     10, 16550       ; 80486  (33Mhz = ~2006 ticks)
         dw     20, 34318       ; not used



;  strings for BIOS routine - step saved after reset

bver    db      'Ver: '
bvernum db      '    h  '
bvercom db      '                '
        db      0

novermg db      'Step detect not suprtd',0

idtxtmg db      'CPUID: '
idtext  db      '             ', 0
cpustepmsg db      'Step: '
modval  db      '   ',0
penthasbug db   'FDIV bug',0

stepa   db      ''
        db      'Step: Step A'
        db      0

; table of step values and what they mean

bvt     dw      303h
        db      '(80386 step B1)'
bvte    dw      305h
        db      '(80386 step D0)'
        dw      308h
        db      '(80386 step D1)'
        dw      400h
        db      '(80486 step A0)'
        dw      401h
        db      '(80486 step B2)'
        dw      403h
        db      '(80486 step B3)'
        dw      404h
        db      '(80486 step B4)'
        dw      405h
        db      '(80486 step B5)'
        dw      406h
        db      '(80486 step B6)'
        dw      407h
        db      '(80486 step C1)'
        dw      2300h
        db      '(80386SX)      '
        dw      0A301h
        db      '(386SLC step 1)'       ; IBM
        dw      0A412h
        db      '(486SLC)       '       ; IBM
        dw      0A422h
        db      '(486SLC2)      '       ; IBM
        dw      0FFFFh

;  text for CPU mode (286 or greater only)

mode_V  db      'V86 (Prot, Virt 8086)', 0
mode_R  db      'Real mode', 0
mode_P  db      'Prot, Priv level '
mode_Pa db      '  ', 0

;  text for internal

cache_D db      'Disabled',0
cache_N db      'Enabld,no WT',0
cache_W db      'Enabld, WT', 0
cache_X db      'None',0


cSize1      db                            '     ',0
cSize2      db                            '     ',0

cSizeNone   db  'Ext cache masks int size'
            db  0

cache_time  db  '    Timings (.5 to 32K): '
cache_time1 db  '                                                     '
            db  CR, LF, '$'

; storage for test durations, data cache tests

timings     dw  0               ; .5K timing
            dw  0               ; 1K
            dw  0               ; 2K
            dw  0               ; 4K
            dw  0               ; 8K
            dw  0               ; 16K
            dw  0               ; 32K

windows1    db  'Windows disables',0
windows2    db  '  other tests.  ',0

systyp  db      ''
systypm db      '                  '
        db      0

sysmsg  db      0
        db      'PC (8088 based)   '
sysend  db      1
        db      'XT (8088 based)   '
        db      2
        db      'PC convert (8088) '
        db      3
        db      'PC jr (8088 based)'
        db      4
        db      'unknown pre-80286 '
        db      8
        db      'XT (80286 based)  '
        db      10h
        db      'AT / ISA (16-bit) '
        db      20h
        db      'EISA arch         '
        db      40h
        db      'MCA (Microchannel)'
        db      0FFh
        db      'unknown           '

;used by sertype and the dfsi display routines
comports db  "    ???"
         db  "   8250","  16450","16C1450","  16550"," 16550A","16C1550"
         db  "  16552","  82510"

HdriveAddr db  0,0,0,0,0,0,0,0,0     ;store up to 8 hard drive addresses
                                   ;(Usually 0 offset=80h, 1=81h, etc.)
num_hdrive db  0
 drive0             db   0
 drive1             db   0
CMOSmsg    db '   ',0

noCMOSmsg db   ', No CMOS found',0
NoCMOSsense db ', CMOS sense off',0

dcachesize_msg db 'Data cache size: ',0
intcachesize_msg db 'Int cache size: ',0

hdrvnum db      '0        ',0
hdrvtxt db      'PC/XT Type ',0
hsize   db      '         ',0
hcyldr  db      '      ',0
hheads  db      '      ',0
hsector db      '      ',0


hdrvtyp db      'PC/XT Type '
hdrvend db      'AT Type    '
        db      'SCSI Type  '
        db      'PS/2 ESDI  '
        db      'Unknown    '

;----------------------------------------------------------------------------
; Data from System Info Area
;----------------------------------------------------------------------------
  in_sysinfo   db   0
  CPUCODE      dw   0    ;code for CPU and NDP
  stepping386  db   0
  cpuclock     dw   0    ;cpu clock rate x 10 (i.e. div by 10 and insert .)
  bit32        db   0
  xmsver       dw   0
  xmmver       dw   0
  hmaavail     db   0    ;left at 0 if no HMA
                         ;set to 1 if HMA exists but in use
                         ;       2               and free
                         ;       3               but in use by DOS 5
  dos5hma      db   0
  hmafree      dw   0
  basemem      dw   0    ;total base mem in KB (040h:13h)
  extmem       dw   0    ;KB of extended memory from BIOS call
  bustype      db   0    ;1=XT bus -- does not currently distinguish
                         ;2=ISA
                         ;3=EISA
                         ;4=MCA
  commport_addr     dw   0,0,0,0
  commport_type     db   0,0,0,0
  printport_addr    dw   0,0,0
  printport_ext     db   0,0,0     ;=1 for extended mode
  printport_text    db   'Extnd',0
  ext_kybd_bios     db   0
  siFlags           db   0
                         ;bit 0    Soundblaster
                         ;bit 1    Adlib
                         ;bit 2    MPU-401
                         ;bit 3    Game Port (from read attempt)
                         ;bit 4    Game Port (from equip flag)
                         ;bit 5    Weitek
                         ;bit 6
  SBLASTER_MASK     EQU  01b
  ADLIB_MASK        EQU  10b
  MPU_MASK          EQU  100b
  GAME_MASK         EQU  1000b
  GAMEB_MASK        EQU  10000b
  WEITEK_MASK       EQU  100000b

  sbport            dw   0    ;note: This variable contains garbage if
                              ;sound blaster not found
  ems_active        db   0
  qemm_version      dw   0
  memm_present      db   0

 ; floppies          db   0    ;high nibble is drive 0
                              ;low nibble is drive 1
                              ;0 = none
                              ;1 = 360K
                              ;2 = 1.2M
                              ;3 = 720K
                              ;4 = 1.44
                              ;5 = 2.88
  FloppyType        db   0,0,0,0
                               ;0 = no drive
                               ;1 = 360KB
                               ;2 = 1.2MB
                               ;3 = 720KB
                               ;4 = 1.44MB
                               ;5 = 2.88MB
                               ;6 = 320KB  (obsolete)
                               ;7 = unknown type

  num_floppies      db   0
  FloppyLetter      db   0,0,0,0   ;floppy letters aren't necessarily
                                   ;sequential (C is usually a HD)

 dfprog_mem    dw   0
 dfdir_mem     dw   0
 dfshell_mem   dw   0

 bios_video    dw   0h        ;video codes from int 10h, function 1A00h
                              ;low = inactive, high = active
 dos_files     dw   0
 dos_buff      dw   0
 dos_env       dw   0
 dos_env_used  dw   0

 temp              db   0
 cdrive        db   0         ;current drive
 cpdrive       db   0         ;current physical drive
 restoredrive  db   0         ;current DF drive
                              ;reset when exit sysinfo
  portok    db   0

  none              db   "none",0
  notcmos           db   "BIOS",0
 logical_count      dw   0

 LARROW   EQU       75
 RARROW   EQU       77
 CLARROW  EQU       115
 CRARROW  EQU       116
 UARROW   EQU       72
 DARROW   EQU       80
 F1_KEY   EQU       59

 subwin_state  db   0    ;saves current subwindow state
 logical_drives     db 27 dup(0)

;OS/2 compatibility box stuff
 os2msg   db 'OS/2 version:',0
 os2msg1x db ' 1.x',0
 os2msg2x db ' 2.x',0
 isos2flag db 0

 serial    STRUC
          info_level     dw   ?
          serial_num     dd   ?
          svolume        db   11 dup (?)
          fsystem        db   8 dup (?)
 serial    ENDS

 serial_info serial <>
 fatid     db   0
 fatid1    db "    Fixed",0
 fatid2    db "Removable",0
 fatid3    db "Networked",0
 fatid4    db " Substitd",0
 fatid5    db "DblSpaced",0
; fatid6    db "  Stacked",0  ;have code to do stacker detect but it
                              ;uses absolute disk writes and I
                              ;don't like that
 fatid7    db "   CD-ROM",0

ReturnPathFlag db   0
