;------------------------------------------------------------------------------
;DFSI.ASM displays the system info screen
;------------------------------------------------------------------------------


;--------------------------------------------------------------------------
; This subroutine displays various system information on the screen
; Returns:  nothing
; Modifies: assume everything
;--------------------------------------------------------------------------
JUMPS
 SYS_INFO      proc near

     mov       in_sysinfo,1        ;flag for error handler
     mov       ah,19h
     int       21h                 ;current drive in al
     mov       restoredrive,al
 _sysinfo_50:
     call      sertype
     call      get_printports
     call      get_siflags
     call      get_global_drive     ;new stuff for 5.00


     call      check_qemm
     or        memm_present,bl
     mov       qemm_version,ax

     call      check_386max
     or        memm_present,bl
     call      check_emm386
     or        memm_present,bl

     call      get_dfmem
     call      get_extmem          ;does a couple of tricks to get total
                                   ;system extended memory

     push      es                  ;get base system memory
     mov       ax,040h
     mov       es,ax
     mov       ax,es:[013h]
     mov       basemem,ax
     pop       es

     call      bios_version
     mov       ax,01A00h
     int       10h
     mov       bios_video,bx
     call      get_dosinfo

     call      disp_current_logical
     mov       ax,1                     ;we start out displaying the logical disk window
     call      implant_subwindow
_si_test:
     call      display_siscreen

;----------------------------------------------------------------------------
;We cycle here waiting for keystrokes
;----------------------------------------------------------------------------
 _sysinfo_100:
     mov       in_sysinfo,1        ;flag for error handler
     mov       ah,08h
     int       21h
     and       al,al
     jnz       _sysinfo_200        ;not extended key, go ahead
     int       21h                 ;extended key -- continue
                                   ;al = 75 (left arrow) previous log drive
                                   ;al = 77 (right arrow) next logical drive
                                   ;     115 (^left) previous fixed
                                   ;     116 (^right) next fixed
                                   ;     72 (up) previous physical
                                   ;     80 (down) next physical
                                   ;     59 (F1) disk help
     cmp       al,59               ;was F1 pressed?
     jne       _sysinfo_110        ;no, continue to look at other keys
     call      DoSIHelp            ;show help screen
     jmp       _sysinfo_100        ;back to looping

 _sysinfo_110:
     call      change_displayed_physical
     jc        _sysinfo_120        ;not a magic key
     call      display_physical
     jmp       _sysinfo_100
 _sysinfo_120:
     call      change_displayed_logical
     jc        _sysinfo_100        ;not one of the magic keys
     call      disp_current_logical
     jc        _sysinfo_100
     mov       ax,1
     call      implant_subwindow
;     call      disp_global_drive  ;i think this was here because of some oddness

     call      draw_sigrid
     jmp       _sysinfo_100

 _sysinfo_200:
                                   ;non-extended keycodes come here in al
     cmp       al,space
     je        _sysinfo_exit
     cmp       al,27
     je        _sysinfo_exit

     ;do stuff with other non-extended keys here
     call      interpret_si_keys

     jmp _sysinfo_100              ;return to looping

;----------------------------------------------------------------------------
;<esc> or <space> pressed; we exit sysinfo
;----------------------------------------------------------------------------
 _sysinfo_exit:
     mov  dl,restoredrive          ;restore drive, clear screen, return
	mov	ah,0Eh
	int	21h

     mov       al,c_normal
	call		clr_scr
	call		refresh_dir_disp
	call		put_menu_paths

     mov       in_sysinfo,0

     ret
 SYS_INFO      endp

;--------------------------------------------------------------------------
; change_displayed_logical
; On entry:
;    al contains extended ASCII keycode
;    cdrive contains current drive
;
; Some of the coding is a bit ugly but when physical drives were added, it
; was simpler to just leave the logical drive code the way it was.
;---------------------------------------------------------------------------
     tmp_cdrive     db   0

 change_displayed_logical  proc near

     mov       bl,cdrive
     mov       tmp_cdrive,bl

     mov       bl,al               ;save keycode
     mov       al,cdrive           ;get the current drive (within sysinfo)
     add       al,'A'              ;convert to letter
     mov       di,offset logical_drives
     mov       cx,logical_count
     repne     scasb               ;search for
     dec       di
                                   ;di now points to current drive in table
     cmp       bl,LARROW
     je        _cdd_20
     cmp       bl,CLARROW
     je        _cdd_20
     jmp       short _cdd_100
 _cdd_20:
     cmp       subwin_state,1
     jne       _cdd_25
     dec       di
 _cdd_25:                          ;if logical drives not currently showing
                                   ;don't change drive letter
     cmp       di,offset logical_drives
     jae       _cdd_50             ;still within the table
     add       di,logical_count    ;wrap around
 _cdd_50:
     cmp       bl,LARROW
     jne       _cdd_60             ;look at all logical drives
     cmp       logical_count,2     ;if only 2 logical drives, are never going
                                   ;to hit a hard drive
     je        _cdd_err
     cmp       byte ptr [di],'B'
     jbe       _cdd_20             ;is a floppy -- skip
 _cdd_60:
     mov       dl,byte ptr [di]
     sub       dl,'A'
     mov       cdrive,dl
     mov       ah,0Eh
     int       21h
     clc
     ret
 _cdd_100:
     cmp       bl,RARROW
     je        _cdd_120
     cmp       bl,CRARROW
     je        _cdd_120
     jmp       short _cdd_err
 _cdd_120:
     cmp       subwin_state,1
     jne       _cdd_125
     inc       di
 _cdd_125:
     cmp       byte ptr[di],0       ;means we're past end
     jne       _cdd_150
     sub       di,logical_count         ;wrap around
 _cdd_150:
     cmp       bl,RARROW
     jne       _cdd_160                 ;look at all logical drives
     cmp       logical_count,2     ;if only 2 logical drives, are never going
                                   ;to hit a hard drive
     je        _cdd_err
     cmp       byte ptr [di],'B'
     jbe       _cdd_120
 _cdd_160:
     jmp       _cdd_60
 _cdd_err:
     stc
     ret
 change_displayed_logical  endp


 ;---------------------------------------------------------------------------
 ;Displays current drive parameters
 ;Current drive can be changed with the arrow keys, etc.
 ;On entry to this function, the current drive has been set to the drive we
 ;   want
 ;---------------------------------------------------------------------------

 disp_current_logical proc near
JUMPS
     ;clear out changeable area


     mov       al,space
     mov       di,offset ld_line0
     mov       cx,7
 _dcd_10:
     push      cx di
     mov       cx,15
     rep       stosb
     pop       di cx
     add       di,SIWIN_LENGTH
     loop      _dcd_10

     mov       ah,19h
     int       21h                 ;current drive in al
     mov       cdrive,al           ;we use this with the lookup table
                                   ;A=0, B=1, etc.

     push      ax

     push      ds
     mov       dl,al
     inc       dl                  ;0=default in this case, not A
     mov       ah,1Ch
     int       21h                 ;get drive allocation info
     jc        _dcd_err
     mov       bl,byte ptr ds:[bx] ;store FAT ID byte
     pop       ds
     mov       fatid,bl
     mov       dx,cx               ;move sector size to dx
     xor       ah,ah               ;al=sectors per cluster, zero ah
     mul       dx                  ;get bytes per cluster
     mov       cx,6
     mov       di,offset DCLUSTER_LOC
     call      cformat

     pop       ax
     add       al,'A'
     mov       di,offset DLETTER_LOC
     stosb
     sub       al,'A'

;major reworking to this whole area in 4.61

     mov       si,offset fatid1   ;assume fixed unless we learn differently
     ;(fixed or removable are displayed only if not ds,network, or subst)
     mov       di,offset DTYPE_LOC
;     cmp       fatid,0F8h
;     jne       _dcd_20

     mov       bl,cdrive
     inc       bl
     mov       ax,4408h       ;cf clear on success
                              ;ax=0 for removable; 1 for fixed
                              ;requires at least DOS 3.0, but so does DF
     int       21h
     jc        _dcd_12
     cmp       ax,1
     je        _dcd_12             ;is a fixed drive
     mov       si,offset fatid2    ;removable
     ;removable is lower "priority" than some other things,
     ;so we keep going
 _dcd_12:

     call      isDoubleSpaced
     jnc       _dcd_13
     mov       si,offset fatid5
     jmp       short _dcd_100
 _dcd_13:

     call      isCDROM
     jnc       _dcd_14
     mov       si,offset fatid7
     jmp       short _dcd_100

 _dcd_14:


 _dcd_15:
     mov       bx,dos_version
     cmp       bl,4
     jae        _dcd_15a
     cmp       bh,10
     jb        _dcd_100
                                  ;must be at least rev 3.1 for network stuff
 _dcd_15a:
     mov       bl,cdrive           ;store drive number
     inc       bl                  ;drive numbers 1,2,3...
     mov       ax,4409h            ;Device-Driver control; check if remote
     int       21h
     jc        _dcd_100            ;failed for some reason
     mov       bx,dx               ;store return value
     and       dx,1000h            ;mask bit 9
     and       dx,dx
     jz        _dcd_16             ;bit 9 not set means not networked
     mov       si,offset fatid3
     jmp       short _dcd_100
 _dcd_16:
     mov       dx,bx
     and       dx,8000h            ;check for substituted bit
     and       dx,dx
     jz        _dcd_17
     mov       si,offset fatid4
     jmp       short _dcd_100
 _dcd_17:
 _dcd_100:
     call      copy_null

     ;Get the serial info using undocumented DOS call
     ;changed to IOCTL Block device request in 5.00
     ;for compatibility with OS/2 Compat box

     mov       ax,DOS_VERSION
     cmp       al,4
     jb        _dcd_150            ;function only DOS 4 and above


;     mov       ax,6900h
;     mov       bl,0
;     mov       dx,offset serial_info
;     int       21h
     mov       ax,440Dh
     mov       cx,0866h
     mov       bl,0
     cmp       isos2flag,1
     je        _dcd_110
     mov       dx,offset serial_info
     jmp       short _dcd_120
_dcd_110:
     mov       si,ds
     mov       di,offset serial_info
_dcd_120:
     int       21h
     jc        _dcd_200

     ;convert the DWORD into hex digits

     mov       ax,word ptr [serial_info.serial_num+2]
     mov       bl,16
     mov       si,offset DSERIAL_LOC
     call      word_to_asce
     mov       al,'-'
     xchg      di,si
     stosb
     xchg      di,si
     mov       ax,word ptr [serial_info.serial_num]
     call      word_to_asce
 _dcd_150:
     call      read_volume
     mov       si,offset temp_volume
     mov       di,offset DVOL_LOC
     mov       cx,11
     rep       movsb
 _dcd_200:
     mov       ah,36h         ;get free disk space
     xor       dl,dl
     int       21h
     push      ax bx cx dx    ;save to recalculate w/ total clusters

     mul       cx             ;sectors/cluster * bytes/sector
     mul       bx             ;* available clusters
                              ;result now in DX:AX
     mov       cx,11
     mov       di,offset DFREE_LOC
     call      cformat

     pop       dx cx bx ax
     mov       bx,dx          ;copy total clusters
     mul       cx
     mul       bx

     mov       cx,11
     mov       di,offset DTOTAL_LOC
     call      cformat
     clc
     ret
 _dcd_err:
     pop       ds ax
     ;reset to the previous default drive
     mov       dl,tmp_cdrive
     mov       cdrive,dl
     mov       ah,0Eh
     int       21h
 _dcd_err2:
     stc

     ret
NOJUMPS
 disp_current_logical endp

;from Microsoft DoubleSpace API.  We ignore all the fancy info related
;to doublespaced drives and swapping and such and just deal with whether
;the drive is compressed
;
;Added 4.61
;
;returns CF set if DoubleSpaced

 isDoubleSpaced     proc near

        mov     ax,4A11h        ; DBLSPACE.BIN INT 2F number
        mov     bx,1            ; bx = GetDriveMap function
        mov     dl,cdrive        ;
        int     2Fh             ; (bl AND 80h) == DS drive flag
                                ; (bl AND 7Fh) == host drive

        or      ax,ax           ; Success?
        jnz     _no_doublespace ;    NO, DoubleSpace not installed

        test    bl,80h          ; Is the drive compressed?
        jnz     _is_compressed  ; YES

 _no_doublespace:
     clc
     ret


 _is_compressed:
     stc
     ret

 isDoubleSpaced     endp

; Checks to see if a drive is a CD-ROM
; On Entry: cdrive = drive number, 0=A: etc.
; Returns: CF set if drive is CD-ROM
; Requires CDROM extensions 2.00 or later to work

 iscdrom  proc near
     mov       ax,1500h   ;test for MSCDEX
     xor       bx,bx
     int       2fh
     mov       ax,bx     ;mscdex not present if bx=0
     or        ax,ax
     jz        no_mscdex
     mov       cl,cdrive
     mov       ch,0
     mov       ax,150Bh  ;mscdex driver check API
     int       2fh
     or        ax,ax
     jz        no_mscdex ; actually is mscdex, but no cd-rom
     stc
     ret
no_mscdex:
     clc
     ret
 iscdrom endp

 get_dosinfo        proc near

     mov       dos_files,0
     push      es
     mov       ah,52h
     int       21h            ;es:bx points to list of lists
     ;pointer to list of DOS file tables at 04h (DWORD)
     mov       ax,es:[bx+4]
     mov       dx,es:[bx+6]
     cmp       ax,0FFFFh
     jne       _gdos_50
     cmp       dx,0FFFFh
     jne        _gdos_50      ;error in finding info in list of lists
     pop       es
     mov       bx,032h
     mov       ax,es:[bx]
     mov       dos_files,ax   ;file handle count from PSP
     jmp       short _gdos_110

 _gdos_50:
     mov       es,dx          ;load segment
     mov       bx,ax

     mov       ax,es:[bx+4]
     add       dos_files,ax

     mov       dx,es:[bx+2]
     mov       ax,es:[bx]

     cmp       ax,0FFFFh
     jne        _gdos_50

 _gdos_100:
     pop       es
 _gdos_110:                   ;end of files determination
                              ;dos_files now contains info

     mov       ax,dos_version
     cmp       al,4
     jb        _gdos_200      ;for now, we only determine buffers if
                              ;we can get them from the list of lists
                              ;which means DOS 4 or later
     push      es
     mov       ah,52h
     int       21h

     mov       ax,es:[bx+03Fh]
     mov       dos_buff,ax
     pop       es
 _gdos_200:
     ;determine total environment space and amount used

     push      es
 _gdos_205:
     mov       ax,es:[16h]
     and       ax,ax
     jz        _gdos_210
     mov       bx,es
     cmp       ax,bx
     je        _gdos_210
     mov       es,ax
     jmp       _gdos_205
 _gdos_210:
     mov       ax,es:[02Ch]
     and       ax,ax
     jz        _gdos_220
     mov       bx,dos_version
     cmp       bh,19               ;check for DOS 3.2x
     jbe       _gdos_230
     cmp       bh,30
     jae       _gdos_230
 _gdos_220:
     mov       bx,es               ;get envseg another way
     mov       ax,bx
     dec       bx
     mov       es,bx
     add       ax,es:[3]
     inc       ax
 _gdos_230:
     dec       ax
     mov       es,ax
     mov       ax,es:[3]
     shl       ax,4
     mov       dos_env,ax
 _gdos_240:
     mov       ax,es
     inc       ax
     mov       es,ax
     xor       bx,bx
 _gdos_245:
     cmp       word ptr es:[bx],0
     je        _gdos_250           ;end of used section found
     inc       bx
     jmp       _gdos_245
 _gdos_250:
     inc       bx
     inc       bx
     mov       dos_env_used,bx

     pop       es


     ret
 get_dosinfo        endp

;---------------------------------------------------------------------------
; Gets global (i.e. not stuff you access with the arrow keys) drive info to
; store
;---------------------------------------------------------------------------

 get_global_drive    proc near
     mov       si,offset logical_drives      ;count them
     call      str_len
     mov       logical_count,cx

; --- Find number of Diskette drives
; and store FloppyType & FloppyLetter settings

syst_skp2:

        mov     cx,0               ; we'll use cx to keep track against logical drives
        mov     bx, 0              ; drive 0 first, keeps track of number
                                   ; of diskettes found
                                   ; We consider floppies to be only
                                   ; possibilities for A: & B: but we
                                   ; also look for up to 2 others
        mov     num_floppies,0
syst_loop2:
        mov     si,offset logical_drives
        add     si,cx              ; point to next logical drive
        mov     dl,byte ptr [si]   ; get next drive letter
        sub     dl,65              ; convert uc drive letter to number
        push    si di bx cx dx     ; preserve all reisters except ax
                                   ; (which returns value)
        call    dsktype            ; drive type in al
        pop     dx cx bx di si
        inc     cx
        cmp     al, 0
        je      gngd_skp3          ; jump if no drive

                                        ;Floppy found, store & increment
        mov     si,offset FloppyType
        mov     byte ptr [si+bx],al ; store the floppy type
        mov     si,offset FloppyLetter
        add     dx,65              ;convert back to a letter
        mov     byte ptr [si+bx],dl ; store the floppy letter

        inc     bx                 ; we found a floppy; increment
gngd_skp3:
        cmp     cx,logical_count
        jae     gngd_skp4
        jmp     syst_loop2
gngd_skp4:
         mov   num_floppies,bl


;----- get number of hard disks and store addresses
     mov       si,offset TMP_BUFF - 1   ;increment will bring back to 0
     mov       bx,0
     mov       num_hdrive,0
gndg_skp5:
     mov       dx,bx
     add       dx,80h
     push      si di bx cx dx   ; preserve all reisters except ax
                                ; (which returns value)
     call      hdsktype
                                ;if fewer than 3 cyclinders, not a drive. An old
                                ;harddiskless DG/One was confused otherwise
     cmp       cx,2
     ja        gndg_skp5A
     mov       al,0
gndg_skp5A:
     pop       dx cx bx di si
     inc       bx               ;increment to next address
     mov       byte ptr [si+bx],0  ;store known value
     cmp       al,0
     je        gndg_skp6
     mov       byte ptr [si+bx],dl  ;store address
     inc       num_hdrive
gndg_skp6:
     cmp       bx,8
     jb        gndg_skp5
;store contiguous set of addresses to Hard drive address table
     mov       cx,8
     mov       si,offset TMP_BUFF
     mov       di,offset HDriveAddr
gngd_skp7:
     cmp       byte ptr [si],0
     je        gngd_skp8
     movsb                    ;copy only non-zero values into table
     jmp short gngd_skp9
gngd_skp8:
     inc       si
gngd_skp9:
     loop      gngd_skp7

;get hard disk CMOS types

 _ggd_300:
     call      test_for_cmos  ;returns carry set if CMOS not found
     jc        _ggd_400

     .READ_CMOS     012h
     mov       ah,al
     and       al,11110000b
     shr       al,4           ;al now contains type of Drive 0
     cmp       al,0Fh
     jne       _ggd_320
     .READ_CMOS 19h           ;get extended drive type
 _ggd_320:
     mov       drive0,al
     and       ah,1111b
     cmp       ah,0Fh
     jne       _ggd_340
     .READ_CMOS 1Ah
     mov       ah,al
 _ggd_340:
     mov       drive1,ah
 _ggd_400:

gngd_ret:
        ret
get_global_drive    endp

;-----------------------------------------------------------------------------
; Fills the address logical drives with the logical drives present
; in the system.  uses byte cdrive to store default drive so can restore
;-----------------------------------------------------------------------------

 set_logical_drives proc near

     mov       ah,19h
     int       21h
     mov       cdrive,al        ;store current default drive so we can restore

     mov       cx,26          ;cycle through all logical drives
     mov       dl,0           ;start w/ 'A' (drive 0)
     mov       di,offset logical_drives
 _sld_25:
     mov       ah,0Eh         ;set default disk drive
     int       21h

     mov       ah,19h         ;get default drive
     int       21h

     cmp       al,dl          ;was the drive stored?
     jne       _sld_50

     add       al,'A'         ;if yes, convert and store
     stosb
 _sld_50:
     inc       dl             ;advance to next drive
     loop      _sld_25

     mov       dl,cdrive      ;restore existing default
     mov       ah,0Eh
     int       21h
     ret

 set_logical_drives endp

;-----------------------------------------------------------------------------
; Tests to see if CMOS exists on the system.  Returns carry clear if yes,
; carry set if no.
;-----------------------------------------------------------------------------

 test_for_CMOS proc near

     mov  al,siset            ;we're telling it no CMOS
     test al,010b             ;this test caused a lockup on an old DG/One
     jz   _tfc_100
     stc
     ret

_tfc_100:
     .READ_CMOS  06h
     mov       temp,al        ;keeps value to return later
     .WRITE_CMOS 06h,0AAh
     .READ_CMOS 06h
     cmp       al,0AAh
     jne       _tfc_fail
     .WRITE_CMOS 06h,055h
     .READ_CMOS 06h
     cmp       al,055h
     jne       _tfc_fail
     mov       ah,0C0h
     push      es
     int       15h
     pop       es
     jnc       _tfc_success
     push      es
     mov       ax,0FFFFh
     mov       es,ax
     mov       bx,0Eh
     mov       al,byte ptr es:[bx]
     pop       es
     cmp       al,0FDh
     jae       _tfc_fail

 _tfc_success:
     clc
     jmp short _tfc_ret
 _tfc_fail:
     stc
 _tfc_ret:
     pushf
     .WRITE_CMOS 06h,temp
     popf
     ret
 test_for_CMOS      endp

 DISPLAY_SISCREEN   proc near

     mov       al,c_normal
	call		clr_scr

     mov       al,c_intense
     mov       cx, 0302h      ;row column upper left
     mov       dx, 0819h      ;row column lower right
     call      clr_window

     mov       al,c_intense
     mov       cx, 0A02h      ;row column upper left
     mov       dx, 1419h      ;row column lower right
     call      clr_window

     mov       al,c_intense
     mov       cx, 1302h      ;row column upper left
     mov       dx, 1419h      ;row column lower right
     call      clr_window

     mov       al,c_intense
     mov       cx, 1602h      ;row column upper left
     mov       dx, 1719h      ;row column lower right
     call      clr_window

     mov       al,c_intense
     mov       cx, 031Bh      ;row column upper left
     mov       dx, 092Dh      ;row column lower right
     call      clr_window

     mov       al,c_intense
     mov       cx, 0B1Bh      ;row column upper left
     mov       dx, 172Dh      ;row column lower right
     call      clr_window

     mov       al,c_intense
     mov       cx, 032Fh      ;row column upper left
     mov       dx, 114Ch      ;row column lower right
     call      clr_window

     mov       al,c_intense
     mov       cx, 142Fh      ;row column upper left
     mov       dx, 154Ch      ;row column lower right
     call      clr_window
     call      disp_hardware
     call      disp_DOS
     call      disp_memory
     call      disp_video
     call      disp_global_drive
     call      cputype
     call      miscundocdisp

     call      draw_sigrid

     ret
 DISPLAY_SISCREEN   endp

include dfsiscr.asm


 DRAW_SIGRID        proc near

	mov		cx,25
	mov		di,0 CROW 0
     mov       si,offset si_line0
_grid2:
	push		cx
	call		str_len
	.put_cx_chars_reg
	add		si,cx
	inc		si
	add		di,ROW_LENGTH
	pop		cx
     loop      _grid2

     ret
 DRAW_SIGRID        endp

;---------------------------------------------------------------------------
; This routine gets various system info up front (primarily related to XMS
; and EMS memory most of which we need anyway for the memory allocation
; routines
;----------------------------------------------------------------------------
JUMPS
 SETUP_SYSINFO      PROC NEAR

     mov       ax,4300h
     int       2fh
     cmp       al,80h
     jne       _ssinfo50                ;al=80h if XMS driver present

 _ssinfo20:
     push      es
     mov       ax,4310h
     int       2fh
     mov       word ptr xmsaddr,bx
     mov       word ptr xmsaddr+2,es    ;save far pointer to entry point
     pop       es

     mov       ah,8
     call      xmsaddr
     mov       xmstotal,dx
     mov       xmslargest,ax

     or        highmem_flag,01b

     mov       ah,0
     call      xmsaddr
     mov       xmsver,ax
     mov       xmmver,bx
     mov       hmaavail,dl
     cmp       dx,1
     jne       _ssinfo50                ;dx = 0 no HMA

     mov       ax,dos_version
     cmp       al,5
     jb        _ssinfo30                ;don't look for below DOS 5
     mov       ax,04A01h                ;hma in use by DOS 5?
     push      es
     int       2fh
     pop       es
     and       bx,bx                    ;bx = 0.  DOS 5 isn't using.
     jz        _ssinfo30
     mov       dos5hma,1
     mov       cl,10
     mov       ax,bx                    ;convert HMA free bytes to KB
     shr       ax,cl
     mov       hmafree,ax               ;Kbytes free
;new DF 4.61
     mov       hmaavail,3               ;in use by DOS5
     jmp       short _ssinfo50

 _ssinfo30:
     mov       ah,1                     ;attempt to allocate hma
     mov       dx,0FFFFh
     call      xmsaddr
     cmp       ax,1                     ;successful?
     jne       _ssinfo50                ;allocation failed, assume in use
     ;note that we have no way of telling the free bytes except in the
     ;case of DOS 5 where we use a documented multiplex call

     mov       hmaavail,2
                                        ;now free it
     mov       ah,2
     call      xmsaddr

;setup default value of 64KB if HMA free
     mov       hmafree,64





 _ssinfo50:

 ;first we test for presence of expanded memory using DOS Open and IOCTL
 ;functions (per Chap 2 Extending DOS)

     mov       dx,offset emmname
     mov       ax,3D00h            ;open
     int       21h
     jc        _ssinfo100
                                   ;open successful, make sure isn't a file
     mov       bx,ax               ;bx=handle from open
     mov       ax,4400h            ;IOCTL get device info
     int       21h
     jc        _ssinfo100

     and       dx,80h              ;bit 7=1 if char device
     jz        _ssinfo100

     mov       ax,4407h            ;EMM present, make sure available
     int       21h
     jc        _ssinfo100

     mov       ah,3Eh              ;close
     int       21h
     jc        _ssinfo100

     mov       ah,40h              ;get EMS system status
     int       67h
     or        ah,ah
     jnz       _ssinfo100

     mov       ems_active,1         ;used later when looking at EMS managers
     mov       ah,46h              ;check EMM version
     int       67h
     or        ah,ah
     jnz       _ssinfo100

     mov       emsversion,al
     cmp       al,32h              ;make sure EMS 3.2+
     jb       _ssinfo100

     or        highmem_flag,010b   ;we have the proper ems

     mov       ah,42h              ;get number of EMS pages
     int       67h
     or        ah,ah
     jnz       _ssinfo100
     mov       tpages,dx
     mov       apages,bx


 _ssinfo100:
     ret

 SETUP_SYSINFO      ENDP

NOJUMPS

;------------------------------------------------------------------------
; Gets DF Memory utilization for display
;------------------------------------------------------------------------

 get_dfmem          proc near
     mov       used_mem,0
     cmp       mem_use,0
     jne       _gdfm_50
     mov       ax,dbs_start
     shr       ax,4
     jmp       short _gdfm_60
 _gdfm_50:
     mov       ax,diralloc
 _gdfm_60:
     add       used_mem,ax         ;program conventional memory usage
     mov       cl,6
     shr       ax,cl
     mov       dfprog_mem,ax       ;store for later display
                                   ;now we do the directory memory usage
     mov       ax,dbs_end
     sub       ax,dbs_start
     push      ax                  ;save memory used
     mov       cl,10
     shr       ax,cl               ;convert to KB
     mov       dfdir_mem,ax        ;save for later display
                                   ;mem_use 1 = XMS
                                   ;        2 = EMS
                                   ;        4 = Conv
     pop       ax
     ;now we figure how much we have for the shell
     mov       bx,used_mem
     mov       ax,avail_mem
     sub       ax,bx
     mov       cl,6
     shr       ax,cl
     cmp       mem_use,2
     je        _gdfm_100
     cmp       mem_use,1
     je        _gdfm_100

                                   ;so long as directory doesn't need conl
                                   ;memory on swap, go ahead
     sub       ax,dfdir_mem        ;otherwise, subtract out directory
 _gdfm_100:
     mov       dfshell_mem,ax

     ret
 get_dfmem          endp

;------------------------------------------------------------------------
; Checks for presence of EMM386 memory manager.  This is another
; quick and dirty.  Returns y/n in bl
;------------------------------------------------------------------------

 check_emm386       proc near

     cmp       ems_active,1
     jne       _cemm386_ret
     mov       ax,0FFA5h
     int       67h
     cmp       ax,0845Ah
     jne       _cemm386_ret
     mov       bl,3
     ret
 _cemm386_ret:
     mov       bl,0
     ret
 check_emm386       endp

;------------------------------------------------------------------------
; Checks for presence of 386^MAX memory manager.  To save a big structure
; and other things required to absolutely confirm presence (and to get
; the version number) we just do a quick look and return y/n in bl
;------------------------------------------------------------------------
 sig386Max     db   '386MAX$$',0

 check_386max       proc near

     mov       ax,03D00h
     mov       dx,offset sig386MAX
     inc       dx
     int       21h
     jc        _c386m_ret
     mov       bl,2
     ret
 _c386m_ret:
     mov       bl,0
     ret
 check_386max       endp



;------------------------------------------------------------------------
; Checks for presence of QEMM memory manager.  Returns the following
; results in ax and bx:
; bx = 0 if not present, 1 if present
; ah/al = major and minor versions in ASCII form
;------------------------------------------------------------------------
     QEMMid    db   0
     qemmaddr   dd   ?

 check_qemm         proc near

     push      es
     mov       portok,0
     mov       QEMMid,0D2h

 _cqemm_50:
     xor       ax,ax
     mov       ah,QEMMid
     mov       bx,05144h
     mov       cx,04D45h
     mov       dx,04D30h
     int       2Fh
     cmp       al,0FFh
     jne       _cqemm_100
     cmp       bx,04D45h
     jne       _cqemm_100
     cmp       cx,04D44h
     jne       _cqemm_100
     cmp       dx,05652h
     jne       _cqemm_100
     mov       portok,1
     jmp       short _cqemm_200
 _cqemm_100:
     cmp       QEMMid,0FFh
     jae       _cqemm_120
     inc       QEMMid
     jmp       short _cqemm_130
 _cqemm_120:
     mov       QEMMid,0C0h
 _cqemm_130:
     cmp       QEMMid,0D2h
     jne       _cqemm_50
 _cqemm_200:
     xor       bx,bx
     mov       bl,portok
     and       bx,bx
     jz        _cqemm_ret          ;QEMM not found

     mov       ah,QEMMid
     mov       al,1
     mov       bx,05145h
     mov       cx,04D4Dh
     mov       dx,03432h
     int       2Fh                 ;alters es!
     cmp       bx,04F4Bh           ;OK?
     je        _cqemm_300
     xor       bx,bx
     jmp       _cqemm_ret
 _cqemm_300:
     mov       ah,3
     mov       word ptr qemmaddr+2,es
     mov       word ptr qemmaddr,di
     call      qemmaddr
     mov       ax,bx
     call      unbcd
     xchg      ah,al
     call      unbcd
     xchg      ah,al

     and       bl,bl
     jz        _cqemm_ret
     mov       bl,1

 _cqemm_ret:
     pop       es
     ret
 check_qemm         endp

;---------------------------------------------------------------------------
; Tries to get the extended memory available in the system.
; If DOS 4 or greater is present, tries to obtain through the List of Lists.
; If this fails, just get it through the BIOS (which may well say 0)
;
; List of Lists method from PC Techniques Dec/Jan 92. Hax 92 by
;     Rich Sadowsky
;---------------------------------------------------------------------------
 get_extmem         proc near

     mov       ax,dos_version
     cmp       al,4
     jb        _gext_100           ;can only do this with DOS4 or greater

     push      es
     mov       ah,52h
     int       21h                 ;get pointer (es:bx) to list of lists
     add       bx,45h
     mov       ax,es:[bx]
     pop       es
     cmp       ax,0FFFFh           ;call failure.  Possibly including under
                                   ;OS/2 compatibility box
     je        _gext_100
     jmp       short _gext_200
 _gext_100:
     mov       ah,088h
     int       15h
     jc        _gext_ret
 _gext_200:
     mov       extmem,ax
 _gext_ret:
     ret
 get_extmem         endp

;------------------------------------------------------------------------
; Sets various bits in siFlags as a function of whether various pieces of
; equipment are present in the system.  Returns Sound Blaster port in
; BX if a Sound Blaster board in present
;------------------------------------------------------------------------
     sbfound   db   0
     midifound db   0

JUMPS
 GET_SIFLAGS        proc near

;     cmp	bypass_si,1
;     je	        _gsi_ret

     cmp       mswin_version,0
     jne       _gsi_300            ;MSWIN 3.1+ will give error if DOS
                                   ;apps try to use Sound Blaster

comment |
     ,removed DF 5.00
     ;Adlib board
     ;I have no idea what the purpose of the following black magic is.
     ;See Infoplus Page 8

     mov       dx,0388h
     in        al,dx
     mov       bl,al     ;bl = xbyte2
     mov       al,0BDh
     out       dx,al
     in        al,dx
     in        al,dx
     in        al,dx
     in        al,dx
     inc       dx
     in        al,dx
     mov       bh,al     ;bh = xbyte3
     mov       al,0
     out       dx,al
     mov       cx,36
     dec       dx
 _gsi_100:
     in        al,dx
     loop      _gsi_100

     and       al,7
     push      ax
     mov       al,bl
     out       dx,al
     inc       dx
     mov       al,bh
     out       dx,al

     pop       ax

     cmp       al,6
     jne       _gsi_150
     or        siFlags,ADLIB_MASK
|
 _gsi_150:                         ;end of Adlib detection

     ;Now we do the Sound Blaster thing

     mov       temp,0              ;used to flag 1st pass through repeat
     push      bp
     mov       sbfound,0
     mov       cx,6                ;loop counter
     mov       sbport,0200h
     xor       dx,dx               ;xword2
 _gsi_160:
     cmp       sbfound,1
     je        _gsi_200
     xor       bp,bp               ;xword1
     mov       dx,sbport
     add       dx,010h
     mov       sbport,dx
     add       dx,0Ch
     mov       portok,0
 _gsi_165:
     cmp       bp,0201h  ;do while xword1(bp) < 0201h and not sbfound
     jae       _gsi_170
     cmp       portok,0
     jne       _gsi_170
 _gsi_166:
     in        al,dx
     and       al,080h
     and       al,al
     jnz       _gsi_167
     mov       portok,1
 _gsi_167:
     inc       bp
     jmp       _gsi_165
 _gsi_170:
     cmp       portok,0
     je        _gsi_177      ;port not ok -- loop to next port

     in        al,dx
     mov       bl,al          ;bl = xbyte3
     mov       al,0D3h
     out       dx,al
     push      cx             ;save main loop counter
     mov       cx,01000h      ;setup time delay loop
 _gsi_171:
     nop
     loop      _gsi_171
     pop       cx
     mov       dx,sbport
     add       dx,6
     mov       al,1
     out       dx,al
     in        al,dx
     in        al,dx
     in        al,dx
     in        al,dx
     mov       al,0
     out       dx,al
     mov       dx,sbport
     add       dx,0Eh
     xor       bh,bh
 _gsi_173:                    ;repeat until xbyte2 = 10 or portok
     cmp       temp,1
     jne       _gsi_175
     cmp       bh,010h        ;bh = xbyte2
     je        _gsi_180
     cmp       portok,0
     jne       _gsi_180
 _gsi_175:
     mov       temp,1
     mov       portok,0
     mov       bp,0
 _gsi_175A:
     cmp       bp,0201h
     jae       _gsi_176A
     cmp       portok,0
     jne       _gsi_176A

     in        al,dx          ;do while bp < 0201h and not portok
     and       al,080h
     cmp       al,080h
     jne       _gsi_176
     mov       portok,1
 _gsi_176:
     inc       bp
     jmp       _gsi_175A
 _gsi_176A:
     cmp       portok,1
     jne       _gsi_177

     push      dx
     mov       dx,sbport
     add       dx,0Ah
     in        al,dx
     pop       dx
     cmp       al,0AAh
     jne       _gsi_177
     mov       sbfound,1
 _gsi_177:
     cmp       sbfound,1
     je        _gsi_200
     jmp       _gsi_190
 _gsi_178:
     jmp       _gsi_173
 _gsi_180:
     mov       al,bl
     out       dx,al
 _gsi_190:
     loop      _gsi_160

 _gsi_200:
     pop       bp
     cmp       sbfound,1
     jne       _gsi_210
     or        siFlags,SBLASTER_MASK
 _gsi_210:
 _gsi_300:
 _gsi_400:
     .RETURN_EQUIP  ax
     test      ah,10000b
     jz        _gsi_420
     or        siFlags,GAMEB_MASK
 _gsi_420:
;     cmp       bit32,1       ;is a 32-bit processor?
;     jne       _gsi_500      ;Weitek test only works with 32-bit
;     call      weitek
;     test      bx,01b
;     jz        _gsi_500      ;no weitek
;     or        siFlags,WEITEK_MASK
 _gsi_500:
     sti
 _gsi_ret:
     ret
 GET_SIFLAGS        endp
NOJUMPS


;------------------------------------------------------------------------
; Fills in the base addresses of the printer ports
;  printport_addr   (3) word
;------------------------------------------------------------------------
 GET_PRINTPORTS     proc near

;     .return_equip  ax
;     mov       cl,14
;     shr       ax,cl     ;# of parallel printer adapters is in bits 14-15
;     and       ax,011b   ;mask out all other bits
;     mov       cx,ax     ;cx now has number of printer ports

     mov       cx,3
     mov       bx,offset printport_addr
;     and       cx,cx
;     jz        _gprint_ret
;     and       cx,011b        ;only look at up to three
     mov       dx,08h         ;printer addresses at offset 8h in BIOS data area
 _gprint_100:
     mov       ax,040h
     push      es
     mov       es,ax
     xchg      bx,dx
     mov       ax,es:[bx]
     xchg      bx,dx
     mov       [bx],ax
     push      bx dx
     mov       bx,offset printport_ext
     push      cx
     neg       cx
     add       cx,3
     add       bx,cx
     pop       cx
     mov       dx,ax          ;store printer port
     call      print_extended ;check for extended functionality
     jnc       _gprint_200    ;nope
     mov       byte ptr [bx],1         ;yep

_gprint_200:
     pop       dx bx
     inc       bx
     inc       bx
     inc       dx
     inc       dx
     pop       es
     loop      _gprint_100
 _gprint_ret:
     ret
 GET_PRINTPORTS     endp

;Checks for extended mode on printer port
; On entry:    dx = printer port
; Returns:     Carry set if extended, otherwise clear

 print_extended     proc near
        cmp     dx,0
        je      prnex_restore
                                   ; now check extended support
        add     dx, 2              ; set to control port
        in      al, dx
        IODELAY
        mov     ah, al             ; save value to restore later
        or      al, 20h
        out     dx, al             ; set extended read bit 5 on

        sub     dx, 2              ; dx = read/write port #
        mov     al, 55h
        out     dx, al             ; send value 55h
        IODELAY
        in      al, dx
        cmp     al, 55h            ; read matches prior write ?
        jne     prnex_extended     ; jump if not

        mov     al, 0AAh
        out     dx, al             ; send value AAh
        IODELAY
        in      al, dx
        cmp     al, 0AAh           ; read matches prior write ?
        je      prnex_restore      ; if so, no extended mode

prnex_extended:
        add     dx, 2
        mov     al, ah
        out     dx, al             ; restore to original state
        stc                        ; port supports extended mode
        ret
prnex_restore:
        add     dx, 2
        mov     al, ah
        out     dx, al             ; restore to original state
        clc
        ret
 print_extended     endp



;--------------------------------------------------------------------------
; Tries to determine if 101/102 keyboard present and supported.
; Looks at Bit 4 of 0040:0096.
; From Hax #33 PC Techniques 10/90
; BIOS support part from INFOPLUS (added 4.60)
; On entry: nothing
; Modifies: AX
; Returns: Al=0 if no extended keyboard, Al=1 if extended keyboard
;          Ah=0 if no BIOS support for extended kybd, Ah=1 if support
;---------------------------------------------------------------------------

 check_keyboard	proc near

     push      bx
     push      es
	mov		ax,040h
	mov		es,ax
	mov		bx,96h
	mov		al,byte ptr es:[bx]
     pop       es
	test		al,10h
	jnz		_ck_yes
	xor		ax,ax
;     ret
     jmp       short _ck_bios
 _ck_yes:
	mov		ax,1
 _ck_bios:
     mov       bx,ax
     mov       ah,02h
     int       16h       ;return shift flag status
     mov       cl,al
     xor       al,0FFh
     mov       ah,012h
     int       16h       ;return extended shift flags
     cmp       al,cl
     jne       _ck_bios_no
     mov       bh,1
     jmp       short _ck_ret
 _ck_bios_no:
     xor       bh,bh
 _ck_ret:
     mov       ax,bx
     pop       bx
     ret

 check_keyboard	endp



 busses   db   "  XT"," ISA","EISA"," MCA"
; comports db   "  8250"," 16450"," 16550","16550A","   ???"
 memmans  db   "QEMM   ","386^MAX","EMM386 "
 hmause   db   "none ","used ","free ","DOS  "


 disp_hardware  proc near

     mov       al,siFlags
     mov       dx,ax
     and       al,SBLASTER_MASK
     mov       di,offset SBLAST_LOC
     call      put_yn
     cmp       al,'N'
     je        _dhw_20

     mov       si,offset SBPORT_LOC
     mov       ax,sbport
     mov       bl,16
     call      word_to_asce
     mov       byte ptr [si],'h'
 _dhw_20:
;     mov       ax,dx
;     and       al,ADLIB_MASK
;     mov       di,offset ADLIB_LOC
;     call      put_yn

;     mov       ax,dx
;     and       al,MPU_MASK
;     mov       di,offset MPU_LOC
;     call      put_yn

;     mov       ax,dx
;     and       al,GAME_MASK
;     mov       di,offset GAME_LOC
;     call      put_yn
;     mov       al,'/'
;     stosb
;     mov       ax,dx
;     and       al,GAMEB_MASK
;     call      put_yn

;Busses removed rev 5 too in favor of new
;     mov       si,offset busses
;     mov       cl,BusType
;     dec       cl                  ;Bus Type stored off base of 1
;    mov       ch,4
;     mov       di,offset BUS_LOC
;     call      put_indexed

;     removed 5.0 (next 3 lines)
;     mov       di,offset MOUSE_LOC
;     mov       al,is_mouse
;     call      put_yn

;     and       al,al
;     jnz       _dhw_25
;     mov       byte ptr [di+3],'N'
;     jmp       short _dhw_30
; _dhw_25:
;     mov       ax,mouse_version
;     call      put_version
; _dhw_30:

     mov       di,offset KYBD_BIOS_LOC
     mov       al,ext_kybd_bios
     call      put_yn

     mov       di,offset KYBD_PRES_LOC
     mov       al,ext_kybd_flag
     call      put_yn

     mov       di,offset printport_addr      ;show printer ports
     mov       cx,3
     mov       bl,16
     mov       dx,11
     mov       si,offset PRINTER_LOC
 _dhw_100:
     mov       ax,[di]
     and       ax,ax
     jz        _dhw_120
     cmp       ax,1000h
     ja        _dhw_120                ;port number too high; in BIOS area
     push      si
     call      put_spaces
     add       si,8
     call      word_to_asce
     mov       byte ptr[si],'h'
     pop       si
     push      si cx bx di             ;print whether print port extended

     mov       bx,offset printport_ext
     neg       cx
     add       cx,3
     add       bx,cx
     cmp       byte ptr [bx],1
     jne       _dhw_110
     mov       si, offset printport_text   ;extended mode, print "Extnd"
     mov       di, offset PRINTER_LOC + 1
     call      copy_null
 _dhw_110:
     pop       di bx cx si
 _dhw_120:
     inc       di
     inc       di
     add       si,SI_LENGTH
     loop      _dhw_100
                                             ;show comm ports
     mov       di,offset commport_addr
     mov       cx,4
     mov       bl,16
     mov       dx,11
     mov       si,offset COMM_LOC
 _dhw_200:
     mov       ax,[di]
     and       ax,ax
     jz        _dhw_250
     push      si
     call      put_spaces
     inc       si
     call      word_to_asce
     mov       byte ptr [si],'h'

     push      di cx
     mov       di,offset commport_type
     add       di,4
     sub       di,cx
     mov       cl,byte ptr [di]              ;point to index for types
;     mov       ch,6
     mov       ch,7                          ;length change in 5.00
     mov       di,si
     inc       di
     inc       di
     mov       si,offset comports
     call      put_indexed
     pop       cx di
     pop       si
 _dhw_250:
     inc       di
     inc       di
     add       si,SI_LENGTH
     loop      _dhw_200
     ret
 disp_hardware endp



 disp_DOS      proc near
     mov       di,offset dos_loc
     mov       ax,dos_version
     xchg      ah,al          ;Microsoft stores MAJOR in low
     cmp       ah,0Ah
     je        ddos_50
     cmp       ah,14h
     je        ddos_60
     call      put_version
     jmp       short ddos_80
ddos_50:
     mov       di,offset si_line3 + 28
     mov       si,offset os2msg
     call      copy_null
     mov       si,offset os2msg1x
     call      copy_null
     mov       isos2flag,1
     jmp       short ddos_80
ddos_60:
     mov       di,offset si_line3 + 28
     mov       si,offset os2msg
     call      copy_null
     mov       si,offset os2msg2x
     call      copy_null
     mov       isos2flag,1
     jmp       short ddos_80

ddos_80:
     call      store_sys_dt   ;store system date/time
     call      parse_date_time ;store in display format
     mov       si,offset DATE_LOC
     mov       dx,s_year           ;setup registers
	mov		ax,s_md             ;with stored info
	call		asc_date            ;call date writing function
     mov       si,offset TIME_LOC
     mov       dx,s_hm
	mov		bx,1
	call		asc_time

     mov       di,offset BREAK_LOC
     mov       al,break_stat
     call      put_yn

     mov       di,offset VERIFY_LOC
     mov       al,verify_stat
     call      put_yn

     mov       cl,memm_present
     and       cl,cl
     jz        _ddos_100                ;no tested memory manager present
     dec       cl                       ;to get to zero base
     mov       ch,7
     mov       si,offset memmans
     mov       di,offset MEMMAN_LOC
     call      put_indexed
     mov       di,offset MEMMAN_LOC
     mov       byte ptr [di+11],'Y'

     cmp       cl,0                     ;is it QEMM (remember reduced by 1)
     jne       _ddos_100
     add       di,8
     mov       ax,qemm_version          ;if yes, write version number
     call      put_version

 _ddos_100:

     mov       di,offset MSWIN_LOC
     mov       ax,mswin_version
     and       ax,ax
     jnz       _ddos_150
     inc       di
     call      put_yn                   ;puts N
     jmp       short _ddos_160
 _ddos_150:
     xchg      ah,al                    ;'cause MS does things backwards
     call      put_version
 _ddos_160:
     mov       di,offset DVIEW_LOC
     mov       ax,dv_version
     and       ax,ax
     jnz       _ddos_170
     inc       di
     call      put_yn
     jmp       short _ddos_180
 _ddos_170:
     call      put_version
 _ddos_180:

     mov       di,offset DOS_FILES_LOC
     xor       dx,dx
     mov       ax,dos_files
     mov       cx,3
     call      format

     mov       di,offset DOS_BUFF_LOC
     xor       dx,dx
     mov       ax,dos_buff
     mov       cx,3
     call      format

     mov       di,offset DOS_ENV_LOC
     xor       dx,dx
     mov       ax,dos_env_used
     mov       cx,4
     call      format
     mov       di,offset DOS_ENV_LOC + 4
     mov       byte ptr [di],'/'
     xor       dx,dx
     mov       ax,dos_env
     mov       cx,4
     mov       di,offset DOS_ENV_LOC + 5
     call      format


    ret
 disp_DOS      endp

 dfdir_options db "Conv"," XMS"," EMS","Disk","Conv"

 disp_memory   proc near


     mov       di,offset XMSV_LOC
     test      highmem_flag,01b
     jz        _dmem_40
     mov       ax,xmsver
     call      put_version

     mov       di,offset XMMV_LOC
     mov       ax,xmmver
     call      put_version

     xor       dx,dx
     mov       di,offset XMSF_LOC
     mov       cx,6
     mov       ax,xmslargest
     call      cformat

     jmp       short _dmem_50
 _dmem_40:
     mov       si,offset none
     call      copy_null
 _dmem_50:
     mov       si,offset hmause
     mov       di,offset HMA_LOC
     mov       cl,hmaavail
     mov       ch,5
     call      put_indexed

     mov       di,offset HMAF_LOC
     mov       ax,hmafree
     xor       dx,dx
     mov       cx,2
     call      format

     cmp       ems_active,0
     je        _dfmem_100               ;no active ems

     mov       si,offset EMSVER_LOC
     xor       ax,ax
     mov       al,emsversion
     mov       bl,16
               ;they store the number as a single hex number.
               ;e.g. version 4.0 is stored as 40h.  Isn't that special?
     call      word_to_asce
     mov       al,byte ptr [si-1]
     mov       byte ptr [si-1],'.'
     mov       byte ptr [si],al

 _dfmem_100:

     xor       dx,dx
     mov       ax,tpages           ;total pages EMS memory (pages)
     mov       cl,4
     shl       ax,cl               ;convert to KB
     mov       di,offset EMS_LOC-1
     mov       cx,6
     call      cformat

     xor       dx,dx
     mov       ax,apages           ;avail pages EMS memory (pages)
     mov       cl,4
     shl       ax,cl               ;convert to KB
     mov       di,offset EMS_LOC-1
     add       di,7
     mov       cx,6
     call      cformat

     xor       dx,dx
     mov       ax,avail_mem        ;available memory in paragraphs
     mov       cl,6
     shr       ax,cl               ;convert to KB
     mov       di,offset CONV_LOC
     add       di,7
     mov       cx,5
     call      cformat

     xor       dx,dx
     mov       ax,basemem        ;base memory in KB
     mov       di,offset CONV_LOC
     mov       cx,5
     call      cformat

     xor       dx,dx
     mov       ax,extmem
     mov       di,offset EXT_LOC-1
     mov       cx,6
     call      cformat


     mov       di,offset DFPROG_LOC
     mov       ax,dfprog_mem
     mov       cx,3
     xor       dx,dx
     call      cformat

     mov       di,offset DFDIR_LOC
     push      di
     mov       ax,dfdir_mem
     mov       cx,3
     xor       dx,dx
     call      cformat
     pop       di
     mov       cl,mem_use
     add       di,6
     mov       si,offset dfdir_options
     mov       ch,4
     call      put_indexed
 _dfmem_150:
     mov       di,offset DFSHELL_LOC
     mov       ax,dfshell_mem
     mov       cx,3
     xor       dx,dx
     call      cformat



     ret
 disp_memory   endp

;-----------------------------------------------------------------------------
; Searches for BIOS date and copyright info and puts in screen
;-----------------------------------------------------------------------------
 copr_array    db   "COPR.",0,"Copr.",0,"(C)",0,"(c)",0,"Copyright",0

 bios_version       proc near

     push      ds
     mov       ax,0F000h      ;point to BIOS ROM
     mov       ds,ax
     mov       si,0FFF5h      ;"normal" BIOS date offset
     mov       di,offset BIOS_LOC
     mov       cx,8
     call      movasciib

     pop       ds
     mov       cx,5           ;5 elements in copyright array
     mov       dx,offset copr_array     ;point to first element
 _bv_70:
     call      str_search
     jnc       _bv_100        ;search succeeded
     loop      _bv_70
     jmp       short _bv_200
 _bv_100:
     push      ds
     mov       ax,0F000h      ;point to BIOS ROM
     mov       ds,ax
     mov       si,dx
     mov       di,offset BIOS_LOC + 12
     mov       cx,12
     call      movasciib
     mov       cx,24
     mov       di,offset BIOS2_LOC
     call      movasciib
     pop       ds

 _bv_200:
     ret


 bios_version       endp


;---------------------------------------------------------;
; This subroutine searches through ROM for the copyright. ;
; On entry: DX points to text to match (ASCIIZ)
; On return: carry failed, dx points to next string
;            no carry succeeded, dx points to match
;---------------------------------------------------------;

 STR_SEARCH        proc near
               MOV    BX,0                   ;Start at offset zero.
               push   cx
               push   bp
               push   ds
               mov    si,dx
               call   str_len
               mov    ax,0F000h              ;point to ROM BIOS data segment
               mov    ds,ax
               mov    bp,cx
 SS_NEXT:      mov    cx,bp
               MOV    SI,BX                  ;Retrieve starting offset.
               MOV    DI,DX                  ;DX has offset of text to match.
               REPZ   CMPSB
               JZ     SS_MATCH               ;If zero, we got a match.
               INC    BX                     ;Else, point to next offset.
               JNZ    SS_NEXT                ;If back to zero, we are done.
               add    dx,bp
               inc    dx
               pop    ds
               pop    bp
               pop    cx
               STC                           ;Indicate no match with carry.
               RET
 SS_MATCH:
               mov    dx,si
               pop    ds
               pop    bp
               pop    cx
               CLC                           ;Indicate match with no carry.
               RET

 STR_Search        endp



     video_array    db "No display         "
                    db "MDA + 5151 (mono)  "
                    db "CGA + color        "
                    db "                   "
                    db "EGA + color        "
                    db "EGA + mono         "
                    db "PGA                "
                    db "VGA + analog mono  "
                    db "VGA + analog color "
                    db "                   "
                    db "MCGA + digital clr "
                    db "MCGA + analog mono "
                    db "MCGA + analog color"
     VELEMENT_LENGTH     EQU 19
     vid_unknown    db "Unknown",0

     video_array2   db "MDA "," CGA"," EGA","MCGA"," VGA"
     VELEMENT2_LENGTH EQU 4

;----------------------------------------------------------------------------
; Puts the appropriate array elements from the video bios call to the screen
;----------------------------------------------------------------------------
 disp_video         proc near
     mov       bx,bios_video
     mov       di,offset VIDEOA_LOC
     cmp       bl,0Ch
     ja        _dvideo_50
     mov       ch,VELEMENT_LENGTH
     mov       si,offset video_array
     mov       cl,bl
     call      put_indexed
     jmp       short _dvideo_100
 _dvideo_50:
;     mov       si,offset vid_unknown
;     call      copy_null
     call      get_adapter
     mov       cl,al
     mov       si,offset video_array2
     mov       ch,VELEMENT2_LENGTH
     call      put_indexed
     jmp       short _dvideo_ret
 _dvideo_100:
     mov       di,offset VIDEOB_LOC
     cmp       bh,0Ch
     ja        _dvideo_150
     mov       si,offset video_array
     mov       cl,bh
     call      put_indexed
     jmp       short _dvideo_ret
 _dvideo_150:
     mov       si,offset vid_unknown
     call      copy_null
 _dvideo_ret:
     ret
 disp_video         endp

 floppy_types  db   "none     "
               db   "360KB 5 "
               db   "1.2MB 5 "
               db   "720KB 3 "
               db   "1.44MB 3"
               db   "2.88MB 3"
               db   "320KB 5 "
               db   "unknown  "


disp_global_drive proc near

     ;display logical drives
     mov       di,offset LOGDRV_LOC
     mov       si,offset logical_drives
     mov       cx,logical_count
     rep       movsb

     ;wipe out HD CMOS msg if no CMOS

     call      test_for_cmos  ;returns carry set if CMOS not found
     jnc        ndgd_100

     mov       di,offset NUM_HDRIVE_LOC + 12
     mov       si,offset noCMOSmsg
     call      copy_null
     test      siset,010b               ;shut off CMOS
     jz        ndgd_200
     mov       di,offset NUM_HDRIVE_LOC + 12
     mov       si,offset noCMOSsense
     call      copy_null
     jmp       short ndgd_200


ndgd_100:
     ;display CMOS hard drive types
;     mov       di,offset HD1_LOC
;     xor       dx,dx
;     xor       ax,ax
;     mov       cx,2
;     mov       al,drive0
;     call      format
;
;     mov       di,offset HD2_LOC
;     xor       dx,dx
;     xor       ax,ax
;     mov       cx,2
;     mov       al,drive1
;     call      format
ndgd_200:

     ;display floppy count
     mov       si,offset NUM_DISKETTE_LOC
     mov       al,num_floppies
     mov       ah,0
     mov       bl,10                    ;decimal radix
     call      word_to_asce



     ;display floppies
     mov       di, offset FLOP1_LOC
     mov       bx,0
     call      display_floppy

     mov       di, offset FLOP2_LOC
     mov       bx,1
     call      display_floppy

     mov       di, offset FLOP3_LOC
     mov       bx,2
     call      display_floppy

     mov       di, offset FLOP4_LOC
     mov       bx,3
     call      display_floppy

     ;display hard disk count
     mov       si,offset NUM_HDRIVE_LOC
     mov       al,num_hdrive
     mov       ah,0
     mov       bl,10                    ;decimal radix
     call      word_to_asce

     ret
disp_global_drive    endp

;------------------------------------------------------------------------
; Displays floppies
; On entry: di points to defined floppy printout offset
;           bx points to offset in floppy tables
; Displays nothing if floppy type = none
;------------------------------------------------------------------------
display_floppy proc near
     mov       si,offset FloppyType
     mov       cl,byte ptr [si+bx]      ;type of floppy (array offset)
     cmp       cl,0
     je        dflop_ret
     mov       ch,9                     ;length of array elements
     push      di
     mov       si,offset floppy_types
     call      put_indexed
     pop       di
     sub       di,3
     mov       si,offset FloppyLetter
     mov       al,byte ptr [si+bx]
     stosb
     mov       al,':'
     stosb
     ret
dflop_ret:
     ret

display_floppy endp

;-----------------------------------------------------------------------------
; Puts null terminated string pointed to by si onto screen with current
; attribute
;-----------------------------------------------------------------------------
 PUT_LEN_CHARS proc near
     call str_len
     call put_cx_chars
     ret
 PUT_LEN_CHARS endp

 COPY_NULL     proc near
     call str_len
     rep  movsb
     ret
 COPY_NULL     endp
;-----------------------------------------------------------------------------
; Puts cl entry (0 base) of array with element length ch to location pointed
; to by di.  On entry, si points to first element of array
;-----------------------------------------------------------------------------
 PUT_INDEXED   proc near
     push      ax cx bx
     mov       ax,cx
     xor       cx,cx
     xor       bx,bx
     mov       bl,ah     ;bx now contains element length
     mov       cl,al
     and       cl,cl
     jz        _pidx_200 ;skip loop if zero
 _pidx_100:
     add       si,bx
     loop      _pidx_100
 _pidx_200:
     mov       cl,ah
     rep       movsb
     pop       bx cx ax
     ret
 PUT_INDEXED   endp

;-----------------------------------------------------------------------------
; Puts a Y or N to di as a function of the al register value
;-----------------------------------------------------------------------------
 PUT_YN        proc near
     cmp       al,0
     jne       _pyn_100
     mov       al,'N'
     jmp       short _pyn_200
 _pyn_100:
     mov       al,'Y'
 _pyn_200:
     stosb
     ret
 PUT_YN        endp

;------------------------------------------------------------------------------
; PUT_VERSION
; Takes a software version number of the form ah=major version and al=minor
; version and displays to di.  Inserts leading 0 for minor version as
; required.
;------------------------------------------------------------------------------
 PUT_VERSION   proc near
     mov       bx,ax
     xor       ax,ax
     mov       al,bh
     mov       si,di
     push      bx
     mov       bx,10
     call      word_to_asce
     pop       bx
     mov       byte ptr [si],'.'
     inc       si
     mov       word ptr [si],'00'
     xor       ax,ax
     mov       al,bl
     cmp       al,10
     jae       _pv_10
     inc       si
 _pv_10:
     push      bx
     mov       bx,10
     call      word_to_asce
     pop       bx
     ret
 PUT_VERSION  endp

;-----------------------------------------------------------------------------
; on input, si points to spaces to blank
; dx has number of spaces
;------------------------------------------------------------------------------
 put_spaces    proc near
     push      di si cx ax
     mov       cx,dx
     mov       di,si
     mov       al,20h
     rep       stosb
     pop       ax cx si di
     ret
 put_spaces    endp


;----------------------------------------------------------------------------
; Works just like movsb but ascii chars only
;-----------------------------------------------------------------------------
 movasciib     proc near

 _mascb_100:
     lodsb                    ;don't want to print any garbage
     cmp       al,32          ;(date's not always there) so rep movsb
                             ;isn't a great idea
     jb        _mascb_200
     cmp       al,'z'
     ja        _mascb_200
     stosb
     loop      _mascb_100
 _mascb_200:
     ret

 movasciib     endp

.8087
;--------------------------------------------------------------------------
; check for Pentium FPU bug
; Rteurns Z(ero)/NZ for OK/Bad
;---------------------------------------------------------------------------
 one      dt   1.0
 bugnr    dt   824633702449.0
 diff     dt   ?    ;should be 0.0 after testing

testndp   proc near

     finit
     fld       [one]
     fld       [bugnr]
     fdivp     st(1),st
     fld       [bugnr]
     fmulp     st(1),st
     fld       [one]
     fsubp     st(1),st
     fstp      [diff]
     fwait
     mov       ax, word ptr [diff]
     or        ax, word ptr [diff+2]
     or        ax, word ptr [diff+4]
     ret
testndp endp
.8086
NOJUMPS

;Copies one of the disk display subwindows into the main sysinfo window
;On entry:
;              Al   =1 for logical disk window
;                   =2 for physical disk window
;                   =3 for help subwindow

implant_subwindow   proc near
     mov  subwin_state,al
     mov  cx,7      ;lines to move
     mov  di,offset SIWIN_TL
isub_30:
     cmp  al,1
     ja   isub_40
     mov  si,offset ld_line0
     jmp short isub_100
isub_40:
     cmp  al,2
     ja   isub_50
     mov  si,offset pd_line0
     jmp short isub_100
isub_50:
     mov  si,offset hd_line0
     jmp short isub_100

isub_100:
     mov  bx,SIWIN_LENGTH
     xchg bx,cx
     push di si
     rep  movsb
     pop  si di
     add  di,SI_LENGTH
     add  si,SIWIN_LENGTH
     xchg bx,cx
     loop isub_100

     ret
implant_subwindow   endp

DoSIhelp       proc near
     mov  bl,subwin_state
     mov  ax,3
     push bx
     call implant_subwindow
     call      draw_sigrid

     mov  ah,0      ;wait for a keystroke
     int  16h

     pop  bx
     mov  al,bl
     call implant_subwindow
     call      draw_sigrid
     ret
DoSIhelp       endp

;--------------------------------------------------------------------------
; change_displayed_logical
; On entry:
;    al contains extended ASCII keycode
;    Puts a valid physical drive number (0 to 7) into cpdrive
;
;--------------------------------------------------------------------------

change_displayed_physical  proc near
     cmp  al,UARROW
     je   cdp_100
     cmp  al,DARROW
     je   cdp_100
cdp_err:
     stc                      ;no valid key for this routine, exit w/ error
     ret
cdp_100:                      ;we have a valid keypress
     cmp  num_hdrive,0        ;can't do anything here if no hard drives
     jbe   cdp_err
     cmp  num_hdrive,1        ;simple case if only one hard drive. Set it.
     ja   cdp_200
     mov  cpdrive,0
     jmp  cdp_ret
cdp_200:
     mov  bl,cpdrive           ;we're now on the current drive
     cmp  al,DARROW
     je   cdp_300

     ;must be an up arrow
     cmp  subwin_state,2
     jne  cdp_210
     dec  bl
cdp_210:
     cmp  bl,0
     jge  cdp_ret             ;still within table
     add  bl,num_hdrive       ;wrap around
     jmp  cdp_ret
cdp_300:
     cmp  subwin_state,2
     jne  cdp_310
     inc  bl
cdp_310:
     cmp  bl,num_hdrive
     jb   cdp_ret             ;still within table
     mov  bl,0                ;wrap around
;     jmp  cdp_ret

cdp_ret:
     mov  cpdrive,bl
     clc
     ret

change_displayed_physical  endp

abuffer   db 15 dup(0)
abuffer_length equ 15
;--------------------------------------------------------------------------
; display_physical
; On entry:
;    cpdrive contains the index into HdriveAddr to display
;
;--------------------------------------------------------------------------
display_physical      proc near

     mov  si,offset HdriveAddr
     xor  bx,bx
     mov  bl,cpdrive
     mov  dl,byte ptr [si+bx]      ;retrieve address in dl of current drive

        call    hdsktype           ; drive type in al
        cmp     al, 0
        jne     dp_100
        jmp     dp_err             ; jump if no drive (shouldn't happen here)

dp_100:
        push    ax
        mov     ax, cx             ; get cylinders
        mov     di, offset hcyldr
        mov     word ptr [di], '  '
        mov     word ptr [di+2], '  '
        mov     bl, 1              ; no left justification
        call    decw               ; insert cylinders (decimal)

        xor     ah, ah
        mov     al, dh             ; get heads
        mov     hheads+3, ' '      ; blank from prior use
        mov     di, offset hheads
        mov     bl, 1              ; no left justification
        call    decw               ; insert heads (decimal)

        xor     ah, ah
        mov     al, dl             ; get sectors
        mov     hsector+3, ' '     ; blank from prior use
        mov     di, offset hsector
        mov     bl, 1              ; no left justification
        call    decw               ; insert sectors (decimal)

        mov     al, dh
        mul     dl                 ; ax = heads * sectors
        mul     cx                 ; dx:ax = total bytes/512
        mov     cx, 11             ; divide to get Megabytes
dp_200:
        shr     dx, 1              ; shift right into carry
        rcr     ax, 1              ; rotate right with carry
        loop    dp_200
        mov     di, offset hsize
        xor     bl, bl             ; left justification
        call    decw               ; insert total size in MB
        mov     word ptr [di], 'M '  ; insert " MB   "
        mov     word ptr [di+2], ' B'
        mov     word ptr [di+4], '  '

        pop     ax                 ; get type back
        dec     al                 ; zero based
        mov     cx, offset hdrvend - offset hdrvtyp
        mul     cl                 ; ax = cl * al
        add     ax, offset hdrvtyp
        mov     si, ax
        mov     di, offset hdrvtxt
        cld
        rep     movsb              ; xfer string

        mov     al,cpdrive
        add     al,48
        mov     di,offset hdrvnum
        stosb
        mov     al,space
        stosb
        mov     al,'('
        stosb

        mov  si,offset HdriveAddr
        xor  bx,bx
        xor  ax,ax
        mov  bl,cpdrive
        mov  al,byte ptr [si+bx]      ;retrieve address

        mov  bl,16
        xchg   si,di
        call word_to_asce
        xchg   si,di

        mov    al,'h'
        stosb
        mov    al,')'
        stosb


;clear out changeable area

     mov       al,space
     mov       di,offset pd_line0
     mov       cx,7
 dp_300:
     push      cx di
     mov       cx,15
     rep       stosb
     pop       di cx
     add       di,SIWIN_LENGTH
     loop      dp_300

      mov      si,offset hsize
      mov      di,offset PSIZE_LOC
      call     right_align

      mov      si, offset hdrvtxt
      mov      di, offset PCONTROLLER_LOC
      call     right_align

      mov      si, offset hcyldr
      mov      di, offset PCYLINDERS_LOC
      call     right_align

      mov      si, offset hheads
      mov      di, offset PHEADS_LOC
      call     right_align

      mov      si, offset hsector
      mov      di, offset PSECTORS_LOC
      call     right_align

      mov      si, offset hdrvnum
      mov      di, offset PNUMBER_LOC
      call     right_align

      ;only look at CMOS drive types if drive 0 or 1
     call      test_for_cmos  ;returns carry set if CMOS not found
     jc        dp_ret

      cmp      cpdrive,1
      ja       dp_ret

      ;blank out message area
      mov      si,offset CMOSmsg
      mov      al,space
      stosb
      stosb
      stosb

      mov      si,offset drive0
      xor      ax,ax
      mov      al,cpdrive
      add      si,ax
      mov      al,byte ptr [si]
      cmp      al,0
      je       dp_ret
      mov      si,offset CMOSmsg
      mov      bl,10
      call     word_to_asce

      mov      si, offset CMOSmsg
      mov      di, offset PCMOS_LOC
      call     right_align

dp_ret:
     mov  ax,2
     call implant_subwindow
     call      draw_sigrid
     clc
     ret
dp_err:
     stc
     ret
display_physical      endp

;---------------------------------------------------------------------------
;Right Align a string
;On entry: si points to the source string
;          di point to right end of destination
;Note: there MUST be a 0 BEFORE the source string since we copy it into
;      the destination backwards. Max length 14.
;The buffer probably isn't strictly needed but the original strings
; were getting a bit messed up so this was easier
;
;---------------------------------------------------------------------------
          db 0
bbuffer   db 15 dup(0)
bbuffer_length equ 15

right_align proc near

      ;make sure the buffer is clean
      push     di
      mov      cx,15
      mov      al,0
      mov      di,offset bbuffer
      rep      stosb
      pop      di

      push     di
      mov      di, offset bbuffer
      call     copy_to_zero
      pop      di

      mov      si, offset bbuffer
      push     di
      call     str_rev             ;we reverse the string
      mov      al,space
      call     str_chrn            ;we set si to the first non-space in the REVERSED string
      jc       ra_ret              ;everything's a space
      call     str_rev             ;we swap the string back
      call     str_len
      dec      cx
      add      si,cx               ;and point to the end

      pop      di
      std                          ;do it backwards
      call     copy_null
      cld                          ;fix the direction flag
ra_ret:
      ret

right_align    endp

;----------------------------------------------------------------------------
; Interpret_si_keys
; On entry: al contains keycode
; Performs appropriate actions
;----------------------------------------------------------------------------

interpret_si_keys   proc near

     ;first check out if it's relevant to physical drives (0 to 7)

     cmp  al,'0'
     jb   isk_100
     cmp  al,'7'
     ja   isk_100
     mov  bl,num_hdrive
     dec  bl
     add  bl,'0'              ;turn max harddrive # into an ASCII number
     cmp  al,bl
     ja   isk_ret             ;trying to do physical but number too big
     sub  al,'0'              ;turn into number
     mov  cpdrive,al          ;store
     call display_physical    ;and display appropriate drive
     ret

isk_100:
     call to_upper            ;convert to uc if lc
     cmp  al,'A'
     jb   isk_ret
     cmp  al,'Z'
     ja   isk_ret
     mov  cx,26
     mov  di,offset logical_drives
     repnz  scasb
     jcxz isk_ret             ;not found
     dec  di                  ;mov di back

     ;change the current drive
     mov       dl,byte ptr [di]
     sub       dl,'A'
     mov       cdrive,dl
     mov       ah,0Eh
     int       21h

     call      disp_current_logical
     jc        isk_ret
     mov       ax,1
     call      implant_subwindow
     call      draw_sigrid

isk_ret:
     ret
interpret_si_keys   endp