;----------------------------------------------------------------------------
;DFMEM.ASM
;Set of routines to setup and manage program and directory memory
;
;Mostly new DF4.60 although a few routines from earlier revs moved to this
;module
;


 min_mem     dw   2000H            ;minimum memory in paragraphs
                                   ;if you have less than this, DF won't start
 avail_mem   dw   ?                ;Available memory prior to DF (paragraphs)
 used_mem    dw   ?                ;Unswappable memory in use (paragraphs)
 dbs_start   dw   0059h            ;start of dir in dir_buf_seg (default)
                                   ;leave some space so don't get seg wrap
                                   ;problems
 dbs_end     dw   0FF40h           ;end of
 DIRALLOC    DW   1000H            ;size of program to shrink to
 mem_use            db  0          ;memory allocation scheme in use
                                   ;0 if 64KB for DF & dir
                                   ;1 if 64KB XMS
                                   ;2 if 64KB EMS
                                   ;3 if 64KB conventional
                                   ;4 if 64KB swap file
;---------------------------------------------------------------------------
;XMS variables
;
 xmsaddr       dd ?
 xmsreqsize    equ  64   ;kb extended memory to allocate
 xmstotal      dw   0
 xmslargest    dw   0
 xmshandle     dw   0

 movepars       equ  $
 movelen       dd   0
 shandle       dw   0
 soffset       dd   0
 dhandle       dw   0
 doffset       dd   0

;EMS variables

 emmname       db  'EMMXXXX0',0
 pneeded       equ  4    ;number of EMS pages needed
 pframe        dw   0    ;page frame address
 tpages        dw   0    ;total EMS pages
 apages        dw   0    ;available EMS pages
 emshandle     dw   0    ;handle for allocated pages
 emsversion    db   0
 pagelen       equ  4000h





;----------------------------------------------------------------------
;INIT_MEM
;This routine initializes program memory.
;On entry: Sets mem_use and sets up initial allocation based on mem_swap (
;          which may have been previously altered by command-line switches)
;Modifies: assume everything
;Returns:  carry clear if successful
;          carry set if failed and DX points to error message
;          sets mem_use to what is being used
;
 INIT_MEM proc near

     ;we start doing our memory allocation tests.
     test      mem_swap,XMS_MASK
     jnz       _imem_100             ;XMS not requested
     call      xms_alloc
     jnc       _imem_ret
_imem_100:
     test      mem_swap,EMS_MASK
     jnz       _imem_200             ;EMS not requested
     call      ems_alloc
     jnc       _imem_ret
_imem_200:
;     test      mem_swap,CONV_MASK
;     jnz       _imem_300
;     mov       mem_use,3
;     jmp       short _imem_ret
_imem_300:
;     mov       mem_use,0
;     jmp       short _imem_ret
_imem_err:
     mov       dx,offset not_enough
     stc
     ret
_imem_ret:
     clc
     ret
 INIT_MEM      endp

;----------------------------------------------------------------------------
; PREEXEC
; Swaps a large conventional memory block to either XMS or EMS and
; deallocates that block prior to an EXEC
;
;----------------------------------------------------------------------------

  PRE_EXEC     proc near

     push      ax
     cmp       mem_use,1
     jne       _pre_e100

     ;copy directory segment to previously allocated XMS block
     ;and deallocate directory segment block
;     JMP       _PRE_E100

     mov       shandle,0
     mov       ax,dbs_start
;     mov       ax,0
     mov       word ptr soffset,ax
     mov       ax,dir_buf_seg
     mov       word ptr soffset+2,ax
     mov       ax,xmshandle
     mov       dhandle,ax
     mov       word ptr doffset,0
     mov       word ptr doffset+2,0
     mov       ax,dbs_end
     sub       ax,dbs_start
     inc       ax
;     mov       word ptr movelen,ax
     ;seems to be some restrictions on what length of movelen can look like
     mov       word ptr movelen,0FF00h
     mov       word ptr movelen+2,0
     mov       ah,0bh
     mov       si,offset movepars
     call      xmsaddr
     or        ax,ax
     jz        _pre_eerr

     jmp       short _pre_e200


 _pre_e100:
     cmp       mem_use,2
     jne       _pre_eret

     ;copy directory segment to previously allocated and mapped EMS pages
     assume ds:nothing, es:nothing
     mov       cx,4
     push      ds
     push      es
     mov       es,pframe
     mov       ax,dir_buf_seg
     mov       ds,ax
     xor       di,di
     xor       si,si
 _pre_e150:
     push      cx
     mov       cx,pagelen
     rep       movsb
     pop       cx
     loop      _pre_e150

     pop       es
     pop       ds
     assume ds:_text, es:_text

 _pre_e200:

     push      es
     mov       ax,dir_buf_seg
     mov       es,ax
     mov       ah,49h              ;release DIR_BUF_SEG
     int       21h
     pop       es
     jc        _pre_eerr

 _pre_eret:
     pop       ax
     clc
     ret
 _pre_eerr:
     pop       ax
     stc
     ret
  PRE_EXEC     endp

;----------------------------------------------------------------------------
; POST_EXEC
; Basically undoes whatever PRE_EXEC did and restores things to the way
; they were prior to the EXEC
;----------------------------------------------------------------------------

  POST_EXEC    proc near
     push      ax
     cmp       mem_use,1
     jne       _post_e100

;     JMP       _POST_E100

     mov       ah,48h                  ;create 64KB block for directory
     mov       bx,1000H
     int       21h
     mov       DIR_BUF_SEG,AX
     jc        _post_eerr

     ;copy XMS block to directory segment
     mov       dhandle,0
     mov       ax,dbs_start
;     mov       ax,0
     mov       word ptr doffset,ax
     mov       ax,dir_buf_seg
     mov       word ptr doffset+2,ax
     mov       ax,xmshandle
     mov       shandle,ax
     mov       word ptr soffset,0
     mov       word ptr soffset+2,0
     mov       ax,dbs_end
     sub       ax,dbs_start
     inc       ax
;     mov       word ptr movelen,ax
     mov       word ptr movelen,0FF00h
     mov       word ptr movelen+2,0
     mov       ah,0bh
     mov       si,offset movepars
     call      xmsaddr
     or        ax,ax
     jz        _post_eerr


 _post_e100:
     cmp       mem_use,2
     jne       _post_eret

     mov       ah,48h                  ;create 64KB block for directory
     mov       bx,1000H
     int       21h
     mov       DIR_BUF_SEG,AX
     jc        _post_eerr

     assume ds:nothing, es:nothing
     mov       cx,4
     push      ds
     push      es
     mov       es,dir_buf_seg
     mov       ax,pframe
     mov       ds,ax
     xor       di,di
     xor       si,si
 _post_e150:
     push      cx
     mov       cx,pagelen
     rep       movsb
     pop       cx
     loop      _post_e150

     pop       es
     pop       ds
     assume ds:_text, es:_text

 _post_eret:
     pop       ax
     clc
     ret
 _post_eerr:
     pop       ax
     stc
     ret
  POST_EXEC    endp

;---------------------------------------------------------------------------
;
;----------------------------------------------------------------------------

 DEALLOC_MEM   proc near

     cmp       mem_use,0           ;small memory, nothing to do
     je        _dealloc_ret

                                   ;large memory, dealloc conventional
                                   ;block first
     push      es
     mov       ax,dir_buf_seg
     mov       es,ax
     mov       ah,49h              ;release DIR_BUF_SEG
     int       21h
     pop       es


     cmp       mem_use,1
     jne       _dealloc_100

     mov       ah,0Ah
     mov       dx,xmshandle
     call      xmsaddr
     jmp       _dealloc_ret


 _dealloc_100:
     cmp       mem_use,2
     jne       _dealloc_200

     mov       ah,45h              ;release EMS pages
     mov       dx,emshandle
     int       67h

 _dealloc_200:
     cmp       mem_use,3
     jne       _dealloc_300

 _dealloc_300:




 _dealloc_ret:
     clc
     ret

 DEALLOC_MEM   endp


;---------------------------------------------------------------------------
;XMS_ALLOC
;Allocate 64KB block of XMS memory.  On failure, returns carry set.
;On success, carry clear, xmshandle contains handle to memory,
;   xmsaddr is far pointer to driver, mem_use set
;---------------------------------------------------------------------------

 XMS_alloc     proc near

     test      highmem_flag,01b
     jz        _xmsa_error

     mov       dx,xmstotal
     cmp       dx,xmsreqsize
     jb        _xmsa_error              ;not enough XMS memory

     mov       ah,9                     ;allocate block
     mov       dx,xmsreqsize
     call      xmsaddr
     or        ax,ax                    ;allocation successful?
     jz        _xmsa_error
     mov       xmshandle,dx             ;save XMS handle

     mov       mem_use,1

     clc
     ret
 _xmsa_error:
     stc
     ret
 XMS_alloc     endp

;---------------------------------------------------------------------------
; Allocate 64KB block of EMS memory.  On failure carry returned set.
;
;---------------------------------------------------------------------------

 EMS_alloc     proc near

     test      highmem_flag,010b
     jz        _ems_ret_err

 _ems_alloc_50:
     mov       bx,apages
     cmp       bx,pneeded
     jb        _ems_ret_err

     mov       ah,43h              ;allocate EMS pages
     mov       bx,pneeded
     int       67h
     or        ah,ah
     jnz       _ems_ret_err
     mov       emshandle,dx

     mov       ah,41h              ;get page frame address
     int       67h
     or        ah,ah
     jnz       _ems_ret_err
     mov       pframe,bx           ;save segment of page frame

     mov       dx,emshandle
     mov       cx,4                ;map pages 0-3

_ems_alloc_100:
     mov       al,cl
     dec       al
     mov       bx,cx
     dec       bx
     mov       ah,44h
     int       67h
     loop      _ems_alloc_100

     mov       mem_use,2
     clc
     ret
 _ems_ret_err:
     stc
     ret
 EMS_alloc     endp


 CONV_alloc    proc near

     mov       mem_use,3
     clc
     ret
 CONV_ALLOC    endp



;------------------------------------------------------------------------
; GET MIN_MEM
; Sets diralloc to minimum size program can be shrunk to
;
;-------------------------------------------------------------------------
 GET_MIN_MEM   proc near

     mov       ax,offset last_byte
     add       ax,1000                   ;add for stack & init. offset
     mov       cl,4
     shr       ax,cl                    ;turn into parahraphs
     mov       diralloc,ax
     ret

 GET_MIN_MEM   endp




 mem_commands  db "0","P","T","C"
 mem_results   db 0111b, NOT EMS_MASK, NOT XMS_MASK, NOT CONV_MASK
 last_mem_result equ $-2

;--------------------------------------------------------------------------
; COMMAND_MEM
; Sets mem_use variable per command-line override
; On entry: AL contains 0 (small), P (expanded), T (extended=XMS), or
;                       C (conventional)
; Modifies: mem_swap (if match found), all registers
; Returns: Nothing (if AL not valid, nothing is changed)
;---------------------------------------------------------------------------

 COMMAND_MEM   proc near

     MOV       DI,OFFSET CMD_LINE      ;Point to command line
     XOR       CX,CX
     MOV       CL,[DI]
     INC       CX
     INC       DI

 _cmem_100:
     MOV       AL,SWITCH
     REPNZ     SCASB
     JCXZ       _com_mem_ret

     MOV       AL,[DI]
     PUSH      DI
     PUSH      CX

     AND       AL,5FH
     cmp       al,"M"
     pop       cx
     pop       di
     jne       _cmem_100

     mov       al,byte ptr[di+1]
     .to_upper al

 _cmem_200:
     mov       di,offset mem_commands
     mov       cx,4
     repnz     scasb
     jnz       _com_mem_ret
     mov       bx,offset last_mem_result
     sub       bx,cx
     inc       bx
     mov       al, byte ptr [bx]
     mov       mem_swap,al
 _com_mem_ret:
     ret
 COMMAND_MEM   endp



;==========================================================================
; Routines used to allocate viewer memory
;==========================================================================

 ;------------------------------------------------------------------;
 ; This subroutine requests a block of free memory
 ; Returns  :  Allocated memory at AX:0
 ;             Memory allocated in BX
 ; Modifies : everything except SI?
 ;------------------------------------------------------------------;
       ASSUME  DS:_TEXT,ES:_TEXT
 GET_MEM               PROC    NEAR
       MOV     BX,0A000H               ;Request the world (640k)
 _G_M1:        PUSH    SI                      ;save pointer
       MOV     AH,48H                  ;ax returns pointer to block
       INT     DOSINT                  ;bx returns paragraphs allocated
       POP     SI
       JNC     _G_M2                   ;success
       CMP     AL,8                    ;check for a nasty error
       JNZ      _G_M_ER                ;not just insufficient memory
       AND     BX,0F000h               ;round available memory to N 64k segs
       JNZ     _G_M1                   ;try again if not zero
 _G_M_ER:
       MOV     N_SEGS,0                ;reset segs available
       STC
       RET                             ;uh-oh, not just error 8

 _G_M2:        MOV     MEM_BUF_SEG,AX          ;save start of file buf
       MOV     CL,4                    ;x16 to find top byte
       SHR     BH,CL                   ;of this seg and then
       JZ      _G_M_ER                 ;no memory
       MOV     N_SEGS,BH               ;save it
       CLC
 _G_M_X:       RET

 GET_MEM       ENDP

 ;------------------------------------------------------------------;
 ; This subroutine releases memory allocated by GET_MEM
 ; On entry : MEM_BUF_SEG conatins segment pointer of allocated memory
 ;------------------------------------------------------------------;
 RELEASE_MEM   PROC    NEAR
       CMP     N_SEGS,0
       JZ      _R_MEM_RET
       PUSH    ES
       MOV     ES,MEM_BUF_SEG
       MOV     AH,49H                  ;free allocated block
       INT     DOSINT
       POP     ES
       MOV     N_SEGS,0                ;reset segs available
 _R_MEM_RET:
       RET
 RELEASE_MEM   ENDP