title DF.asm  Directory Freedom  Copyright 2000 by Gordon R. Haff

COMMENT |

  Author: Gordon Haff, copyright 1989-2000
  version: 4.61B
  Distributed under the terms of the GPL (General Public License)

      4.60 - Note 1: the various org statements at the beginning of program
                     converted to allow for memory management work

|     ;end comments

INCLUDE DFSA.INC
INCLUDE DFMACROS.ASM

;program equates:
 nul   equ     00h
 tab   equ     09h
 cr    equ     0dh
 lf    equ     0ah
 space equ     20h

;equates for sharing modes (MS-DOS function 3Dh)
;added DF 4.60 because of possible SHARE conflicts -- though this shouldn't
;be the issue
 FULLACCESSPERMITTED equ 01000000b  ;read only/deny none


 ;macro equate to calculate position in display memory
 CROW  EQU     * 2 + 2 * 80 *

 SCR_WIDTH	EQU	80
 NUM_VIEWERS   EQU  20        ;number of supplementary (extension specific) viewers

 DOSINT                EQU     21h
 COPY_MARK     EQU     26
 MEMNEEDED     EQU  2000H ; 128K NEEDED TO RUN PROGRAM

 ALT_SHIFT     EQU     08H
 CTRL_SHIFT    EQU     04H
 LSHIFT_SHIFT  EQU     02H
 RSHIFT_SHIFT	EQU	   01H

 NAME_MASK     EQU     01B
 EXT_MASK      EQU     010B
 SIZE_MASK     EQU     0100B
 DATE_MASK     EQU     01000B
 ATTR_MASK     EQU     010000B

 ROW1          EQU     2
 ROW_LEN       EQU     0 CROW 1
 BAR_START     EQU     1 + 1 CROW ROW1

;equates replaced with variables for multiple screen modes
; DIR_ROWS          EQU     20
; DIR_ROW_END   EQU     BAR_START + 0 CROW DIR_ROWS
;  VIEW_ROWS     EQU     24      ;numbers of text rows in view display
; LAST_ROW      EQU     ROW1+DIR_ROWS

 WHERE_LOC     EQU     14      ;col to display current location in view
 WHERE_LEN     EQU     08      ;col's allocated


 ;     locations of data within DTA after FIND_FIRST
 F_ATTR                EQU     21
 F_TIME                EQU     22
 F_DATE                EQU     24
 F_SIZE                EQU     26
 F_NAME                EQU     30

 DIR_RECORD    STRUC
       D_MRK   DB      ?
       D_NAME  DB      8 DUP (?)
               DB      ?
       D_EXT   DB      3 DUP (?)
               DB      ?
       D_SIZE  DB      8 DUP (?)
               DB      ?,?
       D_DATE  DB      8 DUP (?)
               DB      ?,?
       D_TIME  DB      6 DUP (?)
       D_HID   DB      ?
       D_SYS   DB      ?
       D_RO    DB      ?
       D_ARC   DB      ?
 DIR_RECORD    ENDS

 FIELD_SIZE    EQU     1 + D_ARC - D_MRK
 BAR_LEN               EQU     D_HID - D_NAME

;Masks for mem_swap
     XMS_MASK  EQU    01b
     EMS_MASK  EQU    010b
     CONV_MASK EQU    0100b

 ;
 comment |
 SUBTTL Segment data defines
 page
 ROM_BIOS_DATA SEGMENT AT 40h          ; Low Memory "BIOS" Parameters
 ;
       org     10h                     ; Location of EQUIP_FLAG
 EQUIP_FLAG    dw      ?               ; Contains video settings
                                       ; in bits 4 and 5
       org     17h                     ; Location of KB_FLAG
 KB_FLAG       db      ?               ; Contains Alt (bit 3) &
                                       ; Right Shift (bit 0) States
 ;
       org     63h
 ADDR_6845     dw      ?
 CRT_MODE_SET  db      ?
 ROM_BIOS_DATA ends
 |
 ;
 ;comment |
NOWARN UNI
 DUMMY_SEG     SEGMENT AT 1000H
               ORG 00H
 PAGES         DW      7F0h DUP (?)    ;table of screen page sizes
 FILE_BUFF     DB      ?

               ORG     0FFF0H
 END_BUFF      DW      0       ;dummy place holder
 READ_SIZE     EQU     ((END_BUFF - FILE_BUFF)/2) AND 0F800h

 FILE_PTR      DW      ?
               DW      ?
 FILE_END      DW      ?
 LAST_PAGE     DW      ?
 LAST_COL      DW      ?
 ROW           DB      ?
 DUMMY_SEG     ENDS
WARN UNI
;|
 ;
 _TEXT SEGMENT word PUBLIC 'CODE'
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT

 ;
	  ORG	0
 seg_org		EQU	   $

       ORG     2
 PSP_TOP_MEM   LABEL   WORD            ;last paragraph of available mem
       ORG     6
 PSP_TOP_SEG   LABEL   WORD
       ORG     2Ch
 PSP_ENV_SEG   LABEL   WORD

       ORG     5CH
 PSP_FCB       DB      ?

       ORG     80H
 CMD_LINE      LABEL   BYTE
 DTA           LABEL   BYTE

 SUBTTL Data area
 page
       ORG     100H
 START:        JMP     MAIN

 COMMAND_LINE_MAX  EQU  34

 ;--------------------------------------------------------------------------
 ; The following section are modifiable values through DFCONFIG
 ;   Basically any size changes in this section have implications for
 ;   DFCONFIG.
 ;--------------------------------------------------------------------------

 MARKER        DB      "%(&#@)"                ;marker to locate attributes
 REV_CONTROL   DB      'C'    ;Rev control byte.  Tells DFCONFIG things
 NUM_SWITCHES  DB	   17	;number of BYTES before LIST_CMD_LINE

 C_NORMAL      DB      2                       ;dir text attribute
 C_INTENSE     DB      03h                     ;path name attribute
 C_MENU_ATT    DB      1EH                     ;menu text attribute
 C_BORDER      DB      10H                     ;menu border attribute
 C_INVERSE     DB      74H                     ;high-lighted dir entry
 c_menu2_attr  db	   17h

 SWITCH                DB      '/'
 STATUS_REG    DW      0FFH
 blanks2       dw      0
 SORT_DEFAULT  DB      'N'
 VERIFY_DEFAULT DB	   'F'	;Maybe means don't change existing state
						;Yes means on, No means off; /V switch has priority
						;F means off except on copy to floppy
 SOUND_DEFAULT  DB	  0		;0 means standard DOS '07' services beep
						;1 means softer BIOS beep
 EXT_KYBD_FLAG  DB    2       ;1 use extended keyboard bios funcs, 0 don't
						;2 autosenses -- change to 0 or 1 by check_keyboard
 SHIFT_STATE_FLAG  DB  0      ;bit 0 = 0 if Alt key used for secondary 'hard' functions
						;bit 0 = 1 if Left shift used for these
 INIT_VIDEO_MODE	DB	0	; 0 = 80x25; 1 = 80x43/50

 SEARCH_ATTRIB  DB   17H      ;what attrib files to display (10111b)
						;We use this to screen display -- but note that DOS
						;FIND_FIRST/FIND_NEXT functions don't actually screen
						;like you might expect.  Manual screening done
						;in READ_DIR
                              ;        Bit
                              ;76543210
                              ;       1      Read-only
                              ;      1       Hidden
                              ;     1        System
                              ;    1         Volume label
                              ;   1          Subdirectory
                              ;  1           Archive

 printer_port  db      9      ;0 = LPT1, 1=LPT2, 2=LPT3, 9=PRN
 m_vertical    DW      5
 mouse_on      db      1      ;set to 0 to deactivate mouse
 SORT_UP_FLAG  DB     01100b  ;1 if descending order sort, 0 if ascending order
                              ;bit 0: Name
                              ;    1: Extension
                              ;    2: Size
                              ;    3: Date
                              ;    4: Attribute
 over_key      DB      0      ;if 0: <Control-Enter> overrides SmartViewers
                              ;   1: Regular <Enter> overrides
 no_cfg        db      0      ;make 1 to bypass all cfg file stuff
 mem_swap      db   000b      ;Controls memory swap options
                              ;bit 0: 0 if try to use XMS
                              ;bit 1: 0 if try to use EMS
                              ;bit 2: 0 if try to use conventional memory
                              ;bit 3: 0 if try to use disk (reserved)
 drive_keys    db      0      ;0 for left/right arrow; 1 for Control keys
 VIEW_FLAGS    DB      WRAP_BIT ;=1 (make 0 for no initial wrap w/ internal viewer)
 save_mouse_state  db  0      ;1 to save/restore mouse driver state
      ;does double-duty after initialization of indicating whether the
      ;save was successful
 use_logical   db      0      ;0 = default.  Use logical drives (less A&B) if
                              ;              drive table not filled in
                              ;1 = don't
 bypass_si     db      1      ;if =1, bypass select portions of sysinfo
 PAD_CHARS db   5
 BLANKS        DB      1 DUP(0)        ;for future expansion w/o messing up DFCONFIG
 dos_override  db      0h      ;1 to override pre-DOS 3 error message
 hw_reset      db      0h      ;1 to force mouse hardware reset rather than s/w
 FUNC_LNGTH    DB      COMMAND_LINE_MAX+1
 FILL_CMD_LNGTH DB	   104

; keep viewer line immed below list_cmd_line; func in mod_list depends
;on this positioning
 LIST_CMD_LINE DB  0,'/C ',100 DUP(' '),13  ;command line entered
 LENGTH_CMD    EQU $-LIST_CMD_LINE-1
 VIEWER_LINE   DB  '                                  ',0
 VIEWER_LINE_SEC DB  '                                  ',0
 FUNC01_LINE   DB  'q ~                               ',0
 FUNC02_LINE   DB  'arj e ~                           ',0
 FUNC03_LINE   DB  'pkunzip ~                         ',0
 FUNC04_LINE   DB  'nd ~                              ',0
 FUNC05_LINE   DB  'fv ~                              ',0
 FUNC06_LINE   DB  'copy ~ %p\`.%e                    ',0
 FUNC07_LINE   DB  '                                  ',0
 FUNC08_LINE   DB  '                                  ',0
 FUNC09_LINE   DB  '                                  ',0
 FUNC10_LINE   DB  '                                  ',0
 FUNC11_LINE   DB  '                                  ',0
 FUNC12_LINE   DB  '                                  ',0
 RFUNC01_LINE   DB '                                  ',0
 RFUNC02_LINE   DB '                                  ',0
 RFUNC03_LINE   DB '                                  ',0
 RFUNC04_LINE   DB '                                  ',0
 RFUNC05_LINE   DB '                                  ',0
 RFUNC06_LINE   DB '                                  ',0
 RFUNC07_LINE   DB '                                  ',0
 RFUNC08_LINE   DB '                                  ',0
 RFUNC09_LINE   DB '                                  ',0
 ZIP2_LINE     DB  'arj a -se ` !dfzip998             ',0
 RFUNC11_LINE   DB '                                  ',0
 RFUNC12_LINE   DB '                                  ',0
 ZIP_LINE      DB  'pkzip -ao @dfzip998 `             ',0
 VIEW2_LINE     DB 'ar ~                              ',0
 VIEW3_LINE     DB 'vpic ~                            ',0
 VIEW4_LINE     DB 'zr ~                              ',0
 VIEW5_LINE     DB 'zor ~                             ',0
 VIEW6_LINE     DB 'lr ~                              ',0
 VIEW7_LINE     DB '                                  ',0
 VIEW8_LINE     DB '                                  ',0
 VIEW9_LINE     DB '                                  ',0
 VIEW10_LINE    DB '                                  ',0
 VIEW11_LINE    DB '                                  ',0
 VIEW12_LINE    DB '                                  ',0
 VIEW13_LINE    DB '                                  ',0
 VIEW14_LINE    DB '                                  ',0
 VIEW15_LINE    DB '                                  ',0
 VIEW16_LINE    DB '                                  ',0
 VIEW17_LINE    DB '                                  ',0
 VIEW18_LINE    DB '                                  ',0
 VIEW19_LINE    DB '                                  ',0
 VIEW20_LINE    DB '                                  ',0
 VIEW21_LINE    DB '                                  ',0
                DB ' '
 VIEW2_EXT      db 'ARJ        ',0
 VIEW3_EXT      db 'GIF PCX    ',0
 VIEW4_EXT      db 'ZIP QW?    ',0
 VIEW5_EXT      db 'ZOO        ',0
 VIEW6_EXT      db 'LZH        ',0
 VIEW7_EXT      db '           ',0
 VIEW8_EXT      db '           ',0
 VIEW9_EXT      db '           ',0
 VIEW10_EXT     db '           ',0
 VIEW11_EXT     db '           ',0
 VIEW12_EXT     db '           ',0
 VIEW13_EXT     db '           ',0
 VIEW14_EXT     db '           ',0
 VIEW15_EXT     db '           ',0
 VIEW16_EXT     db '           ',0
 VIEW17_EXT     db '           ',0
 VIEW18_EXT     db '           ',0
 VIEW19_EXT     db '           ',0
 VIEW20_EXT     db '           ',0
 VIEW21_EXT     db '           ',0

 VEXT_LEN      EQU     11              ;length of stored extension for viewers


 ; Status variables for functions
 ;      (numbered from low bit)
 ; bit 0
 ;	0 do not pause before return to DF
 ;   1 pause
 ; bit 1
 ;   0 do not read directory on return to DF
 ;   1 read directory
 ; bit 2
 ;   0 Act on highlighted file only -- ignore marks
 ;   1 Act on marked files only -- sequentially
 ;

 FUNC01_STAT DB 10b
 FUNC02_STAT DB 111b
 FUNC03_STAT DB 111b
 FUNC04_STAT DB 111b
 FUNC05_STAT DB 101b
 FUNC06_STAT DB 01b
 FUNC07_STAT DB 0
 FUNC08_STAT DB 0
 FUNC09_STAT DB 0
 FUNC10_STAT DB 0
 FUNC11_STAT DB 0
 FUNC12_STAT DB  0b
 RFUNC01_STAT DB 0b
 RFUNC02_STAT DB 0b
 RFUNC03_STAT DB 0b
 RFUNC04_STAT DB 0b
 RFUNC05_STAT DB 0b
 RFUNC06_STAT DB 0b
 RFUNC07_STAT DB 0
 RFUNC08_STAT DB 0
 RFUNC09_STAT DB 0
 ZIP2_STAT    DB 11b
 RFUNC11_STAT DB 0
 RFUNC12_STAT DB 0
 ZIP_STAT    DB 11b
 VIEW2_STAT  db     0
 VIEW3_STAT  db     0
 VIEW4_STAT  db     0
 VIEW5_STAT  db     0
 VIEW6_STAT  db     0
 VIEW7_STAT  db     0
 VIEW8_STAT  db     0
 VIEW9_STAT  db     0
 VIEW10_STAT  db     0b
 VIEW11_STAT  db     0
 VIEW12_STAT  db     0
 VIEW13_STAT  db     0
 VIEW14_STAT  db     0
 VIEW15_STAT  db     0
 VIEW16_STAT  db     0
 VIEW17_STAT  db     0
 VIEW18_STAT  db     0
 VIEW19_STAT  db     0
 VIEW20_STAT  db     0
 VIEW21_STAT  db     0b

 drive_table db '                          ',0  ;table for cursor key drives


 ;This is a CTRL key menu

 CTRL_MENU  LABEL  BYTE
       DB  " F1   Edit (Qedit)      "
       DB  " F2   Extract ARJ       "
       DB  " F3   Extract ZIP       "
       DB  " F4   Name -> Date      "
       DB  " F5   Archive View      "
       DB  " F6   Test......        "
       DB  " F7   These definitions "
       DB  " F8   are examples only "
       DB  " F9   and require other "
       DB  " F10  software to work  "
       DB  " F11                    "
       DB  " F12                    "
       DB  " Sort down: N,E,D,S,T,O "
       DB  " Del attribute: A,R,H,Y "

 ;This is a Right-Shift key menu

 RSHIFT_MENU  LABEL  BYTE
       DB  " F1   User defined      "
       DB  " F2   User defined      "
       DB  " F3   User defined      "
       DB  " F4   User defined      "
       DB  " F5   User defined      "
       DB  " F6   User defined      "
       DB  "                        "
       DB  "                        "
       DB  "                        "
       DB  " F10  Create Archive 2  "
       DB  " F11  User defined      "
       DB  " F12  User defined      "
       DB  "                        "
       DB  "                        "

;below is the help screen.  DONT'T mess with the length of the lines (including
;the top 5 -- which aren't user modifiable) unless you plan to change DFCONFIG
;as well!
prog_name db   'Directory Freedom     Version 4.61B  ',0
full_copr db   'Copyright 1999 Gordon Haff and Bit Masons Consulting.  All Rights Reserved. ',0
address   db   'email: gordon@alum.mit.edu                                ',0
help1	db	' ',0
help2     db   ' DF d:\source-path\mask d:\dest-path /O,N,E,D,T,S[+/-] /F /V /M[0,C,P,T]    ',0
help3     db   '                                                                            ',0
help4     db   ' SORT OPTIONS         MISCELLANEOUS COMMANDS           TO MARK FILES        ',0
help5     db   ' ----------------     ------------------------------   -------------------- ',0
help6     db   ' N  Name              ^C  Copy (F1)                    <+> or <Ins>  Mark   ',0
help7     db   ' E  Extension         ^M  Move (F3)                    <-> or <Del>  Unmark ',0
help8     db   ' D  Date              ^F  Toggle files-only display    Space         Toggle ',0
help9     db   ' S  Size              ^L  Edit volume name (@F11)                           ',0
help10    db   ' T  Attribute         ^P  Print directory  (@F12)      TO CHANGE DRIVES     ',0
help11    db   ' O  DOS (Unsorted)    ^B  Secondary viewer (F12)       -------------------- ',0
help12    db   '                       [  Make Source Dir = Target     Use Left and Right   ',0
help13    db   '                       ]  Make Target Dir = Source      cursor (arrow) keys ',0
help14    db   ' FILE ATTRIBUTES                                                            ',0
help15    db   ' ----------------     FILE VIEWERS                     TO EXIT              ',0
help16    db   ' A  Archive           ------------------------------   -------------------- ',0
help17    db   ' R  Read-only         Enter or ^V uses a SmartViewer   <Esc> to original    ',0
help18    db   ' Y  System            <Enter> or ^Enter uses default   ^Q to source         ',0
help19    db   ' H  Hidden             viewer (internal or defined)                         ',0
help20    db   '                                                                            ',0
help21    db   '   @ <Alt> or <Left-Shift>     ^ <Ctrl>     <> Grey key (on numeric keypad) ',0
help22    db   '   Directory Freedom is copyrighted freeware.                               ',0
;------------------------------------------------------------------------------
; End of modifiable section
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
; Macros
;------------------------------------------------------------------------------
 WORK_EQ_DEST		MACRO
	call		read_dir
 ENDM

.to_upper macro     arg1
local          to_upper_080
          cmp  arg1,"a"
           jb  to_upper_080
          cmp  arg1,"z"
           ja  to_upper_080
          and  arg1,0DFh
to_upper_080   label     near
endm

.ABS macro arg1
local	nosign
		or 	arg1,arg1
		jns	nosign
		neg	arg1
nosign	label near
endm

.pushall      MACRO
     push ax bx cx dx si di ds es
     pushf
endm

.popall        MACRO
     popf
     pop  es ds di si dx cx bx ax
endm


 NORMAL                DB      07H
 INTENSE               DB      0FH
 MENU_ATT      DB      07H
 BORDER                DB      0FH
 INVERSE               DB      70H
 COLORS                EQU     $ - OFFSET NORMAL
 BAR_ATTRIBUTE DB      70H
 ORIG_ATT      DB      ?                       ;original screen attribute

 DISPLAY_BIT   EQU     80H
 WRAP_BIT      EQU     1
 ASCII_BIT     EQU     2

 BLANK_BIT     EQU     4       ;comment out this line to eliminate this option

 STAR_MASK     DB      0FFH
; VIEW_FLAGS    DB      0
 OPTIONS               DB      ' WA'
 ifdef BLANK_BIT
               DB      'B'
 endif
 OPTIONS_LEN   EQU     $ - OPTIONS

 N_SEGS                DB      ?
 SEG_COUNT     DB      ?
 MEM_BUF_SEG   DW      0F000H
 DIR_BUF_SEG   DW      ?

 FUNCTION      DB      0               ;flag byte to identify function request
 COPY_BIT      EQU     1               ;read/write file
 DELETE_BIT    EQU     2               ;delete file (may follow a move)
 MOVE_BIT      EQU     4               ;across dir move via rename
 RENAME_BIT    EQU     8               ;simple rename
 PROTECT_BIT   EQU     10H             ;check if file already exists on dest
 DIR_OK_BIT    EQU     20H             ;allow function on directory
 HID_OK_BIT    EQU     40H             ;allow function on hidden file
 UPD_CNT_BIT   EQU     80H             ;force update of bytes free display

 VERIFY_STAT   DB      0           ;saves entry condition of verify flag
 VERIFY_STAT_FL DB	   0		     ;saves in-program condition of verify
							;flag do can be turned on for floppy writes
 BREAK_STAT    DB      0
 SORT_LEN      DB      12
; SORT_OPT      DB      "NESDO"
 SORT_OPT      DB      "NESDTO"
 SORT_OPT_CNT  EQU     $ - SORT_OPT
               EVEN
 ;table contains offset of field to be sorted within file info field and
 ; length of the relevant info
 SORT_TABLE    DW      1200h           ;name
               DW      309h            ;extension
               DW      800h + 13       ;size
               DW      29              ;date
               DW      400h + 39       ;attribute
               DW      -1              ;no sort
 SORT_TABLE_END        EQU     $ - 2
 SORT_OFFSET   DW      0               ;start of field on which to sort
 SORT_INDEX    DW      0               ;index into SORT_TABLE of chosen sort

 CURSOR_TYPE   DW      ?
 VIDEO_SEG     DW      0B000H

 CUR_OFFSET    DW      ?               ;ptr to first entry on displayed page
 CUR_FILE      DW      ?               ;GET_NAME returned ptr to dir record
 END_OFFSET    DW      ?
 DIR_DISP_END  DW      ?
 LINE          DW      ?
 COUNT         DW      ?
 MARK_CNT      DW      ?
 SEARCH_COUNT  DW      ?
 FILE_CNT      DW      ?
 FILENAME_END  DW      ?
 READ_HANDLE   DW      ?
 WRITE_HANDLE  DW      ?
 SOURCE_ATTRIB DW      ?
 TARGET_ATTRIB DW      ?
 SIZE_LOW      DW      ?
 SIZE_HIGH     DW      ?
 SOURCE_TIME   DW      ?
 SOURCE_DATE   DW      ?
 FILE_NAME     DW      ?
 WORK_BYTES_FREE DW    ?
               DW      ?
 WORK_CLUSTER  DW      ?
 DEST_BYTES_FREE DW    ?
               DW      ?
 DEST_CLUSTER  DW      ?
 TARG_BYTES_FREE       DW      ?
               DW      ?
 TARG_CLUSTER  DW      ?
 MARK_BYTES    DW      ?
               DW      ?
 MARK_BYTES_FD DW      ?
               DW      ?
 ENTRY_COUNT		DW	?
 SUB_BYTES_COUNT	DW	?
				DW	?


 FD_CLUSTER    EQU      400H   ;size of floppy cluster (1024 bytes)
               ;changed from 512 bytes in DF 4.50


 STK_SEG               DW      ?               ;original SS contents for CALL_DOS
 STK_PTR               DW      ?               ;original SP contents for CALL_DOS
 DOS_LINE      DB      ?,' '            ;command tail for CALL_DOS
 ENV_SEG               DW      ?               ;segment containing environment block
 COM_VAR               DB      'COMSPEC=',0    ;environment variable to match
       ;Parameter block for CALL_DOS
 PAR_BLK               DW      0               ;Use parent's environment
               DW      OFFSET DOS_LINE ;Point to empty command tail
 OFFDOSLINE    DW      ?
               DW      4 DUP (0FFh)    ;FCP pointers (dummies!)

 DISPATCH_KEY  label byte              ;table of scan codes
       DB      01H,4AH,4EH,1CH,82H     ;esc, -, +, cr, space bar(dummy)
;	  DB		7Ah,83h			    ;dummy for +/= and real Alt +/=
	  DB		1Ah, 1Bh			    ;[, ]
       DB      3BH,3CH,3DH,3EH,3FH     ;F1, F2, F3, F4, F5
       DB      40H,41H,42H,43H,44H     ;F6, F7, F8, F9, F10
       DB      85H,86H                 ;F11, F12
       DB      68H,69H,6Ah,52h,53h     ;Alt-F1, Alt-F2, Alt-F3, Ins, Del
       DB      6BH,6CH,6DH,6EH         ;A-F4 A-F5, Alt-F6, Alt-F7
       DB      6FH,70H		         ;Alt-F8, Alt-F9
	  DB		8Bh,8Ch,26h,19h	    ;Alt-F11, Alt-F12, Alt-L, Alt-P
       DB      1EH,13H,23H,15H         ;Alt- A,R,H,Y
       DB      21H                     ;Alt-F
		;<grey enter> added rev. 4.  Extended BIOS functions generate different
		;   scan code for <grey enter> than for <enter>
	  DB		0E0H				    ;<grey enter> when called with extended services
       DB      2Ch                     ;Ctrl-Z
       DB      4BH,4DH                 ;left, right
       DB      73H,74H                 ;Control-left, Control-right
       DB      0EH                     ;Backspace
       DB      011h                    ;Ctrl-W

 exec_scan_codes	label byte
       DB      5EH,5FH,60H,61H,62H,63H,64H ;CTRL-F1 THROUGH CTRL-F7
       DB      65H,66H,67H,89H,8AH     ;CTRL-F8 through CTRL-F12
		;"phony" scan codes for Right Shift function keys
       DB      0A0h,0A1h,0A2h,0A3h,0A4h,0A5h,0A6h,0A7h,0A8h,0A9h,0D3h,0D4h
	  DB		71h				    ;ALT-F10

 SORT_KEYS     label byte              ;must match SORT_OPT table
       DB      31H,12H,1FH,20H,14H,18H     ;N, E, S, D, T, O
       DB      2EH,2FH,32H,10H,30H      ;C, V, M, R, Q, B

 VIEW_KEYS label byte
       DB      47H,48H,49H,4FH         ;home, up, pgup, end
       DB      50H,51H,76H,84H         ;down, pgdn, ^pgdn, ^pgup
       DB      37H,1EH,30H,11H         ;*, A, B, W
 DISPATCH_CNT  EQU $ - DISPATCH_KEY
       DB      4BH,4DH                 ;left, right
 VIEW_CNT      EQU $ - VIEW_KEYS

       even
 DISPATCH_TABLE        label word
       DW      EXIT, UNMARK, MARK, LIST, GO_SPACE
	  DW		READ_DIR,DEST_TO_SOURCE	;swap dest_source routines
       DW      COPY, DELETE, MOVE, RENAME, CLEAR_MARK
       DW      MARK_BLANK, SWAP_MARK, SWAP_DIR, CD_WORK, CD_DEST
       DW      REMARK, LIST   ;F11,F12
       DW      PCOPY, DOS_SHELL, FMOVE, MARK, UNMARK
       DW      REFRESH_POS,RUN_PROG,CREATE_DIR,SYS_INFO  ;refresh to refresh_pos 3.50
	  DW		SWAP_VIDEO_MODE,TOUCH
	  DW		EDIT_VOLUME,PRINT_DIR,EDIT_VOLUME,PRINT_DIR

       DW      ARCHIVE,READ_ONLY,HIDDEN,SYSTEM
       DW      MASK_DIRS
	  DW		LIST
       DW      HELP
       DW      DRIVE_DOWN, DRIVE_UP, DRIVE_DOWN, DRIVE_UP
       DW      UPDIR
       DW      send_ff

       DW      multi, multi, multi, multi, multi, multi, multi
       DW      multi,multi,multi, multi, multi
       DW      multi, multi, multi, multi, multi, multi, multi
       dw      multi,multi,ZIP,multi,multi
	  DW		ZIP

       DW      RE_SORT, RE_SORT, RE_SORT, RE_SORT, RE_SORT, RE_SORT
;       DW      RE_SORT, RE_SORT, RE_SORT, RE_SORT, RE_SORT
       DW      COPY, LIST, MOVE, QUIT,LIST
       DW      HOME_BAR, UP_ARROW, PG_UP, END_BAR
       DW      DN_ARROW, PG_DN, BOTTOM_BAR, TOP_BAR
       DW      STAR, ASCII, BLANK, WRAP
 DISPATCH_END  EQU $ - 2

even
COMP_FUNCS label word
       DW comp1,comp2,comp3,comp4,comp5

 CTRL_PRESSED	DB ?                     ;for attribute functions - flag to indicate CTRL or ALT
 rshift_pressed db	?
 ATTR_BYTE_VAL  DW ?                     ;value of attribute location

 COMSPEC       DB  'COMSPEC=',0
 ENVIRONMENT   DW  ?
 CMD_LINE_PTR  DD  ?
 STACK_SEG     DW  ?
 STACK_PTR     DW  ?
 LIST_FLAG     DW  0
 MENU_STATUS   DW  0   ;Menu state flag =0 for main menu, 1 for ALT_Menu
 param1_msg       DB  'Enter parameters (',17,196,217,' for none)',0
 param2_msg	   db  'Enter archive filename:',0
 ent_volume_msg   db  'Enter new Volume (',17,196,217,' to accept)',0
 doing_zip	   db  0		;Flag that the zip operation being performed
 BS	       DB  8,32,8,0
 LEN_SOURCE    DW  ?


 ENV_ERR_MSG   DB  "Function key not defined",0
 UNALLOC_ERR   DB  0DH,0AH,'DF requires 64K free memory',0DH,0AH,'press a key...$'
 BAD_EXEC_MSG  DB  205,205,16,' Insufficient memory - press a key ',17,205,205,0
 RET_TO_DF_MSG DB  205,205,16,' PRESS ANY KEY TO RETURN TO DF ',17,205,205,0
 OVERRUN_MSG   DB  'Command line overrun',0
 EXEC_ERROR    DB  0
 BAR_COLOR     DB  4FH



 ;data added for view function
 VIEW_TABLE label word
       DW      HOME_FILE, UP_LINE, UP_PG, END_FILE
       DW      DN_LINE, DN_PG, END_FILE, HOME_FILE
       DW      STAR, V_ASCII, BLANK, VWRAP
       DW      LEFT, RIGHT
 VIEW_TABLE_END        EQU $ - 2

 ;error messages
 NOT_ENOUGH    DB  "Requires 128K free RAM",13,10,"$"
 TOO_MANY      DB  "Too many files$"
 NO_COMSPEC    DB  "No COMSPEC variable in environment",13,10
			DB  "Full instructions are given in the manual.  You require a",13,10
			DB  "line such as SET COMSPEC=C:\COMMAND.COM in your AUTOEXEC.BAT file",13,10,13,10,"$"
 PRESS_A_KEY	DB	".... Press a key to Continue ....",13,10,"$"
 BAD_CFG_FILE  DB   "Specified configuration file seems invalid",13,10,"$"
 MISS_CFG_FILE DB   "Specified configuration file not found",13,10,"$"
 WRONG_DOS     DB   "Requires DOS 3.0 or later",13,10,"$"
 BAD_MEMORY    DB  "Fatal memory allocation/deallocation error",13,10,"$"

 ;main menu
 ;Graphics border characters:
 GB_TL         EQU     201     ;Top left
 GB_TH         EQU     205     ;Top horizontal
 GB_TR         EQU     187     ;Top right
 GB_L_TEE      EQU     199     ;Left Tee
 GB_R_TEE      EQU     182     ;Right Tee
 GB_MH         EQU     196     ;Middle line horizontal
 GB_BL         EQU     200     ;Bottom left
 GB_BR         EQU     188     ;Bottom right
 GB_BH         EQU     205     ;Bottom Horizontal;
 GB_V          EQU     186     ;Vertical border

 MENU_STRT     EQU     49 CROW 2
 LOGO  DB  "   Directory Freedom    "
 MENU_WIDTH    EQU     $ - OFFSET LOGO
       DB  "      Version 4.61B     "
       DB  " Copr. Gordon Haff 1999 "
 LOGO_ROWS     EQU     ($ - OFFSET LOGO)/MENU_WIDTH

 MENU1  LABEL  BYTE
       DB  " F1   Copy              "
       DB  " F2   Delete            "
       DB  " F3   Move              "
       DB  " F4   Rename            "
       DB  " F5   Clear marks       "
       DB  " F6   Mark remainder    "
       DB  " F7   Swap Mark/Unmark  "
       DB  " F8   Swap Source/Target"
       DB  " F9   Change Source     "
       DB  " F10  Change Target     "
       DB  " F11  Re-Mark files     "
       DB  " F12  Secondary Viewer  "
       DB  "       Ctl-Z  Help      "
;       DB  " <Enter> View / ChDir   "
       DB  "  Esc or Ctl-Q to Exit  "
 MENU1_ROWS    EQU     ($ - OFFSET MENU1)/MENU_WIDTH
 MENU_ROWS     EQU     3 + LOGO_ROWS + MENU1_ROWS

 BEG_DOS               EQU          (2+MENU_ROWS) * 100h
; BEG_WINDOW    EQU     44 + (2+MENU_ROWS) * 100h              ;
  BEG_WINDOW    EQU     47 + (2+MENU_ROWS) * 100h              ;
; END_WINDOW    dw      ?
 END_WINDOW    dw     79 + 24 * 100h                          ;LENGTH1

 ;This is a ALT key menu

 ALT_MENU  LABEL  BYTE
       DB  " F1   Protected Copy    "
       DB  " F2   DOS Shell         "
       DB  " F3   Forced Move       "
       DB  " F4   Refresh           "
       DB  " F5   Run Program       "
       DB  " F6   Create Dir        "
       DB  " F7   System Info       "
       DB  " F8   Swap Video Mode   "
       DB  " F9   Edit Date/Time    "
       DB  " F10  Create Archive    "
       DB  " F11  Edit Volume Name  "
       DB  " F12  Print File List   "
       DB  "  Sort Up: N,E,D,S,T,O  "
       DB  " Add attribute: A,R,H,Y "


 ;string constants and screen locations

 ENTRY_CUR     EQU     47 + (3 + MENU_ROWS) * 100h
 PROMPT_LOC    EQU     47 CROW (2 + MENU_ROWS)
 PROMPT_LOC2   EQU     47 CROW (3 + MENU_ROWS)
 PROMPT_LOC3   EQU     47 CROW (4 + MENU_ROWS)
 PROMPT_LOC2_RC  EQU	(3 + MENU_ROWS)*100h + 47
 PROMPT_LOC3_RC  EQU	(4 + MENU_ROWS)*100h + 47


 TOO_MANY_FILES  DB        "Too many files.  List truncated.",0
 INVALID               DB  "Error: Invalid drive or directory",0
 LOAD_SORT_MSG DB  "Loading and "
 SORT_MSG      DB  "Sorting directory.",0
 LOAD_SORT_LOC EQU  (40 - ($-LOAD_SORT_MSG)/2) CROW 12
 SORT_LOC      EQU  PROMPT_LOC+8
 LOAD_MSG      DB  "Loading directory.",0
 LOAD_LOC      EQU  (40 - ($-LOAD_MSG)/2) CROW 12

 DIRECTORY     DB  "Dir of Source ",0
 DIRECT_LOC    EQU 2 CROW 0

 VOL_NAME      DB  "Volume: "
; VOL_INS       DB  12 DUP(space)
; W_FREE        DB  11 DUP (space)
;space shifted slightly 4.61
 VOL_INS       DB  11 DUP(space)
 W_FREE        DB  12 DUP (space)
               DB  " bytes free",0
; FILES_LOC     EQU 1 CROW 22
 FILES_LOC     dw   2 CROW 22
;this and other bottom location variables are not adjusted by video_init
;on non-EGA/VGA systems.  1 col indent added 4.60 to be like EGA/VGA

 DEST_MSG      DB  "Target ",0                 ;line up paths 4.0
 DEST_LOC      EQU  9 CROW 1

 DEST_FREE     DB  "Target disk has   "
 D_FREE                DB  13 DUP(space)
               DB  " bytes free",0
; D_FREE_LOC    EQU 1 CROW 23
  D_FREE_LOC     dw 2 CROW 23

 SUBDIR_MSG      DB ""
 SUB_ENTRY_LOC        DB 4 DUP(space)
			  DB " of "
 SUB_TOTAL_LOC        DB 4 DUP(space)
                 DB "."
 SUB_BYTES_LOC        DB 12 DUP(space)
			  DB " bytes/"
 FILES           DB 4 DUP(space)
			  DB " files",0
; SUBDIR_LOC	  EQU 1 CROW 24
 SUBDIR_LOC    dw   2 CROW 24

 BYTES_MRKD_MSG        DB 11 DUP(space)
               DB " Bytes in"
 FILES_MRKD_MSG        DB  4 DUP(space)
               DB  " "
               DB  " files",0
 MARKED_MSG    DB  "Marked files",0
 MARKED_LOC    EQU 48 CROW 24
 MARKED_WIN    EQU 47 + 24 * 100h
 BYTES_SIZE_MSG        DB 11 DUP(space)
               DB " Bytes in"
 FILES_SIZE_MSG        DB  4 DUP(space)
               DB  " "
 SIZE_MSG_1    DB  "files",0
 SIZE_LOC      EQU 48 CROW 23
 SIZE_LOC_2    EQU 50 CROW 24
 FLOPPY_SIZE_MSG  DB 11 DUP (space)
			DB " Bytes on floppy",0

 DELETE_MSG    DB  " will be deleted.",0
               DB  "Do you wish to delete?  Y/N",0
 DDIR_MSG		DB  "Do you wish to delete dir?  Y/N",0
 NODIR_COPY	db	"Destination not directory.",0
			db	"Do you wish to continue? Y/N",0
; DISK_MSG      DB  "Error reading drive "
 FMOVE_MSG	DB  "F-Move ",0
 PCOPY_MSG     DB  "P-"
 COPY_MSG      DB  "Copy ",0
 MOVE_MSG      DB  "Move ",0
 RENAME_MSG    DB  "Rename ",0
 CD_MSG                DB  "Change directory",0
 CHDEST_MSG    DB  "Change default destination",0
 TO_MSG                DB  " to...",0
			DB  "\"
 FILE_MASK	DB  "*.*",10 DUP(0)
 STAR_DOT_STAR DB  "*.*",0
 DIRECTORIES   DB  "<DIR>"
 CREATE_DIR_MSG DB	"  New Dir name: ",0
 NO_DRAW_FLAG	DB  0    ;set flag to 1 to skip screen draw routines
				    ;used by some of the directory routines
 CLR_MSG_FLAG DB  0
 SIZE_FLAG 	DB	0			;set to 1 if doing subdir size func
 NO_DDIR_FLAG	DB	0
 ABORT_DELETE_FLAG	DB	0
 DIR_CONF_FLAG DB	0
 FILE_NAME_BUFF	DB	13 DUP(0)
 SAVED_LINE	DW	?
 BIOS_KYBD_00  DB   0    ;Used with ext_kybd_flag, int 16h func 00 used if extended funcs not wanted
 BIOS_KYBD_01  DB   1    ; ditto function 01 or 11h
 MAX_PARAM	EQU  32
 PARAM_LENGTH	dw	?
 PATH_LENGTH_MSG DB "Path length is"
			  DB 3 DUP(space)
			  DB " with"
			  DB 4 DUP(space)
			  DB "LEFT.",0
 SHELL_MSG	  DB 'Type <EXIT> to return to DF',13,10,'$'
 SECOND_SHIFT	  DB	?		;set to ALT_SHIFT or LSHIFT_SHIFT depending on
						;state of bit 0 of SHIFT_STATE_FLAG
 HOT_SHIFT       DB CTRL_SHIFT+RSHIFT_SHIFT   ;sum of SECOND_SHIFT (added in initialization)
									 ;and CTRL_SHIFT
; IN_DV		  DB	0			;0 if not in DESQview, 1 if are
 PARENT_DIR	  DB '..',0
 DOS_VERSION	  DW	?			;contains DOS version AL=major,AH=minor
 LINE_CNT_DISP	  DB	1			;don't display running line count flag (no = 0)

; variables to parse and set file control blocks (R4)
 DELIMITERS 	DB	9,13,32,"/<>."
 date_delimit  db	":-/"
 FCB_1ST		DW	FCB_5CH,?
 FCB_2ND		DW	FCB_6CH,?

 SCR_HT		Dw	25
 START_SCR_HT  dw   ?
 SCR_WID		Dw	80
 VOFFSET		DW	?
  DIR_ROWS      dw	   20
; DIR_ROW_END	dw	   ?
 VIEW_ROWS	dw	   24
; LAST_ROW	dw	   ?

 DIR_ROW_END	dw	   BAR_START + 0 CROW 20
; LAST_ROW		dw	   ROW1+DIR_ROWS

 IS_EGA		db	0
 IS_VGA		db	0

 ON_COMMAND_LINE	db 1	;used to tell critical error handler that
					;the error occured on the command line and
					;therefore it should abort if critical error
					;occured (not all initialization has taken place)
 SYS_TIME			dw	?    ;date and time in packed form for
 SYS_DATE			dw	?    ;set date/time function
 s_year			dw	?	;year (1980-2099)
 s_md			dw	?	;month/day
 s_hm			dw	?	;hour/minutes

 uv_mode_save		db	?    ;used to save the starting UV mode
 no_dir_store		db	0	;flag used in READ_DIR to control storage
						;of directory entries to prevent dupes (4.0)

 error_msg		dw	?		;stored location of relevant error message
 zip_temp			db	"DFZIP998",0
 zip_handle		dw	?	;handle for temporary zip file
 zip_end_line		db	13,10	;end of line stuff for temp file
 file_err_msg		db	"Error creating temp file",0

 me_flag			db	0	;multi-execute flag
first_time		db	0	;changes to 1 after first time through multi-execute

 is_mouse			db	0	;0 if no mouse prsent; 1 if yes
 mouse_but		db	?	;number of mouse buttons

 touch_prompt       DB  'Enter date/time (',17,196,217,' to accept)',0
 date_prompt		db	'Date: ',0
 time_prompt		db	'Time: ',0
 pseudo_16a		dw	?
 pseudo_8a		db	?
 lsh_label		db	"LSh"	;used for altering menus

 xfcb			db	0ffh		;flag signifying extended fcb
				db	5 dup (0) ;reserved(should be zeros)
				db	8		;volume attribute byte
				db	0		;drive code (set by program)
				db	11 dup('?') ;wildcard filename and extension
				db	25 dup(0)	;remainder of fcb (not used)

 tmp_default_drive	db	?	;used by edit volume function

 open_print_err	db	"Error opening "
 printer_name		db	"LPT1",0
 term_flag		db	0  ;set to 1 while program terminating
					   ;used for changing to non-existent drive
 illegal_dir		db	'Unable to change to initial directory.',13,10
				db	'You may have deleted or renamed it.',13,10,"$"
 but_press_mask	db	0
 m_movement		dw	0
 drive_table_pointer db  -1 ;pointer to drive letter in drive table
                           ;starts w/1.  -1 means no drives defined.
                           ;0 means drives defined, but initial drive isn't.
 num_drive_entries  db   0
 second_var           db   ? ;Variable to store byte (e.g. from command line)
 error_flag         db   0    ;general purpose variable to hold error condition

 cfg_file           db 'df.cfg',0   ;default cfg file
 is_cfg             db   0    ;used to flag cfg file read stuff

 skip_dir_flag      db   0
 highmem_flag       db   0    ;bit 0 set if XMS available
                              ;bit 1 set if EMS available

 siset         db      0b     ;used to shut off some sysinfo settings
                               ;bit 0 = 1
                               ;  Prevent test which require the use of protected
                               ;  mode instructions, which might not be handled
                               ;  correctly V86 mode.
                               ;taken from alpha 5.00 code. Not user changeable
                               ;in 461A
INCLUDE SIHEADER.ASM

 SUBTTL Main program loop
 page
 ;     CODE AREA
 ;----------------------------------------------------------------------------;
      ; Some housekeeping first. Since we will be changing the default drive       ;
 ; and directory to the requested drive and directory, we need to save the    ;
 ; current defaults, so they can be restored.  Install critical error trap.   ;
 ;----------------------------------------------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 MAIN  PROC    NEAR

       call    cfg_cmdline
       call    command_mem             ;need to look for a couple of switches
                                       ;early on prior to memalloc

       MOV     AX,3300H                ;Get Control Break status.
       INT     DOSINT
       MOV     BREAK_STAT,DL           ;and save it

       MOV     AX,3301H                ;Turn Control Break off.
       MOV     DL,0
       INT     DOSINT


	  MOV	AH,30H			    ;get DOS version
	  INT	DOSINT
	  MOV	DOS_VERSION,AX		    ;and store

       call    setup_sysinfo           ;gets some info for sysinfo function
                                       ;upfront so memory functions don't
                                       ;need to repeat


       call    mswin_get_version

	  call	init_mouse		    ;initializes mouse.  Returns status.
	  jc		_m_005			    ;mouse not found
	  cmp	mouse_on,0		    ;override mouse support
	  je		_m_005
	  mov	is_mouse,1
	  mov	mouse_but,ah		    ;number of buttons
							    ;DF4 -- hook for futures
_M_005:
	  call	ident_display		    ;identify the active video subsys
	  mov	al,IS_EGA
	  add	al,IS_VGA
	  jz		_M006		         ;if not EGA or VGA use default settings
	  call	get_uv_dims
       call    video_init              ;setup the various dimension variables
       call    get_rows
       mov     start_scr_ht,ax         ;save starting screen height for restores
_m006:

	  cmp	ext_kybd_flag,2
	  jne	_m007
	  call	check_keyboard
	  mov	ext_kybd_flag,al
       mov     ext_kybd_bios,ah
_m007:
       MOV     AH,54H                  ;Get current verify flag.
       INT     DOSINT                  ; and save.
       MOV     VERIFY_STAT,AL          ;(use /V switch to set verify on)

	  CALL	SET_VERIFY_STATE	    ;act on setting of verify_default
	  CALL	SET_SHIFT_STATE	    ;act on setting of secondary hot key flag
	  CALL	SET_KYBD_STATE          ;act on state of F11/F12 keyboard flag

      call      set_logical_drives     ;fill in system logical drives
       cmp     use_logical,1           ;don't use logical
       je      _m009
       mov     di,offset drive_table
       cmp     byte ptr [di],space      ;is there already something in table?
       jne     _m009
       mov     si,offset logical_drives
_m008:
       cmp     byte ptr [si],0          ;we're at the end
       je      _m009
       cmp     byte ptr [si],'A'        ;we skip over the floppies
       je      _m008A
       cmp     byte ptr [si],'B'
       je      _m008A
       movsb
       jmp     _m008
_m008A:
     inc       si
     jmp       _m008
_m009:
;       MOV     DX,OFFSET DISK_ERROR    ;Install critical error trap.
;       MOV     AX,2524H
;       INT     DOSINT
       mov     ax,offset user_error
       call    cem_install

       CLD                             ;String moves forward.
       CALL    UPD_DEST                ;save dir info about dest
       MOV     SI,OFFSET DEST_PATH     ;Point to storage.
       MOV     DI,OFFSET INITIAL_PATH  ; make copy of starting point
       MOV     CX,68                   ;length of path
       REP     MOVSB

 ;---------------------------------------------------------------------;
 ; More housekeeping. We will be writing directly to the screen buffer ;
 ; so we need the display card address and the status register.          ;
 ;---------------------------------------------------------------------;

       MOV     AX,40h                  ;Point to the ROM BIOS data area
       MOV     DS,AX                   ; and get base address of active
;       ASSUME  DS:ROM_BIOS_DATA
       MOV     AX,ds:[63h]             ; display card.
                                       ;63h points to CRTC address register
                                       ;in BIOS data area (4.60 - Note 1)
       PUSH    CS                      ;Done there, so restore data segment.
       POP     DS
;       ASSUME  DS:_TEXT
       CMP     AX,3B4H                 ;Base address of MONO card is 3B4h.
       JZ      _M1                     ;If that's what we got, it's MONO

       PUSH    AX
       MOV     VIDEO_SEG,0B800H        ; else COLOR so add 800h.
       MOV     SI,OFFSET C_NORMAL
       MOV     DI,OFFSET NORMAL
       MOV     CX,COLORS
       REP     MOVSB
       MOV     AL,INVERSE
       STOSB
       POP     AX
       ADD     AX,6                    ;Add six to get status register
       cmp     is_ega,0                ;DF4 automatically disable snow check
       je      _m1                     ;on EGA or VGA
       cmp     is_vga,0
       je      _m1
;believe there was a bug in the snow check logic of earlier versions.
;status_reg = 0FFh seems to indicate snow checking is on rather than
;the other way around.  DF 4.50 flipped the logic around here

       CMP     BYTE PTR STATUS_REG,0FFH  ;
       JZ      _M1
       mov     byte ptr status_reg,0FFh
       jmp     short _M2

 _M1:  ;DVAWARE ROUTINE for video buffer
       mov     ax,VIDEO_SEG
       push    es
       push    ax
       call    far ptr dv_get_video_buffer
       mov     video_seg,ax
       pop     es

       XOR     AX,AX                   ;if non-zero, disable snow check
 _M2:  MOV     STATUS_REG,AX           ;Store status register.

       XOR     BH,BH                   ;Get current attribute
       MOV     AH,8                    ; of display page zero.
       INT     10H
       MOV     ORIG_ATT,AH             ;Store it.
       MOV     AH,3                    ;Retrieve cursor type.
       INT     10H
       MOV     CURSOR_TYPE,CX
	  call	is_uv_ar
       jnc     _M2_5
       call    get_uv_cursor
	  mov	ax,0CD05h			    ;set Ultravision cursor emulation
	  mov	cl,0
	  int	10h
	  mov	cursor_type,0607h
 _M2_5:
       push      es
       mov       ax,es                 ;save PSP segment
       dec       ax                    ;decrement to get MCB
       mov       es,ax
       mov       ax,word ptr es:[03]   ;get process memory available
       pop       es
       mov       avail_mem,ax

;       MOV     AX,PSP_TOP_MEM          ;get top of available mem
;       MOV     BX,CS                   ;get our segment
;       SUB     AX,BX                   ;memory available
       CMP     AX,min_mem              ;we need min memory for dir functions
       JNC     _M5                     ;got this much

 _M3:  MOV     DX,OFFSET NOT_ENOUGH
	  mov	ah,9
	  int	21h

 _M4:
       jmp     error_exit              ;problem with memory initialization

 _M5:
 _M5A:

;       cmp     mem_swap,0FFh          ;don't use any extended segments
;       jne      _M5B
       cmp     mem_swap,111b
       jne      _M5B
       mov     diralloc,1000h
       mov     mem_use,0               ;single segment for program and dir
       mov     dbs_start,offset dir_buff
       mov     dir_buf_seg,es
       sub     dbs_end,400             ;leave some extra stack space at the end
                                       ;of the directory
       jmp     short _M5C
 _M5B:
       call    get_min_mem
       mov     mem_use,4               ;assume conventional memory only
                                       ;unless set otherwise
       call    init_mem                ;allocates XMS or EMS block if possible
 _M5C:
       mov     ax,diralloc
       MOV     BX,AX                   ;save number of paragraphs
       MOV     CL,4                    ;x16 to find top byte
       SHL     AX,CL                   ;of this seg and then
       MOV     SP,AX                   ;set up a local stack
       XOR     AX,AX
       PUSH    AX                      ;push return address
       PUSH    CS

       MOV     AH,4AH                  ;modify mem block pointed to by es
       INT     DOSINT                  ;requesting bx paragraphs
       JC      _M3

       cmp     mem_use,0
       je      _M6                     ;only single block

       mov     ah,48h                  ;create 64KB block for directory
       mov     bx,1000H
       int     21h
       jc      _M3
       mov     DIR_BUF_SEG,AX


 _M6:
       MOV     OFFDOSLINE,CS           ;put segment in parm block address
       CALL    GET_COMSPEC             ;get file spec for COMMAND.COM
       JNC      _M6_5
       MOV     DX,OFFSET NO_COMSPEC    ;take error exit
	  mov	ah,9
	  int	21h
	  jmp	_M4

_M6_5:
       cmp     dos_override,1
       je      _M6_8                  ;leave override patch in just in case
       MOV     AX,DOS_VERSION
       cmp     al,3
       jae     _M6_8
       MOV     DX,OFFSET WRONG_DOS    ;take error exit if less than DOS 3.0
	  mov	ah,9
	  int	21h
	  jmp	_M4
_M6_8:
       cmp     drive_keys,0
       je      _M6_10
       mov     drive_up_key,74h       ;substitute Control keys
       mov     drive_down_key,73h
_M6_10:
 ;----------------------------------------;
 ; Parse the command line for parameters. ;
 ;----------------------------------------;
       PUSH    AX                   ;Initially sets up SORT_OFFSET according
       PUSH    BX                   ;to SORT_DEFAULT byte which is configurable
       PUSH    CX
       PUSH    DI
       MOV     DI,OFFSET SORT_OPT
       MOV     AL,SORT_DEFAULT
       CALL    SET_SORT
       POP     DI
       POP     CX
       POP     BX
       POP     AX

       MOV     DI,OFFSET CMD_LINE      ;Point to command line
       XOR     CX,CX
       MOV     CL,[DI]
       INC     CX
       INC     DI
       PUSH    DI
       PUSH    CX

 _M7:  MOV     AL,SWITCH
       REPNZ   SCASB
       JNZ     _M12
       MOV     AL,[DI]
       MOV     WORD PTR [DI-1],2020h
       PUSH    DI
       PUSH    CX

       AND     AL,5FH
 ;     CMP     AL,"H"                  ;If "H", remove hidden files.
 ;     JNZ     _M8
 ;     MOV     SEARCH_ATTRIB,1 + 4 + 10
 _M8:  CMP     AL,"V"
       JNZ     _M9
       MOV     AX,2E01H                ;set verify on
       INT     DOSINT

 _M9:  CMP     AL,"F"                  ;fast option - no snow check
       JNZ     _M9a
       MOV     STATUS_REG,0            ;zero flags video status register.

 _M9a:
;       cmp     no_cfg,1
;       je      _m10
;       cmp     AL,"C"
;       jnz     _m10
;       call    set_cfg_file
;       jmp     _M11

 _M10:
       mov     cl,byte ptr[di+1]       ;store 2nd char after switch
       mov     second_var,cl           ;in second_var
 _M10a:
       mov     byte ptr[di+1],20h
       MOV     DI,OFFSET SORT_OPT
                                       ;sort var from command line still in al
       CALL    SET_SORT                ;scan for sort options
       mov     cx,sort_index           ;store sort index (name=0,ext=2,etc.)
       mov     ah,second_var           ;store + or - switch in register
       shr     cx,1                    ;cl = sort_index/2
       mov     al,1                    ;but bit in low order of al
       shl     al,cl                   ;al is now a mask for the sort

       cmp     second_var,'+'          ;is it ascending?
       jne     _M10b
       not     al                      ;Yes? NAND sort byte with mask
       and     sort_up_flag,al
       jmp     short _M11
 _M10b:
       cmp     second_var,'-'          ;is it descending?
       jne     _M11                    ;No? is neither, use default
       or      sort_up_flag,al         ;OR sort byte with mask

 _M11: POP     CX
       POP     DI
       LOOP    _M7

 _M12:
;       cmp     no_cfg,1
;       je      _m12a
;       call    read_cfg_file
_m12a:
       POP     CX
       POP     DI

_m12b:
       CALL    GET_PARAM
;	  push	si
;	  push	di
       JZ      _M15                    ;was there a parameter?
       call    parse_file_filter       ;looks for and deals with file filter if
							    ; there is one
       push    di
       dec     di
       dec     di
       cmp     word ptr [di],'..'
       pop     di
       jne     _m12b1
       mov     skip_dir_flag,1
_m12b1:
       CALL    GET_PARAM
       JZ      _M14                    ;was there a 2nd parameter?
       MOV     DI,OFFSET DEST_PATH     ;save it at dest_path
       CMP     BYTE PTR [SI+1],':'     ;check for drive spec
       JZ      _M13                    ;one found
 _m12c:
       INC     DI                      ;no drive, use default
       INC     DI                      ;by stepping over in dest
 _M13: LODSB                           ;get a byte
       STOSB                           ;put a byte
       OR      AL,AL                   ;check for end and loop
       JNZ     _M13

 _M14:
       MOV     SI,BX
       CALL    CHANGE_PATH             ;Change drive and directory.
 _M15:

_M15_5:
       CALL    READ_DIR                ;get dir info from disk
	  mov	on_command_line,0	    ;we're done with the command line
	  call	parse_date_time
	  cmp	init_video_mode,0	    ;default 43/50 line mode?
	  je		_M16                    ;No? Skip
	  cmp	scr_ht,25               ;are we in normal mode?
	  jne	_m16                    ;no? Skip.
	  call	swap_video_mode         ;otherwise, swap to high-line mode

  _M16:

 ;-----------------------------------------;
 ; We are ready for business now. We will  ;
 ; loop here, waiting for user keystrokes. ;
 ; Performs CALL [DI] to execute function
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;-----------------------------------------;
 GET_KEY       PROC    NEAR
       CALL    REFRESH_DIR_DISP
;	  MOV     CTRL_PRESSED,0
;	  mov	rshift_pressed,0
       CMP     FUNCTION,0
       JE      _G_K0A

       MOV     AX,DEST_CLUSTER
       MOV     TARG_CLUSTER,AX
       CALL    DISP_COUNT_MSG          ;display files and space available
       MOV     FUNCTION,0              ;Restore function flags.

 _G_K0A:       CALL READ_C_KEY      ;Get a keystroke.

	  CMP	CLR_MSG_FLAG,0
	  PUSH	AX                      ;preserve keystroke returned by READ_C_KEY
	  JE		MENU_FLAG_CLR
	  MOV	CLR_MSG_FLAG,0
	  CALL	CLR_MSG
;	  POP	AX

 MENU_FLAG_CLR:
	  POP	AX  ;<<< Moved Pass 9 or so DF4 -- why weren't we hanging?
       MOV     BX,AX                   ;Save returned key.
	  CMP	AL,20H                  ;was it the space bar?
	  JNE	_G_K1_5
       MOV     AH,82H                  ;Assign pseudo value of 82h to space bar
	  MOV	BX,AX
	  JMP	SHORT _G_K1
 _G_K1_5:
       CMP     AH,1                    ;Is it Esc or below?
       JBE     _G_K1                   ;If yes, function.
       CMP     AH,36H                  ;Is it right shift or above?
       JAE     _G_K1                   ;If yes, function.
       CMP     AH,1CH                  ;Is it CR?
       JZ      _G_K1                   ;If yes, function.
       CMP     AH,0EH                  ;is it backspace?
       JZ      _G_K1                   ;if yes, function
       ;DON'T check for X here -- this is taken care of automatically
       ;by checking the Shift-State keys
       ;removed DF 4.60 pass 6
;       cmp     ah,02Dh                 ;is it X
;       JZ      _G_K1                   ;if yes, function
;	  cmp	ax,0D3Dh			    ;is it +/=?
;	  jnz	_G_K1_6			    ;if not, continue
	  cmp	ax,1B5Dh			    ;is it ]?
	  je		_G_K25			    ;if yes,skip to read
	  cmp	ax,1A5Bh			    ;is it [?
	  je		_G_K25			    ;if yes, skip to read
;	  mov	bh,7Ah			    ;plug in dummy key
;	  jmp	short _G_K1
 _G_K1_6:
       MOV     AH,2                    ;Get shift state.
       INT     16H
       TEST    AL,HOT_SHIFT            ;Is a hot key depressed?
       JNZ     _G_K1                   ;If yes, check function request.
       CALL    SEARCH                  ;Else, search for first letter.
       JMP     GET_KEY
_G_K1_9:
;       TEST    AL,CTRL_SHIFT
;       JZ      _G_K1_1
;       MOV     CTRL_PRESSED,1
 _G_K1:
 _G_K1_1:
	  CMP	SECOND_SHIFT,ALT_SHIFT
	  JE		_G_K2
;	  cmp	bx,0D2Bh	    ;is it Rshift +/=
;	  jne	_G_K1_101
;	  mov	bh,83h		;convert to the Alt-Key
;	  jmp	short _G_K2
 _G_K1_101:
	  cmp	RSHIFT_pressed,1	;keep from getting SHIFt-> ALT conversion
	  je		_G_K2
	  cmp	bh,87h	    ;is it Shift-F11
	  je		_G_K1_3	    ;yes? Process
	  cmp	bh,88h	    ;ditto for Shift-F12
	  je		_G_K1_3
	  CMP	BH,54H	    ;is is below Shift-F1
	  JB		_G_K2         ;yes? Pass through unchanged
	  CMP	BH,5DH        ;is it above Shift-F10
	  JA		_G_K2         ;yes, pass through unchanged
 _G_K1_2:
	  ADD	BH,14H 	    ;"converts" SHIFT-Fx to ALT-Fx (to match with
					    ;dispatch table)
	  jmp	short _G_K2
 _G_K1_3:
	  add	bh,4		    ;different conversion for extended keys

 _G_K2:
    	  mov	first_time,0			;used to only ask for parameter first time through
	  cmp	RSHIFT_pressed,1
	  jne	_G_K25
	  add	bh,38h + 14h			;create "phony" scan code (starts at A0)
 _G_K25:
       MOV     DI,OFFSET DISPATCH_KEY
       MOV     CX,DISPATCH_CNT         ;Valid commands.
       MOV     AL,BH
       MOV     BX,OFFSET DISPATCH_END
       CALL    LOOKUP
       JZ      _G_K3                  ;If no match, get another.
	  jmp	_G_K0A
 _G_K3:
       CALL    [BX]                    ;Else do subroutine.
       JMP     GET_KEY                 ;Update screen; get next command.

 ;-----------------------------------------------------------------------;
 ; This is the exit routine. Restore the defaults the way we found them. ;
 ;-----------------------------------------------------------------------;

 ERROR_EXIT:
	  MOV	DX,OFFSET press_a_key
	  mov	ah,9
	  int	21h
	  call	read_key  ;want a pause, but no message clearing
       MOV     AL,1                    ;Error code of one.
       MOV     SI,OFFSET INITIAL_PATH  ;Restore drive.
       JMP     SHORT _T1

 ;rearrangements here pass 8 of 4.60 to get screen clears
 ;to original attribute on critical error termination

 EXIT:
       XOR     AL,AL                   ;Error code of zero.
 TERMINATE:                            ;try to restore segment registers
                                       ;if got here through error handler
       push    cs
       push    cs
       pop     ds
       pop     es

       push    ax
       ;code added 4.61 to restore 25-line video mode if started up DF
       ;that way
       cmp     scr_ht,25
       je      _T03                    ;in 25-line mode already, go ahead
       cmp     start_scr_ht,25
       jne     _T03                    ;weren't in 25-line mode to start
       cmp     is_vga,1
       jne     _T02
       call    VGA25                   ;VGA 25-line restore
       jmp     short _T03
 _T02:
       cmp     is_ega,1
       jne     _T03
       call    EGA25                    ;EGA 25-line restore
 _T03:
       MOV     AL,ORIG_ATT
       CALL    CLR_SCR                 ;Clear screen.
       XOR     DX,DX
       CALL    SET_CURSOR
       pop     ax

	  mov	term_flag,1			;for use by CD_ERROR if needed
       MOV     SI,OFFSET INITIAL_PATH  ;Restore drive.
 _T05:
 _T1:  			                      ;save error code
       push    AX
       push    si
      call    is_uv_ar
      pop     si
      jnc     _t1A
      mov     al,in_dv
      and     al,al
      jnz     _T1A                    ;executing the following call was causing
                                      ;DVX extreme stomach problems
                                      ;so just skip it for now
      mov     ah,0CDh                 ;restores on entry ultravision mode
      mov     al,uv_mode_save
      int     10h
      call     set_uv_cursor
      jmp      short _T1B
 _T1A:
      call     cursor_on               ;cursor restore for non-Ultravision
                                       ;moved 4.61 from earlier rev (orig
                                       ;added DF4 Pass 7)
 _T1B:
       cmp     mem_use,0
       je      _T2

       ;deallocate separate malloc for DIR_BUF
;       push    es
;       mov     ax,dir_buf_seg
;       mov     es,ax
;       mov     ah,49h         ;release DIR_BUF_SEG
;       int     21h
;       pop     es
       call   dealloc_mem              ;deallocates XMS or EMS
 _T2:
	  pop	ax
       push    ax             ;this line had been removed, but put back
						; in DF4 pass 7.  Looks like it ought to be here
       CALL    CHANGE_PATH
       MOV     AL,VERIFY_STAT ;Restore verify state.
       MOV     AH,2EH         ;set verify dos call
       INT     DOSINT
       MOV     AX,3301H       ;Restore Control Break.
       MOV     DL,BREAK_STAT
       INT     DOSINT
       POP     AX             ;get back error code
       MOV     AH,4CH
       INT     DOSINT                  ;and go home

       cmp     save_mouse_state,1  ;mouse driver state not saved
       jne     quit
       push    es
       mov     ax,mdriver_seg
       mov     es,ax
       xor     dx,dx
       mov     ax,23
       int     33h                 ;restore state

       mov     ah,49h
       int     21h                 ;release memory block
       pop     es

 QUIT: CALL    CLR_DOS_WIN
       MOV     SI,OFFSET WORK_PATH     ; and default directory.
       JMP     SHORT   _T05

 GET_KEY       ENDP
 MAIN  ENDP

 SET_SCREEN_DIMS	PROC NEAR


 SET_SCREEN_DIMS  ENDP

;-------------------------------------------------------------------------;
; Sets correct BIOS function values for Extended keyboard (if flag set)   ;
; and modifies menus as appropriate
;
; Modifies: Assume all; bios_kybd_00, bios_kybd_01, user defined menus
;-------------------------------------------------------------------------;

 SET_KYBD_STATE	PROC NEAR

	CMP		EXT_KYBD_FLAG,0     ;should we use extended keyboard ?
	JE		SKS_1               ;no? wipe out extended stuff on menu
	ADD		BIOS_KYBD_00,10H    ;yes? set extended bios function values
	ADD		BIOS_KYBD_01,10H    ;(10h and 11h for int 16h rather than 0 and 1)
	JMP		SKS_RET
 SKS_1:
     ;rewritten df 4.50 to blank all menus
     MOV       DI,OFFSET CTRL_MENU ;wipe out F11 and F12 lines on Control Menu
     call      blank_f11f12
	MOV		DI,OFFSET ALT_MENU ;and the ALT-menu too
     call      blank_f11f12
     MOV       DI,OFFSET MENU1    ;and the main menu
     call      blank_f11f12
     MOV       DI,OFFSET RSHIFT_MENU
     call      blank_f11f12

SKS_RET:
	RET

 SET_KYBD_STATE	ENDP

;-------------------------------------------------------------------
; BLANK_F11F12:
; Blanks out the F11 and F12 lines of the menu.
; On entry, DI points to the offset of the start of the menu
;-------------------------------------------------------------------

 BLANK_F11F12  PROC NEAR
 BF11_2:
	ADD		DI,MENU_WIDTH*10+1
     MOV       CX,MENU_WIDTH
 BF11_3:
;     MOV       BYTE PTR [DI],20H
;     INC       DI
;     LOOP      BF11_3
     mov       ax,2020h
     rep       stosw

     ret
 BLANK_F11F12  ENDP

;------------------------------------------------------------------------;
;This routine checks the status of the currently displayed menu and
;swaps displayed menus if necessary                                      ;
;------------------------------------------------------------------------;

 MENU_CHECK	PROC NEAR

	   mov	 rshift_pressed,0
	   mov	 ctrl_pressed,0
        MOV     AH,2                    ;Get shift state.
        INT     16H
        TEST    AL,HOT_SHIFT            ;Is a hot key depressed?
        JNZ     CHECK_HOT
                                        ;ALT or CTRL is not pressed, check if Regular
	MOV     DX,0    		;menu in place, switch back if not
	JMP     CHECK
 CHECK_HOT:
	TEST    AL,SECOND_SHIFT
	JNZ     CHECK_ALT
	test	   al,RSHIFT_SHIFT
	jnz	   check_rshift
	MOV     DX,2                    ;CTRL key depressed
	mov	   ctrl_pressed,1
	JMP     CHECK
 CHECK_ALT:
	MOV     DX,1                    ;Secondary key depressed
	JMP     CHECK
 CHECK_RSHIFT:
	mov	   rshift_pressed,1
	mov	   dx,3
 CHECK:
        CMP     MENU_STATUS,DX
        JNE     SWITCH_MENU
	RET
 SWITCH_MENU:
	MOV    MENU_STATUS,DX
	CALL   DISPLAY_MENU
	RET

 MENU_CHECK	ENDP


 ;-----------------------------------------------;
 ; This subroutine parses the user command line entry
 ; On entry : DI points to start of string, CX holds count
 ; Returns  : SI=0 if nothing found, else SI points to start
 ; Modifies : adds null to end of space delimited string
 ;----------------------------------------;
 GET_PARAM     PROC    NEAR
       XOR     SI,SI
       MOV     AL,space
       JCXZ    _G_P5
 _G_P1:        SCASB                           ;scan off leading blanks
       JB      _G_P2                   ;skip control, too
       LOOP    _G_P1
       JMP     SHORT _G_P5

 _G_P2:        DEC     DI
       MOV     SI,DI                   ;save source

 _G_P3:        SCASB                           ;search for delimiter
       JAE     _G_P4
       LOOP    _G_P3

 _G_P4:        DEC     DI
       MOV     BYTE PTR [DI],0
 _G_P5:        OR      SI,SI
       RET
 GET_PARAM     ENDP

 ;-----------------------------------------------------------;
 ; This subroutine gets the file spec for COMMAND.COM from the
 ;  environment's COMSPEC variable
 ; On entry :  Nothing
 ; Returns  :  Carry set if COMSPEC not found
 ;             PGM_NAME contains file spec
 ; Modifies :  SI,DI
 ;-----------------------------------------------------------;
 GET_COMSPEC   PROC    NEAR
       MOV     AX,PSP_ENV_SEG                  ;get environment segment from PSP
       MOV     ENV_SEG,AX
       MOV     ES,AX
       ASSUME CS:_TEXT,DS:_TEXT,ES:nothing


 ;-----------------------------------------------------------;
 ; This section searches the environment block for a string
 ; On entry :  ES points to environment block
 ;             DS:DI points to "NAME=" to match
 ; Returns  :  carry set if string not found
 ;             ES:DI points to parameter if found
 ; Modifies :  SI,DI,BX
 ;-----------------------------------------------------------;
       XOR     DI,DI                   ;initialize offset to environment block

 _G_C1:        MOV     BX,OFFSET COM_VAR       ;initialize pointer to pattern
       CMP     BYTE PTR ES:[DI],0      ;End of environment block?
       JNE     _G_C2                   ;no

       STC                             ;indicate error
       JMP     SHORT _G_C6

 _G_C2:        MOV     AL,[BX]                 ;get character from pattern
       OR      AL,AL                   ;end of pattern? (turns off carry)
       JZ      _G_C4                   ;yes means match successful

       CMP     AL,ES:[DI]              ;compare to char in environment block
       JNE     _G_C3                   ;jump if match failed
       INC     BX
       INC     DI
       JMP     _G_C2                   ;loop

 _G_C3:        XOR     AL,AL                   ;scan forward for zero byte in env block
       MOV     CX,-1
       CLD
       REPNZ   SCASB
       JMP     _G_C1                   ;go compare next string

 _G_C4:                                        ;success, return ES:DI = string
       MOV     SI,OFFSET PGM_NAME      ;set DS:SI to point to location for copy
 _G_C5:        MOV     AL,ES:[DI]              ;transfer null-terminated string
       MOV     [SI],AL
       INC     SI
       INC     DI
       OR      AL,AL                   ;found a null?
       JNZ     _G_C5

 _G_C6:        PUSH    CS
       POP     ES
       RET
 GET_COMSPEC   ENDP

 ;---------------------------------------------------------------------------
 ; This subroutine gets the total bytes of the highlighted file
 ; rounded up to its space requirement on the
 ; working (i.e. displayed) disk
 ; Returns file size (rounded up to WORK_CLUSTER increment) in DX:AX
 ; On entry: SI points to file name
 ; Uses but saves DI,SI,BP,BX,CX
 ; Modifies: AX,DX
 ;---------------------------------------------------------------------------

 GET_SUB_BYTE		PROC NEAR

	PUSH		SI
	PUSH		DI
	PUSH		BP
	PUSH		BX
	PUSH		CX

	CALL		GET_FSIZE
	MOV		CX,WORK_CLUSTER
	CALL		ROUND_UP

 _GSB_RET:
	POP		CX
	POP		BX
	POP		BP
	POP		DI
	POP		SI
	RET

 GET_SUB_BYTE	ENDP

 ;------------------------------------------------------------------------
 ; Adds file size in DX:AX to SUB_BYTES_COUNT
 ;-------------------------------------------------------------------------

 ADD_SUB_BYTE		PROC NEAR
;	cmp		size_flag,1		;don't mess up the count if doing dir size func
;	je		_asb_ret
	ADD		SUB_BYTES_COUNT,AX
	ADC		SUB_BYTES_COUNT+2,DX
 _ASB_RET:
	RET

 ADD_SUB_BYTE		ENDP


 ;--------------------------------------------------------------------------
 ;This subroutines toggles the subdirectory bit of the SEARCH_ATTRIB byte
 ;and, hence, allows for the exclusion of subdirectories from the file
 ;display.
 ;--------------------------------------------------------------------------

 MASK_DIRS     PROC NEAR

     xor     search_attrib,10H
     call    refresh_pos
     ret
 MASK_DIRS     ENDP

 ;---------------------------------------------------------------------------
 ; This subroutine sets the program's verify state according to the information
 ; in VERIFY_DEFAULT (set by DFCONFIG).  "M" means no change; "N" means off;
 ; "Y" means on.  This setting is of a lower priority than that set by the /V switch.
 ;	Entry: nothing
 ;	Returns: nothing; may change verify state in DOS
 ;   Modifies: verify state, AX, DX
 ;
 ;-------------------------------------------------------------------------

 SET_VERIFY_STATE	PROC NEAR

	CMP 		VERIFY_DEFAULT,'M'
	JE		_SVS_RET
	CMP		VERIFY_DEFAULT,'F';off until we activate it for floppy writes
	JE		_SVS_1
	CMP		VERIFY_DEFAULT,'N'
	JE		_SVS_1

	MOV		AL,01H		;set verify on
	JMP		SHORT _SVS_2
 _SVS_1:
	MOV		AL,00H
 _SVS_2:
	MOV		AH,2Eh
	XOR		DL,DL		;for DOS 1 & 2 compatibility
	INT		DOSINT
 _SVS_RET:
	RET

 SET_VERIFY_STATE	ENDP
;--------------------------------------------------------------------------
; Sets various variables in accordance with the setting of the
; SHIFT_STATE_FLAG in addition to modifying references on the menus
; from "Alt" to "Lsh" if required.
; Moved to subroutine and Hot-key in menu changed Rev. 4
;--------------------------------------------------------------------------

 SET_SHIFT_STATE	PROC NEAR

	  TEST	SHIFT_STATE_FLAG,01H    ;is bit 0 set (use LSHIFT rather than ALT)?
	  JNZ	_SSS_01
	  MOV	SECOND_SHIFT,ALT_SHIFT
	  JMP	SHORT _SSS_04
_SSS_01:
	  MOV	SECOND_SHIFT,LSHIFT_SHIFT
;menu "correction" removed 4.61 since Ctl are the "official" keys
comment |
	  MOV	DI,OFFSET MENU1	    ;added rev 4
	  push	di
       ;changed to +9 from +8 rev 4.60
       ADD     DI,MENU_WIDTH*13+9
	  MOV	CX,3
	  push	cx
	  MOV	SI,OFFSET LSH_LABEL
	  push	si
	  REP	MOVSB
	  pop	si
	  pop	cx
	  pop	di
       add     di,MENU_WIDTH*11+6 + 25 ;additional 24 from 4.50 for new position
                                       ;and 1 more 4.60
	  rep	movsb
|
_SSS_04:
	  MOV	AH,HOT_SHIFT
	  ADD	AH,SECOND_SHIFT
	  MOV	HOT_SHIFT,AH
	  RET
 SET_SHIFT_STATE	ENDP

;----------------------------------------------------------------------
;Returns the entry number (line in the directory listing) on which
;the cursor is presently sitting in the AX register
;Uses: CUR_OFFSET, LINE
;Returns: ENTRY_COUNT and displays new line
;----------------------------------------------------------------------
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT

 RETURN_ENTRY	PROC NEAR

	CMP		NO_DRAW_FLAG,1   ;this is all visual so if we don't need to
     JNE        _RE_05          ;draw can just skip the whole thing
     jmp       _de_ret
_RE_05:
     push      es
     CALL      GET_NAME
     pop       es

	XOR		AX,AX            ;First we count the lines above the top of
	MOV		BP,-FIELD_SIZE   ;the display (CUR_OFFSET-DIR_BUFF)/FIELD_SIZE
	MOV		SI,CUR_OFFSET
;$     MOV       DI,OFFSET DIR_BUFF
     MOV       DI,dbs_start      ;offset from beginning of dir_seg
 _RE_1:
;$     CMP       SI,OFFSET DIR_BUFF
     CMP       SI,dbs_start
	JBE		_RE_2
	INC		AX
	ADD		SI,BP
	JMP		SHORT _RE_1
 _RE_2:
	MOV		BP,-ROW_LEN      ;now the number of lines down from the top of the screen
	MOV		SI,LINE          ; (LINE-BAR_START)/ROW_LEN
 _RE_3:
	CMP		SI,BAR_START
	JBE		_RE_4
	INC		AX
	ADD		SI,BP
	JMP		SHORT _RE_3

 _RE_4:
	CMP		COUNT,0		  ;Bar counter is 0 only with empty directory
	JE		_RE_5
	INC		AX               ;else increment by one so count starts at 1
 _RE_5:
	MOV		ENTRY_COUNT,AX

 DISPLAY_ENTRY  PROC NEAR
	  cmp	no_draw_flag,1			;if we're a dir_size or something
	  je		_de_ret                  ;like that we skip all this
	  MOV	DI,OFFSET SUB_ENTRY_LOC  ;we modify the line entry and
	  MOV	AX,ENTRY_COUNT
	  XOR	DX,DX
	  MOV	CX,LENGTH SUB_ENTRY_LOC
	  CALL	FORMAT

	  MOV	DI,OFFSET SUB_TOTAL_LOC
	  MOV	AX,COUNT
	  XOR	DX,DX
	  MOV	CX,LENGTH SUB_TOTAL_LOC
;       CALL    CFORMAT
       call    FORMAT

	  MOV	DI,OFFSET SUB_BYTES_LOC
	  MOV	AX,SUB_BYTES_COUNT
	  XOR	DX,SUB_BYTES_COUNT+2
	  MOV	CX,LENGTH SUB_BYTES_LOC
       CALL    CFORMAT
;       CALL    FORMAT

     MOV       DI,SUBDIR_LOC            ;display it
	MOV		SI,OFFSET SUBDIR_MSG
	MOV		AH,INTENSE
	CALL		PUT_STRATT

 _DE_RET:
	RET
 DISPLAY_ENTRY ENDP
 RETURN_ENTRY ENDP


 SUBTTL READ_DIR : (re)Display directory
 page
 ;----------------------------------------------------------------------
 ;  This procedure reads in the directory information, sorts it, and then
 ;enters the main command input program loop.
 ;On Entry: (1)        The current default drive and directory will be displayed
 ;             and then saved as WORK_PATH
 ;          (2)        The default drive and directory will then be reset back to
 ;             the destination drive and directory that must already be
 ;             saved in DEST_PATH.   ;          (3)  The ASCIIZ strings WORK_PATH and DEST_PATH, are
 ;             formatted and saved for display purposes.
 ;        (4) SOURCE and TARGET strings are also created/saved
 ;   During the main program loop the default dir is DEST_PATH
 ;----------------------------------------------------------------------
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT

 READ_DIR      PROC    NEAR

       mov     error_flag,0
       mov     no_dir_store,0 ;reset this flag used with filemasks to default
						;storage of subdirectories (4.0)
	  MOV	AH,19H		;get drive number
	  INT	DOSINT
	  MOV	DL,AL
	  INC	DL			;gets the two interrupts talking the same
						;language (19H retruns drive number -- drive
						;number +1 used by 36H)
	  MOV	AH,36H         ;get drive info
	  INT	DOSINT
	  MUL	CX             ;multiply bytes/sector * sector/cluster
	  MOV	WORK_CLUSTER,AX ;store (will get done eventually, but needs
						 ;to be done up front for subdirectory count)

       MOV     AL,NORMAL
	  CMP	NO_DRAW_FLAG,1
	  JE		_R_D1_NO

       CALL    CLR_SCR

 _R_D1_NO:

       MOV     SI,OFFSET LOAD_SORT_MSG ;Display sorting message.
       MOV     DI,LOAD_SORT_LOC
       CMP     SORT_LEN,-1             ;Unless not sorted.
       JNZ     _R_D1
       MOV     SI,OFFSET LOAD_MSG      ;Then display loading message.
       MOV     DI,LOAD_LOC

 _R_D1:
	  CMP	NO_DRAW_FLAG,1
	  JE		_R_D2_NO
       CALL    PUT_STRING

 _R_D2_NO:
	  XOR	CX,CX			    ;zero out subdirectory byte count
	  MOV	SUB_BYTES_COUNT,CX
	  MOV	SUB_BYTES_COUNT+2,CX

;$       MOV     DI,OFFSET DIR_BUFF      ;Put space character
       MOV     DI,dbs_start
;       MOV     CX,SP                   ; in directory listing
;       SUB     CX,100H                 ;  leave stack space
;       SUB     CX,DI                   ; initialize this much space
       mov     cx,dbs_end
       sub     cx,dbs_start
       add     cx,FIELD_SIZE
       MOV     AL,space                ; with space char in buffer.
       assume es:nothing
       push    es
       mov     es,DIR_BUF_SEG
       mov     di,dbs_start
       REP     STOSB
       pop     es
       assume es:_text


;$       MOV     CUR_OFFSET,OFFSET DIR_BUFF
       mov     ax,dbs_start
       mov     cur_offset,ax
       XOR     AX,AX                   ;initialize variables
       MOV     COUNT,AX                ;clear file counter
       MOV     FILE_CNT,AX             ;
       MOV     LINE,BAR_START


 ;------------------------------------------------------------------;
 ; Read all the directory filenames and store as records in buffer. ;
 ;------------------------------------------------------------------;

      MOV       DI,OFFSET VOL_NAME+8     ;clean out display string
      MOV       CX,11
      CLD
      mov       al,space
      REP       STOSB
	  CALL	READ_VOLUME              ;fill in volume name
      mov      si,offset temp_volume
     mov       di,offset vol_name+8
     mov       cx,11
     rep       movsb

;$       MOV     DI,OFFSET DIR_BUFF + 1  ;Point to buffer.
       MOV     DI,dbs_start
       inc     di
;       MOV     BP,SP                   ;Reserve space for stack.
;       SUB     BP,200H
	  call	is_star_dot_star
	  jc		_R_D15				;if there's a mask, need to read
	  call	read_w_mask              ;in all directoies, then make sure that
	  mov	no_dir_store,1           ;none are read a second time
 _R_D15:
       MOV     DX,OFFSET file_mask
       MOV     CL,SEARCH_ATTRIB
	  xor	ch,ch
       CALL    FIND_FIRST              ;Find first matching file.
       JC      _R_D3                   ;If empty directory, go on

	  mov	al,byte ptr DTA+F_ATTR  ;copy in current file attribute (part of
							    ;routine at _R_D17, but it's a bit more
							    ;efficient this way)
	  cmp	no_dir_store,0		    ;OK to store directories?
	  je		_R_D17                  ;yes? Go ahead

	  TEST	al,10h 			    ;Else, is it a subdirectory?
	  jnz    _R_D2				    ;Yes? Skip the store.
 _R_D17:
		;This RO, Hidden, System file screening added in 4.0
							    ;al from previous step
	  mov	ah,search_attrib	    ;copy in file attribute searchlist
	  not	ah                      ;reverse it for test
	  and	ax,011100000111b        ;mask out all but R-O, Hidden, System
	  and	al,ah                   ;AND them -- if value anything but zero,
	  cmp	al,0                    ; means a don't display attribute bit
	  jne	_R_D2                   ; matched up with an actual attribute bit

	  PUSH	DI
       CALL    STORE_ENTRY             ;Convert to directory format.
	  POP	SI                      ;Use DI before store to get file name position
	  DEC	SI				    ;decrement by 1 to put on mark field
       CALL    GET_SUB_BYTE            ;get file size (rounded up)
       CALL    ADD_SUB_BYTE            ;add to sub_byte_count


 _R_D2:
	  MOV     AH,4FH                  ;Find next matching.
       INT     DOSINT
       JC      _R_D3                   ;If carry, no more names.
	  mov	al,byte ptr DTA+F_ATTR  ;copy in current file attribute
	  cmp	no_dir_store,0		    ;OK to store directories?
	  je		_R_D21                  ;yes? Go ahead
	  TEST	al,10h 			    ;Else, is it a subdirectory?
	  jnz	_R_D2			    ;Yes? Skip the store.
 _R_D21:
	  mov	ah,search_attrib	    ;copy in file attribute searchlist
	  not	ah                      ;reverse it for test
	  and	ax,011100000111b        ;mask out all but R-O, Hidden, System
	  and	al,ah                   ;AND them -- if value anything but zero,
	  cmp	al,0                    ; means a don't display attribute bit
	  jne	_R_D2                   ; matched up with an actual attribute bit

	  PUSH	DI
       CALL    STORE_ENTRY
	  POP	SI                      ;Use DI before store to get file name position
	  DEC	SI				    ;decrement by 1 to put on mark field
       CALL    GET_SUB_BYTE            ;get file size (rounded up)
       CALL    ADD_SUB_BYTE            ;add to sub_byte_count
       CMP     DI,dbs_end              ;Are we encroaching end of segment?
                                       ;save a little buffer so that we
                                       ;don't wrap
       JBE     _R_D2                   ;If no, find next.
;       MOV     DX,OFFSET TOO_MANY      ;Else, exit with message.
       mov     error_flag,1
;       JMP     ERROR_EXIT
 ;-----------------------------------;
 ; Store buffer end address and page ;
 ; end then sort the filenames.      ;
 ;-----------------------------------;

 _R_D3:        DEC     DI
       MOV     END_OFFSET,DI           ;Store ending offset.
       MOV     BX,COUNT                ;Retrieve file count.
       MOV     AX,DIR_ROW_END
       CMP     BX,DIR_ROWS             ;Enough to fill one page?
       JAE     _R_D4                   ;If yes, use default setting.
       MOV     AX,ROW_LEN              ;Calculate last record.
       MUL     BL
       ADD     AX,BAR_START            ;Add bar offset.

 _R_D4:        MOV     DIR_DISP_END,AX
       CMP     SORT_LEN,-1             ;Should we sort or leave original?
       JZ      _R_D5                   ;If it was "/O", don't sort.
       CALL    SORT

 ;--------------=------------------------------------------------;
 ; Ready to get "working" directory and display it and the menu. ;
 ;---------------------------------------------------------------;

 _R_D5:        MOV     DI,OFFSET WORK_PATH     ;Point to storage.
       PUSH    DI                      ;and start of string
       CALL    GET_PATH                ;Get and save directory, space free.
       POP     SI                      ;get back working disk
       MOV     DI,OFFSET SOURCE        ;Make a carbon copy of directory.
 _R_D6:        MOVSB
       CMP     BYTE PTR [SI],0
       JNZ     _R_D6

       MOV     AL,"\"                  ;Add "\" to end of path

 IFDEF SAG
       CMP     SWITCH,"/"              ; Do we really want "/"?
       JE      _R_D6A:                 ; No
       MOV     AL,"/"                  ; Yes
 _R_D6A:
 ENDIF

       CMP     [DI-1],AL               ; if not root directory.
       JZ      _R_D7
       STOSB

 _R_D7:        MOV     FILE_NAME,DI            ;Store end of path to tack
                                       ; on filename later on.
 ;
 ;restore current d:\path for default moves and copies
 _R_D8:        MOV     SI,OFFSET DEST_PATH
	  CMP	NO_DRAW_FLAG,1
	  JE		_R_D_RET
       CALL    SET_DEST                ;Display drive, directory, menu.
       mov     skip_dir_flag,0
       call    init_drive_pointer      ;matches drive pointer to current drive

       cmp     error_flag,1
       jne     _R_D_RET

       ;print too many files error message

 _M15_7:
       call    refresh_dir_disp
       call    disp_count
       MOV     SI,offset TOO_MANY_FILES ;pointer to error message.
       MOV     AH,INTENSE              ;get display attribute
       OR      AH,80H                  ;make it blink
       MOV     DI,PROMPT_LOC
       CALL    PUT_STRATT
       CALL    DELAY

 _R_D_RET:
       RET
 READ_DIR      ENDP

;---------------------------------------------------------------------------
; This routine reads in all directories.  This allows a directory display
; which contains the directory entries even though a file mask is specified
; which would normally exclude them.
; On entry: DI set to offset of DIR_BUFF+1; stack space reserved
; Modified: assume Everything.
; On return: DI points to next location in DTA.
;--------------------------------------------------------------------------

 read_w_mask	proc near

       MOV     DX,OFFSET star_dot_star
       MOV     CX,10h			    ;1st we look for all directories, but unfortunately
							    ;these DOS functions will not return only
							    ;directory attribute files
       CALL    FIND_FIRST              ;Find first matching file.
       JC      _RWM_RET                ;If empty directory, go on

	  TEST	byte ptr DTA+F_ATTR,10h ;is it a subdirectory
	  jz		_RWM_1			    ;no? Don't store -- continue
	  PUSH	DI
       CALL    STORE_ENTRY             ;Convert to directory format.
	  POP	SI                      ;Use DI before store to get file name position
	  DEC	SI				    ;decrement by 1 to put on mark field
	  CALL	GET_SUB_BYTE		    ;get file size (rounded up)
	  CALL	ADD_SUB_BYTE            ;add to sub_byte_count


 _RWM_1:
	  MOV     AH,4FH                  ;Find next matching.
       INT     DOSINT
       JC      _RWM_RET                ;If carry, no more names.
	  TEST	byte ptr DTA+F_ATTR,10h ;is it a subdirectory
	  jz		_RWM_1			    ;no? Don't store -- continue
	  PUSH	DI
       CALL    STORE_ENTRY
	  POP	SI                      ;Use DI before store to get file name position
	  DEC	SI				    ;decrement by 1 to put on mark field
	  CALL	GET_SUB_BYTE		    ;get file size (rounded up)
	  CALL	ADD_SUB_BYTE            ;add to sub_byte_count
       CMP     DI,dbs_end              ;Are we running out of room?
                                       ;changed DF 4.60 P3.  Changed to be same
                                       ;as read_dir
       JBE     _RWM_1                  ;If no, find next.
;       MOV     DX,OFFSET TOO_MANY      ;Else, exit with message.
;       JMP     ERROR_EXIT
       mov     error_flag,1

 _RWM_RET:
 	  ret
 read_w_mask	endp



 ;--------------------------------------------------;
 ; This long subroutine stores the filename in DIR  ;
 ; format. That is, filename, bytes, date and time. ;
 ;--------------------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 STORE_ENTRY   PROC    NEAR
       MOV     SI,OFFSET DTA+F_NAME    ;Point to filename.
       MOV     CX,12                   ;Store 12 bytes of filename.
       CMP     BYTE PTR [SI],"."       ;Is it a dot directory?
       JNZ     _ST_E2                  ;If no, it's a file.
       CMP     BYTE PTR [SI+1],"."     ;Is it a double dot directory?
       JNZ     _ST_E1                  ;If no, single dot so skip.
       INC     COUNT                   ;Else, increment total count.

       assume es:NOTHING
       push    es
       mov     es,DIR_BUF_SEG
       LODSB                           ;Store dots and go to file size.
       STOSB
       STOSB
       pop     es
       assume es:_TEXT
       ADD     DI,10
       JMP     SHORT _ST_E6

 _ST_E1:       RET

 _ST_E2:       INC     COUNT                   ;Increment total count.
 _ST_E3:       LODSB                           ;Get a byte.
       CMP     AL,0                    ;End of filename?
       JZ      _ST_E5                  ;If yes, finish with spaces.
       CMP     AL,"."                  ;Is it the period?
       JNZ     _ST_E4                  ;If no, store.
       SUB     CX,3                    ;Else store 3 spaces.
       MOV     AL,space
       assume es:NOTHING
       push    es
       mov     es,DIR_BUF_SEG
       REP     STOSB
       pop     es
       assume es:_TEXT
       ADD     CX,3
       JMP     SHORT _ST_E3            ;Get next byte.

 _ST_E4:
       push    es
       assume es:NOTHING
       mov     es,DIR_BUF_SEG
       STOSB                           ;Store byte.
       pop     es
       assume es:_TEXT
       LOOP    _ST_E3                  ;Get next byte.
 _ST_E5:       MOV     AL,space                ;Pad balance with spaces.
       assume es:nothing
       push    es
       mov     es,DIR_BUF_SEG
       REP     STOSB
       pop     es
       assume es:_text

 ;process file size column
 _ST_E6:       PUSH    DI                      ;Save pointer.
       TEST    BYTE PTR DTA+F_ATTR,10H ;Is it a directory?
       JZ      _ST_E7                  ;If no, store size.
       MOV     SI,OFFSET DIRECTORIES   ;Else, store "<DIR>".
       INC     DI
       MOV     CX,5
       push    es
       assume es:NOTHING
       mov     es,DIR_BUF_SEG
       REP     MOVSB
       pop     es
       assume es:_TEXT
       JMP     SHORT _ST_E8

 _ST_E7:       INC     FILE_CNT                ;Increment file count.
       ADD     DI,8                    ;Move to end of bytes field.
       MOV     DX,WORD PTR DTA+F_SIZE+2        ;Retrieve high and low words
       MOV     AX,WORD PTR DTA+F_SIZE          ; of bytes.
       assume es:NOTHING
       push    es
       mov     es,DIR_BUF_SEG
       CALL    TRANSLATE               ;Convert to decimal.
       pop     es
       assume es:_text

 _ST_E8:       POP     DI                      ;Retrieve pointer.
       ADD     DI,11                   ;Move to date field.
       MOV     DX,WORD PTR DTA+F_DATE  ;Retrieve date.
       MOV     AX,DX
       MOV     CL,5                    ;Shift to lowest bits.
       ROR     AX,CL
       AND     AX,0FH                  ;Mask off all but month.
       MOV     CL,0FFH                 ;Flag as no leading zeros.
       MOV     CH,"-"                  ;Delimiting character.
       CALL    STORE_DIGITS            ;Store it.

 ;process date column
       MOV     AX,DX                   ;Retrieve date.
       AND     AX,1FH                  ;Mask off all but day.
       MOV     CL,0                    ;Flag include leading zeros.
       MOV     CH,"-"
       CALL    STORE_DIGITS            ;Store it.
       MOV     AX,DX                   ;Retrieve date for last time.
       MOV     CL,9
       ROR     AX,CL
       AND     AX,7FH                  ;Mask off all but year.
       ADD     AX,80                   ;Adjust to ASCII.
       CMP     AX,100                  ;Past year 2000?
       JB      _ST_E9                  ;If no, display. Else, adjust for
       SUB     AX,100                  ; next century. (Planning ahead!)

 _ST_E9:       MOV     CL,0                    ;Display leading zeros.
       MOV     CH,space
       CALL    STORE_DIGITS            ;Store it.

 ;process time column
       INC     DI                      ;Move to time field.
       MOV     DX,WORD PTR DTA+F_TIME  ;Retrieve time.
       MOV     AX,DX
       MOV     CL,11                   ;Shift to hours bits.
       ROR     AX,CL
       AND     AX,1FH                  ;Mask off all but hours.
       PUSH    AX
       CMP     AX,12                   ;Past noon?
       JBE     _ST_E10
       SUB     AX,12                   ;If yes, adjust.

 _ST_E10:
       CMP     AX,0                    ;Midnight?
       JNZ     _ST_E11
       MOV     AX,12                   ;If yes, adjust.

 _ST_E11:
       MOV     CL,0FFH                 ;Suppress leading zeros.
       MOV     CH,":"
       CALL    STORE_DIGITS            ;Store it.

       MOV     AX,DX                   ;Retrieve time.
       MOV     CL,5                    ;Shift to minutes bits.
       ROR     AX,CL
       AND     AX,3FH                  ;Mask off all but minutes.
       MOV     CL,0
       POP     DX                      ;Retrieve hours.
       MOV     CH,"p"                  ;Assume PM.
       CMP     DX,12                   ;Is it PM?
       JAE     _ST_E12
       MOV     CH,"a"                  ;If no, AM.

 _ST_E12:
       CALL    STORE_DIGITS            ;Store it.
       MOV     AH,BYTE PTR DTA+F_ATTR  ;Get attribute byte.
       MOV     AL,"H"                  ;Assume it's hidden.
       TEST    AH,2                    ;Is it?
       JNZ     _ST_E13                 ;If yes, store "H".
       MOV     AL,space                ;Else, store a space.

 _ST_E13:
       assume  es:nothing
       push    es
       mov     es,DIR_BUF_SEG
       STOSB
       pop     es
       assume  es:_text
       MOV     AL,"S"                  ;Assume it's system.
       TEST    AH,4                    ;Is it?
       JNZ     _ST_E14                 ;If yes, store "S".
       MOV     AL,space                ;Else, store a space.

 _ST_E14:
       assume es:nothing
       push    es
       mov     es,DIR_BUF_SEG
       STOSB
       pop     es
       assume es:_text
       MOV     AL,"R"                  ;Assume it's read-only.
       TEST    AH,1                    ;Is it?
       JNZ     _ST_E15                 ;If yes, store "R".
       MOV     AL,space                ;Else, store a space.

 _ST_E15:
       assume es:nothing
       push    es
       mov     es,DIR_BUF_SEG
       STOSB
       pop     es
       assume es:_text
       MOV     AL,"A"                  ;Assume it's archive.
       TEST    AH,20H                  ;is it?
       JNZ     _ST_E16                 ;If yes, store "A".
       MOV     AL,space                ;Else store a space.

 _ST_E16:
       assume es:nothing
       push    es
       mov     es,DIR_BUF_SEG
       STOSB
       pop     es
       assume es:_text
       INC     DI                      ;Bump pointer past mark field.
       assume es:_TEXT
       RET
 STORE_ENTRY   ENDP


 SUBTTL Main Command subroutines
 page
               ;**************************;
               ; MAIN COMMAND SUBROUTINES ;
               ;**************************;

 ;-------------------------------------------------------------------------
 ; This subroutine refreshes the directory, but returns the file to
 ; the original filename if that filename (or directory) is still present
 ; On entry: nothing
 ; Returns: nothing
 ; Modifies: Assume everything
 ;---------------------------------------------------------------------------

 REFRESH_POS	PROC NEAR

	CALL	GET_NAME                   ;get file name
;	MOV	SI,CUR_FILE
	INC	SI
	MOV	CX,12
	MOV	DI,OFFSET FILE_NAME_BUFF   ;and store file/dir name in buffer
     push    ds
     mov     ax,dir_buf_seg
     mov     ds,ax
	REP	MOVSB
     pop     ds

	CALL	REFRESH                    ;refresh the directory

 _RP1:
	CALL	GET_NAME

     assume es:nothing
     push    es
     mov     es,dir_buf_seg
     CMP     BYTE PTR es:[SI].D_NAME,space      ;Is it an empty entry? ----
     pop     es
     assume es:_text
     JZ      _RP_RET                         ;If yes, indicate so.     |
        			;rev 4.0 -- fixes divide by zero on empty dir   ----

	XOR	DX,DX   				;zero out counter
;     MOV  SI,OFFSET DIR_BUFF+1     ;point to top of listing
     mov  si,dbs_start
     inc  si

 _RP2:
	MOV	DI,OFFSET FILE_NAME_BUFF ;point destination to buffer
     MOV  CX,13                    ;incremented by 1 DF4.50 pass 5
	MOV	BX,SI                    ;save position in directory buffer

                                   ;since string compare messes it up
     push ds
     push ax
     mov  ax,dir_buf_seg
     mov  ds,ax
     REPE CMPSB                    ;compare until mismatch
     pop  ax
     pop  ds

	MOV	SI,BX
;     CMP  CX,0                     ;was there one?
;     JZ   _RP4                     ;No! We've found a match
     JCXZ _RP4
	ADD	SI,FIELD_SIZE        	;advance to next entry
	INC	DX                      	;increment counter
     assume es:nothing
     push es
     mov  es,dir_buf_seg
     CMP  BYTE PTR es:[SI],space      ;are we at the end?
     pop  es
     assume es:_text
     JNZ  _RP2
 _RP3:
	STC
	RET
 _RP4:                          	;see SEARCH for the details on this stuff
	MOV	CX,COUNT
	SUB	CX,DX
	MOV	SEARCH_COUNT,CX
	MOV	CL,NORMAL
	MOV	BAR_ATTRIBUTE,CL
	CALL	END_BAR
	JMP	SHORT _RP6
 _RP5:
	CALL	UP_ARROW
 _RP6:
	DEC	SEARCH_COUNT
	JNZ	_RP5
	MOV	CL,INVERSE
	MOV	BAR_ATTRIBUTE,CL
	XOR	BP,BP
	CALL	SCROLL_BAR
 _RP_RET:
	CLC
	RET

 REFRESH_POS	ENDP


 ;-----------------------------------------------------------------------
 ; This subroutine processes a space bar when pressed at the main command
 ; menu.  It acts as an Unmark if the file in question is already marked,
 ; else it acts as if the MARK <grey +> were pressed
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;---------------------------------------------------------------;

 GO_SPACE	PROC NEAR

	CALL	GET_NAME
	MOV	DL,COPY_MARK
     assume es:nothing
     push es
     mov  es,dir_buf_seg
     CMP  es:[SI],DL             ;is the file already marked?
     pop  es
     assume es:_text
	JE	_G_SP1              ;yes? Then Space acts as an unmark

	CALL	MARK				;otherwise, it acts like a MARK
	JMP	_G_SP_RET
 _G_SP1:
	CALL	UNMARK
 _G_SP_RET:
	RET

 GO_SPACE	ENDP

 ;---------------------------------------------------------------;
 ; This subroutine copies files that do not already exist on destination
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;---------------------------------------------------------------;
 PCOPY PROC    NEAR
       MOV     SI,OFFSET PCOPY_MSG     ;display copy message
       OR      FUNCTION,COPY_BIT+PROTECT_BIT   ;Else, indicate copy.
       JMP     SHORT _CPY1

 ;---------------------------------------------------------------;
 ; This subroutine copies either the highlighted or marked file. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;---------------------------------------------------------------;
 COPY  PROC    NEAR
       MOV     SI,OFFSET COPY_MSG      ;display copy message
       OR      FUNCTION,COPY_BIT       ;Else, indicate copy.
 _CPY1:        CALL    SETUP_DEST              ;Count marks, ask for destination.
       JC      _CPY_RET                        ; error exit.
       CALL    EXEC_MARKED             ;Execute the command.

 _CPY_RET:
       RET
 COPY  ENDP
 PCOPY ENDP
 ;----------------------------------------------------------------;
 ; This subroutine deletes either the highlighted or marked file. ;
 ; On entry : no known parameters
 ; Returns  : ABORT_DELETE_FLAG =1 if escape pressed
 ; Modifies : everything
 ;----------------------------------------------------------------;
 DELETE        PROC    NEAR
       CALL    COUNT_MARKS             ;Get count of marked files.
       JNZ     _DEL1                   ;If marked, display number marked.
       CALL    GET_NAME                ;Else get highlighted.
       JBE     _DEL_ERR                ;Exit if it's hidden or a directory
       MOV     SI,FILE_NAME            ;Else display filename.
       JMP     SHORT _DEL2

 _DEL1:
       MOV     SI,OFFSET MARKED_MSG

 _DEL2:        MOV     DI,PROMPT_LOC
       CALL    PUT_STRING
       MOV     SI,OFFSET DELETE_MSG    ;Display "will be deleted".
       CALL    PUT_STRING
       MOV     DI,PROMPT_LOC2          ;Display warning message.
       CALL    PUT_STRING
       CALL    CLEAR_OLD
	  JMP	_DEL3

 DIR_CONF		PROC NEAR

	  MOV	DIR_CONF_FLAG,1
	  CALL	COUNT_MARKS
	  MOV	ABORT_DELETE_FLAG,0
	  CALL	DISP_SIZE_MSG
       MOV     SI,OFFSET DDIR_MSG     ;Display "Dir will be deleted".
       MOV     DI,PROMPT_LOC3         ;Display warning message.
       CALL    PUT_STRING
       CALL    CLEAR_OLD

 _DEL3:        CALL    READ_KEY                ;Get a keystroke.
       CMP     AH,31H                  ;Is it "N"?
       JNZ     _DEL_3_3                ;If yes, exit delete.
	  MOV	ABORT_DELETE_FLAG,1
	  JMP	_DEL_RET
 _DEL_3_3:
       CMP     AH,1                    ;Is it Esc?
	  JNZ	_DEL_3_5
	  MOV	ABORT_DELETE_FLAG,1
       JMP     _DEL_RET                ;If yes, exit delete.
 _DEL_3_5:
       CMP     AH,15H                  ;Is it "Y"?
       JZ      _DEL4                   ;If yes, delete
       CALL    BEEP                    ;Else, beep.
       JMP     _DEL3                   ;And get another keystroke.

 _DEL4:        OR      FUNCTION,DELETE_BIT     ;Indicate deletion.
       CALL    EXEC_MARKED             ;Execute the command.
       JMP     SHORT _DEL_RET

 _DEL_ERR:
       assume es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BYTE PTR es:[SI].D_SIZE,"<" ;is it a directory?
       pop     es
       assume es:_text
	  JNZ	_DEL_ERR_CONT
	  CALL	DEL_DIR
	  JMP	SHORT _DEL_RET

 _DEL_ERR_CONT:
       CALL    BEEP                    ;Beep if error.
 _DEL_RET:
	  MOV	DIR_CONF_FLAG,0
       RET
  DIR_CONF		   ENDP
 DELETE                ENDP


 ;------------------------------------------------------------------;
 ; This subroutine displays a file and byte count of the directory
 ;     in the message location
 ; On entry : MARK_BYTES,MARK_COUNT
 ; Returns  :
 ; Modifies : everything
 ;--------------------------------------------------------------;

 DISP_size_MSG        PROC    NEAR
       CALL    CLR_MSG
 DISP_size     PROC    NEAR
;	  cmp	size_flag,1
;	  je		_d_ms_ret
       MOV     DI,OFFSET FILES         ;message string storage
       MOV     SI,DI                   ;save it
       MOV     AX,FILE_CNT
       XOR     DX,DX
       MOV     CX,LENGTH FILES
       CALL    FORMAT

 ;----------------------------------------------------;
 ; This subroutine displays the byte count and number of all files. ;
 ; On entry : MARK_BYTES and MARK_CNT contain numbers
 ; Returns  : nothing
 ; Modifies : everything
 ;----------------------------------------------------;

 DISP_size_MARKED   PROC    NEAR
       MOV     AX,MARK_BYTES
       MOV     DX,MARK_BYTES+2
       MOV     CX,LENGTH BYTES_SIZE_MSG
       MOV     DI,OFFSET BYTES_SIZE_MSG
       MOV     SI,DI
       CALL    CFORMAT
       MOV     AX,MARK_CNT
       XOR     DX,DX
       MOV     CX,LENGTH FILES_SIZE_MSG
       MOV     DI,OFFSET FILES_SIZE_MSG
       CALL    FORMAT
       MOV     DI,SIZE_LOC
       CALL    PUT_STRING

	  CMP	SIZE_FLAG,1
	  JNE	_D_MS_RET

       MOV     AX,MARK_BYTES_FD
       MOV     DX,MARK_BYTES_FD+2
       MOV     CX,LENGTH FLOPPY_SIZE_MSG
       MOV     DI,OFFSET FLOPPY_SIZE_MSG
       MOV     SI,DI
       CALL    CFORMAT
       MOV     DI,SIZE_LOC_2
       CALL    PUT_STRING

 _D_MS_RET:    RET
 DISP_size_MARKED   ENDP
 DISP_size    ENDP
 DISP_size_MSG        ENDP

 ;----------------------------------------------------------------------;
 ; This subroutine marks all files that aren't marked with an asterisk. ;
 ;      INCLUDING hidden files
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : SI
 ;----------------------------------------------------------------------;
 MARK_HBLANK    PROC    NEAR

       cmp     size_flag,1
	  je		_M_HB05			    ;don't bail if we're doing a size
	  CMP	FILE_CNT,0
	  JE		_M_HB_RET               ;if no files, bail out
 _M_HB05:
;       MOV     SI,OFFSET DIR_BUFF      ;Point to start of listing.
        mov    si,dbs_start
 _M_HB1:
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BYTE PTR es:[SI].D_SIZE,"<"        ;Is it a directory?
       JZ      _M_HB2                   ;If yes, skip.
       CMP     BYTE PTR es:[SI],space     ;Is it a space?
       JNZ     _M_HB2                   ;If no, skip.
       MOV     BYTE PTR es:[SI],COPY_MARK ;Else mark.
 _M_HB2:
       pop     es
       ADD     SI,FIELD_SIZE           ;Next record.
       CMP     SI,END_OFFSET           ;Continue until done.
       JB      _M_HB1
       CALL    COUNT_MARKS
 _M_HB_RET:
       pop     es
       assume  es:_text
       RET
 MARK_HBLANK    ENDP
 ;----------------------------------------------------;
 ; This subroutine counts the number of marked files. ;
 ; On entry : no known parameters
 ; Returns  : CX = MARK_CNT, Z flag set if CX=0,
 ;            MARK_BYTES_FD (with floppy cluster size)
 ; Modifies : CX, SI
 ;----------------------------------------------------;
 COUNT_MARKS_FD   PROC    NEAR
       assume  es:nothing
       push    es
       mov     es,DIR_BUF_SEG
       OR      FUNCTION,UPD_CNT_BIT
       XOR     CX,CX                   ;Zero out counter.
       MOV     MARK_BYTES_FD,CX
       MOV     MARK_BYTES_FD+2,CX
;$       MOV     SI,OFFSET DIR_BUFF      ;Point to start of listing.
       mov     si,dbs_start

 _C_M1_FD:        CMP     BYTE PTR es:[SI],COPY_MARK ;Is it marked?
       JNZ     _C_M2_FD                   ;In no, skip.
       INC     CX                      ;Else, increment counter.
       PUSH    CX
       CALL    GET_FSIZE
       MOV     CX,FD_CLUSTER
       CALL    ROUND_UP
       ADD     MARK_BYTES_FD,AX
       ADC     MARK_BYTES_FD+2,DX
       POP     CX


 _C_M2_FD:
       ADD     SI,FIELD_SIZE           ;Next record.
       CMP     SI,END_OFFSET           ;Continue until done.
       JB      _C_M1_FD
       pop     es
       assume  es:_text
       RET
 COUNT_MARKS_FD   ENDP

 ;--------------------------------------------------------------;
 ; This subroutine deletes a directory                          ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;--------------------------------------------------------------;

 DEL_DIR	PROC	NEAR

	  MOV	DIR_CONF_FLAG,1
	CALL		GET_NAME
	MOV		DI,CUR_FILE
     assume    es:nothing
     push      es
     mov       es,dir_buf_seg
     CMP       BYTE PTR es:[DI].D_SIZE,"<" ;directory?
	JNE		_DDIR_NOT_OK             ;no?  Then can't do a del_dir
     CMP       BYTE PTR es:[DI].D_NAME,"." ;root?
	JE		_DDIR_NOT_OK			;yes? can't do a del_dir
     CMP       BYTE PTR es:[DI].D_RO,"R"   ;ditto if hidden or read-only
	JE		_DDIR_NOT_OK
     CMP       BYTE PTR es:[DI].D_HID,"H"
	JE		_DDIR_NOT_OK
	JMP		_DDIR_OK

 _DDIR_NOT_OK:
     pop       es
	JMP		_DDIR_ERR

 _DDIR_OK:
     pop       es
     assume    es:_text
	MOV		NO_DRAW_FLAG,1           ;skip screen writes in the standard routines

	CALL		GET_NAME
	MOV		SI,OFFSET SOURCE
	MOV		AX,CUR_OFFSET			;save current file offset
	MOV		BX,LINE                  ;and bar line
	PUSH		BX                       ;save these value for future restore
	PUSH		AX

;	mov		dx,file_cnt			;(4.0) -- this was getting messed up
;	push		dx

	CALL		VIEW_DIR                 ;changes to highlighted directory
;	pop		dx
;	mov		file_cnt,dx

	MOV		SI,OFFSET DEST_PATH   ;restore destination directory properly
	CALL		MARK_BLANK
	CALL		COUNT_MARKS

 _DDIR_1:
	CMP		NO_DDIR_FLAG,1
	JE		_DDIR_6

;     CMP       MARK_BYTES,0
;    DF 4.60p7 -- directory not just empty, but no files
     cmp       cx,0
	JNE		_DDIR_3			;if directory empty, just go ahead
 _DDIR_2:
	POP		AX
	POP		BX
	CALL		POP_PARENT

 _DDIR_4:
	CALL		GET_NAME
	MOV		SI,OFFSET SOURCE   		;get directory name (full path)
	PUSH		SI
	PUSH		BX

	CALL		FIND_LENGTH              ;get its length
	MOV		CX,AX
	MOV		DI,OFFSET DEST_PATH      ;point to default destination path
	CLD
	REPE 	CMPSB                    ;compare the two
	CMP		CX,0                     ;are they the same
	JNE		_DDIR_5                  ;no? go ahead and delete
;	MOV		SI,OFFSET PARENT_DIR     ;otherwise change destination path first
;	CALL		SET_DEST
	CALL		UPD_DEST                 ;not sure why this call alone works.  Actually
								;popping to the destination parent causes to
								;go up 2 levels.  Would seem to imply that
								;df destination and reality are out of sync
								;seems to work, but could be a problem indicator
_ddir_5:
	POP		BX
	POP		SI

;	CALL		GET_DSIZE				;get the size of the directory
								;treated differently from files since
								;the size isn't stored in the directory
	MOV		DX,SI
	MOV		AH,3AH
	INT		DOSINT				;delete directory
     JNC		_DE_1     			;an error shouldn't happen, but...
	JMP		_DDIR_ERR

 _DE_1:
	CALL		REMOVE_FILE              ;removes file from listing
;	MOV		AX,WORK_BYTES_FREE
;	MOV		DX,WORK_BYTES_FREE+2
;	PUSH		AX
;	PUSH		DX
;	CALL		GET_PATH				;no easy way to get size of deleted directory
;	POP		DX
;	POP		AX
;	SUB		AX,WORK_BYTES_FREE
;	SBB		DX,WORK_BYTES_FREE+2
;	ADD		SUB_BYTES_COUNT,AX
;	ADC		SUB_BYTES_COUNT+2,DX

	JMP		_DDIR_RET

 _DDIR_3:
	CALL		DIR_CONF				;delete files w/confirm
	POP		AX
	POP		BX
	CALL		POP_PARENT
	CMP		ABORT_DELETE_FLAG,1      ;if routine exited, don't try to delete dir
	JE		_DDIR_RET
	JMP		_DDIR_4

 _DDIR_6:
	POP		AX
	POP		BX
	CALL		POP_PARENT

 _DDIR_ERR:
	CALL		BEEP

 _DDIR_RET:
	MOV		FUNCTION,0
	MOV		NO_DRAW_FLAG,0           ;we're back, restore flag
	MOV		CLR_MSG_FLAG,1
	MOV		NO_DDIR_FLAG,0
	MOV		ABORT_DELETE_FLAG,0
	MOV		MARK_CNT,0
	MOV		MARK_BYTES,0

	CALL		CLR_MSG
	CALL		REFRESH_POS
	MOV		SI,OFFSET DEST_PATH
	CALL		SET_DEST

	RET

 DEL_DIR	ENDP



 ;-----------------------------------------------------------------------
 ;This subroutine pops back up to the parent and fixes up the screen
 ; Returns: nothing
 ; On entry: AX = stored offset
 ;		   BX = STORED LINE
 ; Modifies: Assume everything
 ;-----------------------------------------------------------------------

 POP_PARENT	PROC NEAR

	PUSH		AX
	PUSH		BX

 _PP_1:
	MOV		SI,OFFSET PARENT_DIR
	CALL		VIEW_DIR                 ;jump back up and put things the way we found them

	CALL		GET_NAME
	POP		BX                       ;restore registers
	POP		AX
	MOV		CUR_OFFSET,AX
	MOV		LINE,BX                  ;and previous locations of file and bar
	MOV		BP,0                     ;don't move the bar from here
	MOV		NO_DRAW_FLAG,0           ;turn drawing back on
	CALL		SCROLL_BAR               ;and put the bar and files back where they belong

	RET

 POP_PARENT	ENDP


 ;--------------------------------------------------------------;
 ; This subroutine creates a new directory under the current directory
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;--------------------------------------------------------------;

 CREATE_DIR	PROC	NEAR

	MOV		SI,OFFSET CREATE_DIR_MSG
	CALL		ASK4DIR
	JC		_CREATE_DIR_RET
	MOV		DX,SI       ;set dx to point to new directory name
					  ;pointed to by si in ask4dir
	PUSH		DX

	MOV 		SI,OFFSET WORK_PATH  ;temporarily set the default dir to the visible
							 ;directory -- since this is where we want the
							 ;created directory to go -- not the standard default
	CALL		CHANGE_PATH

	POP		DX
	MOV		AH,39H      	;create subdirectory
	INT		DOSINT
	JC		_CDIR_ERR		;function failed
 _CDIR_1:
	JMP		SHORT _CDIR_2

 _CDIR_ERR:
	CALL BEEP
 _CDIR_2:
	MOV		SI,OFFSET DEST_PATH   ;put the directories back the way the were
	CALL		CHANGE_PATH
 _CREATE_DIR_RET:
	CALL 	REFRESH_POS           ;REFRESH -> REFRESH_POS [3.50]
;	CALL		PUT_MENU_PATHS        ;to maintain cursor position
	RET

 CREATE_DIR	ENDP

 ;-----------------------------------------------------------;
 ; Subroutine prompts for user entry for creating directories
 ;  and then parses whatever the user enters
 ; On entry :  SI points to a prompt message
 ; Returns  :  SI pointing to new dir, AX=':' if only drive specified
 ;             carry flag set if not successful
 ; Modifies : assume everything
 ;-----------------------------------------------------------;
 ASK4DIR      PROC    NEAR
       MOV     DI,PROMPT_LOC
       CALL    PUT_STRING

	  MOV	SI,OFFSET WORK_PATH
	  CALL	FIND_LENGTH		;find existing path length

	  MOV	CX,3				;format existing path length and add to message
	  XOR	DX,DX
	  MOV	DI,OFFSET PATH_LENGTH_MSG + 14
	  PUSH	AX
	  CALL	FORMAT
	  POP	AX

	  NOT	AX
	  ADD	AX,66		     ;66 is max path length (including drive:\)
							;so AX now holds the allowable number of chars
							;remaining (including added delimiter)
	  MOV	CX,3                ;format remaining length and add to message
	  XOR	DX,DX
	  MOV	DI,OFFSET PATH_LENGTH_MSG + 22
	  PUSH	AX
	  CALL	FORMAT
	  POP	AX

	  DEC	AX				;decrement 1 for required added delimiter

	  MOV	CX,AX
	  MOV	SI,OFFSET PATH_LENGTH_MSG
	  MOV	DI,PROMPT_LOC3
	  CALL	PUT_STRING

       CALL    TO_DIR                   ;Ask user for destination.
       JC      _A4DIR_RET                ;If Esc pressed, exit.
       XOR     AL,AL
       STOSB                           ;end string with null
       MOV     SI,OFFSET ENTRY         ;get first 2nd and 3rd bytes
       MOV     AX,[SI+1]
       CMP     AX,':'                  ;is this the end?
       CLC
       JNZ     _A4DIR_RET                ;If no, we're done
       MOV     WORD PTR [SI+2],'.'     ;add a '.',0 to string to fool dos
 _A4DIR_RET:
       RET
 ASK4DIR      ENDP


 TO_DIR       PROC    NEAR
	  PUSH	CX				    ;Preserve counter
       CALL    CLEAR_OLD               ;Remove last user entry.
                                       ;and set up cursor
	  POP	CX
	  XOR	DX,DX			    ;clear counter
 _T_DR1:        CALL    READ_KEY                ;Get a keystroke.
       XOR     BH,BH                   ;set video page 0 for tty out
       CMP     AL,27                   ;Is it Esc?
       JZ      _T_DR3                   ;If yes, abort.
       CMP     AL,13                   ;Is it carriage return?
       JZ      _T_DR4                   ;If yes, execute.
       CMP     AL,8                    ;Is it backspace?
       JNZ     _T_DR2                   ;If yes, backspace.

       CMP     DI,OFFSET ENTRY         ;At beginning of field?
       JZ      _T_DR1                   ;If yes, skip.
       DEC     DI                      ;Else, decrement pointer.
	  DEC	DX				    ;decrement counter
       MOV     BYTE PTR [DI],0
       MOV     AX,0E08H                ;use BIOS TTY
       PUSH    AX
       INT     10H                     ;to backspace
       MOV     AX,0E00H + space        ;blank out char
       INT     10H
       POP     AX                      ;backspace again
       INT     10H
       JMP     SHORT _T_DR1

 _T_DR2:        CMP     AL,space                ;Is it above space?
       JBE     _T_DR1                   ;If no, ignore.
       CMP     DI,OFFSET ENTRY + 32    ;Else, is 32 char entry field full?
       JZ      _T_DR_ERR               ;If yes, ignore.
	  CMP	DX,CX                   ;have we exceeded max path?
	  JAE	_T_DR_ERR
       STOSB                           ;Else, store the character.
	  INC	DX				    ;increment stored character counter
       MOV     AH,0EH                  ;display using BIOS write tty
       INT     10H                     ;which also updates cursor
       JMP     SHORT _T_DR1

 _T_DR3:        CALL    DISP_COUNT_MSG
       STC
       RET
 _T_DR_ERR:
	  PUSH	DX
	  CALL	BEEP
	  POP	DX
	  JMP	SHORT _T_DR1

 _T_DR4:        CLC
       RET
 TO_DIR               ENDP

 ;--------------------------------------------------------------;
 ; This subroutine moves either the highlighted or marked file. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;--------------------------------------------------------------;
 MOVE  PROC    NEAR
       MOV     SI,OFFSET MOVE_MSG      ;Display move message.
       CALL    SETUP_DEST              ;Count marks, ask for destination.
       JC      _MV_RET                 ; error exit

       MOV     AX,WORD PTR ENTRY       ;Check if across drives move.
       CMP     AH,":"                  ;Is there a drive specified?
       JZ      _MV_2                   ;Use specified drive if there
       MOV     AL,DEST_PATH            ;Otherwise use default

 _MV_2:        AND     AL,5FH          ;Capitalize.
       CMP     AL,SOURCE               ;Is it the same as source?
       MOV     AL,MOVE_BIT+PROTECT_BIT ; Meanwhile, force a check to see
                                       ;if target file already exists before
                                       ;executing a rename or copy operation
       JZ      _MV_3                   ;If src disk=targ disk, just rename.
       OR      AL,COPY_BIT+DELETE_BIT  ;Else, indicate both copy/delete.

 _MV_3:        MOV     FUNCTION,AL             ;indicate desired function
       CALL    EXEC_MARKED             ;Execute the command.
 _MV_RET:
       RET
 MOVE  ENDP

 ;--------------------------------------------------------------;
 ; This subroutine moves either the highlighted or marked file. ;
 ;    and overwrites the target file if it exists
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;--------------------------------------------------------------;
 FMOVE  PROC    NEAR
       MOV     SI,OFFSET FMOVE_MSG     ;Display move message.
       CALL    SETUP_DEST              ;Count marks, ask for destination.
       JC      _FMV_RET                ; error exit

;bug fix in 4.60 -- there was drive checking and the drive was
;never getting cleared out of AL.  This is why the results were flakey

       MOV      FUNCTION,COPY_BIT+DELETE_BIT ;Else, indicate both copy/delete.
       CALL    EXEC_MARKED             ;Execute the command.
 _FMV_RET:
       RET
 FMOVE  ENDP

 ;--------------------------------------------------------------;
 ; This subroutine renames either the highlighted or marked file. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;--------------------------------------------------------------;
 RENAME        PROC    NEAR
       OR      FUNCTION,RENAME_BIT+DIR_OK_BIT  ;flag desired function
       MOV     SI,OFFSET RENAME_MSG    ;Display rename message.
       CALL    SETUP_DEST              ;Count marks, ask for destination.
       JC      _REN_RET                ; abort

 _REN1:        MOV     SI,OFFSET WORK_PATH
       CALL    CHANGE_PATH             ;change back to work disk
 _REN2:        CALL    EXEC_MARKED             ;Execute the command.
 ;there is a subtle problem in restoring the dest path that occurs
 ;when the rename operation has renamed the detination such that
 ;DEST_PATH no longer exists as a legitimate path
       MOV     DI,OFFSET DEST_PATH     ;get destination path
       PUSH    DI                      ;save it for now
       MOV     SI,OFFSET SOURCE        ;check with what we just changed

 _REN3:        LODSB                           ;get a byte
       SCASB                           ;check it against dest
       JNZ     _REN4                   ;dest was not renamed
       OR      AL,AL                   ;are we done
       JNZ     _REN3                   ;no, there's more

 _REN4:        POP     SI
       JNZ     _REN5
       MOV     SI,OFFSET ENTRY         ;use new name instead
 _REN5:        CALL    SET_DEST                ;go restore dest
 _REN_RET:
       RET
 RENAME        ENDP


 ;-----------------------------------;
 ; This subroutine clears all marks. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : SI
 ;-----------------------------------;
 CLEAR_MARK    PROC    NEAR
     assume es:NOTHING
       mov     si,dbs_start
       push    es
       mov     es,dir_buf_seg
;       MOV     SI,OFFSET DIR_BUFF      ;Point to start of listing.
 _CLM1:        MOV     BYTE PTR es:[SI],space     ;Write space over mark.
       ADD     SI,FIELD_SIZE           ;Next record.
       CMP     SI,END_OFFSET           ;End of listing?
       JB      _CLM1                   ;If no, continue until done.
       CALL    COUNT_MARKS
       pop     es
     assume es:_TEXT
       RET
 CLEAR_MARK    ENDP


 ;----------------------------------------------------------------------;
 ; This subroutine marks all files that aren't marked with an asterisk. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : SI
 ;----------------------------------------------------------------------;
 MARK_BLANK    PROC    NEAR
       assume es:NOTHING
       push    es
	  CMP	FILE_CNT,0
	  JE		_M_B_RET                ;if no files in directory, skip to end
							    ;works around a bug which allowed marking
							    ;1 "file" in an empty directory
       mov     si,dbs_start
       mov     es,dir_buf_seg
;       MOV     SI,OFFSET DIR_BUFF      ;Point to start of listing.
 _M_B1:
       CMP     BYTE PTR es:[SI].D_SIZE,"<"        ;Is it a directory?
       JZ      _M_B2                   ;If yes, skip.
       CMP     BYTE PTR es:[SI].D_HID,"H" ;Is it a hidden file?
       JZ      _M_B2                   ;If yes, skip.
       CMP     BYTE PTR es:[SI],space     ;Is it a space?
       JNZ     _M_B2                   ;If no, skip.
       MOV     BYTE PTR es:[SI],COPY_MARK ;Else mark.
 _M_B2:
       ADD     SI,FIELD_SIZE           ;Next record.
       CMP     SI,END_OFFSET           ;Continue until done.
       JB      _M_B1
       CALL    COUNT_MARKS
 _M_B_RET:
       pop     es
       assume es:_TEXT
       RET
 MARK_BLANK    ENDP

 ;-------------------------------------------------------;
 ; This subroutine swaps marked/unmarked                       ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : SI
 ;-------------------------------------------------------;
 SWAP_MARK     PROC    NEAR
       assume  es:nothing
      ;push moved 4.61 to cure hangs in directories with no files
       push    es
       CMP     FILE_CNT,0
	  JE		_S_M_RET                ;if no files in directory, skip to end
;       MOV     SI,OFFSET DIR_BUFF      ;Point to start of listing.
       mov     si,dbs_start
       mov     es,dir_buf_seg

 _S_M1:        CMP     BYTE PTR es:[SI],COPY_MARK ;Is it marked ?
       JZ      _S_M2                   ;If yes, unmark it.
       CMP     BYTE PTR es:[SI].D_SIZE,"<"        ;Is it a directory?
       JZ      _S_M3                   ;If yes, skip.
       CMP     BYTE PTR es:[SI].D_HID,"H" ;Is it a hidden file?
       JZ      _S_M3                   ;If yes, skip.
       MOV     BYTE PTR es:[SI],COPY_MARK ;Else mark.
       JMP     SHORT _S_M3

 _S_M2:        MOV     BYTE PTR es:[SI],space
 _S_M3:        ADD     SI,FIELD_SIZE           ;Next record.
       CMP     SI,END_OFFSET           ;Continue until done.
       JB      _S_M1
       CALL    COUNT_MARKS
 _S_M_RET:
       pop     es
       assume  es:_text
       RET
 SWAP_MARK     ENDP

 ;--------------------------------------------------------;
 ; This subroutine marks or unmarks the highlighted file. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : assume everything
 ;--------------------------------------------------------;
 MARK  PROC    NEAR
       CALL    PUT_AMARK
       CALL    DN_ARROW                ;And move down a row.
       RET
 MARK  ENDP

 UNMARK        PROC    NEAR
       MOV     DL,space                ;Space character.
       CALL    PUT_MARK
       CALL    DN_ARROW                ;And move down a row.
       RET
 UNMARK        ENDP

 PUT_AMARK     PROC    NEAR
       MOV     DL,COPY_MARK
 PUT_MARK      PROC    NEAR
       CALL    GET_NAME                ;Get filename.
       JBE     PTM_RET                 ;If directory or hidden, skip.
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       MOV     es:[SI],DL                 ;Else store the character.
       pop     es
       assume  es:_text
       PUSH    SI
       CALL    COUNT_MARKS
       POP     SI
 PTM_RET:      RET
 PUT_MARK      ENDP
 PUT_AMARK     ENDP
 ;-----------------------------------------------------------------------;
 ; This subroutine searches for a filename with a specific first letter. ;
 ; On entry : BL contains character to search for
 ; Returns  : nothing
 ; Modifies : assume everything
 ;-----------------------------------------------------------------------;
 SEARCH        PROC    NEAR
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BL,"a"                  ;Capitalize if lower case.
       JB      _SRCH1
       CMP     BL,"z"
       JA      _SRCH1
       AND     BL,5FH

 _SRCH1:       CALL    GET_NAME                ;Get current position.
       XOR     DX,DX                   ;Zero out file counter.
       MOV     DI,SI                   ;Store current position in DI.
       INC     DI                      ;point to filename
;       MOV     SI,OFFSET DIR_BUFF + 1  ;Point to top of listing.
       mov     si,dbs_start
       inc     si

       CMP     BYTE PTR es:[DI],BL        ;Are we currently at a match?
       JNZ     _SRCH3                  ;If no, start from top.

 _SRCH2:       INC     DX                      ;Increment count.
       ADD     SI,FIELD_SIZE           ;Increment record.
       CMP     SI,DI                   ;New record?
       JBE     _SRCH2                  ;If no, find it.

 _SRCH3:       CMP     BYTE PTR es:[SI],BL        ;Got a match?
       JZ      _SRCH4                  ;If yes, process.

       ADD     SI,FIELD_SIZE           ;Else, point to next record.
       INC     DX
       CMP     BYTE PTR es:[SI],space     ;End of listing?
       JNZ     _SRCH3                  ;If no, keep searching.
       CALL    BEEP                    ;No matches, so beep.
       pop     es
       assume  es:_text
       STC
       RET

 _SRCH4:
;       assume es:nothing

       ;DF 4.60 pass 6.  I think moving this pop up here solves all the
       ; VERY hard to trace garbage on screen problems.  Not sure
       ;exactly where the garbage was coming from but it had something
       ;to do with the scroll/bar movement routines.  We have
       ;the count so don't need the directory segment any longer here


       pop     es
       MOV     CX,COUNT                ;Retrieve file count.
       SUB     CX,DX                   ;Subtract search count.
       MOV     SEARCH_COUNT,CX         ;And store.
       MOV     CL,NORMAL               ;Turn off bar for now.
	  MOV	LINE_CNT_DISP,0	    ;Turn off line number display for now
       MOV     BAR_ATTRIBUTE,CL
       CALL    END_BAR                 ;First move to end.
       JMP     SHORT _SRCH6

 _SRCH5:       CALL    UP_ARROW                ;Move up to matching filename.

 _SRCH6:       DEC     SEARCH_COUNT
       JNZ     _SRCH5

       MOV     CL,INVERSE              ;Turn bar back on and display.
	  MOV	LINE_CNT_DISP,1	    ;Turn line number display back on
       MOV     BAR_ATTRIBUTE,CL
       XOR     BP,BP
       CALL    SCROLL_BAR
       CLC
;       pop     es
;       assume es:_text
       RET
 SEARCH        ENDP

;DF 4.60 development note!!!
;switched to signed compared in this area with 4.60 because of problems
;(presumably) related to changing offset dir_buf to 0.  Some experimentation
;yielded this and there don't SEEM to be side effects...

 ;--------------------------------------------------------------------------;
 ; These six subroutines control the bar and page of the directory listing. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : BX, SI, BP
 ;--------------------------------------------------------------------------;
     assume cs:_text, ds:_text, es:_text
 UP_ARROW      PROC    NEAR
       MOV     BP,-ROW_LEN                     ;Move bar up one line.
       JMP     SHORT BAR_MOVE

 DN_ARROW      PROC    NEAR
       MOV     BP,ROW_LEN                      ;Move bar down one line.

 BAR_MOVE      PROC    NEAR
       CALL    SCROLL_BAR
       RET
 BAR_MOVE      ENDP
 DN_ARROW      ENDP
 UP_ARROW      ENDP

     assume cs:_text, ds:_text, es:_text
 PG_DN PROC    NEAR
	  push	ax
	  push	dx
	  push	bx
	  mov	ax,dir_rows
	  dec	ax
	  mov	bx,FIELD_SIZE
	  mul	bx
	  MOV     BP,ax			  ;Move down page.
	  pop	bx
	  pop	dx
	  pop	ax

 MOVE_PAGE     PROC    NEAR
       CALL    SCROLL
       JMP     SHORT TOP_BAR           ;Move bar to top.

 HOME_BAR      PROC    NEAR
;       MOV     CUR_OFFSET,OFFSET DIR_BUFF;Move listing to beginning.
       push    ax
       mov     ax,dbs_start
       mov     cur_offset,ax
       pop     ax

     assume cs:_text, ds:_text, es:_text
 TOP_BAR       PROC    NEAR
       MOV     SI,BAR_START            ;And move bar to top.
       CALL    MOVE_BAR
       RET
 TOP_BAR               ENDP
 HOME_BAR      ENDP
 MOVE_PAGE     ENDP
 PG_DN         ENDP

     assume cs:_text, ds:_text, es:_text
 PG_UP PROC    NEAR
	  push	ax
	  push	dx
	  push	bx
	  mov	ax,dir_rows
	  dec	ax
	  mov	bx,-FIELD_SIZE
	  mul	bx
	  MOV     BP,ax			  ;Move up page.
	  pop	bx
	  pop	dx
	  pop	ax
       CALL    SCROLL
       JMP     SHORT BOTTOM_BAR

     assume cs:_text, ds:_text, es:_text
 END_BAR       PROC    NEAR
       MOV     BX,END_OFFSET           ;Move listing to last page.
	  push	ax
	  push	dx
	  push	bx
	  mov	ax,dir_rows
	  mov	bx,FIELD_SIZE
	  mul	bx
	  pop	bx
	  sub     bx,ax			  ;Move up page.
	  pop	dx
	  pop	ax
;       CMP     BX,OFFSET DIR_BUFF
       jc      bottom_bar            ;check for segment wrap first

       cmp     bx,dbs_start          ;check if bellow in same segment
       JBE     BOTTOM_BAR

_eb_1:
       MOV     CUR_OFFSET,BX

     assume cs:_text, ds:_text, es_text
 BOTTOM_BAR    PROC    NEAR
       MOV     SI,DIR_DISP_END         ;And move bar to bottom.
       SUB     SI,ROW_LEN
       CALL    MOVE_BAR
       RET
 BOTTOM_BAR    ENDP
 END_BAR       ENDP
 PG_UP ENDP

 ;----------------------------------------------------;
 ; This subroutine does the actual moving of the bar. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : AX, CX, DX, DI
 ;----------------------------------------------------;
     assume cs:_text, ds:_text, es:_text
 MOVE_BAR      PROC    NEAR
       MOV     AL,NORMAL               ;Remove old bar.
       CALL    BAR
       MOV     LINE,SI                 ;And move bar to new line.
       MOV     AL,BAR_ATTRIBUTE

 BAR   PROC    NEAR
       MOV     DI,LINE                 ;Retrieve line.
       MOV     CX,BAR_LEN              ;Bar length 39.
	  CMP	NO_DRAW_FLAG,1
	  JE		_BR_RET
 _BR_1:        CALL    PUT_CHAR                ;Write the attribute.
       LOOP    _BR_1
 _BR_RET:
	 PUSH	SI
	 PUSH	DI
	 PUSH	BP
	 CMP		LINE_CNT_DISP,0
	 JE		_BR_2
	 CALL RETURN_ENTRY
 _BR_2:
	 POP		BP
	 POP		DI
	 POP		SI

      RET
 BAR   ENDP
 MOVE_BAR      ENDP

 ;-------------------------------------;
 ; This subroutine scrolls the screen. ;
 ; On entry : BP indicates direction and number of lines to scroll
 ; Returns  : nothing
 ; Modifies : BX, SI
 ;-------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 SCROLL        PROC    NEAR
       MOV     SI,CUR_OFFSET           ;Get current offset.
       ADD     SI,BP                   ;Add requested direction.
       ;check for segment wrap. Algorithm is we've wrapped if:
       ;si > 0 before addition and
       ;si > 0F000 after addition
       cmp     cur_offset,0
       jl      _sc05
       cmp     si,0F000h
       ja      _sc06
 _SC05:
       cmp     si,dbs_start
       JAE     _SC1
 _SC06:
       push    ax
       mov     ax,dbs_start
       mov     cur_offset,ax
       pop     ax
       JMP     SHORT _SC_RET           ;And update screen.

 _SC1: MOV     BX,END_OFFSET           ;See if beyond end of
;       mov     cx,offset dir_buff
       mov     cx,dbs_start
	  push	ax
	  push	dx
	  mov	ax,dir_rows
	  push	cx
	  mov	cx,FIELD_SIZE
	  mul	cx
	  pop	cx
	  add	cx,ax
	  pop	dx
	  pop	ax
       CMP     BX,cx				; directory listing.
       JA      _SC2
;       jg      _sc2
;       MOV     CUR_OFFSET,OFFSET DIR_BUFF
       push    ax
       mov     ax,dbs_start
       mov     cur_offset,ax
       pop     ax
       JMP     SHORT _SC_RET

 _SC2:
	  push	dx
	  mov	ax,dir_rows
	  mov	cx,FIELD_SIZE
	  mul	cx
	  pop	dx
 	  SUB     BX,AX
       CMP     SI,BX
       JBE     _SC3
;       jle     _sc3
       MOV     SI,BX

 _SC3: MOV     CUR_OFFSET,SI           ;Update current offset.
 _SC_RET:
	 PUSH	SI
	 PUSH	DI
	 PUSH	BP
	 CMP		LINE_CNT_DISP,0
      JE       _SC_4
;      jl       _sc_4
	 CALL RETURN_ENTRY
 _SC_4:
	 POP		BP
	 POP		DI
	 POP		SI
      RET
 SCROLL        ENDP

 ;--------------------------------------------------
 ; This subroutine scrolls the bar if between start
 ; and end of page. Otherwise the page is scrolled.
 ; On entry : BP indicates signed number of lines to scroll
 ; Returns  : nothing
 ; Modifies : AX, CX, DX, SI, DI
 ;--------------------------------------------------
 SCROLL_BAR    PROC    NEAR
       MOV     SI,LINE                 ;Get current line.
       ADD     SI,BP                   ;Add requested line.
       MOV     BP,- FIELD_SIZE         ;Assume below beginning.
       CMP     SI,BAR_START            ;Is it?
       JB      _SCR1                   ;If yes, scroll page instead.
       MOV     BP,FIELD_SIZE           ;Do the same for end of page.
       CMP     SI,DIR_DISP_END
       JAE     _SCR1
       CALL    MOVE_BAR
       JMP     SHORT _SCR2
 _SCR1:        CALL    SCROLL
 _SCR2:        RET
 SCROLL_BAR    ENDP

 ;-------------------------------------------------------;
 ; This subroutine toggles the string filter function. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : nothing
 ;-------------------------------------------------------;
       ASSUME  DS:NOTHING,ES:NOTHING
 ASCII PROC    NEAR
       XOR     VIEW_FLAGS,ASCII_BIT            ;Toggle flag.
       RET
 ASCII ENDP

 ;-----------------------------------------------------;
 ; This subroutine toggles the non-ascii blanking filter on and off.;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : nothing
 ;-----------------------------------------------------;
       ASSUME  DS:NOTHING,ES:NOTHING
 BLANK PROC    NEAR
 ifdef BLANK_BIT
       XOR     VIEW_FLAGS,BLANK_BIT    ;Toggle flag.
 Endif
       RET
 BLANK ENDP

 ;--------------------------------------------------------;
 ; This subroutine toggles the WordStar filter on and off.;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : AX
 ;--------------------------------------------------------;
       ASSUME  DS:NOTHING,ES:NOTHING
 STAR  PROC    NEAR
       XOR     STAR_MASK,80H   ;Toggle flag.
       MOV     AL,' '
       JS      _ST1
       MOV     AL,'*'
 _ST1: MOV     OPTIONS,AL
       RET
 STAR  ENDP

 ;-------------------------------------------------------;
 ; This subroutine toggles the Word wrap function.     ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : nothing
 ;-------------------------------------------------------;
       ASSUME  DS:NOTHING,ES:NOTHING
 WRAP  PROC    NEAR
       XOR     VIEW_FLAGS,WRAP_BIT             ;Toggle flag.
       RET
 WRAP  ENDP

 ;-------------------------------------------------------;
 ; This subroutine spawns a DOS command interpretor.   ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : everything
 ;-------------------------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 DOS_SHELL     PROC    NEAR
	  MOV	DX,0000H
	  MOV	AL,ORIG_ATT
	  CALL	CLR_SCR
       CALL    CLR_DOS_WIN
	  MOV	DX,OFFSET SHELL_MSG
	  MOV	AH,09H
	  INT	DOSINT

       MOV     SI,OFFSET WORK_PATH     ;CD to appropriate directory
       CALL    CHANGE_PATH

       MOV     AX,3301H                ;Restore Control Break.
       MOV     DL,BREAK_STAT
       INT     DOSINT

       call    pre_exec
       MOV     STK_SEG,SS              ;save stack
       MOV     STK_PTR,SP
       MOV     DX,OFFSET PGM_NAME      ;exec command.com
       MOV     BX,OFFSET PAR_BLK
       MOV     AX,4B00H
       INT     DOSINT

 ;program will go away for awhile and return here on "exit"
       PUSH    CS
       POP     DS
       PUSH    CS
       POP     ES
       CLI                             ;no interrupts while fooling with stack
       MOV     SS,STK_SEG              ;restore stack
       MOV     SP,STK_PTR
       STI
                     ;interrupts OK now
       pushf


       call    post_exec
       popf

       JNC     _CD1                    ;jump if DOS exec successful
       CALL    BEEP                    ;beep to signal error

 _CD1: MOV     AX,3301H                ;Turn Control Break off again.
       MOV     DL,0
       INT     DOSINT

       MOV     DX,80H                  ;reset DTA area for find first
       MOV     AH,1AH
       INT     DOSINT
       CALL    REFRESH                 ;Redisplay directory
       RET
 DOS_SHELL     ENDP



;-----------------------------------------------------------------
; Change directory entry in form a.aaa to entry in form a       aaa
; properly padded with spaces
; On entry: SI points to original entry in buffer with space
;           sufficient to allow padding
; Returns: nothing
;------------------------------------------------------------------

 ASSUME	DS:_TEXT,ES:_TEXT
 DIR_FORMAT	PROC NEAR

	CLD                                ;make sure counting is forward
	MOV		DI,OFFSET FILE_NAME_BUFF ;copy filename to buffer
	MOV		CX,12
	REP		MOVSB

	MOV		DI,OFFSET TMP_BUFF       ;switch things around
	MOV		SI,OFFSET FILE_NAME_BUFF ;for modified copyback to TMP_BUFF
	MOV		CX,8

 DIR_F_1:
	MOVSB
	DEC		CX                       ;have 8 characters been copied?
	CMP		CX,0                     ;yes? If so, done with first part
	JE		DIR_F_2
	CMP		BYTE PTR [SI],"."        ;have we hit the period
	JNE		DIR_F_1                  ;no? continue with next character
 DIR_F_2:
	INC		SI                       ;skip over the period
	INC		CX
	MOV		AL,SPACE
	REP		STOSB                    ;and insert a space between the
								;filename and extension
	MOV		CX,3                     ;setup for the extension
 DIR_F_3:
	CMP		BYTE PTR [SI],SPACE      ;have we hit the end?
	JE		DIR_F_RET                ;yes? return
	CMP		CX,0                     ;have we copied three characters
	JE		DIR_F_RET                ;yes? return
	MOVSB                              ;otherwise, copy next character
	DEC		CX
	JMP		DIR_F_3
 DIR_F_RET:

	RET

 DIR_FORMAT ENDP


 SUBTTL Subroutines for changing working or destination directories
 page

 ;-----------------------------------------
 ; Change the current drive and default directory.
 ; On entry : DS:SI = ASCIIZ path name including optional drive
 ; Returns  : AX = error codes if carry set
 ;-----------------------------------------
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 CHANGE_PATH   PROC    NEAR
       CMP     BYTE PTR [SI],0 ;is there anything at all
       JZ      _C_D_DX
       CMP     WORD PTR [SI+1],':'     ;is there only a drive change?
       JZ      _C_D_D2         ;yes

 _C_D_D1:
       MOV     DX,SI           ; DS:DX =ASCIIZ path name, may include drive
       MOV     AH,3BH          ; Change the default directory.
       INT     DOSINT
       JC      CD_ERROR        ;error encountered, bypass drive change
;	  jmp	short _c_d_d3

 _C_D_D2:
       MOV     DX,[SI]
       CMP     DH,':'          ;is there a drive specification?
       JNZ     _C_D_D3         ;no - go exit

       AND     DL,1FH
       DEC     DL              ;convert drive letter to 0,1..
       MOV     AH,0EH          ; Change default drive to DL,  0=A, 1=B
       INT     DOSINT          ;returns number of drives in AL
       MOV     AH,19H          ;get default drive into AL, 0=A, 1=B
       INT     DOSINT          ;to test and
       CMP     AL,DL           ;see if it worked
       JNZ     CD_ERROR        ;failed drive change
 _C_D_D3:
       CLC
 _C_D_DX:
       RET
 CHANGE_PATH   ENDP

 ;--------------------------------------------------------;
 ; display "invalid directory" error message
 ; On entry : no known parameters
 ; Returns  : carry flag set
 ; Modifies : AX, CX, DX at least
 ;--------------------------------------------------------;
 CD_ERROR      PROC    NEAR
	  cmp	term_flag,1
	  jne	_cd_1
	  mov	dx,offset illegal_dir
	  mov	ah,9
	  int	21h
 ;	  call	delay
	  jmp	short _cd_ret
 _cd_1:
       MOV     SI,offset invalid            ;pointer to error message.
       MOV     AH,INTENSE              ;get display attribute
       OR      AH,80H                  ;make it blink
       MOV     DI,PROMPT_LOC
       CALL    PUT_STRATT
       CALL    DELAY
 _cd_ret:
       STC
       RET
 CD_ERROR      ENDP

 ;---------------------------------------------------------;
 ; This subroutine gets the current directory, precedes it with
 ; a \, and saves it at [DI]
 ; On entry : DI points to destination
 ; Returns  : nothing
 ; Modifies : AX, DX, DI, SI
 ;---------------------------------------------------------;
 GET_PATH      PROC    NEAR
       MOV     AH,19H          ;get default drive into AL, 0=A, 1=B
       INT     DOSINT
       ADD     AL,"A"                  ;Convert to ASCII.
       PUSH    AX
       STOSB
       MOV     AX,"\:"                 ;Add colon and slash.
       STOSW
       MOV     SI,DI                   ;now pointing to work_dir
       XOR     DL,DL
       MOV     AH,47H                  ;Retrieve default directory.
       INT     DOSINT

 IFDEF SAG
       CMP     SWITCH,'/'              ;Should we translate \ to / ?
       JE      _G_D4                   ;NO
       PUSH    DI                      ;save on stack
       DEC     DI                      ;point to first slash after volume
 _G_D1:        CMP     BYTE PTR [DI],0         ;End of String?
       JE      _G_D3                   ;yes
       CMP     BYTE PTR [DI],'\'       ;backsash?
       JNE     _G_D2                   ;no
       MOV     BYTE PTR [DI],'/'       ;turn it into a /
 _G_D2:        INC     DI                      ;loop
       JMP     SHORT _G_D1
 _G_D3:        POP     DI
 _G_D4:
 ENDIF

       POP     AX
       CALL    DISK_FREE               ; get disk free space

       RET
 GET_PATH      ENDP

 ;-----------------------------------------------------------;
 ; Subroutine prompts for user entry for changing directories
 ;  and then parses whatever the user enters
 ; On entry :  SI points to a prompt message
 ; Returns  :  SI pointing to new dir, AX=':' if only drive specified
 ;             carry flag set if not successful
 ; Modifies : assume everything
 ;-----------------------------------------------------------;
 ASK4PATH      PROC    NEAR
       MOV     DI,PROMPT_LOC
       CALL    PUT_STRING
       CALL    TO_DEST                 ;Ask user for destination.
       JC      _A4P_RET                ;If Esc pressed, exit.
       XOR     AL,AL
       STOSB                           ;end string with null
       MOV     SI,OFFSET ENTRY         ;get first 2nd and 3rd bytes
       MOV     AX,[SI+1]
       CMP     AX,':'                  ;is this the end?
       CLC
       JNZ     _A4P_RET                ;If no, we're done
       MOV     WORD PTR [SI+2],'.'     ;add a '.',0 to string to fool dos
 _A4P_RET:
       RET
 ASK4PATH      ENDP

 ;---------------------------------------------------------------;
 ; Subroutine to prompt for and then change the working directory
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : assume everything
 ;--------------------------------------------------------;
 CD_WORK       PROC    NEAR
       MOV     SI,OFFSET CD_MSG        ;Display prompt
       CALL    ASK4PATH
       JC      _CD_W_RET
     ;entry point for when we stuff a working directory (e.g. UPDIR)
  CD_WENTRY    PROC MEAR
       call    parse_file_filter
       MOV     BL,WORK_PATH            ;get old work drive:
       MOV     AX,[SI]                 ;check for drive spec
       CMP     AH,':'
       JNZ     _CD_W1                  ;no drive, change to old work
       AND     AL,5FH                  ;capitalize drive request
       CMP     AL,BL                   ;is new drive=old work drive?
       JNZ     NEW_WORK_DIR            ;no - just get new path
                                       ;drive has not changed, but
       CMP     AL,DEST_PATH            ;is drive same as current dest?
       JNE     NEW_WORK_DIR            ;no, different drives
                                       ;make sure we start from old work dir:
 _CD_W1:       PUSH    SI                      ;save the new path for work-dir
       MOV     SI,OFFSET WORK_PATH     ;get back last work path and disk
       CALL    CHANGE_PATH             ;restore old cur-dir on old work disk
       POP     SI                      ;get back new path and set new work dir

 ;---------------------------------------------------;
 ; routine to display a new working directory
 ; On entry : SI points to new dir
 ; Returns  : nothing
 ; Modifies : assume everything
 ;---------------------------------------------------;
 NEW_WORK_DIR  PROC    NEAR
       CALL    CHANGE_PATH             ;And change drive.
       CALL    READ_DIR                ; read dir and restart program
 _CD_W_RET:
       RET
 NEW_WORK_DIR  ENDP
 CD_WENTRY     ENDP
 CD_WORK       ENDP

 ;--------------------------------------------------------;
 ; Subroutine to prompt for and then change the default destination directory
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : assume everything
 ;--------------------------------------------------------;
 CD_DEST       PROC    NEAR
       MOV     SI,OFFSET CHDEST_MSG    ;Display prompt
       CALL    ASK4PATH
       JC      _CD_D_RET               ;escape out

       MOV     AX,[SI]
       CMP     AH,':'
       JNZ     _CD_D1
 ;if old destination drive = work drive, and this is a drive change
 ;then we must restore work_path on work_drive to keep things straight
       MOV     AH,DEST_PATH
       CMP     AH,AL                   ;is there a drive change?
       JZ      _CD_D1                  ;no, go on with dir change
       CMP     AH,WORK_PATH            ;was work a dir on orig dest drive?
       JNZ     _CD_D1                  ;no, go on
       MOV     DX,OFFSET WORK_PATH     ;restore work dir on work drive
       MOV     AH,3BH          ; Change the default directory.
       INT     DOSINT          ; DS:DX =ASCIIZ path name, may include drive

 _CD_D1:
 SET_DEST      PROC    NEAR
;       cmp     skip_dir_flag,1
;       je      _CD_D2
       CALL    CHANGE_PATH             ;And change drive.
 _CD_D2:
       CALL    UPD_DEST                ;update stored info
       MOV     AX,DEST_CLUSTER
       MOV     TARG_CLUSTER,AX
       CALL    COUNT_MARKS
       CALL    PUT_MENU_PATHS
 _CD_D_RET:
       RET
 SET_DEST      ENDP
 CD_DEST               ENDP


 ;--------------------------------------------------------;
 ; Subroutine to update stored info about the current destination dir
 ; On entry : DOS must be logged on to destination drive and dir
 ; Returns  : nothing
 ; Modifies : everything
 ;--------------------------------------------------------;

 UPD_DEST      PROC    NEAR
       MOV     DI,OFFSET DEST_PATH     ;Point to storage.
       CALL    GET_PATH                ;use DOS to store current dir at [DI]
       MOV     AL,DEST_PATH
       MOV     TARG_DISK,AL            ;set default target=destination disk
       RET
 UPD_DEST      ENDP

 ;--------------------------------------------------------;
 ; This subroutine swaps the default destination and
 ; working directories
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : AX, CX, SI, DI
 ;--------------------------------------------------------;
       ASSUME  CS:_TEXT, DS:_TEXT, ES:_TEXT
 SWAP_DIR      PROC    NEAR
       MOV     SI,OFFSET WORK_PATH
       MOV     DI,OFFSET DEST_PATH
       CLD
       MOV     CX,70
       REP     MOVSB
       CALL    READ_DIR
       RET
 SWAP_DIR      ENDP


 ;----------------------------------------------------;
 ; This subroutine checks whether function is to be applied to
 ; several marked files or just one file.  User is then prompted for
 ; a destination path which is read from the keyboard.
 ; On entry : SI points to a prompt message for requesting a destination
 ; Returns  : Carry set if current file is directory
 ; Modifies : CX, SI
 ;----------------------------------------------------;
 SETUP_DEST    PROC    NEAR
       PUSH    SI
       CALL    COUNT_MARKS
       JNZ     _CMC1                   ;If any marked, exit
       CALL    GET_NAME                ;Else get highlighted.

 _CMC1:        POP     SI
       JNC     ASK4DEST                ;is it an ok name(not dir)?
       CALL    BEEP                    ;no - signal error
       RET                             ;and return - else continue

 ;---------------------------------------------;
 ; This subroutine prompts the user for the     ;
 ; destination of highlighted or marked files. ;
 ; On entry : SI points to prompt to be displayed
 ; Returns  : nothing
 ; Modifies : AX, CX, SI, DI
 ;---------------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 ASK4DEST      PROC    NEAR
       MOV     DI,PROMPT_LOC
       CALL    PUT_STRING
       PUSH    DI
       CALL    GET_NAME                ;Get filename.
       POP     DI
       MOV     SI,FILE_NAME
       CMP     MARK_CNT,0              ;were there any marked files?
       JZ      _A4D1                   ;If yes, instead of filename
       MOV     SI,OFFSET MARKED_MSG    ; display "marked"

 _A4D1:        CALL    PUT_STRING

 TO_DEST       PROC    NEAR
       MOV     SI,OFFSET TO_MSG        ;Display "to..."
       CALL    PUT_STRING
       CALL    CLEAR_OLD               ;Remove last user entry.
                                       ;and set up cursor
 _T_D1:        CALL    READ_KEY                ;Get a keystroke.
       XOR     BH,BH                   ;set video page 0 for tty out
       CMP     AL,27                   ;Is it Esc?
       JZ      _T_D3                   ;If yes, abort.
       CMP     AL,13                   ;Is it carriage return?
       JZ      _T_D4                   ;If yes, execute.
       CMP     AL,8                    ;Is it backspace?
       JNZ     _T_D2                   ;If yes, backspace.

       CMP     DI,OFFSET ENTRY         ;At beginning of field?
       JZ      _T_D1                   ;If yes, skip.
       DEC     DI                      ;Else, decrement pointer.
       MOV     BYTE PTR [DI],0
       MOV     AX,0E08H                ;use BIOS TTY
       PUSH    AX
       INT     10H                     ;to backspace
       MOV     AX,0E00H + space        ;blank out char
       INT     10H
       POP     AX                      ;backspace again
       INT     10H
       JMP     SHORT _T_D1

 _T_D2:        CMP     AL,space                ;Is it above space?
       JBE     _T_D1                   ;If no, ignore.
       CMP     DI,OFFSET ENTRY + 32    ;Else, is 32 char entry field full?
       JZ      _T_D1                   ;If yes, ignore.
       STOSB                           ;Else, store the character.
       MOV     AH,0EH                  ;display using BIOS write tty
       INT     10H                     ;which also updates cursor
       JMP     SHORT _T_D1

 _T_D3:        CALL    DISP_COUNT_MSG
       STC
       RET

 _T_D4:        CLC
       RET
 TO_DEST               ENDP
 ASK4DEST      ENDP
 SETUP_DEST    ENDP


 SUBTTL Major support subroutines
 page
               ;***************************;
               ; MAJOR SUPPORT SUBROUTINES ;
               ;***************************;
 ;------------------------------------------------------------------------;
 ; This subroutine either copies moves or deletes
 ; a highlighted or marked file.
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : assume everything. SI points to filename field
 ;------------------------------------------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:NOTHING
 EXEC_MARKED   PROC    NEAR

 _XM05:
       CALL    CURSOR_OFF              ;Turn cursor off.
       TEST    FUNCTION,COPY_BIT       ;if a copy is involved
       JZ      _XM_2
       CALL    GET_BYTES_FREE          ;get space available on target
       JNC     _XM_1
       JMP     CD_ERROR

 _XM_1:
       CALL    GET_MEM
       JNC     _XM_2
       JMP     _XM_RET

 _XM_2:
	  test	function,rename_bit+delete_bit  ;don't want to check last target
									  ;if delete or rename
									  ;DF4 pass 4 (addresses reported problem)
	  jnz	_xm_2_2
	  CALL	CHK_FLOPPY_VER		    ;check floppy verify status and change

 _XM_2_2:							    ;if necessary
       CALL    COUNT_MARKS             ;update bytes marked
       JNZ     _XM_3                   ;If any marked files, go find them.
       CALL    PUT_AMARK               ;and mark it
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       MOV     BYTE PTR es:[SI],space     ;but don't let it show
       pop     es
       assume  es:_text
       JMP     SHORT _XM_5             ;And execute it one time.

 _XM_3:
	  PUSH	si             ;save current file
	  call	parse_entry	;returns carry set if not directory
       jnc     _XM_32
       cmp     MARK_CNT,1     ;added 4.60 pass 7.  Don't request
       ja      _XM_31         ;confirm if only 1 file marked
       clc
       jmp     short _XM_32
 _XM_31:
       stc
       call    no_dir_conf    ;pops up confirmation if carry set
 _XM_32:
       POP     si
	  jnc	_XM_35         ;carry clear -- go ahead
	  jmp	_XM_X          ;otherwise bail out
 _XM_35:
	  CALL	HOME_BAR          ;Home the highlight bar.

 _XM_4:
	  CMP	NO_DRAW_FLAG,1
	  JE		_XM_4_5
       CALL    REFRESH_DIR_DISP                ;Update the screen.
	  CALL	DISPLAY_ENTRY
 _XM_4_5:
 _XM_4_6:
       CALL    GET_NAME                ;Get the highlighted filename.
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BYTE PTR es:[SI],COPY_MARK ;Is it marked?
       pop     es
       assume  es:_text
       JZ      _XM_5                   ;If yes, execute command.
       CALL    DN_ARROW                ;Else, move down a row.
       JMP     SHORT _XM_4             ;And check it for a mark.

 _XM_5:        CALL    GET_NAME                ;test current file for hidden
       JNZ     _XM_6
       INC     MARK_CNT                ;fool marked file counters
       JMP     _XM_15                  ;If yes, skip.

 _XM_6:        CALL    GET_FSIZE               ;get file size
       MOV     SIZE_LOW,AX             ;to be sure it is stored
       MOV     SIZE_HIGH,DX            ;for future use
	  CMP	NO_DRAW_FLAG,1
	  JE		_XM_6_5
       CALL    DISP_COUNT              ;update counter displays
 _XM_6_5:
       TEST    FUNCTION,PROTECT_BIT+RENAME_BIT ;Is it a move or rename?
       JZ      _XM_11                  ;no, bypass "file exists" test

 ;check if target filename already exists.
       CALL    PARSE_ENTRY             ;Else, parse user entry.
       MOV     DX,BP                   ;BP points to filename entry
       TEST    FUNCTION,RENAME_BIT     ;simple rename ?
       JNZ     _XM_7                   ; yes, just use new filename
       MOV     DX,OFFSET TARGET        ;move rename-Point to target.
 _XM_7:        PUSH    DX                      ;save target
       MOV     CX,7                    ;Does the file exist?
       CALL    FIND_FIRST
       POP     DI                      ;get back target
       JC      _XM_8
       JMP     _XM_15                  ; skip since file already exists
 _XM_8:        TEST    FUNCTION,COPY_BIT       ;Is it across drives?
       JNZ     _XM_12                  ;Is yes copy/delete.
 ;file rename and/or move
       MOV     DX,OFFSET SOURCE
       PUSH    DI                      ;save target again
       MOV     AH,56H                  ;Else, rename it.
       INT     DOSINT
       POP     DX                      ;get back target
       JNC     _XM_9
       JMP     _XM_15                  ;Next one if failed.
 _XM_9:        TEST    FUNCTION,MOVE_BIT       ;is this a move?
       JZ     _XM_9A                  ;yes, remove it from list.
       jmp     _XM_14
 _XM_9A:
       MOV     CX,17H                  ;else assume rename
       CALL    FIND_FIRST              ;find target
       MOV     DI,CUR_FILE             ;Point to last entry.
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BYTE PTR es:[DI],COPY_MARK ;was it marked?
       pop     es
       assume  es:_text
       JNZ     _XM_10                  ;If yes,
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       MOV     BYTE PTR es:[DI],"*"       ; mark as done
       pop     es
       assume  es:_text
 _XM_10:       PUSH    DI
       INC     DI
       CALL    STORE_ENTRY             ;save new filename
       POP     DI
       DEC     COUNT                   ;correct total count since not new
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BYTE PTR es:[DI].D_SIZE,'<';directory?
       pop     es
       assume  es:_text
       JZ      _XM_16                  ;yes
       DEC     FILE_CNT                ;else correct file count
       JMP     SHORT _XM_16            ;next one

 _XM_11:       TEST    FUNCTION,COPY_BIT       ;Is it a copy request?
       JZ      _XM_13                  ;If no, check delete.
       CALL    PARSE_ENTRY             ;Else parse user entry.

 _XM_12:       CALL    READ_WRITE              ;Copy the file.
       JC      _XM_15                  ;If failed, skip rest.
       MOV     SI,CUR_FILE             ;Else, mark with asterisk
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       MOV     BYTE PTR es:[SI],"*"
       pop     es
       assume  es:_text

 _XM_13:       TEST    FUNCTION,DELETE_BIT     ;Is it a delete request?
       JZ      _XM_16                  ;If no, skip.
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BYTE PTR es:[SI].D_SIZE,"<"
       pop     es
       assume  es:_text
	  JNE	_XM_13_05			    ;if its a directory, we first have to go
 _XM_13_05:
       MOV     DX,OFFSET SOURCE        ;Else, delete the file.
       MOV     AH,41H
       INT     DOSINT
       JC      _XM_15
       MOV     AX,SIZE_LOW             ;decrement marked bytes
       MOV     DX,SIZE_HIGH
       MOV     CX,WORK_CLUSTER
       CALL    ROUND_UP
       ADD     AX,WORK_BYTES_FREE
       ADC     DX,WORK_BYTES_FREE+2
       MOV     BL,WORK_PATH
       CALL    UPD_FREE_COUNT
 ;     CMP     CL,DEST_PATH            ;is dest = work
 ;     JNZ     _XM_14
 ;     ADD     DEST_BYTES_FREE,AX      ;update dest disk values too
 ;     ADC     DEST_BYTES_FREE+2,DX    ;

 _XM_14:       CALL    REMOVE_FILE             ;If successful, remove from list.
       JMP     SHORT _XM_16

 _XM_15:       CALL    BEEP
       CALL    DN_ARROW                ;Go to next line.
       JMP     SHORT _XM_17
 ;MARK_CNT is used as a loop counter indicating files left to be processed
 ;Note that when there is a failure MARK_CNT no longer equals the
 ; count of marked files
 ;
 _XM_16: MOV   AX,SIZE_LOW             ;decrement marked bytes
       MOV     DX,SIZE_HIGH
       MOV     CX,TARG_CLUSTER
       CALL    ROUND_UP
       SUB     MARK_BYTES,AX
       SBB     MARK_BYTES+2,DX
 _XM_17:       DEC     MARK_CNT                ;update marked file counters
       CALL    CK_KEY                  ; Was a key struck while busy
       JNZ     _XM_18                  ; at our copy, move or delete task?
       CMP     MARK_CNT,0              ;If yes, abort, else all done?
       JLE     _XM_X                   ;If no, continue until done.
       JMP     _XM_4

 _XM_18:       CALL    READ_KEY                ;Clear the keyboard buffer,
       CALL    CK_KEY                  ; user entry and prompt.
       JNZ     _XM_18

 _XM_X:        TEST    FUNCTION,COPY_BIT       ;if a copy is involved
       JZ      _XM_RET
       CALL    RELEASE_MEM
 _XM_RET:
	  CMP	VERIFY_DEFAULT,'F'   ;is verify to change for floppy copies only?
	  JNE	_XM_RET2			 ;no? Exit routine
	  MOV	AH,2EH               ;Otherwise
	  MOV	AL,VERIFY_STAT_FL
	  XOR	DL,DL
	  INT	DOSINT			 ;return verify flag to prior state
 _XM_RET2:
       RET
 EXEC_MARKED   ENDP




;-----------------------------------------------------------------------
; Asks for confirmation before copying/moving files to a non-directory
; Returns carry set if don't want to go ahead; carry clear if you do
;----------------------------------------------------------------------

 NO_DIR_CONF	PROC NEAR

	  jnc	_NDC_YES
	  mov	di,prompt_loc
	  mov	si,offset nodir_copy
	  call	put_string
	  mov	di,prompt_loc2
	  call	put_string
;	  call	clear_old    ;this line was causing exec_marked indigestion -- take out
 _NDC_1:
	  call	read_key
	  cmp	ah,31h	;is it "N"
	  je		_ndc_no
	  cmp	ah,15h
	  jne	_ndc_1
 _ndc_yes:
	  clc
	  ret
 _ndc_no:
	  stc
	  ret

 NO_DIR_CONF	ENDP

;----------------------------------------------------------------------
;If verify default is to have verify on floppy only, this routine
;checks whether the target drive is a floppy.  If it is, it sets the verify
;state to on
;------------------------------------------------------------------------

 CHK_FLOPPY_VER	PROC NEAR

	  PUSH	DS
	  CMP	VERIFY_DEFAULT,'F'   ;is verify to change for floppy copies only?
	  JNE	_CFV_RET			 ;no? go ahead
	  MOV	DI,OFFSET TARG_DISK
	  MOV	DL,BYTE PTR [DI]
	  SUB	DL,40H			 ;convert target drive letter to number
	  MOV	AH,1Ch
	  INT	DOSINT
	  CMP	BYTE PTR ds:[BX],0F8H
	  JE		_CFV_RET			 ;it's a hard drive so make no changes
	  MOV	AH,54H
	  INT	DOSINT			 ;get current verify flag state
	  MOV	VERIFY_STAT_FL,AL

	  MOV	AX,2E01H
	  XOR	DL,DL
	  INT	DOSINT			 ;turn verify flag on

_CFV_RET:
	  POP	DS
	  RET
 CHK_FLOPPY_VER  ENDP


 ;----------------------------------------------------;
 ; This section does the reading and writing to disk. ;
 ; On entry : no known parameters
 ; Returns  : nothing
 ; Modifies : assume everything
 ; sets SI=source file handle, DI=target file handle
 ;----------------------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 READ_WRITE    PROC    NEAR
       CMP     N_SEGS,1
       JNC     _R_W1
       JMP     _R_W_ERR3

 _R_W1:        XOR     DI,DI                   ;set flag for dest handle
 ;get some information on the target filespec, if it exists
       MOV     DX,OFFSET TARGET        ;Point to target filename.
       MOV     CX,7
       CALL    FIND_FIRST              ;Get dir info
       JC      _R_W4
       MOV     SI,OFFSET DTA+F_ATTR
       MOV     AL,[SI]
       TEST    AL,1                    ;is it read only?
       JNZ     _R_W2                   ;go signal error

       XOR     AH,AH                   ;save target attribute
       PUSH    DI                      ;save dest handle/flag
       MOV     DI,OFFSET TMP_BUFF      ;point to some spare room
       MOV     CX,22
       REP     MOVSB                   ;save target info
       POP     DI                      ;get back dest flag
       MOV     CX,AX                   ;Get back attribute
       XOR     CX,1                    ;Flip read-only attribute.
       MOV     DX,OFFSET TARGET        ;Point to target filename.
       CALL    CHMOD                   ;change attribute
       JNC     _R_W3                   ;no error, proceed
 ;error returned when attempting CHMOD
 ;check to see if the error occured because target was a device, eg PRN
       MOV     AX,3D01H                ;open file for write
       INT     DOSINT
       JC      _R_W2                   ;failed
       XOR     BX,BX
       MOV     BL,AL                   ;get file handle from AL
       MOV     AX,4400H                ;get device info
       INT     DOSINT
       CALL    CLOSE_FILE
       AND     DX,80H                  ;is this a device?
       JNZ     _R_W4                   ;yes, ok to proceed
 _R_W2:        JMP     _R_W_ERR3               ;file failed CHMOD - signal error

 _R_W3:        MOV     DI,-1                   ;indicate that we have tweaked target
 ;get some info about the source file
 _R_W4:        MOV     DX,OFFSET SOURCE        ;Point to source filespec.
       MOV     CX,7
       CALL    FIND_FIRST              ;Get source
       JC      _R_W8
       MOV     SI,OFFSET DTA+F_ATTR
       LODSB
       XOR     AH,AH
       MOV     SOURCE_ATTRIB,AX        ; attribute

       CMP     DI,-1                   ;dir target exist?
       JNZ     _R_W6                   ;no - bypass 'same file' test
       TEST    AL,1                    ;is source read-only?
       MOV     AL,space                ;assume no
       JZ      _R_W5                   ;and skip
       MOV     AL,'R'                  ;else expect 'R' mark
 _R_W5:        MOV     BX,CUR_FILE             ;get pointer to buffer entry
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     AL,es:[BX].D_RO            ;and check with what we have now
       pop     es
       assume  es:_text
       JNZ     _R_W8                   ;oops - source and target are identical

 _R_W6:        LODSW                           ;finish saving source info
       MOV     SOURCE_TIME,AX          ; time
       LODSW
       MOV     SOURCE_DATE,AX          ; date
       LODSW                           ;get low size into AX
       MOV     SIZE_LOW,AX             ; and save
       LODSW                           ; and high size word
       MOV     SIZE_HIGH,AX            ;and save

 ;files different:
       XOR     AX,AX                   ;start with nothing
       XOR     DX,DX
       CMP     DI,-1                   ;did filespec exist on target?
       JNZ     _R_W7                   ;no, we won't be deleting it
       MOV     AX,WORD PTR TMP_BUFF+F_SIZE-F_ATTR ;get old size
       MOV     DX,WORD PTR TMP_BUFF+F_SIZE+2-F_ATTR
       MOV     CX,TARG_CLUSTER         ;target cluster size
       CALL    ROUND_UP                ;round up
 _R_W7:        ADD     AX,TARG_BYTES_FREE      ;add space already available on target
       ADC     DX,TARG_BYTES_FREE+2    ;to space that will be freed up
                                       ;by deleting old target file

       PUSH    DX                      ;save result
       PUSH    AX
       MOV     AX,SIZE_LOW             ;get source size.
       MOV     DX,SIZE_HIGH
       MOV     CX,TARG_CLUSTER         ;target cluster size
       CALL    ROUND_UP                ;round up
       POP     BX
       POP     CX
       SUB     BX,AX
       SBB     CX,DX
       JNB     _R_W9                   ;>0 enough space, go ahead
 _R_W8:        CALL    RESET_TARG_AT           ;negative, not enough room.
       JMP     _R_W_ERR3               ;set failed flag and exit

 _R_W9:        MOV     DX,OFFSET SOURCE        ;Point to source filespec.
       XOR     AL,AL                   ;Open file for reading.
       or      al,FULLACCESSPERMITTED
       CALL    OPEN_FILE
       JC      _R_W8                   ;flip target attr and exit

 ;     read in from source
 _R_W10:       MOV     SI,AX                   ;Save the handle.

 _R_W11:       MOV     BX,SI                   ;Retrieve read handle.

       MOV     SEG_COUNT,0             ;zero buffer counter
       MOV     AX,MEM_BUF_SEG          ;Point to 1st 64K buffer segment
       MOV     DS,AX
       ASSUME  DS:DUMMY_SEG

 _R_W12:       XOR     DX,DX
       MOV     CX,0FFFFH               ;Read up to 64K at a time.
       MOV     AH,3FH
       INT     DOSINT
       MOV     DX,DS                   ;save current buffer seg
       PUSH    CS
       POP     DS                      ;restore DS
       ASSUME  DS:_TEXT
       JNC     _R_W13
       JMP     _R_W_ERR                ;if error, close files

 _R_W13:       MOV     BP,AX                   ;Save bytes read.
       CMP     AX,CX                   ;if less than full buffer read,
       JNZ     _R_W14                  ; go close file
       MOV     AL,SEG_COUNT            ;get buffer counter
       INC     AL                      ;add 1 to count done
       CMP     AL,N_SEGS               ;are we at buffer limits?
       JZ      _R_W15                  ;yes, go write some
       MOV     SEG_COUNT,AL            ;one more
       ADD     DX,1000H                ;next 64k seg
       MOV     DS,DX                   ;set up DS
       JMP     _R_W12                  ;go read more

 _R_W14:       CALL    CLOSE_FILE              ;Close file
       XOR     SI,SI                   ;mark file closed
       JC      _R_W_ERR                ;If there was an error, exit.

 _R_W15:       OR      DI,DI                   ;has target been opened?
       JG      _R_W16
       CALL    RESET_TARG_AT           ;check/ restore target attr
       MOV     DX,OFFSET TARGET        ;Point to target filespec.
       XOR     CX,CX                   ;Create and truncate target file
       MOV     AH,3CH                  ; to zero.
       INT     DOSINT
       JC      _R_W_ERR
       MOV     DI,AX                   ;Save handle.

 _R_W16:       MOV     DX,MEM_BUF_SEG          ;Get pointer to buffer segment

 _R_W17:
       MOV     CX,0FFFFH
       CMP     SEG_COUNT,0
       JNZ     _R_W18
       MOV     CX,BP                   ;get back # bytes read earlier

 _R_W18:
       JCXZ    _R_W20                  ;If nothing to do, go close

;the push cx, pop ax sequence removed 4.61.
;believe this one was here in error for what I was trying to do

;       PUSH    CX                      ;save bytes to write
       MOV     DS,DX                   ;set up buffer segment
       ASSUME  DS:DUMMY_SEG

       XOR     DX,DX
       MOV     BX,DI                   ;Retrieve write handle.
       MOV     AH,40H
       INT     DOSINT                  ;Write the buffer to disk.
;       POP     AX                      ;get back bytes to write
       MOV     DX,DS                   ;save current buffer ptr
       PUSH    CS
       POP     DS
       ASSUME  DS:_TEXT

       JC      _R_W_ERR                ;abort if error in write
       CMP     AX,CX                   ;Did we write same number as read?
;       JNZ     _R_W_ERR                ;If we didn't, exit.
       JNZ     _R_W_ERASE              ;If we didn't, exit.
       DEC     SEG_COUNT               ;count off one buffer full
       JS      _R_W19                  ;done with this buffer read if <0
       ADD     DX,1000H                ;next 64k chunk
       JMP     _R_W17

 _R_W19:
       OR      SI,SI                   ;is source still open?
       JZ      _R_W20
       JMP     _R_W11                  ;If yes, there must be more.

 _R_W20:       MOV     BX,DI
       MOV     CX,SOURCE_TIME          ;Else, make time/date same
       MOV     DX,SOURCE_DATE          ; as source.
       MOV     AX,5701H
       INT     DOSINT

 _R_W21:       MOV     BX,DI
       CALL    CLOSE_FILE
       JMP     SHORT _R_W_RET

 _R_W_ERR:
       OR      SI,SI                   ;check is file open?
       JZ      _R_W_ERR1               ;bypass if zero
       MOV     BX,SI                   ;get read handle
       CALL    CLOSE_FILE              ;Close file

 _R_W_ERR1:
       OR      DI,DI                   ;check is file open?
       JG      _R_W_ERR2               ;file is open
       JZ      _R_W_ERR3               ;0 means all done
       CALL    RESET_TARG_AT           ;must be -1
       JMP     SHORT _R_W_ERR3
 _R_W_ERR2:
       MOV     BX,DI
       CALL    CLOSE_FILE
 _R_W_ERR3:
       STC
 _R_W_RET:
       PUSHF
       CALL    GET_BYTES_FREE          ;get space available on target
       POPF
       RET
 _R_W_ERASE:
       ;erase target file if only partially written
       OR      DI,DI                   ;check is file open?
       JZ      _RWE_10                 ;bypass if zero
       MOV     BX,DI                   ;get read handle
       CALL    CLOSE_FILE              ;Close file
 _rwe_10:
       mov     dx,offset target
       mov     ah,41h
       int     21h
       jmp     _r_w_err

 READ_WRITE    ENDP


 ;reset attribute on target
 RESET_TARG_AT PROC    NEAR
       CMP     DI,-1
       JNZ     _R_T_RET
       MOV     DX,OFFSET TARGET        ;Point to target filename.
       MOV     CL,TMP_BUFF             ;get original attribute
       XOR     CH,CH                   ;clear high byte
       CALL    CHMOD                   ;change attribute
       MOV     DI,0                    ;clear handle as a flag
 _R_T_RET:
       RET
 RESET_TARG_AT ENDP

 ;--------------------------------------------------------------------------;
 ; This subroutine gets the highlighted file and converts it to DOS format. ;
 ; On entry :  CUR_OFFSET points to a filname entry
 ;             DIR_OK_BIT is set in FUNCTION if function is allowed
 ;             on <DIR> entries.
 ; Returns  :  SI points to current file
 ;             Carry flag is set if function is prohibited on this entry
 ;             Zero flag set if entry is hidden but otherwise allowed
 ; updates  :  CUR_FILE, fills in SOURCE
 ; Modifies :  AX, CX, SI, DI
 ;--------------------------------------------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 GET_NAME      PROC    NEAR
       MOV     SI,CUR_OFFSET           ;Get top of page.
       MOV     AX,LINE                 ;Get location of bar.
       SUB     AX,BAR_START            ;Adjust.
       MOV     CL,ROW_LEN              ;Convert to byte pointer.
       DIV     CL
       MOV     CL,FIELD_SIZE
       MUL     CL
       ADD     SI,AX                   ;Add to current offset.
       MOV     CUR_FILE,SI             ;And save pointer.
       PUSH    SI
       INC     SI                      ;Bump past mark field.
       MOV     DI,FILE_NAME            ;Store the first eight characters.
       MOV     CX,8                    ;in SOURCE
       CALL    STORE_BYTES_DIR
       INC     SI
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BYTE PTR es:[SI],space     ;End of name?
       pop     es
       assume  es:_text
       JZ      _G_N_RET                ;If yes, done here.
       MOV     AL,"."                  ;Else, add dot.
       STOSB
       MOV     CX,3                    ;Three possible characters
       CALL    STORE_BYTES_DIR             ; as extension.

 _G_N_RET:
       MOV     BYTE PTR [DI],0         ;Convert to ASCIIZ.
       POP     SI                      ;get back record ptr
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BYTE PTR es:[SI].D_NAME,space      ;Is it an empty entry?
       pop     es
       assume  es:_text
       JZ      _G_N_ERROR              ;If yes, indicate so.

       TEST    FUNCTION,DIR_OK_BIT     ;are dir's allowed for this fn?
       JNZ     _G_N_HID                ;yes, dir's will be ok

       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BYTE PTR es:[SI].D_SIZE,"<"        ;Is it a directory?
       pop     es
       assume  es:_text
       JZ      _G_N_ERROR              ;If yes, indicate so.

 _G_N_HID:
       TEST    FUNCTION,HID_OK_BIT
       JNZ     _G_N_OK
       assume  es:nothing
       push    es
       mov     es,dir_buf_seg
       CMP     BYTE PTR es:[SI].D_HID,"H" ;Is it hidden?
       pop     es
       assume  es:_text
 _G_N_OK:
       CLC
       RET

 _G_N_ERROR:
       STC
       RET
 GET_NAME      ENDP




 ;-----------------------------------------------;
 ; This subroutine parses the user TARGET entry. ;
 ; On entry : no known parameters
 ; Returns  : carry set if not directory
 ;		  : clear otherwise
 ; Modifies : everything
 ;----------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 PARSE_ENTRY   PROC    NEAR
       MOV     BP,OFFSET TARGET        ;Point to target storage.
       MOV     DI,BP
       MOV     SI,OFFSET ENTRY         ;Point to user entry.
       CMP     BYTE PTR [SI],0         ;Anything entered?
       JNZ     _P_E1                   ;If yes, continue.
       JMP     _P_E17                  ;Else, store source name.

 _P_E1:        LODSB                           ;Move user entry into target
       STOSB                           ; workspace.
       CMP     AL,0
       JNZ     _P_E1
       STD                             ;Reverse string operation.
       DEC     DI                      ;Adjust pointer back one.
       MOV     SI,DI                   ;Make it the source pointer.
       MOV     FILENAME_END,DI         ;And store.

 _P_E2:        CMP     SI,OFFSET TARGET - 1    ;Are we at start of name?
       JZ      _P_E4                   ;If yes, done here.
       LODSB
       CMP     AL,"\"                  ;Else, is it a path delimiter?
       JZ      _P_E3                   ;If yes, mark start of filename.
       CMP     AL,"/"                  ;Alternative path delimiter?
       JZ      _P_E3                   ;If yes, mark start of filename.
       CMP     AL,":"                  ;Colon is also a path delimiter.
       JNZ     _P_E2

 _P_E3:        INC     SI                      ;Adjust pointer to end of path.
 _P_E4:        INC     SI
       MOV     BP,SI                   ;And store.
       CLD                             ;String back to forward.
       MOV     DI,OFFSET PSP_FCB       ;Use file control block for
       MOV     AX,2900H                ; workspace.
       INT     DOSINT                  ;Parse the entry for globals.
       CMP     AL,1                    ;Any wild cards?
       JNZ     _P_E15                  ;If no, check if it's a directory.

       MOV     SI,OFFSET PSP_FCB + 1   ;Else, point to first character.
       MOV     DI,BP                   ;Point to target storage.
       MOV     BX,FILE_NAME            ;Point to source.
       MOV     CX,8                    ;Eight characters.

 _P_E5:        LODSB
       CMP     AL,space                ;End of name?
       JZ      _P_E8                   ;If yes, do extension.
       CMP     AL,"?"                  ;Wild card?
       JNZ     _P_E6                   ;If no, store target character.
       MOV     AL,[BX]                 ;Else, replace with source char.
       CMP     AL,"."                  ;Unless end of name.
       JZ      _P_E8
       CMP     AL,0
       JZ      _P_E8

 _P_E6:        STOSB                           ;Store the character.
       CMP     BYTE PTR [BX],"."       ;Are we at end of source name?
       JZ      _P_E7                   ;If yes, don't move pointer.
       INC     BX                      ;Else, point to next source char.

 _P_E7:        LOOP    _P_E5

 _P_E8:        MOV     AL,"."                  ;Filename delimiter.
       STOSB                           ;Store it.

 _P_E9:        CMP     [BX],AL                 ;Was there a dot in source?
       JZ      _P_E10                  ;If yes do extension.
       CMP     BYTE PTR [BX],0         ;End of source name?
       JZ      _P_E11                  ;If yes, do extension.
       INC     BX                      ;Else, go to end of name.
       JMP     SHORT _P_E9

 _P_E10:       INC     BX                      ;Bump pointer past dot.
 _P_E11:       MOV     SI,OFFSET PSP_FCB + 9   ;Point to extension of parsed.
       MOV     CX,3                    ;Three characters.

 _P_E12:       LODSB
       CMP     AL,space                ;End of parsed?
       JZ      _P_E14                  ;If yes, done here.
       CMP     AL,"?"                  ;Wild card?
       JNZ     _P_E13                  ;If no, store user character.
       MOV     AL,[BX]                 ;Else, store source character.

 _P_E13:       STOSB
       INC     BX
       LOOP    _P_E12                  ;Do all three extension chars.

 _P_E14:       XOR     AL,AL                   ;Make it an ASCIIZ.
       STOSB
       JMP     SHORT _P_E_RET          ;Done here.

 _P_E15:       MOV     DI,BP                   ;Any characters after path
       CMP     BP,FILENAME_END         ; delimiter?
       JZ      _P_E17                  ;If no, tack on source name.
       MOV     DX,OFFSET ENTRY         ;Else, see if it's a directory.
       MOV     CX,10H
       CALL    FIND_FIRST
       JC      _P_E_NODIR                ;If not found, done here.
                                       ;DF 4.60 pass 7.  CMP->TEST
                                       ;was causing failures if other
                                       ;bits set
       test     DTA+F_ATTR,CL           ;If not directory, done here.
       JZ     _P_E_NODIR
       MOV     DI,FILENAME_END         ;Else, tack on source filename.
       MOV     AL,"\"

 IFDEF SAG
       CMP     SWITCH,"/"              ;do we really want "/"?
       JE      _P_E16                  ;no
       MOV     AL,"/"                  ;yes
 _P_E16:
 ENDIF

       STOSB
 _P_E17:       MOV     SI,FILE_NAME            ;Source filename.
       MOV     CX,14
       REP     MOVSB

 _P_E_RET:
	clc
	ret
 _P_E_NODIR:
	 stc
	 ret
 PARSE_ENTRY   ENDP

 ;------------------------------------------------------------------;
 ; This subroutine removes the filename from the directory listing. ;
 ;------------------------------------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 REMOVE_FILE   PROC    NEAR
       MOV     DI,CUR_FILE             ;Point to filename.
       MOV     SI,DI                   ;Move all the records

	  CALL	GET_FSIZE			    ;get file size
	  MOV	CX,WORK_CLUSTER
	  CALL	ROUND_UP
	  SUB	SUB_BYTES_COUNT,AX      ;decrement subdirectory total
	  SBB	SUB_BYTES_COUNT+2,DX

       ADD     SI,FIELD_SIZE           ; that follow up one.

 _R_F1:        MOV     CX,FIELD_SIZE
       assume  es:nothing, ds:nothing
       push    es
       push    ds
       mov     ax,dir_buf_seg
       mov     ds,ax
       mov     es,ax
       REP     MOVSB
       pop     ds
       pop     es
       assume  es:_text, ds:_text
       CMP     DI,END_OFFSET
       JB      _R_F1
       SUB     DI,FIELD_SIZE
       MOV     END_OFFSET,DI           ;Store new end.
       XOR     BP,BP
       CALL    SCROLL                  ;Update the screen.
       DEC     COUNT
	  CMP	DIR_CONF_FLAG,1         ;if a directory is removed, don't change file count
	  JE		_R_F_1_5
       DEC     FILE_CNT                ;Decrement file count.
 _R_F_1_5:
	  SUB	DI,FIELD_SIZE           ;changed DF 4.00 - we remove directories
							    ;in addition to just files, so we need to
							    ;check if scrolling will put us above the
							    ;beginning of the directory buffer.
							    ;If not, go ahead
;       CMP     DI,OFFSET DIR_BUFF
       cmp     di,dbs_start
       JB      _R_F_RET                ;If empty, exit.

 _R_F2:
	  mov	ax,dir_rows
	  CMP COUNT,ax			          ;Full page?
       JAE     _R_F_RET                ;If yes, skip.
       SUB     DIR_DISP_END,ROW_LEN    ;Else, adjust page end.
       MOV     SI,DIR_DISP_END
       SUB     SI,ROW_LEN
       CMP     SI,LINE                 ;Is bar below directory listing?
       JA      _R_F_RET                ;If no, skip.
       CALL    MOVE_BAR                ;Else, move bar up one line.
	 PUSH	SI
	 PUSH	DI
	 PUSH	BP
	  CALL	RETURN_ENTRY		    ;update ENTRY_COUNT
	 POP		BP
	 POP		DI
	 POP		SI
 _R_F_RET:
       RET
 REMOVE_FILE   ENDP

 SUBTTL Miscellaneous small support subroutines
 page
               ;***************************;
               ; OTHER SUPPORT SUBROUTINES ;
               ;***************************;

       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 ;-----------------------------------------------------------;
 ; This subroutine moves and turns the cursor on and removes ;
 ; the last user entry in preparation for new input.         ;
 ; On entry :  DX points to location for prompt
 ; Returns  :  DI pointing to ENTRY buffer for user input
 ;-----------------------------------------------------------;
 CLEAR_OLD     PROC    NEAR
       MOV     DX,ENTRY_CUR
       CALL    SET_CURSOR              ;Move cursor.
       MOV     DI,OFFSET ENTRY         ;Write nulls over old entry.
       PUSH    DI
       XOR     AX,AX
       MOV     CX,18
       REP     STOSW
       POP     DI                      ;return pointer for entry.
       RET
 CLEAR_OLD     ENDP


 ;----------------------------------------------------;
 ; This subroutine counts the number of marked files. ;
 ; On entry : no known parameters
 ; Returns  : CX = MARK_CNT, Z flag set if CX=0,
 ;            MARK_BYTES
 ;            Sets NO_DDIR_FLAG =1 if subdirs or hidden,R-O files present
 ; Modifies : CX, SI
 ;----------------------------------------------------;
 COUNT_MARKS   PROC    NEAR
	  MOV	NO_DDIR_FLAG,0
       OR      FUNCTION,UPD_CNT_BIT
       XOR     CX,CX                   ;Zero out counter.
       MOV     MARK_BYTES,CX
       MOV     MARK_BYTES+2,CX
       assume es:nothing
       push    es
       mov     es,dir_buf_seg
;       MOV     SI,OFFSET DIR_BUFF      ;Point to start of listing.
       mov     si,dbs_start

 _C_M1:        CMP     BYTE PTR es:[SI],COPY_MARK ;Is it marked?
       JNZ     _C_M2                   ;In no, skip.
       CMP     BYTE PTR es:[SI].D_HID,"H"  ;is entry hidden?
	  JNE	_C_M5
       CMP     BYTE PTR es:[SI].D_RO,"R"   ;is entry read-only?
	  JNE	_C_M5
	  MOV	NO_DDIR_FLAG,1
 _C_M5:
       INC     CX                      ;Else, increment counter.
       PUSH    CX
       CALL    GET_FSIZE
       MOV     CX,TARG_CLUSTER
       CALL    ROUND_UP
       ADD     MARK_BYTES,AX
       ADC     MARK_BYTES+2,DX
       POP     CX
 _C_M2:
	  CMP	NO_DDIR_FLAG,1			;if flag already set, continue
	  JE		_C_M4
       CMP     BYTE PTR es:[SI].D_HID,"H"  ;is entry hidden?
	  JE		_C_M3
       CMP     BYTE PTR es:[SI].D_RO,"R"   ;is entry read-only?
	  JE		_C_M3
       CMP     BYTE PTR es:[SI].D_SIZE,"<" ;is entry a directory?
	  JNE	_C_M4                   	;if not, continue on
       CMP     BYTE PTR es:[SI].D_NAME,"." ;make sure it's not the parent
	  JE		_C_M4
 _C_M3:
	  MOV	NO_DDIR_FLAG,1			;set flag
 _C_M4:
       ADD     SI,FIELD_SIZE           ;Next record.
       CMP     SI,END_OFFSET           ;Continue until done.
       JB      _C_M1
       MOV     MARK_CNT,CX             ;Store the count of marked files.
       OR      CX,CX
       pop     es
       assume  es:_TEXT
       RET
 COUNT_MARKS   ENDP

 ;-------------------------------------------------------------;
 ; This subroutine waits until a keystroke is pressed and then ;
 ; clears the message.  Keystroke is disgarded.
 ;-------------------------------------------------------------;
 ;DF 3.50: Delay procedure now doesn't display messages etc and just
 ; clears screen.  Doing the other screen stuff didn't seem to serve
 ; a useful function and cause a divide by zero error -- presumably because
 ; of some of the new display stuff -- when DELAY was invoked because of an
 ; invalid directory specified on the startup command line.  Probably a
 ; variable that wasn't initialized yet.  Was easier to fix this way.
 ;

 DELAY PROC    NEAR
       CALL    READ_KEY
       CALL    CLR_MSG
	  RET
 DELAY ENDP

 ;----------------------------------------------;
 ; This subroutine displays the count of files. ;
 ; On entry : WORK_BYTES_FREE, DEST_BYTES_FREE, MARK_BYTES, etc
 ; Returns  : upated display
 ; Modifies : everything
 ;----------------------------------------------;
 DISP_COUNT_MSG        PROC    NEAR
       CALL    CLR_MSG
 DISP_COUNT    PROC    NEAR
       MOV     DI,OFFSET FILES         ;message string storage
       MOV     SI,DI                   ;save it
       MOV     AX,FILE_CNT
       XOR     DX,DX
       MOV     CX,LENGTH FILES
       CALL    FORMAT

	  MOV	SI,OFFSET VOL_NAME
       MOV     DI,FILES_LOC            ;Row 24; column 6.
       MOV     AH,INTENSE
       CALL    PUT_STRATT

       MOV     DI,D_FREE_LOC
       MOV     SI,OFFSET DEST_FREE     ;Display free bytes on dest
       MOV     AH,INTENSE
       CALL    PUT_STRATT

	  CALL	RETURN_ENTRY

 ;----------------------------------------------------;
 ; This subroutine displays the byte count and number of marked files. ;
 ; On entry : MARK_BYTES and MARK_CNT contain numbers
 ; Returns  : nothing
 ; Modifies : everything
 ;----------------------------------------------------;

 DISP_MARKED   PROC    NEAR
       CMP     MARK_CNT,0
       JZ      _D_MR1
       MOV     AX,MARK_BYTES
       MOV     DX,MARK_BYTES+2
       MOV     CX,LENGTH BYTES_MRKD_MSG
       MOV     DI,OFFSET BYTES_MRKD_MSG
       MOV     SI,DI
       CALL    CFORMAT
;       CALL    FORMAT
       MOV     AX,MARK_CNT
       XOR     DX,DX
       MOV     CX,LENGTH FILES_MRKD_MSG
       MOV     DI,OFFSET FILES_MRKD_MSG
       CALL    FORMAT
       MOV     DI,MARKED_LOC
       CALL    PUT_STRING
       JMP     SHORT   _D_MR_RET

 _D_MR1:       MOV     AL,NORMAL
       MOV     CX,MARKED_WIN
       CALL    CLR_EOL

 _D_MR_RET:    RET
 DISP_MARKED   ENDP
 DISP_COUNT    ENDP
 DISP_COUNT_MSG        ENDP



 ;----------------------------------------------------;
 ; Subr. to convert ascii file size into binary
 ; On entry : SI points to mark field of a marked file
 ; Returns  : DX:AX = file size.
 ; Modifies : AX, BX, DX, BP, saves SI
 ;----------------------------------------------------;

 ;we shall assume SI points to filename
 GET_FSIZE     PROC    NEAR
       assume  es:nothing
       push    cx
       push    di
       PUSH    SI
       push    es
       mov     es,dir_buf_seg
       XOR     AX,AX
       XOR     DX,DX
       ADD     SI,D_SIZE
       CMP     BYTE PTR es:[SI],'<'
       JNZ      _GFS50A
       pop     es
       jmp     short _GFS_RET
 _GFS50A:
       mov     di,offset tmp_buff2
       dec     si                       ;to catch >100MB files
 _GFS100A:
      cmp      byte ptr es:[si],20h
      jne      _gfs200A
      inc      si
      jmp      _gfs100a
 _GFS200A:
      ;at beginning of size
      mov      al,byte ptr es:[si]
      cmp      al,20h
      je       _gfs300a
      mov      byte ptr [di],al
      inc      si
      inc      di
      jmp      _gfs200A
 _GFS300A:
      mov      byte ptr [di],20h
      mov      si,offset tmp_buff2
      mov      bl,10
       pop     es
       assume  es:_text
      call     dfasc_to_dword
;      xor      dx,dx
;      xor      ax,ax
 _GFS_RET:
       POP     SI
       pop     di
       pop     cx
       RET
 GET_FSIZE     ENDP

;==============================================================================
;FUNC:  ASC_TO_DWORD
;
;DESC:  Converts an ASCII string to a unsigned dword of given radix
;
;IN:    BL              radix from 2 to 36, not checked ("radix")
;       DS:SI           address of ASCIIZ string ("instr")
;
;OUT:   JA (RESERVED)
;       JE if successful
;         DX;AX         unsigned dword converted from "instr"
;         (DS:)SI       address of first character in "instr" which could not
;                         be converted
;       JB if no digits encountered (underflow)
;         DX;AX         zero
;
;==============================================================================

dfasc_to_dword  proc near
                push    bx cx bp
                xor     bh,bh           ;zero high byte of radix
                xor     cl,cl           ;initialize exit condition indicator
                xor     dx,dx           ;initialize high byte of dword
                xor     bp,bp           ;initialize exchange register for AX
a_to_dw_020:    lodsb                   ;get a character from ASCII string
                xor     ah,ah           ;zero high byte of read digit
                cmp     al,"0"          ;below ASCII digits?
                 jb     a_to_dw_800     ;  y: end
                cmp     al,"9"          ;is it an ASCII digit?
                 jna    a_to_dw_030     ;  y: convert for ASCII digits
                cmp     al,"A"          ;below uppercase alpha?
                 jb     a_to_dw_800     ;  y: end
                and     al,0DFh         ;convert to uppercase alpha
                sub     al,7            ;adjust alpha to digit
a_to_dw_030:    sub     al,"0"          ;convert digit to byte value
                cmp     bl,al           ;is radix greater than byte value?
                 jna    a_to_dw_800     ;  n: end
                xchg    ax,bp           ;setup accumulated value for multiply
                .mul_dw bx              ;multiply accumulated value by radix
                .add_dw dx,bp,ax        ;add digit and accumulated value
                mov     cl,1            ;indcate if any digits converted
                jmp     a_to_dw_020     ;get next character from ASCII string

a_to_dw_800:    dec     si              ;point SI at 1st digit not converted
                cmp     cl,1            ;set return condition
                xchg    ax,bp           ;put accumulated dword value in AX;DX
                pop     bp cx bx
                ret
dfasc_to_dword endp


 ;----------------------------------------------------;
 ; This subroutine performs a table lookup
 ; On entry :  AL contains a byte
 ;             DI points to a lookup table of length CX
 ;             BX points to last entry of a result table
 ; Returns  :  BX points to the matching entry in the result table
 ;             NZ implies no match found
 ; Modifies : BX, CX,  DI
 ;----------------------------------------------------;
 LOOKUP        PROC    NEAR
       REPNZ   SCASB           ;scan table
       PUSHF                   ;save flags
       JNZ     _LK_RET         ;not found
       SHL     CX,1            ;multiply by two bytes per word
       SUB     BX,CX           ;this many bytes from end
 _LK_RET:      POPF                    ;restore flags
       RET
 LOOKUP        ENDP

 ;----------------------------------------------------;
 ; This subroutine performs a table lookup for a sort option
 ; Sorts are done on a field starting at SORT_OFFSET with a
 ; field length of SORT_LEN
 ; On entry :  AL contains a byte to check
 ;             DI points to a lookup table of length SORT_OPT_CNT
 ; Modifies : AX, BX, CX,  DI
 ;----------------------------------------------------;
 SET_SORT      PROC    NEAR
       MOV     CX,SORT_OPT_CNT
       MOV     BX,OFFSET SORT_TABLE_END
       CALL    LOOKUP
       JNZ     _S_S_RET
       MOV     AX,[BX]
       MOV     BYTE PTR SORT_OFFSET,AL
       MOV     BYTE PTR SORT_LEN,AH

       MOV     AX,OFFSET SORT_TABLE_END ;store index of selected sort
       push    ax
       MOV     CX,SORT_OPT_CNT-1
       shl     cx,1
       SUB     AX,BX
       SUB     CX,AX
       MOV     SORT_INDEX,CX  ;name = 0; ext =2, etc.
       pop     ax
 _S_S_RET:
       RET
 SET_SORT      ENDP

 ;--------------------------------------------------------;
 ; This procedure does a string move, skipping over spaces
 ; On entry : SI, DI set up for move
 ; Returns  : nothing
 ; Modifies : AL, CX, SI, DI
 ;---------------------------------------------------------;
 STORE_BYTES   PROC    NEAR
       LODSB                           ;Get a character.
       CMP     AL,space                ;If it's space, skip.
       JZ      _S_B1
       STOSB
 _S_B1:        LOOP    STORE_BYTES
       RET
 STORE_BYTES   ENDP

 ;--------------------------------------------------------;
 ; This procedure does a string move, skipping over spaces
 ; MOVES FROM DIR_BUF_SEG (i.e. ds set to this segment)
 ; On entry : SI, DI set up for move
 ; Returns  : nothing
 ; Modifies : AL, CX, SI, DI
 ;---------------------------------------------------------;
     ASSUME DS:NOTHING, ES:_TEXT
 STORE_BYTES_DIR   PROC    NEAR
       push    ds
 _SBD_A:
       push    ax
       mov     ax,dir_buf_seg
       mov     ds,ax
       pop     ax
       LODSB                           ;Get a character.
       CMP     AL,space                ;If it's space, skip.
       JZ      _SBD_B
       STOSB
_SBD_B:        LOOP    _SBD_A
       pop     ds
       RET
 STORE_BYTES_DIR   ENDP

 ;---------------------------------------------------
 ; These subroutines converts a hex number to decimal.
 ; FORMAT clears field first
 ;---------------------------------------------------
 ; On entry : DX:AX=number to convert
 ;          CX = length of field to be cleared first
 ;          DI= start of destination field
 ; Returns  : DI points to beginning of converted string
 ; Modifies : AX, BX, CX, DX, DI
 ;---------------------------------------------------;
       ASSUME  DS:NOTHING,ES:NOTHING
 FORMAT        PROC    NEAR
       PUSH    AX
       MOV     AL,space
       DEC     CX
       REPNZ   STOSB
       POP     AX

 ;---------------------------------------------------;
 ; On entry : DX:AX=number to convert,
 ;          DI= end of destination
 ;---------------------------------------------------;
 TRANSLATE     PROC    NEAR
       XCHG    AX,DX
       MOV     BX,10                   ;Convert to decimal.
       STD                             ;Reverse direction.

 _TR1: MOV     CX,DX
       XOR     DX,DX
       DIV     BX
       XCHG    AX,CX
       DIV     BX
       XCHG    AX,DX
       ADD     AL,"0"                  ;Convert to ASCII.
       STOSB                           ;Store the remainder.
       MOV     AX,CX
       OR      CX,DX
       JNZ     _TR1
       CLD                             ;Back to forward direction.

       RET
 TRANSLATE     ENDP
 FORMAT                ENDP

;--------------------------------------------------------------------
; Just like Format, but adds commas
;--------------------------------------------------------------------
       ASSUME  DS:NOTHING,ES:NOTHING
 CFORMAT        PROC    NEAR
       PUSH    AX
       MOV     AL,space
       DEC     CX
       REPNZ   STOSB
       POP     AX

       mov     bx,di
       push    bx
       call    translate

       pop     bx
       push    si
       mov     si,bx
       push    di
       call    nstr_to_com   ; convert to commas
       pop     di
       pop     si

       ret
cformat  endp

 ;------------------------------------------;
 ; This subroutine rounds a number up
 ; On entry :  DX:AX = number to convert
 ;             CX = number base
 ; Returns  :  DX:AX with CX unchanged
 ;------------------------------------------;
 ROUND_UP      PROC    NEAR

;       jmp     _r_u_old
       push    cx bx
       mov     bx,cx
       call    div_dw                  ;divide by cluster size
       OR      CX,CX                   ;check for remainder
       JZ      _R_U10                  ;nothing extra?
       INC     AX                      ;add one for remainder
 _R_U10:
       .MUL_DW BX,CX                   ;and go back to original units
       pop     bx cx
       RET

 _r_u_old:
       DIV     CX                      ;divide by base
       OR      DX,DX                   ;check for remainder
       JZ      _R_U1                   ;nothing extra?
       INC     AX                      ;add one for remainder
 _R_U1:        MUL     CX                      ;and go back to original units
       RET

 ROUND_UP      ENDP

 ;-------------------------------------------------;
 ; This routine formats a byte to ASCII decimal
 ; and stores it at ES:DI, followed by delimiter CL
 ; On entry :  AX = number (<100) to convert
 ;             CH = trailing delimiter char
 ;             CL not 0 to supress leading zero
 ; Returns  : nothing
 ; Modifies : assume everything
 ;-------------------------------------------------;
     assume es:nothing
 STORE_DIGITS  PROC    NEAR
       push    es
       mov     es,dir_buf_seg
       MOV     BL,10
       DIV     BL                      ;Divide by ten.
       ADD     AX,"00"                 ;Convert to ASCII.
       OR      CL,CL                   ;Are we to display leading zero?
       JZ      _ST_D1                  ;If yes, store as is.
       CMP     AL,"0"                  ;Is it a leading zero?
       JNZ     _ST_D1                  ;If no, store it.
       MOV     AL,space                ;Else, store a space.

 _ST_D1:       STOSW
       MOV     AL,CH                   ;Store delimiter character also.
       STOSB
       pop     es
       RET
 STORE_DIGITS  ENDP

;--------------------------------------------------------------------------
;Converts a string of numbers to a number with commas
;SI points to the end of the numeric string.  Number is padded to the left
;as required to fill the space.  It is assumed that there is enough
;--------------------------------------------------------------------------

 NSTR_TO_COM   PROC NEAR

       std
       mov di,offset tmp_buff2  ;using tmp_buff was corrupting the storage
                                ;used to restore the initial directory
                                ;when changing to a subdirectory
                                ;fixed df450 pass 2 to tmp_buff2
       mov     al,','
       xor     cx,cx
       xor     dx,dx
 _ntc_100:
       inc     cx
       cmp     byte ptr [si],space
       je      _ntc_ret
       cmp     cx,4
       je      _ntc_200
       cmp     cx,8
       je      _ntc_200
       movsb
       jmp     _ntc_100
 _ntc_200:
       stosb
       inc     dx
       jmp     _ntc_100
 _ntc_ret:
       cld
       inc     si
       inc     di
       dec     cx
       xchg    si,di
       sub     di,dx
       rep     movsb
       cld
       mov     di,offset tmp_buff2   ; cleanup tmp_buff
       mov     al,space             ; not doing so seemed to cause a problem
                                    ; the next time search was called.
       mov     cx,79
       rep     stosb
       ret
 NSTR_TO_COM   ENDP

 SUBTTL Screen display subroutines
 page
 ;----------------------------------------------------------------------------;
 ; This subroutine displays the current directory, menu, and number of files. ;
 ;----------------------------------------------------------------------------;

       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 PUT_MENU_PATHS        PROC    NEAR
       MOV     AL,NORMAL
       CALL    CLR_SCR
       CALL    DISPLAY_MENU

       MOV     AH,INTENSE
       MOV     DI,DIRECT_LOC
       MOV     SI,OFFSET DIRECTORY     ;Display "Directory of".
       CALL    PUT_STRATT
       MOV     SI,OFFSET WORK_PATH     ;Display working directory.
       CALL    PUT_STRATT
	  mov	bl,byte ptr [si-2]      ;loads last path character

	  mov	si,offset file_mask    ;display mask with preceeding \
	  call	is_star_dot_star	    ;checks to see if file_mask is
							    ; a *.*.  If it is, we don't print the mask
	  jc		_PMP_2			    ;they match
	  cmp	bl,'\'			    ;don't add another \ if have a F:\ type line
	  je		_PMP_1
	  dec	si
 _PMP_1:
	  call	put_stratt

 _PMP_2:
       MOV     DI,DEST_LOC
       MOV     SI,OFFSET DEST_MSG      ;Display destination msg
       CALL    PUT_STRATT
       MOV     SI,OFFSET DEST_PATH     ;Display dest directory.
       CALL    PUT_STRATT
	  MOV	DI,SUBDIR_LOC
	  MOV	SI,OFFSET SUBDIR_MSG
	  CALL	PUT_STRATT

       MOV     AL,INVERSE
       CALL    BAR                     ;Put up cursor bar.
       MOV     FUNCTION,UPD_CNT_BIT    ;force update of count displays
       RET
 PUT_MENU_PATHS        ENDP

;---------------------------------------------------------------------------
; Determines if the file_mask location contains *.*.  If it does, it
; returns the carry flag set.  If not clear.
;---------------------------------------------------------------------------
 IS_STAR_DOT_STAR PROC NEAR

	push		si
	mov		si,offset file_mask
	cmp		byte ptr [si],'*'
	jne		_ISDS_NO
	cmp		byte ptr [si+1],'.'
	jne		_ISDS_NO
	cmp		byte ptr [si+2],'*'
	jne		_ISDS_NO
	pop		si
	stc
	ret
 _ISDS_NO:
	pop		si
	clc
	ret

 IS_STAR_DOT_STAR ENDP




;---------------------------------------------------------------------
	ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT
 DISPLAY_MENU	PROC NEAR

       MOV     AL,NORMAL

       MOV     DI,MENU_STRT            ;And to screen position.
       MOV     AL,GB_TL                ;top left
       MOV     BX,GB_TR + GB_TH*100h   ;middle and right characters
       CALL    PUT_MENU_BORDER
       MOV     SI,OFFSET LOGO          ;Point to menu position.
       MOV     BL,LOGO_ROWS
	  mov	bh,c_menu2_attr
       CALL    PUT_MENU_LINES

       MOV     AL,GB_L_TEE                     ;mid- left
       MOV     BX,GB_R_TEE + GB_MH*100h        ;middle and right characters
       CALL    PUT_MENU_BORDER

       MOV     CX,MENU_STATUS
       CMP     CX,0
       JNE     MENU_ALT
       MOV     SI,OFFSET MENU1
       JMP     MENU_CONTINUE
MENU_ALT:
       CMP     CX,1
       JNE     MENU_CTRL
       MOV     SI,OFFSET ALT_MENU
       JMP     MENU_CONTINUE
MENU_CTRL:
	  cmp	cx,2
	  jne	menu_rshift
       MOV     SI,OFFSET CTRL_MENU
       JMP     MENU_CONTINUE
MENU_RSHIFT:
	mov		si,offset rshift_menu

MENU_CONTINUE:
       MOV     BL,MENU1_ROWS
	  mov	bh,c_menu_att
;       cmp     cx,0           ;lines commented out 4.50.  Main menu changed
;       je      _mc_1          ;accommodate F11 and F12 keys
        dec     bl
        dec     bl
        call    put_menu_lines
        mov     bl,2
;        jmp     short _mc_2
_mc_1:
;       sub     bl,4
;       call    put_menu_lines
;       mov     bl,4
_mc_2:
	  mov	bh,c_menu2_attr
       CALL    PUT_MENU_LINES

       MOV     AL,GB_BL                ;bottom left
       MOV     BX,GB_BR + GB_BH*100h   ;middle and right characters
       CALL    PUT_MENU_BORDER
       RET

DISPLAY_MENU	ENDP

;------------------------------------------------------------;
 ; This subroutine is used to display a border line on menu
 ; On entry :  AL = left border edge char to display
 ;             AH = display attribute to use
 ;             BH = char to repeat in middle
 ;             BL = right border edge character
 ;             DI = where to put char in display
 ; Returns  :  DI points to location of start of next line
 ; Modifies :  DI, uses and preserves ES
 ;------------------------------------------------------------;
 PUT_MENU_BORDER       PROC    NEAR
       MOV     AH,BORDER
       CALL    PUT_CHARATT
       MOV     AL,BH

       MOV     CX,MENU_WIDTH
 _PMB1:        CALL    PUT_CHARATT
       LOOP    _PMB1

       MOV     AL,BL
       CALL    PUT_CHARATT
       ADD     DI,ROW_LEN-2*(MENU_WIDTH+2)             ;Next line.
       RET
 PUT_MENU_BORDER       ENDP

 ;------------------------------------------------------------;
 ; This subroutine is used to display a set of menu lines
 ; On entry :  BL = number of lines to display
 ;             SI points to lines to display after border
 ;             DI = where to put chars in display
 ;			BH = menu attribute to use
 ; Returns  :  DI points to location of start of next line
 ; Modifies :  DI, uses and preserves ES
 ;------------------------------------------------------------;
 PUT_MENU_LINES        PROC    NEAR
       MOV     AH,BORDER
       MOV     AL,GB_V
       CALL    PUT_CHARATT

       MOV     AH,bh
       MOV     CX,MENU_WIDTH
 _PML1:        LODSB
       CALL    PUT_CHARATT
       LOOP    _PML1

       MOV     AH,BORDER
       MOV     AL,GB_V
       CALL    PUT_CHARATT

       ADD     DI,ROW_LEN-2*(MENU_WIDTH+2)             ;Next line.
       DEC     BL
       JNZ     PUT_MENU_LINES
       RET
 PUT_MENU_LINES        ENDP

 ;-------------------------------------------------;
 ; This subroutine displays the directory listing. ;
 ;-------------------------------------------------;
       ASSUME  CS:_TEXT,DS:_TEXT,ES:_TEXT
 REFRESH_DIR_DISP      PROC    NEAR
       MOV     SI,CUR_OFFSET           ;Retrieve starting offset.
       MOV     DI,0 CROW ROW1          ;Point to row two of screen.
	  mov	cx,dir_rows
	  mov	bh,cl
 _R_DD1:
       assume    ds:nothing
       push    ds
       mov     ax,dir_buf_seg
       mov     ds,ax
       MOV     CX,FIELD_SIZE           ;44 characters per line.
       CALL    PUT_CX_CHARS                    ;Write them.
       pop     ds
       assume  ds:_text
       ADD     DI,ROW_LEN - FIELD_SIZE * 2     ;Bump pointer to next line.
       DEC     BH                      ;Do all lines.
       JNZ     _R_DD1
       RET
 REFRESH_DIR_DISP      ENDP

 ;------------------------------------------------------------;
 ; This subroutine displays a character by writing directly   ;
 ; to the screen buffer.  To avoid screen noise (snow) on the ;
 ; color card, the horizontal retrace has to be monitored.    ;
 ; On entry :  AL = char to display
 ;             DI = where to put char in display
 ; Returns  :  DI points to next location
 ; Modifies :  DI, uses and preserves ES
 ;------------------------------------------------------------;
       ASSUME  DS:NOTHING,ES:NOTHING
 PUT_CHAR      PROC    NEAR
       PUSH    ES                      ;save seg register
       PUSH    DX
       MOV     ES,VIDEO_SEG            ;Point to screen segment.
       MOV     DX,STATUS_REG           ;Retrieve status register.
       CALL    PUT_BYTE
       INC     DI                      ;Bump pointer past attribute.
       POP     DX
       POP     ES                      ;restore segment register
       RET                             ;Return
 PUT_CHAR      ENDP

 ;------------------------------------------------------------;
 ; This subroutine displays a character and attribute
 ; On entry :  AL = char to display
 ;             AH = display attribute to use
 ;             DI = where to put char in display
 ; Returns  :  DI points to next location
 ; Modifies :  DI, uses and preserves ES
 ;------------------------------------------------------------;
 PUT_CHARATT   PROC    NEAR
       PUSH    ES                      ;save seg register
       PUSH    DX
       PUSH    AX
       MOV     ES,VIDEO_SEG            ;Point to screen segment.
       MOV     DX,STATUS_REG           ;Retrieve status register.
       CALL    PUT_BYTE                ;put char
       MOV     AL,AH
       CALL    PUT_BYTE                ;put attribute
       POP     AX
       POP     DX
       POP     ES                      ;restore segment register
       RET                             ;Return
 PUT_CHARATT   ENDP


 PUT_BYTE      PROC    NEAR
       OR      DX,DX                   ;zero if mono or ega
       JZ      _P_B3                   ;don't wait if mono

       PUSH    AX
 _P_B1:        IN      AL,DX                   ;Get status.
       TEST    AL,8                    ;Is vertical in retrace?
       JNZ     _P_B2A                  ;If yes, lets go
       TEST    AL,1                    ;Is it low?
       JNZ     _P_B1                   ;If not, wait until it is.

 _P_B2:        IN      AL,DX                   ;Get status.
       TEST    AL,1                    ;Is it high?
       JZ      _P_B2                   ;If no, wait until it is.
 _P_B2A:       POP     AX

 _P_B3:        STOSB                           ; to write to screen buffer.
       RET
 PUT_BYTE      ENDP


 ;---------------------------------------------------------------;
 ; This subroutine writes null terminated string to Videoseg [DI]
 ; On entry :  DS:SI points to string of length CX
 ;             DI points to a location in the video memory
 ; Returns  :  nothing
 ; Modifies :  AX, SI, DI, uses but preserves ES
 ;---------------------------------------------------------------;
 PUT_STRING    PROC    NEAR
       LODSB
       OR      AL,AL
       JZ      _PST_RET
       CALL    PUT_CHAR
       JMP     PUT_STRING
 _PST_RET:
       RET                             ;Return
 PUT_STRING    ENDP

 PUT_STRATT    PROC    NEAR            ;attribute in AH
       LODSB
       OR      AL,AL
       JZ      _PSA_RET
       CALL    PUT_CHARATT
       JMP     PUT_STRATT
 _PSA_RET:
       RET                             ;Return
 PUT_STRATT    ENDP

 ;---------------------------------------------------------------;
 ; This subroutine writes a string to Videoseg [DI]
 ; Writes up to first null character or CX characters.
 ; On entry :  DS:SI points to string with max length CX
 ;             DI points to a location in the video memory
 ; Returns  :  nothing
 ; Modifies :  AX, CX, SI, DI, uses but preserves ES
 ;---------------------------------------------------------------;
 ifdef SMALL
 PUT_CX_CHARS  PROC    NEAR            ;use current attribute

       PUSH    ES                      ;save seg register
       PUSH    DX
       MOV     ES,VIDEO_SEG            ;Point to screen segment.
       MOV     DX,STATUS_REG           ;Retrieve status register.

 _PCXC1:       LODSB                           ;get character
       CALL    PUT_BYTE
       INC     DI                      ;Bump pointer past attribute.
       LOOP    _PCXC1

       POP     DX
       POP     ES                      ;restore segment register
       RET
 PUT_CX_CHARS  ENDP

 else

 ; Faster but bulkier display of CX chars:
 PUT_CX_CHARS  PROC    NEAR            ;use current attribute

       PUSH    ES                      ;save seg register
       PUSH    DX
       MOV     ES,VIDEO_SEG            ;Point to screen segment.
       MOV     DX,STATUS_REG           ;Retrieve status register.
       OR      DX,DX
       JZ      _PCXC3

 _PCXC1:       IN      AL,DX                   ;Get status.
       TEST    AL,8                    ;Is vertical in retrace?
       JNZ     _PCXC3                  ;If yes, lets go
       TEST    AL,1                    ;Is it low?
       JNZ     _PCXC1                  ;If not, wait until it is.

 _PCXC2:       IN      AL,DX                   ;Get status.
       TEST    AL,1                    ;Is it high?
       JZ      _PCXC2                  ;If no, wait until it is.
       MOVSB
       INC     DI
       LOOP    _PCXC1
       JMP     SHORT   _PCXC_RET

 _PCXC3:       MOVSB
       INC     DI
       LOOP    _PCXC3

 _PCXC_RET:
       POP     DX
       POP     ES                      ;restore segment register
       RET
 PUT_CX_CHARS  ENDP
 endif

 ;     ********************************
 ;     *  BIOS SCREEN WRITING ROUTINES
 ;     ********************************
 ;-----------------------------------------------------------------------;
 ; These subroutines clear either the messages or the entire screen. ;
 ;-----------------------------------------------------------------------;
               ASSUME  DS:_TEXT,ES:_TEXT

 CLR_MSG       PROC    NEAR
       MOV     AL,NORMAL
       MOV     CX,BEG_WINDOW           ;Row 24; column 43.
       JMP     SHORT CLR_EOS

 CLR_EOL       PROC    NEAR
       MOV     DH,CH
       MOV     DL,79
       JMP     SHORT   CLR_WINDOW

 CLR_SCR       PROC    NEAR
       XOR     CX,CX

 CLR_EOS       PROC    NEAR
       MOV     DX,END_WINDOW           ;Row ??(25 or..); column 79.

       CALL    CURSOR_OFF

 ;-------------------------------------------------------------------;
 ; Clear arbitray window to attribute specified in AL
 ; On entry :  AL     = screen attribute to use
 ;             CH, CL = row, col of upper left
 ;             DH, DL = row, col of lower right
 ; Modifies : AX, saves BX, BP
 ;-------------------------------------------------------------------;
 CLR_WINDOW    PROC    NEAR
       PUSH    BP
       PUSH    BX
       MOV     BH,AL
       MOV     AX,600H
       INT     10H
       POP     BX
       POP     BP
       RET
 CLR_WINDOW    ENDP
 CLR_EOS               ENDP
 CLR_SCR               ENDP
 CLR_EOL               ENDP
 CLR_MSG               ENDP

 CLR_DOS_WIN   PROC    NEAR
       MOV     AL,ORIG_ATT
       MOV     CX,BEG_DOS
       CALL    CLR_EOS
       MOV     DX,BEG_DOS - 100h
       CALL    SET_CURSOR
       RET
 CLR_DOS_WIN           ENDP
 SUBTTL Bios Interface (non-screen)
 page
 ;******************************************
 ;  OTHER BIOS ROUTINES
 ;******************************************
 ;------------------
 ; Set cursor off
 ;------------------
 CURSOR_OFF    PROC    NEAR
       PUSH    CX
       MOV     CX,2000H
       JMP     SHORT _CU1

 ;------------------------------
 ; Set cursor on
 ;------------------------------
 CURSOR_ON     PROC    NEAR
       PUSH    CX
       MOV     CX,CURSOR_TYPE

 ;------------------------------
 ; Set cursor size
 ; On entry :  CH = start line
 ;             CL = stop line
 ;------------------------------
 _CU1: PUSH    AX
       MOV     AH,1
       INT     10H
       POP     AX
       POP     CX
       RET
 CURSOR_ON     ENDP
 CURSOR_OFF    ENDP

 ;---------------------------------------------------------;
 ; Move the cursor,
 ; On entry : DH, DL = cursor position, (0,0)= upper left
 ;---------------------------------------------------------;
 SET_CURSOR    PROC    NEAR
       PUSH    SI
       XOR     BH,BH                   ;Page zero.
       MOV     AH,2                    ;Set cursor.
       INT     10H
       CALL    CURSOR_ON
       POP     SI
       RET
 SET_CURSOR    ENDP

 ;-------------------------------------------------------------------;
 ; Beep via Hardware.
 ;-------------------------------------------------------------------;
 BEEP  PROC    NEAR

	CMP	SOUND_DEFAULT,0
	je	_beep_1		; if 0 setting, use DOS services

 Sound		PROC	NEAR
          PUSH CX ax
 s1:
		MOV	AL,182		;notify 8253 that frequency data is
		OUT	67,AL		;coming
		MOV	AL,0		;send frequency data (1193280/freq /256 = high-order byte)
		OUT	66,AL
		MOV	AL,14
		OUT	66,AL
		IN	AL,97		;activate speaker
		OR	AL,3
		OUT	97,AL
		MOV	CX,1500h	;time delay for duration
 sbeep:		LOOP	sbeep
		IN	AL,97		;deactivate speaker
		AND	AL,252
		OUT	97,AL

          POP  ax CX
		RET
 Sound		ENDP

 _beep_1:
       push ax dx
       MOV     DL,7
       MOV     AH,2
       INT     DOSINT
       pop     dx ax
       RET
 BEEP  ENDP


 ;-------------------------------------------------------------------;
 ; Retrieve keystroke via BIOS.
 ; Returns : ascii value in AL,
 ;       : scan code in AH
 ;-------------------------------------------------------------------;
 READ_C_KEY      PROC    NEAR
       cmp     is_mouse,0   ;4.50 pull out ALL mouse stuff if no mouse
       je      start_read   ;4.50
       xor     bx,bx               ;zero out bx for holding vertical mickeys
	  mov	ax,11
	  int	33h				;and zero out motion counters
	  mov	m_movement,0
	  cmp	is_mouse,1
	  je		read_w_mouse
 START_READ:
       CALL    MENU_CHECK
       MOV     AH,BIOS_KYBD_01	;check for keystroke
       INT     16H
       JNZ     SREAD_2             ;loop until keystroke
       call    dv_pause            ;relinquish rest of time slice to DV
       call    mswin_pause
       jmp     short start_read
 SREAD_2:
       MOV     AH,BIOS_KYBD_00     ;read keystroke
       INT     16H
       RET
 READ_W_MOUSE:
       CALL    MENU_CHECK		;check if menu to be changed with hot key

	  call	chk_mb_press
	  jnc	_rwm_but5		     ;nothing, continue
	  call	emulate_keys
	  ret

 _RWM_but5:

       MOV     AH,BIOS_KYBD_01	;check for keystroke
       INT     16H
       JNZ     READ_KEYSTROKE      ;was a keystroke -- process


	  mov	ax,11
	  int	33h
	  add	m_movement,dx
	  mov	dx,m_movement
	  .ABS	dx				;dx = ABS(dx)
       mov     cx,m_vertical
	  cmp	dx,cx
	  ja	    _M_ENOUGH
       call    dv_pause            ;give up rest of time slide to DV
       call    mswin_pause
	  jmp	READ_W_MOUSE
_M_ENOUGH:
	  cmp	m_movement,0
	  jl		_M_UP

	  mov	ax,5000h			;down arrow equivalent
;	  sub	m_movement,cx
	  ret
 _M_UP:
	  mov	ax,4800h            ;up arrow equivalent
;	  add	m_movement,cx
	  ret

 READ_KEYSTROKE:
	  MOV	AX,11		     ;read mouse motion counters
	  INT	33h                 ;hence zeroing them out
       MOV     AH,BIOS_KYBD_00     ;read keystroke
       INT     16H
       RET

 READ_C_KEY      ENDP

 CHK_MB_PRESS	PROC NEAR

	  mov	but_press_mask,0
	  mov	ax,3				;is any button down?
	  int	33h
	  and	bx,bx
	  jz		_cmp_no             ;No? continue
 _cmp1:
	  mov	ax,5
	  mov	bx,0
	  int	33h
	  cmp	bx,0				;was the left button pressed?
	  je		_cmp2
	  or		but_press_mask,1b
 	  stc
	  ret
 _cmp2:
	  mov	ax,5
	  mov	bx,1
	  int	33h
	  cmp	bx,0                ;was the right button pressed?
	  je		_cmp3
	  or		but_press_mask,10b
 	  stc
	  ret
 _cmp3:
	  cmp	mouse_but,3
	  jne	_cmp_no
	  mov	ax,5
	  mov	bx,2
	  int	33h
	  cmp	bx,0                ;was the middle button pressed?
	  je		_cmp_no
	  or		but_press_mask,100b
 	  stc
	  ret
 _cmp_no:
	  clc			;nothing pressed
	  ret

 CHK_MB_PRESS ENDP

 EMULATE_KEYS PROC NEAR

 _EK1:
	  test	but_press_mask,100b			;middle
	  jz		_EK2
	  mov	ax,3920h            ;space bar
	  ret
 _EK2:
	  test	but_press_mask,1b			;left
	  jz		_EK3
	  mov	ax,1C0Dh            ;Enter
	  ret
 _EK3:
	  test	but_press_mask,10b			;right
	  jz		_EK_RET
	  mov	ax,011Bh            ;<esc>
	  ret
 _EK_RET:
	  clc
	  ret
 EMULATE_KEYS ENDP

 ;-------------------------------------------------------------------;
 ; Retrieve keystroke via BIOS.
 ; Returns : ascii value in AL,
 ;       : scan code in AH
 ;-------------------------------------------------------------------;
 READ_KEY      PROC    NEAR

;       MOV     AH,BIOS_KYBD_00
	  MOV	AH,0
	;don't need extended services here and they were causing trouble
       INT     16H
       RET
 READ_KEY      ENDP

 ;-------------------------------------------------------------------;
 ; Check for keystroke via BIOS.
 ; returns Z Flag set if no char
 ;         character in AX if NZ
 ;-------------------------------------------------------------------;
 CK_KEY        PROC    NEAR
;       MOV     AH,BIOS_KYBD_01
	  MOV	AH,1
       INT     16H
       RET
 CK_KEY        ENDP

 SUBTTL Dos interface subroutines
 page
 ;******************************************
 ;             DOS FUNCTION CALLS
 ;******************************************
       ASSUME  DS:_TEXT,ES:_TEXT
 ;-------------------------------;
 ; This subroutine opens a file. ;
 ; On entry : AL = open mode
 ;          DS:DX =ASCIIZ path name
 ; Returns  : AX = error codes if carry set
 ;-------------------------------;
 OPEN_FILE     PROC    NEAR
       MOV     AH,3DH
       INT     DOSINT
       RET
 OPEN_FILE     ENDP

 ;-------------------------------;
 ; This subroutine closes a file. ;
 ; On entry : BX = file handle
 ; Returns  : AX = error codes if carry set
 ;-------------------------------;
 CLOSE_FILE    PROC    NEAR
       MOV     AH,3EH
       INT     DOSINT
       RET
 CLOSE_FILE    ENDP

 ;------------------------------------------------;
 ; This subroutine finds the first matching file. ;
 ; On entry : CX = attribute used in seraching
 ;          DS:DX =ASCIIZ drive, path and filename
 ; Returns  : AX = error codes if carry set
 ;------------------------------------------------;
 FIND_FIRST    PROC    NEAR
       MOV     AH,4EH
       INT     DOSINT
       RET
 FIND_FIRST    ENDP

 ;------------------------------------------------------------------;
 ; This subroutine gets the disk space available on the target drive
 ; On entry : DX points to [d:]filename
 ; Returns  : available space in DX:AX
 ; Modifies : AX, BX, CX, DX, SI
 ;------------------------------------------------------------------;
       ASSUME  DS:_TEXT,ES:_TEXT
 GET_BYTES_FREE        PROC    NEAR
       MOV     SI,OFFSET ENTRY         ;Retrieve pointer to target file.
       MOV     AX,[SI]                 ;get two bytes
       AND     AL,5FH                  ;Capitalize.
       CMP     AH,":"                  ;Is there a drive request?
       JZ      _G_B_1                  ;If no, get default drive.
       MOV     AL,DEST_PATH            ;Assume default drive.

 _G_B_1:       MOV     TARG_DISK,AL            ;save it
       ;let run on to DISK_FREE
 ;----------------------------------------------;
 ; This subroutine retrieves available clusters ;
 ; and converts it to hexidecimal bytes free.  ;
 ; On entry :  AL specifies a drive letter in ASCII
 ; Returns  :  DX:AX = bytes free on disk
 ;             BX    = clusters free
 ;             CX    = bytes per cluster
 ; Modifies : AX, BX, CX, DX
 ;----------------------------------------------;
       ASSUME  DS:_TEXT,ES:_TEXT
 DISK_FREE     PROC    NEAR
       PUSH    AX
       AND     AL,1FH                  ;ignore case
       MOV     DL,AL
       MOV     AH,36H                  ;Disk free space.
       INT     DOSINT
       INC     AX                      ;-1 if not drive not valid
       JNZ     _D_F0                   ;ok
       STC                             ;bad drive - set carry
       POP     AX
       RET                             ;return failure

 _D_F0:        DEC     AX                      ;restore correct ax
       XOR     DX,DX
       MUL     CX              ;sectors per cluster times bytes per sector.
       MOV     CX,AX           ;save cluster size for other calculations
       MUL     BX              ;bytes per cluster times clusters
       POP     BX


       CMP     BL,TARG_DISK            ;save it
       JNZ     UPD_FREE_COUNT
       MOV     TARG_BYTES_FREE,AX
       MOV     TARG_BYTES_FREE+2,DX
       MOV     TARG_CLUSTER,CX

 UPD_FREE_COUNT        PROC    NEAR
       CMP     BL,DEST_PATH            ;test if TARG=DEST
       JNZ     _D_F1
       MOV     DEST_BYTES_FREE,AX      ;update dest disk values too
       MOV     DEST_BYTES_FREE+2,DX    ;
       MOV     DEST_CLUSTER,CX

       PUSH    DX
       PUSH    CX
       PUSH    BX
       PUSH    AX
       MOV     DI,OFFSET D_FREE        ;Point to storage.
       MOV     CX,LENGTH D_FREE
       CALL    CFORMAT          ;Convert hex to decimal and store.
;       CALL    FORMAT          ;Convert hex to decimal and store.
       POP     AX
       POP     BX
       POP     CX
       POP     DX

 _D_F1:        CMP     BL,WORK_PATH            ;test if TARG=WORK
       JNZ     _D_F2
       MOV     WORK_BYTES_FREE,AX      ;update work disk values too
       MOV     WORK_BYTES_FREE+2,DX    ;
       MOV     WORK_CLUSTER,CX

       MOV     DI,OFFSET W_FREE        ;Point to storage.
       MOV     CX,LENGTH W_FREE
       CALL    CFORMAT          ;Convert hex to decimal and store.
;       CALL    FORMAT          ;Convert hex to decimal and store.

 _D_F2:        CLC
 _D_F_RET:
         RET

 UPD_FREE_COUNT        ENDP
 DISK_FREE     ENDP
 GET_BYTES_FREE        ENDP


;--------------------------------------------------------------------------
;Allows the user to enter a parameter of maximum length MAX_PARAM
;and copies that parameter to the buffer ENTRY upon the user typing
;a <CR>.  If the user types an <esc>, input is aborted and the carry
;flag is set.
; On entry: CX holds max length
; Modifies: assume all
; Returns: carry set if abort, clear if OK -- parameter in ENTRY
;--------------------------------------------------------------------------

 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT

 ENTER_PARAM  PROC NEAR

		CLC
		MOV	 PARAM_LENGTH,CX
		cmp	 doing_zip,0
		jne	 param_1
		mov	 si,offset param1_msg
		je	 param_cont
 param_1:
		MOV   SI,OFFSET param2_msg
 param_cont:
		MOV	 DI,PROMPT_LOC
		CALL  PUT_STRING
		MOV   DX,172EH
		CALL  CLEAR_OLD
		JMP   PARAM_ENT
		mov	si,offset entry

PARAM_BAD:
		CALL  BEEP
		jmp	short param_ent
 INPUT_PARAM	PROC NEAR
		mov	param_length,cx
		mov	di,offset entry
PARAM_ENT:
		CALL  READ_KEY                 ;Get a keystroke
		CMP   AL,27                    ;Is it ESC?
		JZ    _EP_ERR                  ;Yes, abort RUN_PROG
		CMP   AL,13                    ;Is it a Return key?
		JZ    _EP_RET                  ;Execute program
		CMP   AL,8                     ;Is it a backspace
		JNZ   NOT_BS3
		CALL  MOVE_BS                  ;Yes, backspace
		JMP   SHORT PARAM_ENT          ;Get next keystroke
NOT_BS3:
		CMP   AL,32                    ;Space or above?
		JB    PARAM_BAD                ;No, ignore entry

		MOV	 SI,OFFSET ENTRY
		ADD	 SI,PARAM_LENGTH
		CMP   DI,SI			      ;At end of entry field?
		JZ    PARAM_BAD                ;Yes, ignore entry
		STOSB                          ;Else store the byte
		CALL  WRITE_TEXT               ;And write it to the screen
		JMP   PARAM_ENT                ;Then loop back for more

 _EP_ERR:
			 STC
			 RET
 _EP_RET:
		MOV	BYTE PTR [DI],0		 ;make sure there's no garabage left
;		MOV	BYTE PTR [DI],32		 ;make sure there's no garabage left
		INC	DI
		MOV	 SI,OFFSET ENTRY
		ADD	 SI,PARAM_LENGTH
		CMP   DI,SI			      ;At end of entry field?
		JBE	_EP_RET
		CLC
		 RET
 INPUT_PARAM		ENDP
 ENTER_PARAM		ENDP

;-----------------------------------------------------------------------
;Inserts a prompted string entered by the user at the location pointed to by
;DI which is passed to this subroutine.
;Preserves SI, assume changes all else; advances DI to char after
;inserted filename
;------------------------------------------------------------------------
 ASSUME CS:_TEXT, DS:_TEXT, ES:_TEXT

 USER_PARAM_INS	PROC NEAR

	PUSH		SI
	PUSH		AX
	PUSH		DI

 _UPI_1:
	cmp		first_time,1		;skip the entry procedure on multi-execute after
							;first time
	je		_UPI_15             ;go straight to parsing
	MOV		CX,MAX_PARAM
	CALL		ENTER_PARAM    	;prompt for parameter -- put at OFFSET ENTRY
	jnc		_UPI_15			;<esc> not hit
 UPI_14:						;we're only here if <esc> hit
 ;	cmp		doing_zip,1		;
 ;	jne		_UPI_1
	pop		di
	jmp		short _UPI_ESC		;we want to bail out if this is archive function

 _UPI_15:
	POP		DI
	MOV		SI,OFFSET ENTRY
 _UPI_2:                           ;copy the string to DI
	CALL		FIND_LENGTH

	PUSH		DI				;will the length of the parameter cause
	ADD		DI,AX			;an overrun?
	CMP		DI,OFFSET VIEWER_LINE-1
	POP		DI
	JGE		_UPI_OVER            ;yes? set carry and exit

	MOV		CX,AX
	REP		MOVSB
	CLC
	mov		cx,1
	JMP		SHORT _UPI_RET
 _UPI_ESC:
	xor		cx,cx 			;zero cx indicates escape pressed
	jmp		short _UPI_ERR
 _UPI_OVER:
	mov		cx,1
 _UPI_ERR:
	STC
 _UPI_RET:
	cmp		byte ptr [di-1],0
	jne		_UPI_RET1
	mov		byte ptr [di-1],32	;get rid of the NULL at the end
 _UPI_RET1:
	POP		AX
	POP		SI
	RET


USER_PARAM_INS	ENDP

;-----------------------------------------;
; These subroutines display the messages. ;
;-----------------------------------------;

DISPLAY_TEXT   PROC NEAR
               CALL   SET_CURSOR             ;Move cursor.
GET_TEXT:      LODSB
               CMP    AL,0                   ;Zero marks end of string.
               JZ     END_TEXT
               CALL   WRITE_TEXT
               JMP    SHORT GET_TEXT
END_TEXT:      RET

WRITE_TEXT:    PUSH   SI                     ;BIOS does not save SI.
               MOV    AH,0EH                 ;Write teletype.
               INT    10H
               POP    SI
               RET
DISPLAY_TEXT   ENDP

;--------------------------------------------------------------------------
; Makes the source (working/displayed) directory the new destination
;  (default) directory.
;--------------------------------------------------------------------------

dest_to_source	proc near

	mov	si,offset work_path
	call	set_dest


	ret
dest_to_source	endp



;------------------------------------------------------------------------
; Initializes mouse.  If mouse/driver not found, sets carry flag and
; returns 0 in al.  If found, returns 1 in al, number of buttons in ah,
; and carry flag clear.
; On entry: nothing
; Modifies: assume everything
; Returns: see above
;-------------------------------------------------------------------------
     mouse_version  dw   0
     mousetype      db   0
     mouseIRQ       db   0
     mdriver_seg    dw   0

 init_mouse    proc near

	push	es
	mov	ax,3533h	;get interrupt 33h vector
	int	21h
	mov	ax,es
	or	ax,bx
	jz	_im_no_driver
	cmp	byte ptr es:[bx], 207
	jne	_im_reset
 _im_no_driver:
	xor	al,al	;return 0 in al
	pop	es		;4.0P2 wasn't in here -- caused a hang in no driver present
	stc
	ret
 _im_reset:
     ;Mouse driver state saving info
     cmp  save_mouse_state,1
     jne  _im_50
     mov  ax,21        ;get mouse driver storage requirements
     int  33h
     mov  cl,4
     mov  bx,ax
     shr  bx,cl        ;convert to paragraphs
     mov  ah,48h       ;allocate memory
     int  21h
     jc  _im_45       ;failed
     mov  mdriver_seg,ax
     push es
     mov  es,ax
     mov  ax,22        ;save mouse driver state to buffer
     xor  dx,dx
     int  33h
     pop  es
     jmp  short _im_50
 _im_45:
     mov  save_mouse_state,0
 _im_50:
     cmp  hw_reset,1   ;normally do a software reset.  Have patch location
                       ;left in to do a h/w reset.  (Changed to s/w reset
                       ;DF 4.50 pass 4
     je   _im_reset_hw
     mov  ax,33      ;M1%=33 (software reset)
     jmp  short _im_100
 _im_reset_hw:
     xor  ax,ax     ;M1%=0
 _im_100:
     int  33h
     cmp  ax,-1      ;was mouse found?
     jne   _im_no_driver
     push ax bx
     mov  ax,36h
     int  33h
     mov  mouse_version,ax
     mov  mousetype,ch
     mov  mouseIRQ,cl
     pop  bx ax
	mov	al,1		;return 1 in al
	mov	ah,bl	;return number of buttons in ah
	pop	es
	clc
	ret
 init_mouse endp

;-------------------------------------------------------------------------
;get and set the default Ultravision text-mode cursor
; 00h = line
; FFh = box
;-------------------------------------------------------------------------

 UV_CURSOR     DB      ?

 get_uv_cursor proc near
     push ax
     push cx
     mov  ax,0CD06h
     int  10h
     mov  uv_cursor,cl
     pop  cx
     pop  ax
     ret
 get_uv_cursor endp

 set_uv_cursor proc near
     push ax
     push cx
     mov  ax,0CD05h
     mov  cl,uv_cursor
     int  10h
     pop  cx
     pop  ax
     ret
 set_uv_cursor endp


INCLUDE DF450NEW.ASM ;various new routines for DF 4.50
INCLUDE DFVIEW.ASM  ;VIEW and VIEW_DIR routines and associated
INCLUDE DFVID.ASM   ;video and Ultravision functions
INCLUDE DFTOUCH.ASM ;date/time related functions
INCLUDE DFSA.ASM    ;various support routines adapted from Spontaneous Assembler source
INCLUDE DFVOL.ASM	;volume read and edit routines
INCLUDE DFEXEC.ASM	;exec-related routines
INCLUDE DFPARSE.ASM ;user-defined command-line parsing
INCLUDE DFZIP.ASM	;routines related to creating archive file
INCLUDE DFATTR.ASM	;attribute change related routines
INCLUDE DFHELP.ASM	;help screen
INCLUDE DFCFG.ASM   ;routines to read in a .CFG file
INCLUDE DFMEM.ASM   ;memory allocation/de-allocation routines
INCLUDE DFPRINT.ASM	;functions for printing directory listing
INCLUDE DFSORT.ASM  ;sorting and related comparison routines
INCLUDE DFCPU.ASM
IFDEF debugsi
     INCLUDE DFDEBSI.ASM
ELSE
     INCLUDE DFSI.ASM    ;System info screen
ENDIF
;INCLUDE PZTIMER.ASM
INCLUDE DFFREQ.ASM
INCLUDE DFDVIEW.ASM
INCLUDE DFERROR.ASM

               even
 PGM_NAME      DB      0               ;program name for CALL_DOS
 INITIAL_PATH  EQU     PGM_NAME+80
 WORK_PATH     EQU     INITIAL_PATH+70
 DEST_PATH     EQU     WORK_PATH+70
 SOURCE                EQU     DEST_PATH+70
 TARGET                EQU     SOURCE+70+13
 TARG_DISK     EQU     TARGET+70+13
 ENTRY         EQU     TARG_DISK+2
 TMP_BUFF      EQU     ENTRY+36
 TMP_BUFF2     EQU     TMP_BUFF+80
 FCB_5CH       EQU     TMP_BUFF2+80   ;changed so could use for parameters
							   ; in 4.0
 FCB_6CH		EQU	   FCB_5CH+16
 SET_STORE     EQU     FCB_6CH+16
 DIR_BUFF      EQU     SET_STORE+0  ;settings read from config file are here
 last_byte	EQU	   $			 ;DIR_BUFF begins here

 _TEXT ENDS
 END  START