// registry.c -- Finger daemon registry functions
// Copyright 1995 Dean Troyer (troyer@indirect.com)
// All rights reserved.
//
// 0.5  11Oct95     dlt     Extract these from fingerd.c
//      15Oct95     dlt     Add support for UserInfo & ProcInfo

#include "fingerd.h"

extern char LMDomain[];                 // LanMan Domain Name
extern DWORD UserInfo;                  // Enable for user information
extern DWORD ProcInfo;                  // Enable for process information

// ReadRegistry -- Read registry items
//
// Parameters:
//   none
//
// Return:
//   none
//
// Comments:
//   Reads registry data, substituting defaults for values not present

VOID ReadRegistry()
{
    HKEY RegKey;
    unsigned long BufLen;
    char szBuf[32];
    DWORD EntryType, Result, Temp;

    // Read registry data
    
    RegCreateKey(HKEY_LOCAL_MACHINE, Finger_Reg_Key, &RegKey);

    // Lan Manager/NT Domain
    BufLen = sizeof(szBuf);
    strcpy(LMDomain, Reg_LMDomain_Def);
    Result = RegQueryValueEx(RegKey, Reg_LMDomain, 0, &EntryType, szBuf, &BufLen);
    if (Result == ERROR_SUCCESS &&
       ((EntryType == REG_SZ) || (EntryType == REG_EXPAND_SZ))) {
        strcpy(LMDomain, szBuf);
    }

    // User information enable
    UserInfo = Reg_UserInfo_Def;
    BufLen = sizeof(Temp);
    Result = RegQueryValueEx(RegKey, Reg_UserInfo, NULL, &EntryType, (LPBYTE)&Temp, &BufLen);
    if (Result == ERROR_SUCCESS && EntryType == REG_DWORD) {
        UserInfo = Temp;
    }

    // Process information enable
    ProcInfo = Reg_ProcInfo_Def;
    BufLen = sizeof(Temp);
    Result = RegQueryValueEx(RegKey, Reg_ProcInfo, NULL, &EntryType, (LPBYTE)&Temp, &BufLen);
    if (Result == ERROR_SUCCESS && EntryType == REG_DWORD) {
        ProcInfo = Temp;
    }

    RegCloseKey(RegKey);
}  // ReadRegistry

// InstallRegistry -- Add registry items
//
// Parameters:
//   none
//
// Return:
//   none
//
// Comments:
//   Install the required registry keys with reasonable default values;
//   reasonable being whatever is defined in config.h

VOID InstallRegistry()
{
    HKEY    RegKey;
    DWORD   Result;
    DWORD   EntryType;
    char    szBuf[32];
    DWORD   Temp;
    
    // Set up registry entries
    RegCreateKey(HKEY_LOCAL_MACHINE, Finger_Reg_Key, &RegKey);

    // Lan Manager/NT Domain
    Result = RegQueryValueEx(RegKey, Reg_LMDomain, NULL, &EntryType, NULL, NULL);
    if (Result != ERROR_SUCCESS || 
       ((EntryType != REG_SZ) && (EntryType != REG_EXPAND_SZ))) {
        strcpy(szBuf, Reg_LMDomain_Def);
        RegSetValueEx(RegKey, Reg_LMDomain, 0, REG_SZ, (CONST BYTE *)szBuf, 
                      strlen(szBuf) + 1);
    }

    // User information enable
    Result = RegQueryValueEx(RegKey, Reg_UserInfo, NULL, &EntryType, NULL, NULL);
    if (Result != ERROR_SUCCESS || EntryType != REG_DWORD) {
        Temp = Reg_UserInfo_Def;
        RegSetValueEx(RegKey, Reg_UserInfo, 0, REG_DWORD, (CONST BYTE *)&Temp, sizeof(Temp));
    }

    // Process information enable
    Result = RegQueryValueEx(RegKey, Reg_ProcInfo, NULL, &EntryType, NULL, NULL);
    if (Result != ERROR_SUCCESS || EntryType != REG_DWORD) {
        Temp = Reg_ProcInfo_Def;
        RegSetValueEx(RegKey, Reg_ProcInfo, 0, REG_DWORD, (CONST BYTE *)&Temp, sizeof(Temp));
    }

    RegCloseKey(RegKey);
}  // InstallRegistry


// RemoveRegistry -- Remove registry items
//
// Parameters:
//   none
//
// Return:
//   none
//
// Comments:
//   Completely removes the registry subkey

VOID RemoveRegistry()
{
    HKEY    RegKey;
    
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, Finger_Reg_Key, 0, KEY_ALL_ACCESS, &RegKey)
       == ERROR_SUCCESS) {
        RegCloseKey(RegKey);
        RegDeleteKey(HKEY_LOCAL_MACHINE, Finger_Reg_Key);
    }
}  // InstallRegistry

