// perf.c - Windows NT Performance Data Function
// Copyright 1995 Dean Troyer (troyer@indirect.com)
// All rights reserved.
//
// See fingerd.txt for license information
//
// Taken from an article posted to comp.os.windows-nt.misc by 
// Dimitris Staikos (dstaikos@theseas.ntua.gr)
//
// Interrogate NT's performance data for process information
//
// This module is compiled with Unicode turned on to support
// the Win32 APIs that require Unicode
//
// 0.5  04Feb95      dlt     Create module

#define STRICT
#define UNICODE
#include <stdio.h>
#include <stdlib.h>

// Don't include the world ...
#define NOGDI             
#define NOSOUND           
#define NOCOMM            
#define NODRIVERS         
#define OEMRESOURCE       
#define NONLS             
#define NOSERVICE         
#define NOKANJI           
#define NOMINMAX          
#define NOLOGERROR        
#define NOPROFILER        
#define NOMEMMGR          
#define NOOPENFILE        
#define NORESOURCE        
#define NOATOM            
#define NOLANGUAGE        
#define NOLSTRING         
#define NODBCS            
#define NOKEYBOARDINFO    
#define NOGDICAPMASKS     
#define NOCOLOR           
#define NOGDIOBJ          
#define NODRAWTEXT        
#define NOTEXTMETRIC      
#define NOSCALABLEFONT    
#define NOBITMAP          
#define NORASTEROPS       
#define NOMETAFILE        
#define NOSYSMETRICS      
#define NOSYSTEMPARAMSINFO
#define NOMSG             
#define NOWINSTYLES       
#define NOWINOFFSETS      
#define NOSHOWWINDOW      
#define NODEFERWINDOWPOS  
#define NOVIRTUALKEYCODES 
#define NOKEYSTATES       
#define NOWH              
#define NOMENUS           
#define NOSCROLL          
#define NOCLIPBOARD       
#define NOICONS           
#define NOMB              
#define NOSYSCOMMANDS     
#define NOMDI             
#define NOCTLMGR          
#define NOWINMESSAGES     
#define NOHELP            

#include <windows.h>
#include <winperf.h>

#include "perf.h"

#define MEM_STEP 8000

// Globals
extern DWORD dwDebug;

#ifndef HELPER_MACROS

//******************************************************************************************
// Helper Functions to walk the performance data structures
//******************************************************************************************
PPERF_OBJECT_TYPE FirstObject(PPERF_DATA_BLOCK pPerfData)
{
    return ((PPERF_OBJECT_TYPE) ((PBYTE) pPerfData + pPerfData->HeaderLength)) ;
}
//******************************************************************************************
PPERF_OBJECT_TYPE NextObject (PPERF_OBJECT_TYPE pObject)
{
    return ((PPERF_OBJECT_TYPE) ((PBYTE) pObject + pObject->TotalByteLength)) ;
}
//******************************************************************************************
PPERF_COUNTER_DEFINITION FirstCounter(PPERF_OBJECT_TYPE pObjectDef)
{
    return (PPERF_COUNTER_DEFINITION)((PCHAR) pObjectDef + pObjectDef->HeaderLength);
}
//******************************************************************************************
PPERF_COUNTER_DEFINITION NextCounter(PPERF_COUNTER_DEFINITION pCounterDef)
{
    return (PPERF_COUNTER_DEFINITION)((PCHAR) pCounterDef + pCounterDef->ByteLength);
}
//******************************************************************************************
PPERF_INSTANCE_DEFINITION FirstInstance (PPERF_OBJECT_TYPE pObject)
{
    return (PPERF_INSTANCE_DEFINITION)((PBYTE) pObject + pObject->DefinitionLength);
}
//******************************************************************************************

#endif // !HELPER_MACROS

PPERF_INSTANCE_DEFINITION NextInstance (PPERF_INSTANCE_DEFINITION pInstance)
{
    // next instance is after this instance + this instance's counter data
    PPERF_COUNTER_BLOCK  pCtrBlk;

    pCtrBlk = (PPERF_COUNTER_BLOCK)((PBYTE)pInstance + pInstance->ByteLength);

    return (PPERF_INSTANCE_DEFINITION)((PBYTE)pInstance + pInstance->ByteLength + pCtrBlk->ByteLength);
}

/******************************************************************************************
 Retrieves from HKEY_PERFORMANCE_DATA the value of the string passed as parameter
 and returning the memory in pMem.
 Returns TRUE if it succeeds, FALSE upon failure. pMem is changed only when TRUE is about
 to be returned.
 When performance data is retrieved, the dwNeeded parameter in the call to RegQueryValueEx
 is NOT changed to reflect the needed size, CONTRARY to what the documentation states.
 The code checks for this condition, and if it is detected the dwNeeded parameter is
 increased by MEM_STEP. When requesting "Counter 009" or "Help 009" the dwNeeded parameter
 is changed by the system, so the manual adjustment is avoided.
*******************************************************************************************/
DWORD PerformanceKeyRetrieve(LPTSTR szName, LPVOID *pMemory)
{
    LPVOID pMem;
    DWORD dwNeeded, dwType, dwHelp;
    LONG lError;
    DWORD RetVal = 0;

    __try
    {
        dwNeeded = MEM_STEP;
        pMem = HeapAlloc(GetProcessHeap(), HEAP_GENERATE_EXCEPTIONS, dwNeeded);

        do {
            dwHelp = dwNeeded;
            lError = RegQueryValueEx(HKEY_PERFORMANCE_DATA, szName, NULL, &dwType, pMem, &dwNeeded);
            if (dwDebug)
                wprintf(TEXT("After query\n"));
            if (lError == ERROR_MORE_DATA) {
                if (dwHelp == dwNeeded) {      // Check if manual adjustment is neccessary
                    if (dwDebug)
                        wprintf(TEXT("more memory...\n"));
                    dwNeeded += MEM_STEP;
                }
                pMem = HeapReAlloc(GetProcessHeap(), HEAP_GENERATE_EXCEPTIONS, pMem, dwNeeded);
            }
            else if (lError == ERROR_SUCCESS) {
                if (dwDebug)
                    wprintf(TEXT("Success!\n"));
                RetVal = 0;
            } else {
                if (dwDebug)
                    wprintf(TEXT("Unexpected Error : Failed to open subkey 009 of Perflib - Error Code %d\n%s"), lError,
                            TEXT("If your lang key is not 009 please change the source code to the correct value\n"));

                HeapFree(GetProcessHeap(), 0, pMem);
                RetVal = 1;
            }
        } while (lError == ERROR_MORE_DATA);

    }
    __except ((GetExceptionCode()==STATUS_NO_MEMORY || GetExceptionCode()==STATUS_ACCESS_VIOLATION) ?
             EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
    {
        if (dwDebug)
            wprintf(TEXT("PerformanceKeyRetrieve()\nFailed to allocate memory for request \"%s\". Error Code = %d\n"),
                    szName, GetLastError());
          
        RetVal = GetLastError();
    }

    if (!RetVal)
        *pMemory = pMem;

    return RetVal;
}  // PerformanceKeyRetrieve

