// config.h -- Finger service configuration stuff
// Copyright 1995 Dean Troyer (troyer@indirect.com)
// All rights reserved.
//
// See fingerd.txt for license information
//
// 0.4  02Feb95     dlt     Initial release
// 0.5  11Oct95     dlt     Process enhancements
//      15Oct95     dlt     Add support for UserInfo & ProcInfo

#ifndef _CONFIG_H
#define _CONFIG_H

#define PROGRAM_NAME    "Fingerd"               // Program file name
#define INTERNAL_NAME   "FingerD"               // Internal name of service
#define DISPLAY_NAME    "Finger Server"         // Displayed name of service
#define VERSION         "0.5"                   // Program version number
#define COPYRIGHT       "Copyright (C) 1995 Dean Troyer (troyer@indirect.com)"

// Special functions

#define ID_ID           "finger-conf"           // FingerD configuration
#define ID_PROC         "proc"                  // System processes

// Registry Stuff

#define REG_SERVICE_KEY "SYSTEM\\CurrentControlSet\\Services\\" INTERNAL_NAME "\\Parameters"
#define REG_DEBUG       "Debug"

// Root key under HKEY_LOCAL_MACHINE
#define Root_Reg_Key    "SOFTWARE\\Local"
#define Finger_Reg_Key  Root_Reg_Key "\\" INTERNAL_NAME

// The LanMan domain to interrogate
#define Reg_LMDomain    "LanManDomain"
#define Reg_LMDomain_Def ""

// Controls user information dump
#define Reg_UserInfo    "EnableUserInfo"
#define Reg_UserInfo_Def 1

// Controls proc information dump
#define Reg_ProcInfo    "EnableProcInfo"
#define Reg_ProcInfo_Def 1

// Event Log key
#define Event_Reg_Key   "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application\\" INTERNAL_NAME
#define Event_Reg_DLL   INTERNAL_NAME "M.DLL"

// Windows sockets

#define WSVERSION       0x101           // Required version of windows sockets
#define FINGER_SERVICE  "finger"        // Lookup server port in /etc/services
#define DEF_FINGER_PORT 79              // Default port used by most of the world

// Misc stuff

#define REQLEN 255                  // max length of request string
#define XFERBUFLEN 1024             // max # of character for send/recv

#endif  // _CONFIG_H

