# Generated automatically from Makefile.in by configure.
# Makefile for GNU Awk.
#
# Copyright (C) 1986, 1988-1995 the Free Software Foundation, Inc.
# 
# This file is part of GAWK, the GNU implementation of the
# AWK Programming Language.
# 
# GAWK is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# GAWK is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA



MAKEINFO = makeinfo --no-split

srcdir = .

CC = bcc
YACC = bison -y

INSTALL = /usr/bin/ginstall -c
INSTALL_PROGRAM = ${INSTALL}
INSTALL_DATA = ${INSTALL} -m 644

BE_LIBS = -nodefaults $(BUILDHOME)/metro/lib/libdll.a \
          $(BUILDHOME)/metro/lib/libpos.so
LIBS = $(BE_LIBS)

ALLOCA = 

TOPDIR = $(BUILDHOME)/install
exec_prefix = $(TOPDIR)
prefix = $(TOPDIR)/system
binprefix =
manprefix =

bindir = ${exec_prefix}/bin
libdir = ${prefix}/bin.data
manexta = 1
mandir = ${prefix}/man/man$(manexta)
manext = .$(manexta)
infodir = ${prefix}/info
datadir = ${prefix}/bin.data/awk
destdatadir = /system/bin.data/awk
libexecdir = ${prefix}/bin.data/libexec/awk

DEFPATH = ".:$(destdatadir)"

SHELL = /bin/sh
CFLAGS = -O -DGAWK -I. -I$(srcdir) -DHAVE_CONFIG_H

# object files
AWKOBJS = array.o builtin.o eval.o field.o gawkmisc.o io.o main.o \
	missing.o msg.o node.o re.o version.o

ALLOBJS = $(AWKOBJS) awktab.o

# GNUOBJS
#	GNU stuff that gawk uses as library routines.
GNUOBJS= regex.o dfa.o $(ALLOCA)

# source and documentation files
SRC = array.c builtin.c eval.c field.c gawkmisc.c io.c main.c \
	missing.c msg.c node.c re.c version.c

ALLSRC= $(SRC) awktab.c

AWKSRC= awk.h awk.y custom.h $(ALLSRC) patchlevel.h protos.h

GNUSRC = alloca.c dfa.c dfa.h regex.c regex.h getopt.h getopt.c getopt1.c

COPIES = missing/system.c missing/tzset.c \
	missing/memcmp.c missing/memcpy.c missing/memset.c \
	missing/random.c missing/strncasecmp.c missing/strchr.c \
	missing/strerror.c missing/strtod.c \
	missing/strftime.c missing/strftime.3 

DOCS= doc/gawk.1 doc/gawk.texi doc/texinfo.tex

TEXFILES= doc/gawk.aux doc/gawk.cp doc/gawk.cps doc/gawk.fn doc/gawk.fns \
	  doc/gawk.ky doc/gawk.kys doc/gawk.pg doc/gawk.pgs doc/gawk.toc \
	  doc/gawk.tp doc/gawk.tps doc/gawk.vr doc/gawk.vrs

MISC =	NEWS COPYING FUTURES Makefile.in PROBLEMS README PORTS POSIX.STD \
	configure configure.in acconfig.h configh.in ACKNOWLEDGMENT \
	ChangeLog INSTALL LIMITATIONS install-sh mkinstalldirs aclocal.m4 \
	stamp-h.in

OTHERS= amiga doc pc atari vms README_d posix awklib

ALLDOC= doc/gawk.dvi $(TEXFILES) doc/gawk.info*

# Release of gawk.  There can be no leading or trailing white space here!
REL=3.0

# clear out suffixes list
.SUFFIXES:
.SUFFIXES: .c .o

.c.o:
	$(CC) -c $(CFLAGS) $<

# rules to build gawk
# all:	gawk doc/all awklib/all
all:	gawk awklib/all

# stuff to make sure that configure has been run.
$(srcdir)/configure:	configure.in aclocal.m4
	cd $(srcdir) && autoconf

# autoheader might not change confh.in, so touch a stamp file
$(srcdir)/configh.in:	stamp-h.in
$(srcdir)/stamp-h.in:	configure.in aclocal.m4 acconfig.h
	cd $(srcdir) && autoheader
	date > $(srcdir)/stamp-h.in

#config.h:	stamp-h
#stamp-h:	configh.in config.status
#	$(SHELL) ./config.status

Makefile:	Makefile.in config.status
	$(SHELL) ./config.status

config.status:	configure
	$(SHELL) ./config.status --recheck

gawk:	$(ALLOBJS) $(GNUOBJS) $(REOBJS)
	$(CC) -o gawk $(LDFLAGS) $(ALLOBJS) $(GNUOBJS) $(REOBJS) $(LIBS)

$(ALLOBJS):	awk.h dfa.h regex.h config.h custom.h

$(GNUOBJS):	config.h custom.h

# SunOS make's (at least) VPATH doesn't do subdirectories...
# Solaris make doesn't allow $< in the actual rule
gawkmisc.o:	$(srcdir)/amiga/gawkmisc.ami $(srcdir)/atari/gawkmisc.atr \
		$(srcdir)/pc/gawkmisc.pc $(srcdir)/posix/gawkmisc.c \
		$(srcdir)/vms/gawkmisc.vms
	$(CC) -c $(CFLAGS) -DDEFPATH='$(DEFPATH)' $(srcdir)/gawkmisc.c

getopt.o:	getopt.h

getopt1.o:	getopt.h

main.o:	patchlevel.h

awktab.c:	awk.y
	$(YACC) -v $(srcdir)/awk.y && \
	if test -f y.tab.c ; then mv y.tab.c ytab.c ; else true ; fi && \
	sed '/^extern char .malloc(), .realloc();$$/d' ytab.c >awktab.c && \
	rm ytab.c

# VMS POSIX make won't apply the default .c.o rule to awktab.o for some reason
awktab.o:	awktab.c awk.h
	$(CC) -c $(CFLAGS) $(srcdir)/awktab.c

alloca.o:	alloca.c

install:	gawk installdirs
	$(INSTALL) gawk $(bindir)/awk && chmod 755 $(bindir)/awk
	cd awklib && $(MAKE) install

#	$(INSTALL) gawk $(bindir) && chmod 755 $(bindir)/gawk
#	cd doc && $(MAKE) install

installdirs: mkinstalldirs
	$(srcdir)/mkinstalldirs $(bindir) $(datadir) \
		$(libdir) $(libexecdir)

#	$(srcdir)/mkinstalldirs $(bindir) $(datadir) \
#		$(libdir) $(infodir) $(mandir) $(libexecdir)

uninstall:
	rm -f $(bindir)/gawk
	cd awklib && $(MAKE) uninstall
	-rmdir $(datadir) $(libexecdir)

#	cd doc && $(MAKE) uninstall

# auxiliary rules for release maintenance
lint:	$(ALLSRC)
	lint -hcbax $(CFLAGS) $(ALLSRC)

xref:
	cxref -c $(CFLAGS) $(ALLSRC) | grep -v '	/' >xref

clean:
	rm -rf gawk *.o core y.output
	cd doc && $(MAKE) clean
	cd test && $(MAKE) clean
	cd awklib && $(MAKE) clean

distclean:	clean
	rm -f Makefile TAGS tags *.orig *.rej */*.orig */*.rej awk.output \
		gmon.out make.out config.h config.status config.cache \
		config.log stamp-h
	cd doc && $(MAKE) distclean
	cd awklib && $(MAKE) distclean

mostlyclean:	clean

maintainer-clean:	distclean
	@echo "This command is intended for maintainers to use; it"
	@echo "deletes files that may require special tools to rebuild."
	rm -f awktab.c
	cd doc && $(MAKE) maintainer-clean
	cd test && $(MAKE) maintainer-clean
	cd awklib && $(MAKE) maintainer-clean

clobber:	maintainer-clean

TAGS:
	etags $(AWKSRC)
	ctags $(AWKSRC)

dvi:	$(srcdir)/doc/gawk.texi
	cd doc && $(MAKE) dvi

info:	$(srcdir)/doc/gawk.texi
	cd doc && $(MAKE) info

doc/all:
	cd doc && $(MAKE) all

awklib/all:
	cd awklib && $(MAKE) all

dist:	$(AWKSRC) $(GNUSRC) $(DOCS) $(MISC) $(COPIES) awklib/stamp-eg distclean
	-rm -rf gawk-$(REL)*
	dir=gawk-$(REL).`gawk '{print $$3}' patchlevel.h` && \
	mkdir $$dir && \
	cp -pr $(AWKSRC) $(GNUSRC) $(MISC) $$dir && \
	mkdir $$dir/missing && \
	cp -p $(COPIES) $$dir/missing && \
	for i in $(OTHERS); \
	do \
		cp -pr $$i $$dir ; \
	done && \
	cp -pr test $$dir && \
	(cd $$dir/doc; $(MAKEINFO) gawk.texi) && \
	find $$dir -type d -exec chmod 777 {} ';' && \
	find $$dir -print | doschk && \
	tar -cf - $$dir | gzip > $$dir.tar.gz && \
	rm -fr $$dir

awklib/stamp-eg:
	cd awklib ; $(MAKE) stamp-eg

check:	gawk
	cd test; $(MAKE) -k

test:	check

