#! /bin/sh

prefix=$1

if test -z "$prefix"; then
	echo "no root directory specified."
	exit 1
fi

# Get a list of all files in the tree.
# Avoid problems where prefix is a symbolic link by doing cd to root dir.

echo "finding files in $prefix ..."
cd $prefix
find . -type f -print | sort >/tmp/strip.rawlist

# toss out the ones we don't want to touch
# these are:
#
#	all files related to emacs
#	all *.ixlibrary files
#	all files in .../sys/l/
#	all files in .../sys/libs/
#	all files in .../adalib/	(changes datestamp)
#	all files named libamiga.a	(strip bug corrupts them?)
#	all known files that use dld	(miniperl, perl, a2p)
#	all libstubs.a files in libnix	(strip bug strips too much?)
#	all *.tfm files			(misidentified by "file" on x86 BeOS)

echo "Filtering out files we shouldn't touch ..."
sed </tmp/strip.rawlist >/tmp/strip.filtered \
	-e "/emacs/d"			\
	-e "/\.tfm/d"			\
	-e "/\.ixlibrary/d"		\
	-e "/\/Sys\/L\//d"		\
	-e "/\/Sys\/Libs\//d"		\
	-e "/\/adalib\//d"		\
	-e "/\/libamiga.a/d"		\
	-e "/\/bin\/miniperl/d"		\
	-e "/\/bin\/perl/d"		\
	-e "/\/libnix\/libstubs/d"	\
	-e "/\/bin\/a2p/d"

# Find the types of the files

echo "Getting file types ..."
cat /tmp/strip.filtered | xargs file >/tmp/strip.types

# Strip the executables

echo "Creating list of executables ..."
grep "AmigaOS hunk format executable" /tmp/strip.types >/tmp/strip.execfiles
grep "MS-DOS executable" /tmp/strip.types >>/tmp/strip.execfiles
grep "ELF 32-bit LSB shared object" /tmp/strip.types >>/tmp/strip.execfiles
sed "s/:.*$//" </tmp/strip.execfiles >/tmp/strip.execlist
for i in `cat /tmp/strip.execlist`
do
	echo "Stripping executable $i"
	strip $i
done

# Strip the archive libraries

echo "Creating list of archive libraries ..."
grep "archive" /tmp/strip.types >/tmp/strip.archfiles
sed "s/:.*$//" </tmp/strip.archfiles >/tmp/strip.archlist
for i in `cat /tmp/strip.archlist`
do
	echo "Stripping debug symbols from $i"
	strip -g $i
done

# Strip the object files

echo "Creating list of object files ..."
grep "mc68010 executable not stripped" /tmp/strip.types >/tmp/strip.objfiles
grep "COFF executable not stripped" /tmp/strip.types >>/tmp/strip.objfiles
grep "ELF 32-bit LSB relocatable" /tmp/strip.types >>/tmp/strip.objfiles
sed "s/:.*$//" </tmp/strip.objfiles >/tmp/strip.objlist
for i in `cat /tmp/strip.objlist`
do
	echo "Stripping debug symbols from $i"
	strip -g $i
done

rm /tmp/strip.*
