/* Instruction description for i960.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright (C) 1996, 1997, 1998, 1999 Free Software Foundation, Inc.

This file is part of the GNU Binutils and/or GDB, the GNU debugger.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#ifndef I960_OPC_H
#define I960_OPC_H

#define CGEN_ARCH i960

/* Given symbol S, return i960_cgen_<S>.  */
#define CGEN_SYM(s) CONCAT3 (i960,_cgen_,s)

/* Selected cpu families.  */
#define HAVE_CPU_I960BASE

#define CGEN_INSN_LSB0_P 0
#define CGEN_WORD_BITSIZE 32
#define CGEN_DEFAULT_INSN_BITSIZE 32
#define CGEN_BASE_INSN_BITSIZE 32
#define CGEN_MIN_INSN_BITSIZE 32
#define CGEN_MAX_INSN_BITSIZE 64
#define CGEN_DEFAULT_INSN_SIZE (CGEN_DEFAULT_INSN_BITSIZE / 8)
#define CGEN_BASE_INSN_SIZE (CGEN_BASE_INSN_BITSIZE / 8)
#define CGEN_MIN_INSN_SIZE (CGEN_MIN_INSN_BITSIZE / 8)
#define CGEN_MAX_INSN_SIZE (CGEN_MAX_INSN_BITSIZE / 8)
#define CGEN_INT_INSN_P 0

/* FIXME: Need to compute CGEN_MAX_SYNTAX_BYTES.  */

/* CGEN_MNEMONIC_OPERANDS is defined if mnemonics have operands.
   e.g. In "b,a foo" the ",a" is an operand.  If mnemonics have operands
   we can't hash on everything up to the space.  */
#define CGEN_MNEMONIC_OPERANDS
/* Maximum number of operands any insn or macro-insn has.  */
#define CGEN_MAX_INSN_OPERANDS 16

/* Maximum number of fields in an instruction.  */
#define CGEN_MAX_IFMT_OPERANDS 9

/* Enums.  */

/* Enum declaration for insn opcode enums.  */
typedef enum insn_opcode {
  OPCODE_00, OPCODE_01, OPCODE_02, OPCODE_03
 , OPCODE_04, OPCODE_05, OPCODE_06, OPCODE_07
 , OPCODE_08, OPCODE_09, OPCODE_0A, OPCODE_0B
 , OPCODE_0C, OPCODE_0D, OPCODE_0E, OPCODE_0F
 , OPCODE_10, OPCODE_11, OPCODE_12, OPCODE_13
 , OPCODE_14, OPCODE_15, OPCODE_16, OPCODE_17
 , OPCODE_18, OPCODE_19, OPCODE_1A, OPCODE_1B
 , OPCODE_1C, OPCODE_1D, OPCODE_1E, OPCODE_1F
 , OPCODE_20, OPCODE_21, OPCODE_22, OPCODE_23
 , OPCODE_24, OPCODE_25, OPCODE_26, OPCODE_27
 , OPCODE_28, OPCODE_29, OPCODE_2A, OPCODE_2B
 , OPCODE_2C, OPCODE_2D, OPCODE_2E, OPCODE_2F
 , OPCODE_30, OPCODE_31, OPCODE_32, OPCODE_33
 , OPCODE_34, OPCODE_35, OPCODE_36, OPCODE_37
 , OPCODE_38, OPCODE_39, OPCODE_3A, OPCODE_3B
 , OPCODE_3C, OPCODE_3D, OPCODE_3E, OPCODE_3F
 , OPCODE_40, OPCODE_41, OPCODE_42, OPCODE_43
 , OPCODE_44, OPCODE_45, OPCODE_46, OPCODE_47
 , OPCODE_48, OPCODE_49, OPCODE_4A, OPCODE_4B
 , OPCODE_4C, OPCODE_4D, OPCODE_4E, OPCODE_4F
 , OPCODE_50, OPCODE_51, OPCODE_52, OPCODE_53
 , OPCODE_54, OPCODE_55, OPCODE_56, OPCODE_57
 , OPCODE_58, OPCODE_59, OPCODE_5A, OPCODE_5B
 , OPCODE_5C, OPCODE_5D, OPCODE_5E, OPCODE_5F
 , OPCODE_60, OPCODE_61, OPCODE_62, OPCODE_63
 , OPCODE_64, OPCODE_65, OPCODE_66, OPCODE_67
 , OPCODE_68, OPCODE_69, OPCODE_6A, OPCODE_6B
 , OPCODE_6C, OPCODE_6D, OPCODE_6E, OPCODE_6F
 , OPCODE_70, OPCODE_71, OPCODE_72, OPCODE_73
 , OPCODE_74, OPCODE_75, OPCODE_76, OPCODE_77
 , OPCODE_78, OPCODE_79, OPCODE_7A, OPCODE_7B
 , OPCODE_7C, OPCODE_7D, OPCODE_7E, OPCODE_7F
 , OPCODE_80, OPCODE_81, OPCODE_82, OPCODE_83
 , OPCODE_84, OPCODE_85, OPCODE_86, OPCODE_87
 , OPCODE_88, OPCODE_89, OPCODE_8A, OPCODE_8B
 , OPCODE_8C, OPCODE_8D, OPCODE_8E, OPCODE_8F
 , OPCODE_90, OPCODE_91, OPCODE_92, OPCODE_93
 , OPCODE_94, OPCODE_95, OPCODE_96, OPCODE_97
 , OPCODE_98, OPCODE_99, OPCODE_9A, OPCODE_9B
 , OPCODE_9C, OPCODE_9D, OPCODE_9E, OPCODE_9F
 , OPCODE_A0, OPCODE_A1, OPCODE_A2, OPCODE_A3
 , OPCODE_A4, OPCODE_A5, OPCODE_A6, OPCODE_A7
 , OPCODE_A8, OPCODE_A9, OPCODE_AA, OPCODE_AB
 , OPCODE_AC, OPCODE_AD, OPCODE_AE, OPCODE_AF
 , OPCODE_B0, OPCODE_B1, OPCODE_B2, OPCODE_B3
 , OPCODE_B4, OPCODE_B5, OPCODE_B6, OPCODE_B7
 , OPCODE_B8, OPCODE_B9, OPCODE_BA, OPCODE_BB
 , OPCODE_BC, OPCODE_BD, OPCODE_BE, OPCODE_BF
 , OPCODE_C0, OPCODE_C1, OPCODE_C2, OPCODE_C3
 , OPCODE_C4, OPCODE_C5, OPCODE_C6, OPCODE_C7
 , OPCODE_C8, OPCODE_C9, OPCODE_CA, OPCODE_CB
 , OPCODE_CC, OPCODE_CD, OPCODE_CE, OPCODE_CF
 , OPCODE_D0, OPCODE_D1, OPCODE_D2, OPCODE_D3
 , OPCODE_D4, OPCODE_D5, OPCODE_D6, OPCODE_D7
 , OPCODE_D8, OPCODE_D9, OPCODE_DA, OPCODE_DB
 , OPCODE_DC, OPCODE_DD, OPCODE_DE, OPCODE_DF
 , OPCODE_E0, OPCODE_E1, OPCODE_E2, OPCODE_E3
 , OPCODE_E4, OPCODE_E5, OPCODE_E6, OPCODE_E7
 , OPCODE_E8, OPCODE_E9, OPCODE_EA, OPCODE_EB
 , OPCODE_EC, OPCODE_ED, OPCODE_EE, OPCODE_EF
 , OPCODE_F0, OPCODE_F1, OPCODE_F2, OPCODE_F3
 , OPCODE_F4, OPCODE_F5, OPCODE_F6, OPCODE_F7
 , OPCODE_F8, OPCODE_F9, OPCODE_FA, OPCODE_FB
 , OPCODE_FC, OPCODE_FD, OPCODE_FE, OPCODE_FF
} INSN_OPCODE;

/* Enum declaration for insn opcode2 enums.  */
typedef enum insn_opcode2 {
  OPCODE2_0, OPCODE2_1, OPCODE2_2, OPCODE2_3
 , OPCODE2_4, OPCODE2_5, OPCODE2_6, OPCODE2_7
 , OPCODE2_8, OPCODE2_9, OPCODE2_A, OPCODE2_B
 , OPCODE2_C, OPCODE2_D, OPCODE2_E, OPCODE2_F
} INSN_OPCODE2;

/* Enum declaration for insn m3 enums.  */
typedef enum insn_m3 {
  M3_0, M3_1
} INSN_M3;

/* Enum declaration for insn m3 enums.  */
typedef enum insn_m2 {
  M2_0, M2_1
} INSN_M2;

/* Enum declaration for insn m1 enums.  */
typedef enum insn_m1 {
  M1_0, M1_1
} INSN_M1;

/* Enum declaration for insn zero enums.  */
typedef enum insn_zero {
  ZERO_0
} INSN_ZERO;

/* Enum declaration for insn mode a enums.  */
typedef enum insn_modea {
  MODEA_OFFSET, MODEA_INDIRECT_OFFSET
} INSN_MODEA;

/* Enum declaration for insn zero a enums.  */
typedef enum insn_zeroa {
  ZEROA_0
} INSN_ZEROA;

/* Enum declaration for insn mode b enums.  */
typedef enum insn_modeb {
  MODEB_ILL0, MODEB_ILL1, MODEB_ILL2, MODEB_ILL3
 , MODEB_INDIRECT, MODEB_IP_DISP, MODEB_RES6, MODEB_INDIRECT_INDEX
 , MODEB_ILL8, MODEB_ILL9, MODEB_ILL10, MODEB_ILL11
 , MODEB_DISP, MODEB_INDIRECT_DISP, MODEB_INDEX_DISP, MODEB_INDIRECT_INDEX_DISP
} INSN_MODEB;

/* Enum declaration for insn zero b enums.  */
typedef enum insn_zerob {
  ZEROB_0
} INSN_ZEROB;

/* Enum declaration for insn branch m1 enums.  */
typedef enum insn_br_m1 {
  BR_M1_0, BR_M1_1
} INSN_BR_M1;

/* Enum declaration for insn branch zero enums.  */
typedef enum insn_br_zero {
  BR_ZERO_0
} INSN_BR_ZERO;

/* Enum declaration for insn ctrl zero enums.  */
typedef enum insn_ctrl_zero {
  CTRL_ZERO_0
} INSN_CTRL_ZERO;

/* Enum declaration for general registers.  */
typedef enum h_gr {
  H_GR_FP = 31, H_GR_SP = 1, H_GR_R0 = 0, H_GR_R1 = 1
 , H_GR_R2 = 2, H_GR_R3 = 3, H_GR_R4 = 4, H_GR_R5 = 5
 , H_GR_R6 = 6, H_GR_R7 = 7, H_GR_R8 = 8, H_GR_R9 = 9
 , H_GR_R10 = 10, H_GR_R11 = 11, H_GR_R12 = 12, H_GR_R13 = 13
 , H_GR_R14 = 14, H_GR_R15 = 15, H_GR_G0 = 16, H_GR_G1 = 17
 , H_GR_G2 = 18, H_GR_G3 = 19, H_GR_G4 = 20, H_GR_G5 = 21
 , H_GR_G6 = 22, H_GR_G7 = 23, H_GR_G8 = 24, H_GR_G9 = 25
 , H_GR_G10 = 26, H_GR_G11 = 27, H_GR_G12 = 28, H_GR_G13 = 29
 , H_GR_G14 = 30, H_GR_G15 = 31
} H_GR;

/* Enum declaration for condition code.  */
typedef enum h_cc {
  H_CC_CC
} H_CC;

/* Attributes.  */

/* Enum declaration for machine type selection.  */
typedef enum mach_attr {
  MACH_BASE, MACH_I960_KA_SA, MACH_I960_CA, MACH_MAX
} MACH_ATTR;

/* Number of architecture variants.  */
#define MAX_MACHS ((int) MACH_MAX)

/* Ifield attribute indices.  */

/* Enum declaration for cgen_ifld attrs.  */
typedef enum cgen_ifld_attr {
  CGEN_IFLD_MACH, CGEN_IFLD_VIRTUAL, CGEN_IFLD_UNSIGNED, CGEN_IFLD_PCREL_ADDR
 , CGEN_IFLD_ABS_ADDR, CGEN_IFLD_RESERVED, CGEN_IFLD_SIGN_OPT
} CGEN_IFLD_ATTR;

/* Number of non-boolean elements in cgen_ifld.  */
#define CGEN_IFLD_NBOOL_ATTRS ((int) CGEN_IFLD_VIRTUAL)

/* Enum declaration for i960 ifield types.  */
typedef enum ifield_type {
  I960_F_NIL, I960_F_OPCODE, I960_F_SRCDST, I960_F_SRC2
 , I960_F_M3, I960_F_M2, I960_F_M1, I960_F_OPCODE2
 , I960_F_ZERO, I960_F_SRC1, I960_F_ABASE, I960_F_MODEA
 , I960_F_ZEROA, I960_F_OFFSET, I960_F_MODEB, I960_F_SCALE
 , I960_F_ZEROB, I960_F_INDEX, I960_F_OPTDISP, I960_F_BR_SRC1
 , I960_F_BR_SRC2, I960_F_BR_M1, I960_F_BR_DISP, I960_F_BR_ZERO
 , I960_F_CTRL_DISP, I960_F_CTRL_ZERO, I960_F_MAX
} IFIELD_TYPE;

#define MAX_IFLD ((int) I960_F_MAX)

/* Hardware attribute indices.  */

/* Enum declaration for cgen_hw attrs.  */
typedef enum cgen_hw_attr {
  CGEN_HW_MACH, CGEN_HW_VIRTUAL, CGEN_HW_UNSIGNED, CGEN_HW_SIGNED
 , CGEN_HW_CACHE_ADDR, CGEN_HW_FUN_ACCESS, CGEN_HW_PC, CGEN_HW_PROFILE
} CGEN_HW_ATTR;

/* Number of non-boolean elements in cgen_hw.  */
#define CGEN_HW_NBOOL_ATTRS ((int) CGEN_HW_VIRTUAL)

/* Enum declaration for i960 hardware types.  */
typedef enum hw_type {
  HW_H_PC, HW_H_MEMORY, HW_H_SINT, HW_H_UINT
 , HW_H_ADDR, HW_H_IADDR, HW_H_GR, HW_H_CC
 , HW_MAX
} HW_TYPE;

#define MAX_HW ((int) HW_MAX)

/* Operand attribute indices.  */

/* Enum declaration for cgen_operand attrs.  */
typedef enum cgen_operand_attr {
  CGEN_OPERAND_MACH, CGEN_OPERAND_VIRTUAL, CGEN_OPERAND_UNSIGNED, CGEN_OPERAND_PCREL_ADDR
 , CGEN_OPERAND_ABS_ADDR, CGEN_OPERAND_SIGN_OPT, CGEN_OPERAND_NEGATIVE, CGEN_OPERAND_RELAX
 , CGEN_OPERAND_SEM_ONLY
} CGEN_OPERAND_ATTR;

/* Number of non-boolean elements in cgen_operand.  */
#define CGEN_OPERAND_NBOOL_ATTRS ((int) CGEN_OPERAND_VIRTUAL)

/* Enum declaration for i960 operand types.  */
typedef enum cgen_operand_type {
  I960_OPERAND_PC, I960_OPERAND_SRC1, I960_OPERAND_SRC2, I960_OPERAND_DST
 , I960_OPERAND_LIT1, I960_OPERAND_LIT2, I960_OPERAND_ST_SRC, I960_OPERAND_ABASE
 , I960_OPERAND_OFFSET, I960_OPERAND_SCALE, I960_OPERAND_INDEX, I960_OPERAND_OPTDISP
 , I960_OPERAND_BR_SRC1, I960_OPERAND_BR_SRC2, I960_OPERAND_BR_DISP, I960_OPERAND_BR_LIT1
 , I960_OPERAND_CTRL_DISP, I960_OPERAND_MAX
} CGEN_OPERAND_TYPE;

/* Number of operands types.  */
#define MAX_OPERANDS ((int) I960_OPERAND_MAX)

/* Maximum number of operands referenced by any insn.  */
#define MAX_OPERAND_INSTANCES 8

/* Insn attribute indices.  */

/* Enum declaration for cgen_insn attrs.  */
typedef enum cgen_insn_attr {
  CGEN_INSN_MACH, CGEN_INSN_VIRTUAL, CGEN_INSN_UNCOND_CTI, CGEN_INSN_COND_CTI
 , CGEN_INSN_SKIP_CTI, CGEN_INSN_DELAY_SLOT, CGEN_INSN_RELAXABLE, CGEN_INSN_RELAX
 , CGEN_INSN_ALIAS, CGEN_INSN_NO_DIS, CGEN_INSN_PBB
} CGEN_INSN_ATTR;

/* Number of non-boolean elements in cgen_insn.  */
#define CGEN_INSN_NBOOL_ATTRS ((int) CGEN_INSN_VIRTUAL)

/* Enum declaration for i960 instruction types.  */
typedef enum cgen_insn_type {
  I960_INSN_INVALID, I960_INSN_MULO, I960_INSN_MULO1, I960_INSN_MULO2
 , I960_INSN_MULO3, I960_INSN_REMO, I960_INSN_REMO1, I960_INSN_REMO2
 , I960_INSN_REMO3, I960_INSN_DIVO, I960_INSN_DIVO1, I960_INSN_DIVO2
 , I960_INSN_DIVO3, I960_INSN_REMI, I960_INSN_REMI1, I960_INSN_REMI2
 , I960_INSN_REMI3, I960_INSN_DIVI, I960_INSN_DIVI1, I960_INSN_DIVI2
 , I960_INSN_DIVI3, I960_INSN_ADDO, I960_INSN_ADDO1, I960_INSN_ADDO2
 , I960_INSN_ADDO3, I960_INSN_SUBO, I960_INSN_SUBO1, I960_INSN_SUBO2
 , I960_INSN_SUBO3, I960_INSN_NOTBIT, I960_INSN_NOTBIT1, I960_INSN_NOTBIT2
 , I960_INSN_NOTBIT3, I960_INSN_AND, I960_INSN_AND1, I960_INSN_AND2
 , I960_INSN_AND3, I960_INSN_ANDNOT, I960_INSN_ANDNOT1, I960_INSN_ANDNOT2
 , I960_INSN_ANDNOT3, I960_INSN_SETBIT, I960_INSN_SETBIT1, I960_INSN_SETBIT2
 , I960_INSN_SETBIT3, I960_INSN_NOTAND, I960_INSN_NOTAND1, I960_INSN_NOTAND2
 , I960_INSN_NOTAND3, I960_INSN_XOR, I960_INSN_XOR1, I960_INSN_XOR2
 , I960_INSN_XOR3, I960_INSN_OR, I960_INSN_OR1, I960_INSN_OR2
 , I960_INSN_OR3, I960_INSN_NOR, I960_INSN_NOR1, I960_INSN_NOR2
 , I960_INSN_NOR3, I960_INSN_NOT, I960_INSN_NOT1, I960_INSN_NOT2
 , I960_INSN_NOT3, I960_INSN_CLRBIT, I960_INSN_CLRBIT1, I960_INSN_CLRBIT2
 , I960_INSN_CLRBIT3, I960_INSN_SHLO, I960_INSN_SHLO1, I960_INSN_SHLO2
 , I960_INSN_SHLO3, I960_INSN_SHRO, I960_INSN_SHRO1, I960_INSN_SHRO2
 , I960_INSN_SHRO3, I960_INSN_SHLI, I960_INSN_SHLI1, I960_INSN_SHLI2
 , I960_INSN_SHLI3, I960_INSN_SHRI, I960_INSN_SHRI1, I960_INSN_SHRI2
 , I960_INSN_SHRI3, I960_INSN_EMUL, I960_INSN_EMUL1, I960_INSN_EMUL2
 , I960_INSN_EMUL3, I960_INSN_MOV, I960_INSN_MOV1, I960_INSN_MOVL
 , I960_INSN_MOVL1, I960_INSN_MOVT, I960_INSN_MOVT1, I960_INSN_MOVQ
 , I960_INSN_MOVQ1, I960_INSN_MODPC, I960_INSN_MODAC, I960_INSN_LDA_OFFSET
 , I960_INSN_LDA_INDIRECT_OFFSET, I960_INSN_LDA_INDIRECT, I960_INSN_LDA_INDIRECT_INDEX, I960_INSN_LDA_DISP
 , I960_INSN_LDA_INDIRECT_DISP, I960_INSN_LDA_INDEX_DISP, I960_INSN_LDA_INDIRECT_INDEX_DISP, I960_INSN_LD_OFFSET
 , I960_INSN_LD_INDIRECT_OFFSET, I960_INSN_LD_INDIRECT, I960_INSN_LD_INDIRECT_INDEX, I960_INSN_LD_DISP
 , I960_INSN_LD_INDIRECT_DISP, I960_INSN_LD_INDEX_DISP, I960_INSN_LD_INDIRECT_INDEX_DISP, I960_INSN_LDOB_OFFSET
 , I960_INSN_LDOB_INDIRECT_OFFSET, I960_INSN_LDOB_INDIRECT, I960_INSN_LDOB_INDIRECT_INDEX, I960_INSN_LDOB_DISP
 , I960_INSN_LDOB_INDIRECT_DISP, I960_INSN_LDOB_INDEX_DISP, I960_INSN_LDOB_INDIRECT_INDEX_DISP, I960_INSN_LDOS_OFFSET
 , I960_INSN_LDOS_INDIRECT_OFFSET, I960_INSN_LDOS_INDIRECT, I960_INSN_LDOS_INDIRECT_INDEX, I960_INSN_LDOS_DISP
 , I960_INSN_LDOS_INDIRECT_DISP, I960_INSN_LDOS_INDEX_DISP, I960_INSN_LDOS_INDIRECT_INDEX_DISP, I960_INSN_LDIB_OFFSET
 , I960_INSN_LDIB_INDIRECT_OFFSET, I960_INSN_LDIB_INDIRECT, I960_INSN_LDIB_INDIRECT_INDEX, I960_INSN_LDIB_DISP
 , I960_INSN_LDIB_INDIRECT_DISP, I960_INSN_LDIB_INDEX_DISP, I960_INSN_LDIB_INDIRECT_INDEX_DISP, I960_INSN_LDIS_OFFSET
 , I960_INSN_LDIS_INDIRECT_OFFSET, I960_INSN_LDIS_INDIRECT, I960_INSN_LDIS_INDIRECT_INDEX, I960_INSN_LDIS_DISP
 , I960_INSN_LDIS_INDIRECT_DISP, I960_INSN_LDIS_INDEX_DISP, I960_INSN_LDIS_INDIRECT_INDEX_DISP, I960_INSN_LDL_OFFSET
 , I960_INSN_LDL_INDIRECT_OFFSET, I960_INSN_LDL_INDIRECT, I960_INSN_LDL_INDIRECT_INDEX, I960_INSN_LDL_DISP
 , I960_INSN_LDL_INDIRECT_DISP, I960_INSN_LDL_INDEX_DISP, I960_INSN_LDL_INDIRECT_INDEX_DISP, I960_INSN_LDT_OFFSET
 , I960_INSN_LDT_INDIRECT_OFFSET, I960_INSN_LDT_INDIRECT, I960_INSN_LDT_INDIRECT_INDEX, I960_INSN_LDT_DISP
 , I960_INSN_LDT_INDIRECT_DISP, I960_INSN_LDT_INDEX_DISP, I960_INSN_LDT_INDIRECT_INDEX_DISP, I960_INSN_LDQ_OFFSET
 , I960_INSN_LDQ_INDIRECT_OFFSET, I960_INSN_LDQ_INDIRECT, I960_INSN_LDQ_INDIRECT_INDEX, I960_INSN_LDQ_DISP
 , I960_INSN_LDQ_INDIRECT_DISP, I960_INSN_LDQ_INDEX_DISP, I960_INSN_LDQ_INDIRECT_INDEX_DISP, I960_INSN_ST_OFFSET
 , I960_INSN_ST_INDIRECT_OFFSET, I960_INSN_ST_INDIRECT, I960_INSN_ST_INDIRECT_INDEX, I960_INSN_ST_DISP
 , I960_INSN_ST_INDIRECT_DISP, I960_INSN_ST_INDEX_DISP, I960_INSN_ST_INDIRECT_INDEX_DISP, I960_INSN_STOB_OFFSET
 , I960_INSN_STOB_INDIRECT_OFFSET, I960_INSN_STOB_INDIRECT, I960_INSN_STOB_INDIRECT_INDEX, I960_INSN_STOB_DISP
 , I960_INSN_STOB_INDIRECT_DISP, I960_INSN_STOB_INDEX_DISP, I960_INSN_STOB_INDIRECT_INDEX_DISP, I960_INSN_STOS_OFFSET
 , I960_INSN_STOS_INDIRECT_OFFSET, I960_INSN_STOS_INDIRECT, I960_INSN_STOS_INDIRECT_INDEX, I960_INSN_STOS_DISP
 , I960_INSN_STOS_INDIRECT_DISP, I960_INSN_STOS_INDEX_DISP, I960_INSN_STOS_INDIRECT_INDEX_DISP, I960_INSN_STL_OFFSET
 , I960_INSN_STL_INDIRECT_OFFSET, I960_INSN_STL_INDIRECT, I960_INSN_STL_INDIRECT_INDEX, I960_INSN_STL_DISP
 , I960_INSN_STL_INDIRECT_DISP, I960_INSN_STL_INDEX_DISP, I960_INSN_STL_INDIRECT_INDEX_DISP, I960_INSN_STT_OFFSET
 , I960_INSN_STT_INDIRECT_OFFSET, I960_INSN_STT_INDIRECT, I960_INSN_STT_INDIRECT_INDEX, I960_INSN_STT_DISP
 , I960_INSN_STT_INDIRECT_DISP, I960_INSN_STT_INDEX_DISP, I960_INSN_STT_INDIRECT_INDEX_DISP, I960_INSN_STQ_OFFSET
 , I960_INSN_STQ_INDIRECT_OFFSET, I960_INSN_STQ_INDIRECT, I960_INSN_STQ_INDIRECT_INDEX, I960_INSN_STQ_DISP
 , I960_INSN_STQ_INDIRECT_DISP, I960_INSN_STQ_INDEX_DISP, I960_INSN_STQ_INDIRECT_INDEX_DISP, I960_INSN_CMPOBE_REG
 , I960_INSN_CMPOBE_LIT, I960_INSN_CMPOBNE_REG, I960_INSN_CMPOBNE_LIT, I960_INSN_CMPOBL_REG
 , I960_INSN_CMPOBL_LIT, I960_INSN_CMPOBLE_REG, I960_INSN_CMPOBLE_LIT, I960_INSN_CMPOBG_REG
 , I960_INSN_CMPOBG_LIT, I960_INSN_CMPOBGE_REG, I960_INSN_CMPOBGE_LIT, I960_INSN_CMPIBE_REG
 , I960_INSN_CMPIBE_LIT, I960_INSN_CMPIBNE_REG, I960_INSN_CMPIBNE_LIT, I960_INSN_CMPIBL_REG
 , I960_INSN_CMPIBL_LIT, I960_INSN_CMPIBLE_REG, I960_INSN_CMPIBLE_LIT, I960_INSN_CMPIBG_REG
 , I960_INSN_CMPIBG_LIT, I960_INSN_CMPIBGE_REG, I960_INSN_CMPIBGE_LIT, I960_INSN_BBC_REG
 , I960_INSN_BBC_LIT, I960_INSN_BBS_REG, I960_INSN_BBS_LIT, I960_INSN_CMPI
 , I960_INSN_CMPI1, I960_INSN_CMPI2, I960_INSN_CMPI3, I960_INSN_CMPO
 , I960_INSN_CMPO1, I960_INSN_CMPO2, I960_INSN_CMPO3, I960_INSN_TESTNO_REG
 , I960_INSN_TESTG_REG, I960_INSN_TESTE_REG, I960_INSN_TESTGE_REG, I960_INSN_TESTL_REG
 , I960_INSN_TESTNE_REG, I960_INSN_TESTLE_REG, I960_INSN_TESTO_REG, I960_INSN_BNO
 , I960_INSN_BG, I960_INSN_BE, I960_INSN_BGE, I960_INSN_BL
 , I960_INSN_BNE, I960_INSN_BLE, I960_INSN_BO, I960_INSN_B
 , I960_INSN_BX_INDIRECT_OFFSET, I960_INSN_BX_INDIRECT, I960_INSN_BX_INDIRECT_INDEX, I960_INSN_BX_DISP
 , I960_INSN_BX_INDIRECT_DISP, I960_INSN_CALLX_DISP, I960_INSN_CALLX_INDIRECT, I960_INSN_CALLX_INDIRECT_OFFSET
 , I960_INSN_RET, I960_INSN_CALLS, I960_INSN_FMARK, I960_INSN_FLUSHREG
 , I960_INSN_MAX
} CGEN_INSN_TYPE;

/* Index of `invalid' insn place holder.  */
#define CGEN_INSN_INVALID I960_INSN_INVALID
/* Total number of insns in table.  */
#define MAX_INSNS ((int) I960_INSN_MAX)

/* cgen.h uses things we just defined.  */
#include "opcode/cgen.h"

/* This struct records data prior to insertion or after extraction.  */
struct cgen_fields 
{
  long f_nil;
  long f_opcode;
  long f_srcdst;
  long f_src2;
  long f_m3;
  long f_m2;
  long f_m1;
  long f_opcode2;
  long f_zero;
  long f_src1;
  long f_abase;
  long f_modea;
  long f_zeroa;
  long f_offset;
  long f_modeb;
  long f_scale;
  long f_zerob;
  long f_index;
  long f_optdisp;
  long f_br_src1;
  long f_br_src2;
  long f_br_m1;
  long f_br_disp;
  long f_br_zero;
  long f_ctrl_disp;
  long f_ctrl_zero;
  int length;
};

/* Attributes.  */
extern const CGEN_ATTR_TABLE i960_cgen_hw_attr_table[];
extern const CGEN_ATTR_TABLE i960_cgen_operand_attr_table[];
extern const CGEN_ATTR_TABLE i960_cgen_insn_attr_table[];

/* Hardware decls.  */

extern CGEN_KEYWORD i960_cgen_opval_h_gr;
extern CGEN_KEYWORD i960_cgen_opval_h_cc;

#define CGEN_INIT_PARSE(od) \
{\
}
#define CGEN_INIT_INSERT(od) \
{\
}
#define CGEN_INIT_EXTRACT(od) \
{\
}
#define CGEN_INIT_PRINT(od) \
{\
}

/* -- opc.h */

#undef CGEN_DIS_HASH_SIZE
#define CGEN_DIS_HASH_SIZE 256
#undef CGEN_DIS_HASH
#define CGEN_DIS_HASH(buffer, value) ((unsigned char *) (buffer))[3]

/* ??? Until cgen disassembler complete and functioning well, redirect back
   to old disassembler.  */
#define CGEN_PRINT_INSN(od, pc, info) print_insn_i960_orig (pc, info)

/* -- */


#endif /* I960_OPC_H */
