#! /bin/sh
#
# Script to encapsulate a complete set of steps needed to currently
# configure, build, and install the GNUPro ELF tools.  Note that 
# rootdir (below) needs to be customized for each person's build
# environment.  Also, you must run this from a completely freshly
# created scratch directory, not inside the source tree.

# Abort on any errors.
set -e

# Set the following to point to the root directory of the Cygnus sources
# This will vary depending upon where you have checked it out.
rootdir=/work/beos/source/cygnus

# Virgin BeOS R4 is missing printf.h, which we need.
test -f /boot/develop/headers/posix/printf.h || echo "Missing /boot/develop/posix/printf.h; libstdc will fail to build"

# Configure the tree.  Keep log file in configure.log
$rootdir/configure -v --prefix=/boot/develop/tools/gnupro --cache-file=config.cache --disable-c-mbchar --with-gxx-include-dir=/boot/develop/tools/gnupro/include/g++ i586-beos 2>&1 | tee configure.log

# Build the tools.  Keep log file in make.log
make -kw 2>&1 | tee make.log

# Install the tools. Keep log file in install.log
make -kw install 2>&1 | tee install.log

# Strip the installed files.  This is hardcoded for now because we
# don't want to use the strip.sh script, which depends upon using
# the GG "file" command.

strip /boot/develop/tools/gnupro/bin/addr2line
strip /boot/develop/tools/gnupro/bin/ar
strip /boot/develop/tools/gnupro/bin/as
strip /boot/develop/tools/gnupro/bin/c++
strip /boot/develop/tools/gnupro/bin/c++filt
strip /boot/develop/tools/gnupro/bin/g++
strip /boot/develop/tools/gnupro/bin/gasp
strip /boot/develop/tools/gnupro/bin/gcc
strip /boot/develop/tools/gnupro/bin/gcov
strip /boot/develop/tools/gnupro/bin/gperf
strip /boot/develop/tools/gnupro/bin/gprof
strip /boot/develop/tools/gnupro/bin/ld
strip /boot/develop/tools/gnupro/bin/nm
strip /boot/develop/tools/gnupro/bin/objcopy
strip /boot/develop/tools/gnupro/bin/objdump
strip /boot/develop/tools/gnupro/bin/protoize
strip /boot/develop/tools/gnupro/bin/ranlib
strip /boot/develop/tools/gnupro/bin/readelf
strip /boot/develop/tools/gnupro/bin/size
strip /boot/develop/tools/gnupro/bin/strings
strip /boot/develop/tools/gnupro/bin/strip
strip /boot/develop/tools/gnupro/bin/unprotoize
strip /boot/develop/tools/gnupro/lib/gcc-lib/i586-beos/2.9-beos-991026/cc1
strip /boot/develop/tools/gnupro/lib/gcc-lib/i586-beos/2.9-beos-991026/cc1plus
strip /boot/develop/tools/gnupro/lib/gcc-lib/i586-beos/2.9-beos-991026/collect2
strip /boot/develop/tools/gnupro/lib/gcc-lib/i586-beos/2.9-beos-991026/cpp

strip -g /boot/develop/tools/gnupro/lib/gcc-lib/i586-beos/2.9-beos-991026/libgcc.a
strip -g /boot/develop/tools/gnupro/lib/gcc-lib/i586-beos/2.9-beos-991026/crtbegin.o
strip -g /boot/develop/tools/gnupro/lib/gcc-lib/i586-beos/2.9-beos-991026/crtend.o
