;***********************************************************************
;*                                                                     *
;* DOWJONES.ASP  (C) 1990 DATASTORM TECHNOLOGIES, INC.                 *
;*                                                                     *
;* A sample ASPECT script file for logging onto Dow Jones via Tymnet.  *
;*                                                                     *
;***********************************************************************
;
;***********************************************************************
; The following two defines should be customized with the dialing      *
; directory entry for your local TYMNET number and your DOW JONES      *
; password.                                                            *
;***********************************************************************

define TYMNET_ENTRY "1"
define PASSWORD "my_password"

;***********************************************************************

proc main                       ; start of main procedure
   clear                        ; clear screen
   locate 0 0                   ; locate cursor at 0,0
   box 0 0 4 28 14              ; draw box
   atsay 2 2 14 "Logging onto DOW JONES..."  ; put message in box
   locate 6 0                   ; cursor to row 6

   if not fromddir              ; if not linked to a dial directory entry
      dial TYMNET_ENTRY         ; dial directory entry for TYMNET - make sure E71
   endif
   transmit "^M"                ; transmit a carriage return
   waitfor "identifier"         ; wait for TYMNET prompt
   transmit "A"                 ; send an A (no carriage return)
   waitfor "log in: "           ; wait for TYMNET login prompt
   transmit "DOW1;;"            ; send "DOW1;;"
   waitfor "WHAT SERVICE PLEASE?"   ; wait for DOW prompt
   transmit "DJNS^M"            ; DOW JONES news service
   waitfor "PASSWORD"           ; wait for password prompt
   transmit PASSWORD            ; send password
   transmit "^M"                ; followed by a carriage return
   alarm 2                      ; beep to inform user logon complete
endproc
