;***********************************************************************
;*                                                                     *
;*                                                                     *
;* CSERVE.ASP  (C) 1990 DATASTORM TECHNOLOGIES, INC.                   *
;*                                                                     *
;* A sample ASPECT script file for logging onto CompuServe via local   *
;* CIS number.                                                         *
;*                                                                     *
;***********************************************************************
;
;***********************************************************************
; The following three defines should be customized with the dialing    *
; directory entry for your local CIS number, your CompuServe ID, and   *
; your CompuServe password.  The rest of the script should need no     *
; modification.                                                        *
;***********************************************************************

define CIS_NUMBER "1"        ; make sure entry is E71, full duplex, VT102 term
define ID "12345,1234"
define PASSWORD "abcdef*abcde"

proc main                     ; start of main procedure
   clear                      ; clear screen
   locate 0 0                 ; locate cursor at 0,0
   box 0 0 4 29 14            ; draw box
   atsay 2 2 14 "Logging onto COMPUSERVE..."  ; put message in box
   locate 6 0                 ; cursor to row 6

   if not fromddir            ; if not called via Dial Dir link
      dial CIS_NUMBER         ; use dialing directory entry for CIS number
   endif
   pause 3                    ; wait three seconds
   transmit "^C"              ; transmit CTRL-C
   waitfor "User ID:"         ; wait for "User ID:" to come in COM port
   transmit ID                ; send your ID
   transmit "^M"              ; send carriage return
   waitfor "Password:"        ; wait for "Password:" to come in COM port
   transmit PASSWORD          ; send password
   transmit "^M"              ; send carriage return
   set enq cisb               ; turn on auto CIS downloads
   waitfor "!" 60             ; wait for CompuServe prompt
   transmit "g dstorm^M"      ; go to DATASTORM support forum
endproc                       ; end of main procedure
