/*****************************************************************************
 * File:	sockets.h
 *
 * Author:	Rhett "Jonzy" Jones
 *		jonzy@cc.utah.edu
 *
 * Date:	May 29, 1993
 *
 * Modifed:	May 29, 1994, by Rhett "Jonzy" Jones.
 *		Added the forward declaration to GetHostName().
 *
 *		July 23, 1994, by Rhett "Jonzy" Jones.
 *		Added the forward declaration to SendBuffer().
 *
 *		September 22, 1994 by Rhett "Jonzy" Jones.
 *		Added declaratio of PostContactHostError().
 *
 * Description:	Header file for use with "sockets.c".  Simply defines a type,
 *		prototypes a few routines, and declares a variable as
 *		extern.
 *
 * Bugs:	No known bugs.
 *
 * Copyright:	Copyright 1993, 1994, University of Utah Computer Center.
 *		JUGHEAD (TM) is a trademark of Archie Comic Publications, Inc.
 *		and is used pursuant to license.  This source may be used and
 *		freely distributed as long as this copyright notice remains
 *		intact, and is in no way used for any monetary gain, by any
 *		institution, business, person, or persons.
 *
 ****************************************************************************/

#ifdef USEPROTOTYPES
	extern void	PostContactHostError(int error, char *hostStr, char *portStr);
	extern char	*GetHostName(char *hostDomainFromConf_h);
	extern void	IP2Hostname(int sockfd,char *host,char *ip);
	extern int	SetUpReadNwriter(int theSocket);
	extern void	CloseReadNwriter(void);
	extern int	ContactHost(char* theHost, int thePort);
	extern int	SendBuffer(char *buffer,int bufferSize);
	extern int	SendString(char *s);
	extern char	*GetString(FILE *ptr);
	extern void	TooMuchTime4Read(void);
	extern int	ListenerEstablished(int port);
	extern int	ProcessRequest(int sockfd);
#else
	extern void	PostContactHostError();
	extern char	*GetHostName();
	extern void	IP2Hostname();
	extern int	SetUpReadNwriter();
	extern void	CloseReadNwriter();
	extern int	ContactHost();
	extern int	SendBuffer();
	extern int	SendString();
	extern char	*GetString();
	extern void	TooMuchTime4Read();
	extern int	ListenerEstablished();
	extern int	ProcessRequest();
#endif
