#ifndef UTIL_H
#define UTIL_H

#include <Xm/Xm.h>
#include <regex.h>
#include "chat.h"


#ifdef BIGENDIAN
/* convert the bytes of a 16-bit integer to little endian */
#define BSWAP16(c) (((c & 0xff) << 8) | ((c >> 8) & 0xff))
/* convert the bytes of a 32-bit integer to little endian */
#define BSWAP32(c) ((c>>24)&0xff)|((c>>8)&0xff00)|((c<<8)&0xff0000)|(c<<24)
#else
#define BSWAP16(c) c
#define BSWAP32(c) c
#endif

char* ReadErr(int r);

int ReadChars(int fd, void *ptr, int toRead);
int WriteChars(int fd, void *ptr, int toWrite);

PRIV* FindPrivByNick(String nick);
PRIV* FindPrivByWin(Widget w);
CHAN* FindChanByName(String channel);
CHAN* FindChanByWin(Widget w);

int CmdMatch(String s, String cmd, int len);

int SplitServer(String s, String *server, String *port, String *meta);

String GetFileTail(String fileName);

String GetDir(String fileName);

int RegEx(String s, String regExpr, int nmatch, regmatch_t pmatch[]);

void CenterDialog(Widget d);
void ForceDialog(Widget d);
void ForceWindow(Widget w);

#endif
