/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/Xm.h>
#include <Xm/List.h>

#include "main.h"
#include "connect.h"
#include "transfer.h"
#include "search.h"
#include "message.h"
#include "msgbox.h"
#include "listwin.h"
#include "util.h"


static Widget listWin = NULL;
static XtIntervalId timerId;


void DestroyUlListWin(void)
{
    if (listWin) {
	DestroyWin(XtParent(listWin));
	listWin = NULL;
    }
}


void UlListCB(Widget w, XtPointer clientData,
	XmSelectionBoxCallbackStruct *cbs)
{
    Widget list;
    int i, *pos;
    UPLOAD *upload;

    switch (cbs->reason) {
        case XmCR_OK:
	    list = XtNameToWidget(w, "ItemsListSW.ItemsList");
	    XtVaGetValues(list, XmNselectedPositions, &pos, NULL);
	    for (i = 0, upload = uploads; i < ((*pos) - 1);
		     i++, upload = upload->next);
	    EndUl(upload, 1);
            break;
	case XmCR_CANCEL:
	case XmCR_PROTOCOLS:
	    XtRemoveTimeOut(timerId);
	    DestroyUlListWin();
    }
}


static void UpdateUlList(XtPointer closure, XtIntervalId *id)
{
    UPLOAD *upload;
    int i, numUploads, percent, *pos, lastPos = 0, posCount;
    String tmp = XtMalloc(8192), fileName;
    XmString *str;
    Widget list;
    
    if (! listWin) {
	XtFree(tmp);
	return;
    }

    for (numUploads = 0, upload = uploads; upload;
	 numUploads++, upload = upload->next);

    str = (XmString*)XtMalloc(numUploads * sizeof(XmString));
    for (i = 0, upload = uploads; i < numUploads;
	    i++, upload = upload->next) {
	percent = (upload->count * 100) / upload->tot;
	fileName = GetFileTail(upload->fileName);
	sprintf(tmp, "%-50.47s%-25.22s%d",
		fileName, upload->nick, percent);
	str[i] = XmStringCreateLocalized(tmp);
	XtFree(fileName);
    }

    list = XtNameToWidget(listWin, "ItemsListSW.ItemsList");
    
    XtVaGetValues(list, XmNselectedPositionCount, &posCount, NULL);
    if (posCount) {
	XtVaGetValues(list, XmNselectedPositions, &pos, NULL);
	lastPos = *pos;
    }
 
    XtVaSetValues(listWin,
	    XmNlistItems, str,
	    XmNlistItemCount, numUploads,
	    NULL);

    if (numUploads) {
	if (! posCount)
	    XmListSelectPos(list, 1, False);
	else
	    XmListSelectPos(list, lastPos, False);

    	XmUpdateDisplay(topLevel);
    }
    
    for (i = 0; i < numUploads; i++)
        XmStringFree(str[i]);
    XtFree((String)str);
    XtFree(tmp);

    timerId = XtAppAddTimeOut(appCon, 1000,
	    (XtTimerCallbackProc)UpdateUlList, NULL);
}


void ListUploads(void)
{
    DestroyUlListWin();
    listWin = ListWin("ulList", (XtCallbackProc)UlListCB, NULL);
    UpdateUlList(NULL, NULL);
}
