/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/Xm.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>

#include "main.h"
#include "connect.h"
#include "message.h"
#include "info.h"
#include "msgbox.h"
#include "util.h"


void ShowServerStats(void)
{
    if (SendMsg(MSG_CLIENT_USAGE_STATS, ""))
	Disconnect(strerror(errno));
}


void DoShowServerStats(String data)
{
    regmatch_t pmatch[11];
    String values[11], timeStr = XtMalloc(256);
    String tmp, dtxt, htxt;
    int i, j, r, len;
    int time, days, hours, minutes, seconds;
    double kiloBytes;
    char timeTmp[80];
    time_t startTime;
    struct tm *tm;
    
    enum {CONN_CLIENTS, CONN_SERVERS, TOT_CLIENTS, FILES, GIGABYTES,
	  ACTIVE_CHANNELS, START_TIME, UP_TIME, MEM_USED, REG_USERS};

    r = RegEx(data, "^([^ ]+) ([^ ]+) ([^ ]+) ([^ ]+) ([^ ]+) ([^ ]+) "
	            "([^ ]+) ([^ ]+) ([^ ]+) ([^ ]+)", 11, pmatch);
    if (r <= 0) {
	ErrMsg("DoShowServerStats: regex error");
	XtFree(timeStr);
	return;
    }

    for (i = 0, j = 1; i < 10; i++, j++) {
	if (! (len = pmatch[j].rm_eo - pmatch[j].rm_so))
	    break;
	switch (i) {
	    case START_TIME:
		tmp = (String)XtCalloc(len + 1, 1);
		strncpy(tmp, data + pmatch[j].rm_so, len);
		startTime = (time_t)atol(tmp);
		XtFree(tmp);
		tm = gmtime(&startTime);
		strftime(timeStr, 80, "%Y-%m-%d  %H:%M", tm);
		values[i] = XtNewString(timeStr);
		break;
	    case UP_TIME:
		tmp = (String)XtCalloc(len + 1, 1);
		strncpy(tmp, data + pmatch[j].rm_so, len);
		time = atol(tmp);
		XtFree(tmp);
		days = time / 86400;
		hours = (time / 3600) % 24;
		minutes = (time / 60) % 60;
		seconds = time % 60;
		dtxt = "day";
		if (days > 1)
		    dtxt = "days";
		htxt = "hr";
		if (hours > 1)
		    htxt = "hrs";
		sprintf(timeStr, "%d sec", seconds);
		if (minutes) {
		    strcpy(timeTmp, timeStr);
		    sprintf(timeStr, "%d min  %s", minutes, timeTmp);
		}
		if (hours) {
		    strcpy(timeTmp, timeStr);
		    sprintf(timeStr, "%d %s  %s", hours, htxt, timeTmp);
		}
		if (days) {
		    strcpy(timeTmp, timeStr);
		    sprintf(timeStr, "%d %s  %s", days, dtxt, timeTmp);
		}
		values[i] = XtNewString(timeStr);
		break;
	    case GIGABYTES:
		tmp = (String)XtCalloc(len + 1, 1);
		strncpy(tmp, data + pmatch[j].rm_so, len);
		kiloBytes = strtod(tmp, NULL);
		sprintf(tmp, "%.1f", kiloBytes / 1048576.0);
		values[i] = XtNewString(tmp);
		XtFree(tmp);
		break;
	    default:
		values[i] = (String)XtCalloc(len + 1, 1);
		strncpy(values[i], data + pmatch[j].rm_so, len);
	}
    }
    values[i] = NULL;

    ShowInfo("srvStats", values, 25);

    for (j = 0; j < i; j++)
        XtFree(values[j]);
    XtFree(timeStr);
}
