#ifndef SOUND_H
#define SOUND_H

#include <Xm/Xm.h>


#define RIFF		0x46464952
#define WAVE		0x45564157
#define FMT		0x20746D66
#define DATA		0x61746164
#define PCM_CODE	1
#define WAVE_MONO	1
#define WAVE_STEREO	2


typedef struct {
    int	            riffTag;
    int		    riffLength;
    int		    waveTag;
    int		    fmtTag;
    int		    fmtLength;
    unsigned short  format;
    unsigned short  channels;
    int             sampRate;
    int		    avgSampRate;
    unsigned short  align;
    unsigned short  bitsPerSample;
    int		    dataTag;
    int		    dataLength;
} WAVHDR;


#define NUM_SOUNDS 4

#define CHANMSG_SOUND 0
#define PRIVMSG_SOUND 1
#define JOIN_SOUND    2
#define PART_SOUND    3

extern String sound[NUM_SOUNDS];

WAVHDR* ReadWavHdr(int fd);
int CheckWav(String name);
void PlaySound(String name);

#endif
