/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/BulletinB.h>
#include <Xm/MessageB.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>

#include "main.h"
#include "msgbox.h"
#include "util.h"

static Widget simpleMsg = NULL;


#define YESNO_YES 1
#define YESNO_NO  2


void ErrMsg(String msg)
{
    Widget d, parent;
    Arg args[20];
    int n;
    XmString msgString;
    
    SimpleMsgRemove();
    
    parent = curFocus ? curFocus : topLevel;

    msgString = XmStringCreateLocalized(msg);

    n = 0;
    XtSetArg(args[n], XmNautoUnmanage, False); n++;
    XtSetArg(args[n], XmNdefaultPosition, False); n++;
    XtSetArg(args[n], XmNnoResize, True); n++;
    XtSetArg(args[n], XmNmessageString, msgString); n++;
    d = XmCreateErrorDialog(parent, "errMsg", args, n);
    XtUnmanageChild(XtNameToWidget(d, "Help"));
    XtUnmanageChild(XtNameToWidget(d, "Cancel"));

    XtAddCallback(d, XmNokCallback,
	    (XtCallbackProc)XtDestroyWidget, NULL);

    CenterDialog(d);
    XmStringFree(msgString);
}


void InfoMsg(String msg)
{
    Widget d, parent;
    Arg args[20];
    int n;
    XmString msgString;

    SimpleMsgRemove();
    
    parent = curFocus ? curFocus : topLevel;

    msgString = XmStringCreateLocalized(msg);

    n = 0;
    XtSetArg(args[n], XmNautoUnmanage, False); n++;
    XtSetArg(args[n], XmNdefaultPosition, False); n++;
    XtSetArg(args[n], XmNnoResize, True); n++;
    XtSetArg(args[n], XmNmessageString, msgString); n++;
    d = XmCreateInformationDialog(parent, "infoMsg", args, n);
    XtUnmanageChild(XtNameToWidget(d, "Help"));
    XtUnmanageChild(XtNameToWidget(d, "Cancel"));

    XtAddCallback(d, XmNokCallback,
	    (XtCallbackProc)XtDestroyWidget, NULL);

    CenterDialog(d);
    XmStringFree(msgString);
}


static void YesNoCB(Widget w, int *yesNo,
	XmSelectionBoxCallbackStruct *cbs)
{
    switch(cbs->reason) {
	case XmCR_OK:
	    *yesNo = YESNO_YES;
	    break;
	case XmCR_CANCEL:
        case XmCR_PROTOCOLS:
	    *yesNo = YESNO_NO;
    }

    XtDestroyWidget(XtParent(w));
}


int YesNoMsg(String msg, String dflt)
{
    Widget d, parent;
    Arg args[20];
    int n, yesNo;
    XmString msgString;
    
    parent = curFocus ? curFocus : topLevel;

    msgString = XmStringCreateLocalized(msg);

    n = 0;
    XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
    XtSetArg(args[n], XmNautoUnmanage, False); n++;
    XtSetArg(args[n], XmNdefaultPosition, False); n++;
    XtSetArg(args[n], XmNnoResize, True); n++;
    XtSetArg(args[n], XmNmessageString, msgString); n++;
    d = XmCreateQuestionDialog(parent, "yesNoMsg", args, n);
    XtUnmanageChild(XtNameToWidget(d, "Help"));
    XmStringFree(msgString);

    if (dflt) {
	XtVaSetValues(d, XmNinitialFocus, XtNameToWidget(d, dflt),
		NULL);
    }
    
    XtAddCallback(d, XmNokCallback, (XtCallbackProc)YesNoCB,
	    (XtPointer)&yesNo);
    XtAddCallback(d, XmNcancelCallback, (XtCallbackProc)YesNoCB,
	    (XtPointer)&yesNo);

    CenterDialog(d);

    yesNo = 0;
    while ((! yesNo) || (XtAppPending(appCon)))
	XtAppProcessEvent(appCon, XtIMAll);

    if (yesNo == YESNO_YES)
	return 1;
    else
	return 0;
}


static void SimpleMsgDestroyCB(Widget w, XtPointer clientData,
	XtPointer callData)
{
    simpleMsg = NULL;
}


void SimpleMsg(String msg)
{
    Widget parent;
    Arg args[20];
    int n;
    XmString msgString;
    
    SimpleMsgRemove();

    parent = curFocus ? curFocus : topLevel;

    msgString = XmStringCreateLocalized(msg);
 
    n = 0;
    XtSetArg(args[n], XmNautoUnmanage, False); n++;
    XtSetArg(args[n], XmNdefaultButtonType, XmDIALOG_NONE); n++;
    XtSetArg(args[n], XmNmessageString, msgString); n++;
    simpleMsg = XmCreateWorkingDialog(parent, "simpleMsg", args, n);
    XmStringFree(msgString);
    XtUnmanageChild(XtNameToWidget(simpleMsg, "Cancel"));
    XtUnmanageChild(XtNameToWidget(simpleMsg, "Help"));

    XtAddCallback(simpleMsg, XmNdestroyCallback,
	    (XtCallbackProc)SimpleMsgDestroyCB, NULL);

    CenterDialog(simpleMsg);
    ForceDialog(simpleMsg);
}


void SimpleMsgRemove(void)
{
    if (simpleMsg) {
	XtUnmapWidget(XtParent(simpleMsg));
	XtDestroyWidget(XtParent(simpleMsg));
	simpleMsg = NULL;
    }
}
