/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/SelectioB.h>
#include <Xm/Protocols.h>

#include "main.h"


Widget ListWin(String name, XtCallbackProc callback, XtPointer clientData)
{
    Widget shell, selBox;
    XmString xms;
    String shellName, tmp;
    
    shellName = (String)XtMalloc(strlen(name) + strlen("_popup") + 1);
    sprintf(shellName, "%s_popup", name);
    
    shell = XtVaCreatePopupShell(shellName,
	    topLevelShellWidgetClass, topLevel,
	    XmNiconPixmap, napPix,
	    NULL);

    XtFree(shellName);
    
    selBox = XtVaCreateManagedWidget(name,
	    xmSelectionBoxWidgetClass, shell, NULL);

    XtVaGetValues(selBox, XmNlistLabelString, &xms, NULL);
    XmStringGetLtoR(xms, XmFONTLIST_DEFAULT_TAG, &tmp);
    if (! strlen(tmp))
	XtUnmanageChild(XtNameToWidget(selBox, "Items"));
    XmStringFree(xms);
    XtFree(tmp);
    
    XtVaGetValues(selBox, XmNokLabelString, &xms, NULL);
    XmStringGetLtoR(xms, XmFONTLIST_DEFAULT_TAG, &tmp);
    if (strlen(tmp)) {
	XtAddCallback(selBox, XmNokCallback,
		(XtCallbackProc)callback, clientData);
    } else
	XtUnmanageChild(XtNameToWidget(selBox, "OK"));
    XmStringFree(xms);
    XtFree(tmp);

    XtVaGetValues(selBox, XmNapplyLabelString, &xms, NULL);
    XmStringGetLtoR(xms, XmFONTLIST_DEFAULT_TAG, &tmp);
    if (strlen(tmp)) {
	XtAddCallback(selBox, XmNapplyCallback,
		(XtCallbackProc)callback, clientData);
	XtManageChild(XtNameToWidget(selBox, "Apply"));
    }
    XmStringFree(xms);
    XtFree(tmp);
	
    XtAddCallback(selBox, XmNcancelCallback,
	    (XtCallbackProc)callback, clientData);
    
    XtUnmanageChild(XtNameToWidget(selBox, "Help"));
    XtUnmanageChild(XtNameToWidget(selBox, "Text"));
    XtUnmanageChild(XtNameToWidget(selBox, "Selection"));

    XtAddCallback(selBox, XmNfocusCallback,
	    (XtCallbackProc)FocusCB, NULL);

    XmAddWMProtocolCallback(shell,
	    XmInternAtom(XtDisplay(shell), "WM_DELETE_WINDOW", False),
	    (XtCallbackProc)callback, clientData);

    XtPopup(shell, XtGrabNone);

    return selBox;
}




