/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/Xm.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "main.h"
#include "connect.h"
#include "message.h"
#include "msgbox.h"
#include "linklist.h"
#include "listwin.h"
#include "util.h"

static LISTLINK *linkList = NULL;

static Widget listWin = NULL;


void DestroyLinksWin()
{
    if (listWin) {
	DestroyWin(XtParent(listWin));
	listWin = NULL;
    }
}


void ListLinksCB(Widget w, XtPointer clientData,
	XmSelectionBoxCallbackStruct *cbs)
{
    DestroyLinksWin();
}


void ListLinks(void)
{
    String p;
    
    while (linkList) {
	XtFree(linkList->data);
	p = (String)linkList;
	linkList = linkList->next;
	XtFree(p);
    }

    linkList = NULL;
    
    if (SendMsg(MSG_CLIENT_LINKS, ""))
	Disconnect(strerror(errno));
}


void AddLink(String s)
{
    LISTLINK *newLink, *linkPtr;

    newLink = XtNew(LISTLINK);
    newLink->data = XtNewString(s);
    newLink->next = NULL;
    
    if (! linkList)
	linkList = newLink;
    else {
	for (linkPtr = linkList; linkPtr->next; linkPtr = linkPtr->next);
	linkPtr->next = newLink;
    }
}


void DoListLinks(void)
{
    LISTLINK *ll;
    String srcSrv, srcPort, destSrv, destPort, hops;
    String src = XtMalloc(256), dest = XtMalloc(256);
    String via = XtMalloc(256);
    String tmp = XtMalloc(8192);
    XmString *str;
    int i, numLinks;

    DestroyLinksWin();
    if (! linkList) {
	InfoMsg("No links exist");
	goto end;
    }
    
    listWin = ListWin("linkList", (XtCallbackProc)ListLinksCB, NULL);
  
    for (numLinks = 0, ll = linkList; ll; numLinks++, ll = ll->next);
    
    str = (XmString*)XtMalloc(numLinks * sizeof(XmString));
    for (i = 0, ll = linkList; i < numLinks; i++, ll = ll->next) {
	srcSrv = strtok(ll->data, " ");
	srcPort = strtok(NULL, " ");
	destSrv = strtok(NULL, " ");
	destPort = strtok(NULL, " ");
	sprintf(dest, "%s:%s", destSrv, destPort);
	hops = strtok(NULL, " ");

	if (hops)
	    sprintf(via, "%s:%s", srcSrv, srcPort);
	else
	    strcpy(via, "DIRECT");

	sprintf(tmp, "%-35.34s%-6s%-35.34s  ", dest, hops, via);
        str[i] = XmStringCreateLocalized(tmp);
    }

    XtVaSetValues(listWin,
	    XmNlistItems, str,
	    XmNlistItemCount, numLinks,
	    NULL);
    
    for (i = 0; i < numLinks; i++)
        XmStringFree (str[i]);
    XtFree((String)str);

end:
    XtFree(src);
    XtFree(dest);
    XtFree(via);
    XtFree(tmp);
}
