/*
 *  XmNap  A Motif napster client
 *  
 *  Copyright (C) 2000 Mats Peterson
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *  
 *  Please send any comments/bug reports to
 *  matsp888@yahoo.com  (Mats Peterson)
 */

#include <Xm/Xm.h>
#include <Xm/SelectioB.h>
#include <Xm/Protocols.h>

#include "main.h"
#include "util.h"

#define INPUT_OK     1
#define INPUT_CANCEL 2

String inputString = NULL;


void GetInputCB(Widget w, int *okCancel,
	XmSelectionBoxCallbackStruct *cbs)
{
    switch(cbs->reason) {
	case XmCR_OK:
	    *okCancel = INPUT_OK;
	    XmStringGetLtoR(cbs->value, XmFONTLIST_DEFAULT_TAG,
		    &inputString);
	    break;
	case XmCR_CANCEL:
        case XmCR_PROTOCOLS:
	    *okCancel = INPUT_CANCEL;
    }

    while (! XtIsShell(w))
	w = XtParent(w);
    XtDestroyWidget(w);
}


String GetInput(String prompt, String dflt, int length)
{
    Widget dialog, parent;
    XmString promptString, dfltString;
    extern void read_name();
    Arg args[5];
    int n = 0;
    int okCancel;

    parent = curFocus ? curFocus : topLevel;

    promptString = XmStringCreateLocalized(prompt);
    
    XtSetArg(args[n], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); n++;
    XtSetArg(args[n], XmNdefaultPosition, False); n++;
    XtSetArg (args[n], XmNselectionLabelString, promptString); n++;
    XtSetArg (args[n], XmNtextColumns, length); n++;
    dialog = XmCreatePromptDialog(parent, "inputBox", args, n);
    XmStringFree(promptString);

    if (strlen(dflt)) {
	dfltString = XmStringCreateLocalized(dflt);
	XtVaSetValues(dialog, XmNtextString, dfltString, NULL);
	XmStringFree(dfltString);
    }

    XtAddCallback (dialog, XmNokCallback,
	    (XtCallbackProc)GetInputCB, (XtPointer)&okCancel);
    XtAddCallback (dialog, XmNcancelCallback,
	    (XtCallbackProc)GetInputCB, (XtPointer)&okCancel);
    XmAddWMProtocolCallback(XtParent(dialog),
	    XmInternAtom(XtDisplay(dialog), "WM_DELETE_WINDOW", False),
	    (XtCallbackProc)GetInputCB, (XtPointer)&okCancel);

    XtUnmanageChild(
        XmSelectionBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
    
    CenterDialog(dialog);

    if (inputString) {
	XtFree(inputString);
        inputString = NULL;
    }
    
    okCancel = 0;
    while ((! okCancel) || (XtAppPending(appCon)))
	XtAppProcessEvent(appCon, XtIMAll);

    if (okCancel == INPUT_OK)
	return inputString;
    else
	return "";
}


