#
#  Miscellaneous networking routines
#

package provide mpTk 0.6.15


proc mpTk::Net::SockAble {fd} {
    variable net

    if {[set r [fconfigure $fd -error]] != ""} {
	set net(sockerr) $r
    } elseif {[eof $fd]} {
	set net(sockerr) "EOF"
    } else {
	set net(sockerr) ""
    }
}


proc mpTk::Net::waitvar {var timeout} {
    variable net

    set net(afterproc) \
	    [after $timeout "upvar #0 $var x; set x Timeout"]
    tkwait variable $var
    after cancel $net(afterproc)
}


proc mpTk::Net::waitsock {fd mode timeout} {
    variable net

    set net(sockerr) ""
    set old_script [fileevent $fd $mode]
    fileevent $fd $mode [list ::mpTk::Net::SockAble $fd]
    waitvar ::mpTk::Net::net(sockerr) $timeout
    fileevent $fd $mode $old_script

    if {$net(sockerr) != ""} {
	error $net(sockerr)
    } 
}


proc mpTk::Net::writesock {fd data} {
    if {[catch {puts -nonewline $fd $data} r]} {
	error $r
    }
    if {[catch {flush $fd} r]} {
	error $r
    }
    if {[set r [fconfigure $fd -error]] != ""} {
	error $r
    }
}
