#
#  Generic info display box with titles, values and an OK button
#

package provide mpTk 0.6.15

namespace eval mpTk {
    namespace eval Info {
	namespace import ::mpTk::Misc::centerwin
    }
}


proc mpTk::Info::showinfo {w wtitle titles values titlew valuew {spacing 1.5m}} {
    variable info

    set info(oldFocus) [focus]
    catch {destroy $w}
    toplevel $w -relief raised -bd 2
    wm title $w $wtitle
    wm resizable $w false false

    frame $w.spacer -height 4m
    pack $w.spacer

    for {set i 0} {$i < [llength $titles]} {incr i} {
	frame $w.$i
	pack $w.$i -padx 5m -pady $spacing -fill x
	label $w.$i.l1 -width $titlew -anchor w \
		-text [lindex $titles $i]
	if {$valuew == 0} {
	    label $w.$i.l2 -anchor w -text [lindex $values $i]
	} else {
	    entry $w.$i.l2 -width $valuew -borderwidth 1
	    $w.$i.l2 insert end [lindex $values $i]
	    frame $w.$i.rmarg -width 1m
	    pack $w.$i.rmarg -side right
	}
	pack $w.$i.l1 $w.$i.l2 -side left
    }

    proc ExitInfo {w} {
	variable info
	catch {focus $info(oldFocus)}
	destroy $w
    }
    
    button $w.ok -text Ok -default active \
	    -command [list mpTk::Info::ExitInfo $w]
    pack $w.ok -pady 4m

    centerwin $w

    bind $w <Return> [list mpTk::Info::ExitInfo $w]
    focus $w.ok
}
