package PGopherLib::Term;

use strict;
use warnings;
use POSIX ();
use PGopherLib::Globals qw/$TERMSIZE $rows $cols/;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(initterm newtty oldtty cls clreol curpos appkeys);

my ($oldtty, $newtty);


sub initterm {
    if (defined($TERMSIZE)) {
	($cols, $rows) = ($TERMSIZE =~ /^(\d+)x(\d+)$/) or
		die "Invalid format of \$TERMSIZE string\n";
    } else {
	my $TIOCGWINSZ =
		($^O eq "linux") ? 0x5413 :
		($^O eq "solaris") ? ord('T') * 256 + 104 :
		0x40087468;
	my $winsize = pack("S4", 0, 0, 0, 0);
	ioctl(STDIN, $TIOCGWINSZ, $winsize) or die "Can't get terminal size; " .
		"you need to define \$TERMSIZE in your .pgopherrc\n";
	($rows, $cols) = unpack("SS", $winsize);
    }

    ($oldtty, $newtty) = (POSIX::Termios->new(), POSIX::Termios->new());
    $oldtty->getattr(0) or die "getattr: $!\n";
    $newtty->getattr(0) or die "getattr: $!\n";
    $newtty->setiflag($newtty->getiflag() & ~&POSIX::ICRNL);
    $newtty->setcc(&POSIX::VEOL, 015);
    $newtty->setattr(0, &POSIX::TCSANOW) or die "setattr: $!\n";
}

sub newtty {
    $newtty->setattr(0, &POSIX::TCSANOW);
}

sub oldtty {
    $oldtty->setattr(0, &POSIX::TCSANOW);
}

sub cls {
    print "\033[H\033[2J";
}

sub clreol {
    print "\033[K";
}

sub curpos {
    print "\033[$_[0];$_[1]H";
}

sub appkeys {
    my $on = shift;
    print ($on ? "\033[?1h" : "\033[?1l");
}

1;
