package PGopherLib::Main;

use strict;
use warnings;
no warnings 'exec';
use Encode qw/from_to/;
use PGopherLib::Globals qw/$HOST $PAGER $BROWSER $PDFVIEW $IMGVIEW $SNDPLAY
	$MOVPLAY $PH $TELNET $TN3270 $BOOKMARKS $PROMPT $TEXTENC @pageropt
	@history @menu $user $cwd $sigint $sigpipe $utf8/;
use PGopherLib::Init qw/init quit/;
use PGopherLib::Misc qw/msg prompt errmsg mysystem myconnect isutf8 escape
	unescape splithpts getbookmark help menu/;
use PGopherLib::Term qw/newtty oldtty cls appkeys/;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(main);


sub doit {
    my ($type, $desc, $sel, $host, $port);

    my $input = (shift =~ /^\s*(.*?)\s*$/)[0];

    SWITCH: {
	$input eq "" and return;
	$input =~ /^[Qq]$/ and quit;
	$input eq "!" and return do {cls; mysystem($ENV{'SHELL'})};
	$input =~ /^[Hh]$/ and return help;
	$input =~ /^\?\d*$/ and do {
	    if ($input =~ /\d/) {
		scalar(@menu) or return;
		my $n = substr($input, 1);
		$n < 1 || $n > scalar(@menu) and return errmsg "invalid entry";
		($type, $desc, $sel, $host, $port) = @{$menu[$n - 1]};
	    } else {
		scalar(@history) or return;
		($type, $desc, $sel, $host, $port) = @{$history[$#history]};
	    }
	    prompt "$host:$port/$type$sel ";
	    return;
	};
	$input =~ /^d?\d+$/ and do {
	    scalar(@menu) or return;
	    my $n = ($input =~ /^d?(\d+)$/)[0];
	    $n < 1 || $n > scalar(@menu) and return errmsg "invalid entry";
	    ($type, $desc, $sel, $host, $port) = @{$menu[$n - 1]};
	    $type =~ /[3i]/ and return errmsg "not a " .
		    ($input =~ /^d/ ? "downloadble" : "viewable") . " item";
	    $input =~ /^d/ and $type =~ /[1278T]/ and
		    return errmsg "not a downloadable item";
	    last;
	};
	$input eq "." and do {
	    scalar(@history) or return;
	    ($type, $desc, $sel, $host, $port) = @{$history[$#history]};
	    last;
	};
	$input eq "," and do {
	    scalar(@history) < 2 and return;
	    pop @history;
	    ($type, $desc, $sel, $host, $port) = @{$history[$#history]};
	    last;
	};
	$input eq "b" and do {
	    ($desc, $host, $port, $type, $sel) = getbookmark or return;
	    $type ne "1" and $input = 1;
	    last;
	};
	$input =~ /^B\d*$/ and do {
	    if ($input =~ /\d/) {
		scalar(@menu) or return;
		my $n = substr($input, 1);
		$n < 1 || $n > scalar(@menu) and return errmsg "invalid entry";
		($type, $desc, $sel, $host, $port) = @{$menu[$n - 1]};
	    } else {
		scalar(@history) or return;
		($type, $desc, $sel, $host, $port) = @{$history[$#history]};
	    }
	    $desc = (prompt("Description: ") or "$host:$port/$type$sel");
	    open(FILE, ">>$BOOKMARKS") or return errmsg "open: $!";
	    my $tmp = "$desc\t$host";
	    SWITCH: {
		$type eq "2" and do {$port != 105 and $tmp .= ":$port"; last};
		$type =~ /[8T]/ and do {$port != 23 and $tmp .= ":$port"; last};
		$port != 70 and $tmp .= ":$port";
	    }
	    ($type ne "1" or $sel ne "") and $tmp .= "/$type$sel";
	    print FILE "$tmp\n";
	    close(FILE);
	    return;
	};
	$desc = "";
	($host, $port, $type, $sel) = splithpts(unescape($input)) or
		return errmsg "invalid entry";
	$type ne "1" and $input = 1;
    }

    $type eq "7" and $sel !~ /\t/ and do {
	my $query = prompt("Query: ") or return;
	$sel .= "\t$query";
    };

    my $sock;
    $type !~ /[28T]/ and do {
	msg "Getting data... ";
	$sock = myconnect($host, $port) or return;
	binmode $sock;
	select($sock); $| = 1; print $sock "$sel\r\n"; select(STDOUT);
    };

    ACTION: {
	if ($type =~ /[17]/) {
	    my @tmenu = ();
	    $sigint = 0;
	    while (<$sock>) {
		s/[\r\n]+$//;
		$_ eq "." and last;
		my ($desc, $sel, $host, $port) = split(/\t/);
		my $type = substr($desc, 0, 1); $desc = substr($desc, 1);
		$desc =~ s/[\x80-\x9f]//g;
		$type eq "+" and do {
		    scalar(@tmenu) or last;
		    my @tmp = ($host, $port);
		    ($type, $desc, $sel, $host, $port) = @{$tmenu[$#tmenu]};
		    ($host, $port) = @tmp;
		};
		$sigint and last ACTION;
		push @tmenu, [$type, $desc, $sel, $host, $port];
	    }
	    @menu = @tmenu;
	    if ($input ne "." and $input ne ",") {
		push @history, [$type, $desc, $sel, $host, $port];
		scalar(@history) > 100 and splice(@history, 0, 1);
	    }
	} else {
	    my $fname;
	    if ($type eq "h" and $sel =~ /^URL:/) {
		$fname = "redirect.html";
	    } else {
		my $delim = ($sel =~ /\//) ? '/' :
			($sel =~ /\\/) ? '\\' :
			($sel =~ /:/) ? ':' :
			'/';
		$fname = (unescape($sel) =~ /^(.*[\Q$delim\E])?(.*)$/)[1];
		$fname ||= "dummy";
	    }
	    SWITCH: {
		$type eq "0" and do {
		    my $file;
		    if ($input =~ /^d/) {
			open(FILE, '>', $fname) or do
				{errmsg "open: $!"; last ACTION};
			binmode FILE;
			msg "Saving file `$fname'... ";
			$file = \*FILE;
		    } else {
			cls;
			oldtty; appkeys 1;
			open(PIPE, '|-', $PAGER, @pageropt) or do {
			    newtty; appkeys 0;
			    errmsg "open: $!";
			    last ACTION;
			};
			binmode PIPE;
			$file = \*PIPE;
		    }
		    $sigint = $sigpipe = 0;
		    while (<$sock>) {
			s/[\r\n]+$//;
			$_ eq "." and last;
			s/^\.//;
			$utf8 and do {
			    $input !~ /^d/ and (isutf8($_) or
				    from_to($_, $TEXTENC, "utf-8"));
			};
			last if $sigint || $sigpipe;
			print $file "$_\n";
		    }
		    close($file);
		    if ($input =~ /^d/) {
			$sigint and unlink $fname;
		    } else {
			newtty; appkeys 0;
			$PAGER ne "less" and
				prompt "Press RETURN to continue ";
		    }
		    last;
		};
		$type =~ /[hPgIs;]/ and do {
		    open(FILE, '>', $fname) or do
			    {errmsg "open: $!"; last ACTION};
		    binmode FILE;
		    $input =~ /^d/ and msg "Saving file `$fname'... ";
		    $sigint = 0;
		    print FILE while (read($sock, $_, 8192) and ! $sigint);
		    close(FILE);
		    $sigint and do {unlink $fname; last ACTION};
		    if ($input =~ /^\d/) {
			msg $PROMPT;
			my $r = mysystem(
			    ($type eq "h") ? ($BROWSER, "file://" .
				    escape("$cwd/$fname")) :
			    ($type eq "P") ? ($PDFVIEW, $fname) :
			    ($type =~ /[gI]/) ? ($IMGVIEW, $fname) :
			    ($type eq "s") ? ($SNDPLAY, $fname) :
			    ($MOVPLAY, $fname)
			    );
			unlink $fname;
			$r == -1 and do {errmsg "system: $!"; last ACTION};
		    }
		    last;
		};
		$type =~ /[28T]/ and do {
		    my $s = ($type eq "2") ? $PH :
			    ($type eq "8") ? $TELNET :
			    $TN3270;
		    $s =~ s/%HOST%/$host/;
		    $s =~ s/%PORT%/$port/;
		    $type eq "8" and do {
		    	my $login = ($sel or $user);
			$s =~ s/%LOGIN%/$login/;
		    };
		    cls;
		    mysystem($s) == -1 and do
			    {errmsg "system: $!"; last ACTION};
		    print "\n";
		    prompt "Press RETURN to continue ";
		    last;
		};
		open(FILE, '>', $fname) or do
			{errmsg "open: $!"; last ACTION};
		binmode FILE;
		msg "Saving file `$fname'... ";
		$sigint = 0;
		print FILE while (read($sock, $_, 8192) and ! $sigint);
		close(FILE);
		$sigint and unlink $fname;
	    }
	}
    }

    $type !~ /[28T]/ and close($sock);
}

sub main {
    init;
    cls;
    doit (scalar(@ARGV) ? $ARGV[0] : $HOST);
    while (1) {
	menu;
	doit prompt($PROMPT);
    }
}

1;
