/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Vector;

class Upload
implements Runnable,
Constants {
    public String data;
    public String fileName = null;
    public String realName = null;
    public String nick = null;
    public int tot;
    public int count;
    public int offset;
    public Shared shared;
    public Thread thread = null;
    public Socket socket = null;
    public InputStream in = null;
    public OutputStream out = null;
    public FileInputStream fileStream = null;
    public boolean ulStat = false;
    public boolean isRunning = false;
    public int ulMode = 0;

    public Upload(Socket socket) {
        this.socket = socket;
        try {
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public Upload(String string) {
        this.ulMode = 1;
        this.data = string;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void closeSocket() {
        try {
            this.in.close();
            this.out.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        int n;
        byte[] byArray = new byte[8192];
        if (this.ulMode == 1) {
            this.fwUpload();
            return;
        }
        try {
            n = this.in.read(byArray);
            if (n == -1) {
                this.closeSocket();
                return;
            }
        }
        catch (Exception exception) {
            this.closeSocket();
            return;
        }
        String string = new String(byArray, 0, n);
        this.nick = string.substring(0, string.indexOf(32));
        this.fileName = string.substring(string.indexOf(34) + 1, string.lastIndexOf(34));
        String string2 = string.substring(string.lastIndexOf(34) + 2);
        String[] stringArray = string2.split(" ");
        this.offset = Integer.parseInt(stringArray[0]);
        this.realName = this.fileName.replaceAll("\\", "/").substring(2);
        this.count = this.offset;
        this.shared = (Shared)Globals.sharedFiles.get(this.realName);
        if (this.shared == null || this.offset > this.shared.size) {
            try {
                this.out.write("FILE NOT SHARED".getBytes(), 0, 15);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Upload.endUl(this, false);
            return;
        }
        this.tot = this.shared.size;
        try {
            this.fileStream = new FileInputStream(this.realName);
        }
        catch (Exception exception) {
            Upload.endUl(this, false);
            return;
        }
        try {
            this.fileStream.skip(this.count);
        }
        catch (Exception exception) {
            Upload.endUl(this, false);
            return;
        }
        string2 = Integer.toString(this.shared.size);
        try {
            this.out.write(string2.getBytes(), 0, string2.length());
        }
        catch (Exception exception) {
            Upload.endUl(this, false);
            return;
        }
        if (!Network.sendMsg(220, "")) {
            Network.disconnect(false);
            Upload.endUl(this, false);
            return;
        }
        this.ulStat = true;
        this.addUpload();
        Upload.doUl(this);
    }

    private void fwUpload() {
        int n;
        String[] stringArray = this.data.split(" ");
        this.nick = stringArray[0];
        long l = Long.parseLong(stringArray[1]);
        String string = Util.convertIP(l);
        int n2 = Integer.parseInt(stringArray[2]);
        this.fileName = this.data.substring(this.data.indexOf(34) + 1, this.data.lastIndexOf(34));
        String string2 = this.data.substring(this.data.lastIndexOf(34) + 2);
        stringArray = string2.split(" ");
        try {
            this.socket = new Socket(string, n2);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (UnknownHostException unknownHostException) {
            Upload.unreachable(this.nick);
            return;
        }
        catch (IOException iOException) {
            return;
        }
        this.realName = this.fileName.replaceAll("\\", "/").substring(2);
        this.shared = (Shared)Globals.sharedFiles.get(this.realName);
        if (this.shared == null) {
            Upload.endUl(this, false);
            return;
        }
        this.tot = this.shared.size;
        try {
            this.fileStream = new FileInputStream(this.realName);
        }
        catch (Exception exception) {
            Upload.endUl(this, false);
            return;
        }
        byte[] byArray = new byte[1];
        if (Network.readBytes(this.in, byArray, 1) < 0) {
            Upload.endUl(this, false);
            return;
        }
        if ((char)byArray[0] != '1') {
            Upload.endUl(this, false);
            return;
        }
        try {
            this.out.write("SEND".getBytes(), 0, 3);
        }
        catch (Exception exception) {
            Upload.endUl(this, false);
            return;
        }
        string2 = Globals.userName + " \"" + this.fileName + "\" " + this.shared.size;
        try {
            this.out.write(string2.getBytes(), 0, string2.length());
        }
        catch (Exception exception) {
            Upload.endUl(this, false);
            return;
        }
        try {
            n = this.in.read(byArray);
            if (n == -1) {
                Upload.endUl(this, false);
                return;
            }
        }
        catch (Exception exception) {
            Upload.endUl(this, false);
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            if (!Character.isDigit((char)byArray[0])) {
                Upload.endUl(this, false);
                return;
            }
            ++n3;
        }
        string2 = new String(byArray, 0, n);
        this.offset = Integer.parseInt(string2);
        if (this.offset > this.shared.size) {
            Upload.endUl(this, false);
            return;
        }
        this.count = this.offset;
        try {
            this.fileStream.skip(this.count);
        }
        catch (Exception exception) {
            Upload.endUl(this, false);
            return;
        }
        if (!Network.sendMsg(220, "")) {
            Network.disconnect(false);
            Upload.endUl(this, false);
            return;
        }
        this.ulStat = true;
        this.addUpload();
        Upload.doUl(this);
    }

    private void addUpload() {
        Object[] objectArray = new Object[]{this.fileName, Integer.toString(this.shared.size), this.nick, "", "", new Integer(0), ""};
        MyTableModel myTableModel = TransferWindow.transferWindow.getModel(1);
        int n = myTableModel.data.size();
        myTableModel.addRow(n, objectArray);
        Globals.uploads.put(this.fileName + ":" + this.nick, this);
    }

    public static void removeUpload(String string, String string2) {
        MyTableModel myTableModel = TransferWindow.transferWindow.getModel(1);
        int n = Upload.findUpload(string, string2);
        if (n != -1) {
            myTableModel.deleteRow(n);
            Globals.uploads.remove(string + ":" + string2);
        }
    }

    public static void unreachable(String string) {
        if (!Network.sendMsg(626, string)) {
            Network.disconnect(false);
        }
    }

    public static int findUpload(String string, String string2) {
        MyTableModel myTableModel = TransferWindow.transferWindow.getModel(1);
        int n = 0;
        while (n < myTableModel.data.size()) {
            Vector vector = (Vector)myTableModel.data.get(n);
            String string3 = (String)vector.get(0);
            String string4 = (String)vector.get(2);
            if (string3.equals(string) && string4.equals(string2)) break;
            ++n;
        }
        if (n == myTableModel.data.size()) {
            return -1;
        }
        return n;
    }

    public static void showStatus(Upload upload, String string) {
        MyTableModel myTableModel = TransferWindow.transferWindow.getModel(1);
        int n = 0;
        while (n < myTableModel.data.size()) {
            Vector vector = (Vector)myTableModel.data.get(n);
            String string2 = (String)vector.get(0);
            String string3 = (String)vector.get(2);
            if (string2.equals(upload.fileName) && string3.equals(upload.nick)) break;
            ++n;
        }
        myTableModel.setValueAt(string, n, 3);
    }

    public static void showProgress(Upload upload, int n, String string) {
        MyTableModel myTableModel = TransferWindow.transferWindow.getModel(1);
        int n2 = 0;
        while (n2 < myTableModel.data.size()) {
            Vector vector = (Vector)myTableModel.data.get(n2);
            String string2 = (String)vector.get(0);
            String string3 = (String)vector.get(2);
            if (string2.equals(upload.fileName) && string3.equals(upload.nick)) break;
            ++n2;
        }
        myTableModel.setValueAt(new Integer(n), n2, 5);
        myTableModel.setValueAt(string, n2, 6);
    }

    public static void doUl(Upload upload) {
        byte[] byArray = new byte[8192];
        long l = -1L;
        Date date = new Date();
        Upload.showStatus(upload, "Uploading");
        do {
            int n;
            try {
                n = upload.fileStream.read(byArray);
                if (n < 0) break;
                upload.out.write(byArray, 0, n);
            }
            catch (Exception exception) {
                break;
            }
            upload.count += n;
            Date date2 = new Date();
            long l2 = (date2.getTime() - date.getTime()) / 1000L;
            if (l2 == l && upload.count != upload.tot) continue;
            int n2 = upload.count * 100 / upload.tot;
            double d = l2 != 0L ? (double)(upload.count - upload.offset) / 1024.0 / (double)l2 : 0.0;
            String string = Double.toString(d);
            String string2 = string.substring(0, string.indexOf(46) + 2);
            Upload.showProgress(upload, n2, string2);
            l = l2;
        } while (upload.count != upload.tot);
        Upload.endUl(upload, true);
    }

    public static void endUl(Upload upload, boolean bl) {
        try {
            if (upload.fileStream != null) {
                upload.fileStream.close();
                upload.fileStream = null;
            }
            if (upload.socket != null) {
                upload.in.close();
                upload.out.close();
                upload.socket.close();
                upload.socket = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl && upload.ulStat) {
            if (!Network.sendMsg(221, "")) {
                Network.disconnect(false);
            }
            upload.ulStat = false;
        }
        if (upload.count < upload.tot) {
            Upload.showStatus(upload, "Transfer Incomplete");
        } else {
            Upload.showStatus(upload, "Transfer Completed");
        }
    }
}

