/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SearchWindow
extends JPanel
implements ActionListener,
Constants {
    private static JComponent[] fields;
    private static TableCellRenderer fileRenderer;
    private static JButton searchButton;
    private static JLabel resultLabel;
    private static JPopupMenu popup;
    public static SearchWindow searchWindow;
    public static MyTableModel tableModel;
    public static TableSorter tableSorter;
    public static JTable table;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public SearchWindow() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 30));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        String[] stringArray = new String[]{"Artist", "Title", "Bitrate", "Frequency", "Max Files", "Connection"};
        JLabel[] jLabelArray = new JLabel[6];
        int n = 0;
        while (n < 6) {
            jLabelArray[n] = new JLabel(stringArray[n]);
            ++n;
        }
        int[] nArray = new int[]{25, 25, 5, 5, 5};
        fields = new JComponent[6];
        int n2 = 0;
        while (n2 < 6) {
            if (n2 < 5) {
                SearchWindow.fields[n2] = new JTextField(nArray[n2]);
                ((JTextField)fields[n2]).addActionListener(this);
            } else {
                SearchWindow.fields[n2] = new JComboBox<String>(Globals.linkStr);
            }
            ++n2;
        }
        Util.addLabelTextRows(jLabelArray, fields, gridBagLayout, jPanel);
        searchButton = new JButton("Search");
        searchButton.addActionListener(this);
        resultLabel = new JLabel();
        resultLabel.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jPanel);
        jPanel2.add(searchButton);
        jPanel2.add(resultLabel);
        String[] stringArray2 = new String[]{"File Name", "Size", "Bitrate", "Freq", "Time", "Nick", "Link"};
        tableModel = new MyTableModel(stringArray2);
        tableSorter = new TableSorter(tableModel);
        fileRenderer = new FileRenderer();
        table = new JTable(tableSorter){

            public TableCellRenderer getCellRenderer(int n, int n2) {
                if (n2 == 0) {
                    return fileRenderer;
                }
                return super.getCellRenderer(n, n2);
            }
        };
        table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = SearchWindow.class$("java.lang.String")) : class$java$lang$String, new StringRenderer());
        table.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = SearchWindow.class$("java.lang.Number")) : class$java$lang$Number, new NumberRenderer());
        tableSorter.addMouseListenerToHeaderInTable(table);
        table.setAutoResizeMode(0);
        int[] nArray2 = new int[]{550, 85, 45, 58, 58, 108, 78};
        int n3 = 0;
        while (n3 < nArray2.length) {
            serializable = table.getColumnModel().getColumn(n3);
            ((TableColumn)serializable).setPreferredWidth(nArray2[n3]);
            ++n3;
        }
        serializable = new JScrollPane(table);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)serializable, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel2, "North");
        this.add((Component)jPanel3, "Center");
        popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Download");
        jMenuItem.setActionCommand("Download");
        jMenuItem.addActionListener(this);
        popup.add(jMenuItem);
        PopupListener popupListener = new PopupListener();
        table.addMouseListener(popupListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            int[] nArray = table.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                new Download(nArray[n], null);
                ++n;
            }
            return;
        }
        Search search = new Search();
        search.artist = ((JTextField)fields[0]).getText();
        search.title = ((JTextField)fields[1]).getText();
        search.minBitrate = ((JTextField)fields[2]).getText();
        search.minFreq = ((JTextField)fields[3]).getText();
        search.maxFiles = ((JTextField)fields[4]).getText();
        search.minLink = Integer.toString(((JComboBox)fields[5]).getSelectedIndex());
        this.doSearch(search);
    }

    private void doSearch(Search search) {
        String string = "";
        if (search.artist.length() > 0) {
            string = string + "FILENAME CONTAINS \"" + search.artist + "\"";
        }
        String string2 = "500";
        if (search.maxFiles.length() > 0) {
            string2 = search.maxFiles;
        }
        string = string + " MAX_RESULTS " + string2;
        if (search.title.length() > 0) {
            string = string + " FILENAME CONTAINS \"" + search.title + "\"";
        }
        if (search.minLink.length() > 0) {
            string = string + " LINESPEED \"AT LEAST\" " + search.minLink;
        }
        if (search.minBitrate.length() > 0) {
            string = string + " BITRATE \"AT LEAST\" \"" + search.minBitrate + "\"";
        }
        if (search.minFreq.length() > 0) {
            string = string + " FREQ \"AT LEAST\" \"" + search.minFreq + "\"";
        }
        if (SearchWindow.tableModel.data.size() > 0) {
            tableModel.clear();
        }
        resultLabel.setText("Searching...");
        if (!Network.sendMsg(200, string)) {
            Network.disconnect(false);
        }
    }

    public static void addResult(String string) {
        Object[] objectArray = new Object[7];
        objectArray[0] = string.substring(string.indexOf(34) + 1, string.lastIndexOf(34));
        String string2 = string.substring(string.lastIndexOf(34) + 2);
        String[] stringArray = string2.split(" ");
        objectArray[1] = new Integer(stringArray[1]);
        objectArray[2] = new Integer(stringArray[2]);
        objectArray[3] = new Integer(stringArray[3]);
        int n = Integer.parseInt(stringArray[4]) / 60;
        String string3 = Integer.toString(n);
        if (n < 10) {
            string3 = "0" + string3;
        }
        int n2 = Integer.parseInt(stringArray[4]) % 60;
        String string4 = Integer.toString(n2);
        if (n2 < 10) {
            string4 = "0" + string4;
        }
        objectArray[4] = string3 + ":" + string4;
        objectArray[5] = stringArray[5];
        objectArray[6] = Globals.linkStr[Integer.parseInt(stringArray[7])];
        int n3 = SearchWindow.tableModel.data.size();
        tableModel.addRowNoUpdate(n3, objectArray);
    }

    public static void showResults() {
        Runnable runnable = new Runnable(){

            public void run() {
                tableModel.fireTableRowsInserted(0, SearchWindow.tableModel.data.size() - 1);
                resultLabel.setText(table.getRowCount() + " files");
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public static void create() {
        searchWindow = new SearchWindow();
        JavaNap.tabbedPane.addTab("Search", searchWindow);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                new Download(table.getSelectedRow(), null);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

