/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class PrivWindow
extends JPanel
implements ChatWindow,
ActionListener,
Constants {
    private static PrivWindow privWindow;
    private String nick;
    private JTextArea text;
    private JScrollPane textScrollPane;
    private JButton closeButton;
    private JPanel buttonPane;
    private JPopupMenu chatPopup;

    public PrivWindow(String string) {
        this.nick = string;
        this.text = new JTextArea();
        this.text.setEditable(false);
        this.text.setFont(Globals.monoFont);
        this.text.setBackground(Globals.textBackground);
        this.text.setForeground(Globals.textForeground);
        this.text.setCaretColor(Globals.textForeground);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.textScrollPane = new JScrollPane(this.text);
        this.textScrollPane.setPreferredSize(new Dimension(360, 290));
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.buttonPane = new JPanel();
        this.buttonPane.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.buttonPane.add(this.closeButton);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)this.textScrollPane, "Center");
        this.add((Component)this.buttonPane, "South");
        String[] stringArray = new String[]{"Save", "Clear"};
        this.chatPopup = new JPopupMenu();
        int n = 0;
        while (n < stringArray.length) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[n]);
            jMenuItem.setActionCommand(Integer.toString(n));
            jMenuItem.addActionListener(this);
            this.chatPopup.add(jMenuItem);
            ++n;
        }
        PopupListener popupListener = new PopupListener();
        this.text.addMouseListener(popupListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            this.handleChatPopup(actionEvent);
        } else {
            Chat.partPriv(this.nick);
        }
    }

    private void handleChatPopup(ActionEvent actionEvent) {
        int n = Integer.parseInt(actionEvent.getActionCommand());
        switch (n) {
            case 0: {
                this.saveBuffer();
                break;
            }
            case 1: {
                this.clearBuffer();
            }
        }
    }

    public void saveBuffer() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this.text.getText());
                fileWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void clearBuffer() {
        try {
            this.text.replaceRange("", 0, this.text.getLineEndOffset(this.text.getLineCount() - 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doAddText(String string, boolean bl) {
        JScrollBar jScrollBar = this.textScrollPane.getVerticalScrollBar();
        if (jScrollBar.getValue() + jScrollBar.getVisibleAmount() == jScrollBar.getMaximum()) {
            this.text.setCaretPosition(this.text.getDocument().getLength());
        } else {
            this.text.setCaretPosition(0);
        }
        if (Globals.timeStamp && !bl) {
            this.text.append("[" + Util.getDate("HH:mm") + "] ");
        }
        this.text.append(string + "\n");
        if (this.text.getLineCount() > Globals.chatBufferLines + 100) {
            try {
                this.text.replaceRange("", 0, this.text.getLineStartOffset(100));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addText(final String string, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doAddText(string, bl);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                PrivWindow.this.doAddText(string, bl);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static PrivWindow create(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            privWindow = new PrivWindow(string);
            JavaNap.tabbedPane.addTab(string, privWindow);
            JavaNap.tabbedPane.setSelectedIndex(JavaNap.tabbedPane.indexOfComponent(privWindow));
            return privWindow;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                PrivWindow.privWindow = new PrivWindow(string);
                JavaNap.tabbedPane.addTab(string, privWindow);
                JavaNap.tabbedPane.setSelectedIndex(JavaNap.tabbedPane.indexOfComponent(privWindow));
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return privWindow;
    }

    public static void doDestroy(String string) {
        ChatSession chatSession = (ChatSession)Chat.sessions.get(string);
        PrivWindow privWindow = (PrivWindow)chatSession.window;
        JavaNap.tabbedPane.remove(JavaNap.tabbedPane.indexOfComponent(privWindow));
    }

    public static void destroy(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            PrivWindow.doDestroy(string);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                PrivWindow.doDestroy(string);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                PrivWindow.this.chatPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

