/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class Network
implements Runnable,
Constants {
    private static Socket serverSocket = null;
    private static InputStream in = null;
    private static OutputStream out = null;
    private static boolean manualDisc;
    public static boolean isConnected;
    public static Thread thread;

    public static void connect(String string, int n, int n2) {
        if (thread != null && thread.isAlive()) {
            Network.disconnect(true);
        }
        Globals.curServer.name = string;
        Globals.curServer.port = n;
        Globals.curServer.meta = n2;
        manualDisc = false;
        thread = new Thread(Globals.network);
        thread.start();
    }

    public static void disconnect(boolean bl) {
        if (thread == null) {
            return;
        }
        if (bl) {
            manualDisc = true;
            Network.doDisconnectStuff();
            while (thread.isAlive()) {
                try {
                    Thread.sleep(99L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            thread = null;
            return;
        }
        if (!manualDisc) {
            Network.doDisconnectStuff();
        }
        JavaNap.setUIDisconnected();
        isConnected = false;
    }

    public static void doDisconnectStuff() {
        Chat.partAllSessions();
        Browse.destroyAllWindows();
        try {
            in.close();
            out.close();
            serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean waitReconnect() {
        int n = Globals.reconnTimeOut / 100;
        if (!Globals.autoReconnect || manualDisc) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                break;
            }
            if (manualDisc) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void doLoginStuff() {
        Command.sendAutoCommands();
    }

    public static boolean sendMsg(int n, String string) {
        try {
            byte[] byArray = new byte[2];
            int n2 = string.length();
            byArray[0] = (byte)(n2 & 0xFF);
            byArray[1] = (byte)(n2 >> 8);
            out.write(byArray, 0, 2);
            byArray[0] = (byte)(n & 0xFF);
            byArray[1] = (byte)(n >> 8);
            out.write(byArray, 0, 2);
            byArray = string.getBytes();
            out.write(byArray);
            out.flush();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static int readBytes(InputStream inputStream, byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n > 0) {
            int n4;
            try {
                n4 = inputStream.read(byArray, n2, n);
            }
            catch (IOException iOException) {
                return -1;
            }
            if (n4 <= 0) {
                return -1;
            }
            n3 += n4;
            n -= n4;
            n2 += n4;
        }
        return n3;
    }

    private static int byteToInt(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    private static String reDirect(String string, int n) {
        Socket socket;
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[1];
        boolean bl = false;
        try {
            socket = new Socket(string, n);
            in = socket.getInputStream();
            out = socket.getOutputStream();
        }
        catch (UnknownHostException unknownHostException) {
            InfoWindow.showInfo("Couldn't resolve host " + Globals.curServer.name, true);
            return null;
        }
        catch (IOException iOException) {
            InfoWindow.showInfo("Couldn't get I/O for the connection to " + Globals.curServer.name, true);
            return null;
        }
        int n2 = 0;
        while (true) {
            int n3;
            try {
                n3 = in.read(byArray2);
            }
            catch (Exception exception) {
                bl = true;
                break;
            }
            if (n3 <= 0) {
                bl = true;
                break;
            }
            if ((char)byArray2[0] == '\n') break;
            byArray[n2++] = byArray2[0];
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl ? null : new String(byArray, 0, n2);
    }

    public void run() {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = new byte[8192];
        do {
            int n;
            String string;
            String string2;
            if (Globals.curServer.meta == 1) {
                string2 = Network.reDirect(Globals.curServer.name, Globals.curServer.port);
                if (string2 == null) {
                    if (Network.waitReconnect()) continue;
                    break;
                }
                if (string2.length() == 0 || string2.indexOf(":") == -1) {
                    InfoWindow.showInfo("Got invalid string from metaserver", true);
                    if (Network.waitReconnect()) continue;
                    break;
                }
                String[] stringArray = string2.split(":");
                string = stringArray[0];
                n = Integer.parseInt(stringArray[1]);
            } else {
                string = Globals.curServer.name;
                n = Globals.curServer.port;
            }
            try {
                serverSocket = new Socket(string, n);
                in = serverSocket.getInputStream();
                out = serverSocket.getOutputStream();
            }
            catch (UnknownHostException unknownHostException) {
                InfoWindow.showInfo("Couldn't resolve host " + Globals.curServer.name, true);
                if (Network.waitReconnect()) continue;
                break;
            }
            catch (IOException iOException) {
                InfoWindow.showInfo("Couldn't get I/O for the connection to " + Globals.curServer.name, true);
                if (Network.waitReconnect()) continue;
                break;
            }
            isConnected = true;
            JavaNap.setUIConnected();
            if (Globals.registered == 0) {
                if (!Network.sendMsg(7, Globals.userName)) {
                    Network.disconnect(false);
                    if (Network.waitReconnect()) continue;
                    break;
                }
            } else {
                string2 = Globals.userName + " " + Globals.password + " " + Globals.dataPort + " \"" + Globals.clientString + "\" " + Globals.linkType;
                if (!Network.sendMsg(2, string2)) {
                    Network.disconnect(false);
                    if (Network.waitReconnect()) continue;
                    break;
                }
            }
            while (Network.readBytes(in, byArray, 2) >= 0) {
                int n2 = (Network.byteToInt(byArray[1]) << 8) + Network.byteToInt(byArray[0]);
                if (Network.readBytes(in, byArray2, 2) < 0) break;
                int n3 = (Network.byteToInt(byArray2[1]) << 8) + Network.byteToInt(byArray2[0]);
                if (Network.readBytes(in, byArray3, n2) < 0) break;
                Message.parse(new String(byArray3, 0, n2), n3);
            }
            Network.disconnect(false);
            if (!Network.waitReconnect()) break;
        } while (Globals.autoReconnect && !manualDisc);
    }

    static {
        isConnected = false;
        thread = null;
    }
}

