/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JavaNap
extends JFrame
implements ActionListener,
ChangeListener,
Constants {
    private static JMenuBar menuBar;
    private static JMenu menu;
    private static JMenu submenu;
    private static JMenuItem menuItem;
    private static JCheckBoxMenuItem cbMenuItem;
    private static JButton[] buttons;
    private static String[] images;
    private static String[] titles;
    private static ImageIcon[] icons;
    private static JTextField serverEntry;
    private static int lastTabIndex;
    public static ChatTextField input;
    public static JavaNap mainWindow;
    public static JTabbedPane tabbedPane;
    public static StatusBar statusBar;
    static /* synthetic */ Class class$JavaNap;

    public JavaNap() {
        this.setTitle("JavaNap");
        URL uRL = (class$JavaNap == null ? (class$JavaNap = JavaNap.class$("JavaNap")) : class$JavaNap).getResource("images/JavaNap.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setIconImage(imageIcon.getImage());
        this.setDefaultCloseOperation(0);
        this.buildMenu();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.addButtons(jToolBar);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jToolBar, gridBagConstraints);
        jPanel.add(jToolBar);
        JLabel jLabel = new JLabel("Server:");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        serverEntry = new JTextField(20);
        serverEntry.addActionListener(this);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagLayout.setConstraints(serverEntry, gridBagConstraints);
        jPanel.add(serverEntry);
        tabbedPane = new JTabbedPane();
        tabbedPane.setFont(Globals.propFont);
        tabbedPane.addChangeListener(this);
        InfoWindow.create();
        SearchWindow.create();
        TransferWindow.create();
        tabbedPane.setEnabledAt(1, false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        input = new ChatTextField();
        input.addActionListener(this);
        input.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 9) {
                    return;
                }
                String string = input.getText();
                Completion.completeCommandOrNick(string);
            }
        });
        input.setFont(Globals.monoFont);
        input.setBackground(Globals.inputBackground);
        input.setForeground(Globals.inputForeground);
        input.setCaretColor(Globals.inputForeground);
        jPanel2.add(input);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 6)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)tabbedPane, "Center");
        jPanel3.add((Component)jPanel2, "South");
        JPanel jPanel4 = (JPanel)this.getContentPane();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        jPanel4.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        statusBar = new StatusBar(3);
        jPanel4.add((Component)statusBar, "South");
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                Point point = JavaNap.this.getLocation();
                Config.props.put("main_x", Integer.toString(point.x));
                Config.props.put("main_y", Integer.toString(point.y));
            }

            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = JavaNap.this.getSize();
                Config.props.put("main_width", Integer.toString(dimension.width));
                Config.props.put("main_height", Integer.toString(dimension.height));
            }
        });
    }

    private void buildMenu() {
        menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        menu = new JMenu("File");
        menu.setFont(Globals.propFont);
        menu.setMnemonic(70);
        menuBar.add(menu);
        menuItem = new JMenuItem("Exit", 88);
        menuItem.setFont(Globals.propFont);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu = new JMenu("Edit");
        menu.setFont(Globals.propFont);
        menu.setMnemonic(69);
        menuBar.add(menu);
        menuItem = new JMenuItem("Preferences", 80);
        menuItem.setFont(Globals.propFont);
        menuItem.addActionListener(this);
        menu.add(menuItem);
    }

    private void addButtons(JToolBar jToolBar) {
        buttons = new JButton[4];
        icons = new ImageIcon[4];
        int n = 0;
        while (n < 4) {
            URL uRL = (class$JavaNap == null ? JavaNap.class$("JavaNap") : class$JavaNap).getResource("images/" + images[n] + ".gif");
            JavaNap.icons[n] = new ImageIcon(uRL);
            JavaNap.buttons[n] = new JButton(icons[n]);
            if (n < 3) {
                jToolBar.add(buttons[n]);
                buttons[n].setToolTipText(titles[n]);
                buttons[n].setActionCommand(images[n]);
                buttons[n].addActionListener(this);
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            this.menuAction(actionEvent);
            return;
        }
        if (actionEvent.getSource() instanceof JButton) {
            this.buttonAction(actionEvent);
            return;
        }
        if (actionEvent.getSource() == serverEntry) {
            String string = serverEntry.getText();
            Command.parse("/server " + string);
            return;
        }
        String string = input.getText();
        input.setText("");
        if (string.length() == 0) {
            return;
        }
        if (string.charAt(0) == '/') {
            Command.parse(string);
        } else {
            if (Chat.curSession == null) {
                return;
            }
            String string2 = tabbedPane.getTitleAt(tabbedPane.getSelectedIndex());
            int n = Chat.curSession.window instanceof ChannelWindow ? 402 : 205;
            String[] stringArray = string.split("\u0000");
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (n == 205) {
                    Chat.curSession.window.addText(stringArray[n2], false);
                }
                if (!Network.sendMsg(n, string2 + " " + stringArray[n2])) {
                    Network.disconnect(false);
                    return;
                }
                ++n2;
            }
        }
    }

    private void menuAction(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getText();
        if (string.equals("Exit")) {
            JavaNap.quit();
        }
    }

    private void buttonAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("connect")) {
            Network.connect(Globals.curServer.name, Globals.curServer.port, Globals.curServer.meta);
        } else if (string.equals("disconnect")) {
            Network.disconnect(true);
        } else if (!string.equals("config")) {
            if (string.equals("quit")) {
                JavaNap.quit();
            } else {
                ((JTextField)actionEvent.getSource()).setText("");
                Command.parse(string);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        int n = tabbedPane.getSelectedIndex();
        String string = tabbedPane.getTitleAt(n);
        ChatSession chatSession = (ChatSession)Chat.sessions.get(string);
        if (chatSession != null) {
            Chat.curSession = chatSession;
            if (chatSession.window instanceof ChannelWindow) {
                this.setTitle(chatSession.name + "  " + chatSession.topic);
            } else {
                this.setTitle(chatSession.name);
            }
        } else {
            Chat.curSession = null;
            this.setTitle(string);
        }
        tabbedPane.setForegroundAt(n, Color.BLACK);
    }

    public static void setUIConnected() {
        Runnable runnable = new Runnable(){

            public void run() {
                buttons[0].setIcon(icons[3]);
                buttons[0].setToolTipText(titles[3]);
                buttons[0].setActionCommand(images[3]);
                tabbedPane.setEnabledAt(1, true);
                tabbedPane.setEnabledAt(2, true);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public static void doSetUIDisconnected() {
        buttons[0].setIcon(icons[0]);
        buttons[0].setToolTipText(titles[0]);
        buttons[0].setActionCommand(images[0]);
        statusBar.setText(0, " ");
        statusBar.setText(1, " ");
        statusBar.setText(2, " ");
        tabbedPane.setEnabledAt(1, false);
        tabbedPane.setEnabledAt(2, false);
        tabbedPane.setSelectedIndex(0);
    }

    public static void setUIDisconnected() {
        if (SwingUtilities.isEventDispatchThread()) {
            JavaNap.doSetUIDisconnected();
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                JavaNap.doSetUIDisconnected();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private static void setFocus() {
        input.requestFocusInWindow();
    }

    private static void quit() {
        int n = JOptionPane.showConfirmDialog(mainWindow, "Do you really want to quit?", "JavaNap", 0);
        if (n == 0) {
            Config.write();
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        Config.read();
        mainWindow = new JavaNap();
        mainWindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JavaNap.quit();
            }

            public void windowOpened(WindowEvent windowEvent) {
                JavaNap.setFocus();
            }
        });
        mainWindow.pack();
        mainWindow.setLocation(Globals.mainX, Globals.mainY);
        mainWindow.setSize(Globals.mainWidth, Globals.mainHeight);
        mainWindow.setVisible(true);
        Globals.network = new Network();
        Globals.dataSocket = new DataSocket(Globals.dataPort);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        images = new String[]{"connect", "config", "quit", "disconnect"};
        titles = new String[]{"Connect To Server", "Configure JavaNap", "Exit Program", "Disconnect From Server"};
        lastTabIndex = -1;
    }
}

