/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class InfoWindow
extends JPanel {
    public static InfoWindow infoWindow;
    private static JTextArea text;
    private static JPanel contentPane;

    public InfoWindow() {
        text = new JTextArea();
        text.setEditable(false);
        text.setFont(Globals.monoFont);
        text.setBackground(Globals.textBackground);
        text.setForeground(Globals.textForeground);
        text.setCaretColor(Globals.textForeground);
        JScrollPane jScrollPane = new JScrollPane(text);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    private static void doShowInfo(String string, boolean bl) {
        text.setCaretPosition(text.getDocument().getLength());
        if (Globals.timeStamp && !bl) {
            text.append("[" + Util.getDate("HH:mm") + "] ");
        }
        text.append(string + "\n");
        if (text.getLineCount() > 500) {
            try {
                text.replaceRange("", 0, text.getLineStartOffset(100));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (JavaNap.tabbedPane.getSelectedIndex() != 0) {
            JavaNap.tabbedPane.setForegroundAt(0, Color.BLUE);
        }
    }

    public static void showInfo(final String string, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            InfoWindow.doShowInfo(string, bl);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                InfoWindow.doShowInfo(string, bl);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void create() {
        infoWindow = new InfoWindow();
        JavaNap.tabbedPane.addTab("Info", infoWindow);
        JavaNap.tabbedPane.setSelectedIndex(0);
    }
}

