/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import java.util.Vector;

class Download
implements Constants {
    public Vector data = new Vector();
    public String fileName = null;
    public String dlName = null;
    public String nick = null;
    public int tot;
    public int count;
    public int offset;
    public Thread thread = null;
    public Socket socket = null;
    public InputStream in = null;
    public OutputStream out = null;
    public FileOutputStream fileStream = null;
    public boolean dlStat = false;
    public boolean isRunning = false;

    public Download(int n, String string) {
        int n2;
        Constants constants;
        if (string != null) {
            constants = (BrowseWindow)Browse.windows.get(string.toLowerCase());
            n2 = 0;
            while (n2 < constants.tableModel.getColumnCount()) {
                this.data.add(constants.tableSorter.getValueAt(n, n2));
                ++n2;
            }
            this.data.add(string);
            this.nick = string;
        } else {
            int n3 = 0;
            while (n3 < SearchWindow.tableModel.getColumnCount()) {
                this.data.add(SearchWindow.tableSorter.getValueAt(n, n3));
                ++n3;
            }
            this.nick = (String)this.data.get(5);
        }
        this.fileName = (String)this.data.get(0);
        this.tot = (Integer)this.data.get(1);
        constants = (Download)Globals.downloads.get(this.fileName + ":" + this.nick);
        if (constants != null) {
            if (((Download)constants).isRunning) {
                return;
            }
            Download.removeDownload(this.fileName, this.nick);
        }
        this.isRunning = true;
        this.addDownload();
        Download.showStatus(this, "Initiating");
        if (this.tot == 0) {
            Download.abortDl(this, false, "File size is 0 bytes");
            this.isRunning = false;
            return;
        }
        n2 = 0;
        n2 = this.fileName.lastIndexOf(92);
        if (n2 == -1) {
            n2 = this.fileName.lastIndexOf(47);
        }
        String string2 = this.fileName.substring(n2 + 1);
        this.offset = 0;
        String string3 = Globals.dlDir + File.separator + string2;
        File file = new File(string3);
        if (file.exists()) {
            if ((int)file.length() == this.tot) {
                Download.abortDl(this, false, "File is complete");
                return;
            }
            this.offset = (int)file.length();
        }
        this.dlName = string3;
        if (!Network.sendMsg(203, this.nick + " " + "\"" + this.fileName + "\"")) {
            Network.disconnect(false);
            Download.abortDl(this, false, "");
        }
    }

    private void addDownload() {
        Object[] objectArray = new Object[]{(String)this.data.get(0), (Integer)this.data.get(1), (String)this.data.get(5), "", new Integer(0), ""};
        MyTableModel myTableModel = TransferWindow.transferWindow.getModel(0);
        int n = myTableModel.data.size();
        myTableModel.addRow(n, objectArray);
        Globals.downloads.put(this.fileName + ":" + this.nick, this);
    }

    public static void removeDownload(String string, String string2) {
        MyTableModel myTableModel = TransferWindow.transferWindow.getModel(0);
        int n = Download.findDownload(string, string2);
        if (n != -1) {
            myTableModel.deleteRow(n);
            Globals.downloads.remove(string + ":" + string2);
        }
    }

    public static void unreachable(String string) {
        if (!Network.sendMsg(626, string)) {
            Network.disconnect(false);
        }
    }

    public static int findDownload(String string, String string2) {
        MyTableModel myTableModel = TransferWindow.transferWindow.getModel(0);
        int n = 0;
        while (n < myTableModel.data.size()) {
            Vector vector = (Vector)myTableModel.data.get(n);
            String string3 = (String)vector.get(0);
            String string4 = (String)vector.get(2);
            if (string3.equals(string) && string4.equals(string2)) break;
            ++n;
        }
        if (n == myTableModel.data.size()) {
            return -1;
        }
        return n;
    }

    public static void showStatus(Download download, String string) {
        MyTableModel myTableModel = TransferWindow.transferWindow.getModel(0);
        int n = 0;
        while (n < myTableModel.data.size()) {
            Vector vector = (Vector)myTableModel.data.get(n);
            String string2 = (String)vector.get(0);
            String string3 = (String)vector.get(2);
            if (string2.equals(download.fileName) && string3.equals(download.nick)) break;
            ++n;
        }
        myTableModel.setValueAt(string, n, 3);
    }

    public static void showProgress(Download download, int n, String string) {
        MyTableModel myTableModel = TransferWindow.transferWindow.getModel(0);
        int n2 = 0;
        while (n2 < myTableModel.data.size()) {
            Vector vector = (Vector)myTableModel.data.get(n2);
            String string2 = (String)vector.get(0);
            String string3 = (String)vector.get(2);
            if (string2.equals(download.fileName) && string3.equals(download.nick)) break;
            ++n2;
        }
        myTableModel.setValueAt(new Integer(n), n2, 4);
        myTableModel.setValueAt(string, n2, 5);
    }

    public static void doDl(Download download, boolean bl) {
        byte[] byArray = new byte[8192];
        long l = -1L;
        download.count = bl ? download.offset : download.offset + 1;
        Date date = new Date();
        Download.showStatus(download, "Downloading");
        do {
            int n;
            try {
                n = download.in.read(byArray);
                if (n < 0) break;
                download.fileStream.write(byArray, 0, n);
            }
            catch (Exception exception) {
                break;
            }
            download.count += n;
            Date date2 = new Date();
            long l2 = (date2.getTime() - date.getTime()) / 1000L;
            if (l2 == l && download.count != download.tot) continue;
            int n2 = download.count * 100 / download.tot;
            double d = l2 != 0L ? (double)(download.count - download.offset) / 1024.0 / (double)l2 : 0.0;
            String string = Double.toString(d);
            String string2 = string.substring(0, string.indexOf(46) + 2);
            Download.showProgress(download, n2, string2);
            l = l2;
        } while (download.count != download.tot);
        Download.endDl(download, true, false);
    }

    public static void endDl(Download download, boolean bl, boolean bl2) {
        if (!download.isRunning) {
            return;
        }
        download.isRunning = false;
        try {
            if (download.fileStream != null) {
                download.fileStream.close();
                download.fileStream = null;
            }
            if (download.socket != null) {
                download.in.close();
                download.out.close();
                download.socket.close();
                download.socket = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl2 && download.dlName != null) {
            try {
                File file = new File(download.dlName);
                file.delete();
                download.dlName = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl && download.dlStat) {
            if (!Network.sendMsg(219, "")) {
                Network.disconnect(false);
            }
            download.dlStat = false;
        }
        if (bl2) {
            Download.showStatus(download, "Transfer Aborted");
        } else if (download.count < download.tot) {
            Download.showStatus(download, "Transfer Incomplete");
        } else {
            Download.showStatus(download, "Transfer Completed");
        }
    }

    public static void abortDl(Download download, boolean bl, String string) {
        Download.endDl(download, bl, true);
        if (string.length() > 0) {
            Download.showStatus(download, string);
        }
    }
}

