/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class Config
implements Constants {
    static String fileName = "javanap.properties";
    public static Properties props;

    private static void getServers() {
        String string = props.getProperty("servers");
        if (string.length() == 0) {
            return;
        }
        String[] stringArray = string.split(" +");
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n].split(":");
            if (stringArray2.length < 3) {
                System.err.println("Invalid/missing data in " + fileName);
                System.exit(1);
            }
            Server server = new Server();
            server.name = stringArray2[0];
            server.port = Integer.parseInt(stringArray2[1]);
            server.meta = Integer.parseInt(stringArray2[2]);
            Globals.servers.add(server);
            ++n;
        }
    }

    private static void getAutoCommands() {
        String string = props.getProperty("autocommands");
        if (string.length() == 0) {
            return;
        }
        String[] stringArray = string.split(" *: *");
        int n = 0;
        while (n < stringArray.length) {
            Globals.autoCommands.add(stringArray[n]);
            ++n;
        }
    }

    private static Font getFont(String string) {
        int n = 0;
        String string2 = props.getProperty(string);
        String[] stringArray = string2.split(":");
        if (stringArray.length < 3) {
            System.err.println("Invalid/missing data in " + fileName);
            System.exit(1);
        }
        String string3 = stringArray[0];
        int n2 = Integer.parseInt(stringArray[1]);
        string2 = stringArray[2];
        if (string2.equals("plain")) {
            n = 0;
        } else if (string2.equals("bold")) {
            n = 1;
        }
        Font font = new Font(string3, n, n2);
        return font;
    }

    private static Color getColor(String string) {
        String string2 = props.getProperty(string);
        String[] stringArray = string2.split(":");
        if (stringArray.length < 3) {
            System.err.println("Invalid/missing data in " + fileName);
            System.exit(1);
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        Color color = new Color(n, n2, n3);
        return color;
    }

    public static void read() {
        FileInputStream fileInputStream;
        Properties properties = null;
        try {
            properties = new Properties();
            fileInputStream = new FileInputStream("defaultProperties");
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Can't find default properties file");
            System.exit(1);
        }
        props = new Properties(properties);
        try {
            fileInputStream = new FileInputStream("appProperties");
            props.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Globals.userName = props.getProperty("username");
            Globals.password = props.getProperty("password");
            Globals.dataPort = Integer.parseInt(props.getProperty("dataport"));
            Globals.linkType = Integer.parseInt(props.getProperty("linktype"));
            Globals.registered = Integer.parseInt(props.getProperty("registered"));
            Globals.dlDir = props.getProperty("dldir");
            if (Globals.dlDir.length() == 0) {
                Globals.dlDir = System.getProperty("user.home");
            }
            Config.getServers();
            Globals.autoReconnect = new Boolean(props.getProperty("auto_reconnect"));
            Globals.reconnTimeOut = Integer.parseInt(props.getProperty("reconn_timeout"));
            Config.getAutoCommands();
            Globals.chatBufferLines = Integer.parseInt(props.getProperty("chatbufferlines"));
            Globals.monoFont = Config.getFont("monofont");
            Globals.propFont = Config.getFont("propfont");
            Globals.labelFont = Config.getFont("labelfont");
            Globals.listFont = Config.getFont("listfont");
            Globals.textBackground = Config.getColor("textbackground");
            Globals.textForeground = Config.getColor("textforeground");
            Globals.inputBackground = Config.getColor("inputbackground");
            Globals.inputForeground = Config.getColor("inputforeground");
            Globals.sounds[0] = props.getProperty("chanmsg_sound");
            Globals.sounds[1] = props.getProperty("nickmsg_sound");
            Globals.sounds[2] = props.getProperty("privmsg_sound");
            Globals.sounds[3] = props.getProperty("join_sound");
            Globals.sounds[4] = props.getProperty("part_sound");
            Globals.mainX = Integer.parseInt(props.getProperty("main_x"));
            Globals.mainY = Integer.parseInt(props.getProperty("main_y"));
            Globals.mainWidth = Integer.parseInt(props.getProperty("main_width"));
            Globals.mainHeight = Integer.parseInt(props.getProperty("main_height"));
            Globals.cwDividerLoc = Integer.parseInt(props.getProperty("cw_dividerloc"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Invalid/missing data in " + fileName);
            System.exit(1);
        }
        Globals.curServer = (Server)Globals.servers.get(0);
    }

    public static void write() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("appProperties");
            props.store(fileOutputStream, "---JavaNap application properties---");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

