/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class Chat
implements Constants {
    public static Hashtable sessions = new Hashtable();
    public static ChatSession curSession = null;

    public static void joinChannel(String string) {
        if (!Network.sendMsg(400, string)) {
            Network.disconnect(false);
        }
    }

    public static void doJoinChannel(String string) {
        ChatSession chatSession = new ChatSession();
        chatSession.name = string;
        chatSession.topic = "";
        chatSession.window = ChannelWindow.create(string);
        sessions.put(string, chatSession);
        curSession = chatSession;
    }

    public static void partChannel(String string) {
        if (!Network.sendMsg(401, string)) {
            Network.disconnect(false);
        }
    }

    public static void doPartChannel(String string) {
        int n = JavaNap.tabbedPane.getSelectedIndex();
        ChannelWindow.destroy(string);
        sessions.remove(string);
        if (JavaNap.tabbedPane.getSelectedIndex() == n) {
            Chat.setTab();
        }
    }

    public static void joinPriv(String string) {
        ChatSession chatSession = new ChatSession();
        chatSession.name = string;
        chatSession.topic = "";
        chatSession.window = PrivWindow.create(string);
        sessions.put(string, chatSession);
        curSession = chatSession;
        JavaNap.mainWindow.setTitle(string);
    }

    public static void partPriv(String string) {
        int n = JavaNap.tabbedPane.getSelectedIndex();
        PrivWindow.destroy(string);
        sessions.remove(string);
        if (JavaNap.tabbedPane.getSelectedIndex() == n) {
            Chat.setTab();
        }
    }

    public static void partAllSessions() {
        Enumeration enumeration = sessions.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ChatSession chatSession = (ChatSession)sessions.get(string);
            if (chatSession.window instanceof ChannelWindow) {
                Chat.doPartChannel(string);
                continue;
            }
            Chat.partPriv(string);
        }
        curSession = null;
    }

    public static void doSetTab() {
        int n = JavaNap.tabbedPane.getSelectedIndex();
        String string = JavaNap.tabbedPane.getTitleAt(n);
        ChatSession chatSession = (ChatSession)sessions.get(string);
        if (chatSession != null) {
            curSession = chatSession;
            if (chatSession.window instanceof ChannelWindow) {
                JavaNap.mainWindow.setTitle(chatSession.name + "  " + chatSession.topic);
            } else {
                JavaNap.mainWindow.setTitle(chatSession.name);
            }
        } else {
            curSession = null;
            JavaNap.mainWindow.setTitle(string);
        }
        JavaNap.tabbedPane.setForegroundAt(n, Color.BLACK);
    }

    public static void setTab() {
        if (SwingUtilities.isEventDispatchThread()) {
            Chat.doSetTab();
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Chat.doSetTab();
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void rcvGlobal(int n, String string) {
        ChatSession chatSession = null;
        String[] stringArray = string.split(" ", 2);
        String string2 = stringArray[0];
        String string3 = "";
        if (stringArray.length > 1) {
            string3 = stringArray[1];
        }
        if ((chatSession = n == 205 ? (ChatSession)sessions.get(string2) : curSession) == null) {
            switch (n) {
                case 205: {
                    Chat.joinPriv(string2);
                    Chat.curSession.window.addText("> " + string3, false);
                    if (Globals.sounds[2].length() != 0) {
                        new SoundClip(Globals.sounds[2]);
                    }
                    return;
                }
                case 627: {
                    InfoWindow.showInfo("OPERATOR MESSAGE from " + string2 + ": " + string3, false);
                    return;
                }
                case 628: {
                    InfoWindow.showInfo("GLOBAL MESSAGE from " + string2 + ": " + string3, false);
                    return;
                }
                case 751: {
                    if (!Network.sendMsg(752, string2)) {
                        Network.disconnect(false);
                    }
                    return;
                }
                case 752: {
                    String string4 = Ping.getPingTime(string2);
                    if (string4 == null) {
                        return;
                    }
                    InfoWindow.showInfo("PONG received from " + string2 + ": " + string4, false);
                    return;
                }
            }
        }
        switch (n) {
            case 205: {
                chatSession.window.addText("> " + string3, false);
                if (chatSession != curSession) {
                    int n2 = JavaNap.tabbedPane.indexOfComponent((PrivWindow)chatSession.window);
                    JavaNap.tabbedPane.setForegroundAt(n2, Color.RED);
                }
                if (Globals.sounds[2].length() == 0) break;
                new SoundClip(Globals.sounds[2]);
                break;
            }
            case 627: {
                chatSession.window.addText("*** OPERATOR MESSAGE from " + string2 + ": " + string3, false);
                break;
            }
            case 628: {
                chatSession.window.addText("*** GLOBAL MESSAGE from " + string2 + ": " + string3, false);
                break;
            }
            case 751: {
                chatSession.window.addText("*** " + string2 + " PING", false);
                if (Network.sendMsg(752, string2)) break;
                Network.disconnect(false);
                break;
            }
            case 752: {
                String string5 = Ping.getPingTime(string2);
                if (string5 == null) break;
                chatSession.window.addText("*** PONG received from " + string2 + ": " + string5, false);
            }
        }
    }

    public static void rcvChannel(int n, String string) {
        String string2 = null;
        boolean bl = false;
        String[] stringArray = string.split(" ", 2);
        String string3 = stringArray[0];
        String string4 = "";
        if (stringArray.length > 1) {
            string4 = stringArray[1];
        }
        ChatSession chatSession = (ChatSession)sessions.get(string3);
        switch (n) {
            case 403: {
                String string5;
                stringArray = string4.split(" ", 2);
                String string6 = stringArray[0];
                string2 = "";
                if (stringArray.length > 1) {
                    string2 = stringArray[1];
                }
                chatSession.window.addText("<" + string6 + "> " + string2, false);
                boolean bl2 = bl = string2.toLowerCase().indexOf(Globals.userName.toLowerCase()) != -1;
                if (string6.equals(Globals.userName)) break;
                String string7 = string5 = bl ? Globals.sounds[1] : Globals.sounds[0];
                if (string5.length() == 0) break;
                new SoundClip(string5);
                break;
            }
            case 410: {
                chatSession.topic = string2 = string4;
                if (chatSession != curSession) break;
                JavaNap.mainWindow.setTitle(string3 + " " + string2);
                break;
            }
            case 824: {
                stringArray = string4.split(" ", 2);
                String string8 = stringArray[0];
                string2 = "";
                if (stringArray.length > 1) {
                    string2 = stringArray[1].replaceAll("\"", "");
                }
                chatSession.window.addText("* " + string8 + " " + string2, false);
                boolean bl3 = bl = string2.toLowerCase().indexOf(Globals.userName.toLowerCase()) != -1;
            }
        }
        if (chatSession != curSession && n != 410) {
            int n2 = JavaNap.tabbedPane.indexOfComponent((ChannelWindow)chatSession.window);
            if (JavaNap.tabbedPane.getForegroundAt(n2).equals(Color.RED)) {
                return;
            }
            Color color = bl ? Color.RED : Color.BLUE;
            JavaNap.tabbedPane.setForegroundAt(n2, color);
        }
    }

    public static void updateUserList(final int n, final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                int n2;
                String[] stringArray = string.split(" ");
                String string7 = stringArray[0];
                String string2 = stringArray[1];
                String string3 = stringArray[2];
                String string4 = stringArray[3];
                ChatSession chatSession = (ChatSession)sessions.get(string7);
                if (chatSession == null) {
                    System.err.println("\"" + string7 + "\": no such channel");
                    return;
                }
                MyTableModel myTableModel = ((ChannelWindow)chatSession.window).tableModel;
                if (n == 406 || n == 408) {
                    Object object;
                    n2 = 0;
                    while (n2 < myTableModel.data.size()) {
                        object = (Vector)myTableModel.data.get(n2);
                        String string5 = (String)((Vector)object).get(0);
                        if (string2.compareToIgnoreCase(string5) < 0) break;
                        ++n2;
                    }
                    object = new Object[]{string2, new Integer(string3), Globals.linkStr[Integer.parseInt(string4)]};
                    myTableModel.addRow(n2, (Object[])object);
                    if (n == 406) {
                        chatSession.window.addText("*** " + string2 + " has joined channel " + string7, false);
                        if (Globals.sounds[3].length() != 0) {
                            new SoundClip(Globals.sounds[3]);
                        }
                    }
                } else {
                    n2 = 0;
                    while (n2 < myTableModel.data.size()) {
                        Vector vector = (Vector)myTableModel.data.get(n2);
                        String string6 = (String)vector.get(0);
                        if (string6.equals(string2)) break;
                        ++n2;
                    }
                    if (n2 < myTableModel.data.size()) {
                        myTableModel.deleteRow(n2);
                    }
                    chatSession.window.addText("*** " + string2 + " has left channel " + string7, false);
                    if (Globals.sounds[4].length() != 0) {
                        new SoundClip(Globals.sounds[4]);
                    }
                }
                if (chatSession != curSession) {
                    n2 = JavaNap.tabbedPane.indexOfComponent((ChannelWindow)chatSession.window);
                    JavaNap.tabbedPane.setForegroundAt(n2, Color.BLUE);
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

