/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class ChannelWindow
extends JPanel
implements ChatWindow,
ActionListener,
Constants {
    private static ChannelWindow channelWindow;
    private String channel;
    private JTable list;
    private JTextArea text;
    private JScrollPane textScrollPane;
    private JButton closeButton;
    private JPanel buttonPane;
    private JSplitPane splitPane;
    private JPopupMenu chatPopup;
    private JPopupMenu userPopup;
    public MyTableModel tableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public ChannelWindow(String string) {
        JMenuItem jMenuItem;
        Serializable serializable;
        this.channel = string;
        this.text = new JTextArea();
        this.text.setEditable(false);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setFont(Globals.monoFont);
        this.text.setBackground(Globals.textBackground);
        this.text.setForeground(Globals.textForeground);
        this.text.setCaretColor(Globals.textForeground);
        this.textScrollPane = new JScrollPane(this.text);
        this.textScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Globals.cwDividerLoc = ChannelWindow.this.splitPane.getDividerLocation();
                Config.props.put("cw_dividerloc", Integer.toString(Globals.cwDividerLoc));
            }
        });
        String[] stringArray = new String[]{"Nick", "Shared", "Link"};
        this.tableModel = new MyTableModel(stringArray);
        this.list = new JTable(this.tableModel);
        this.list.setShowGrid(false);
        this.list.setIntercellSpacing(new Dimension(0, 1));
        this.list.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = ChannelWindow.class$("java.lang.String")) : class$java$lang$String, new StringRenderer());
        this.list.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = ChannelWindow.class$("java.lang.Number")) : class$java$lang$Number, new NumberRenderer());
        this.list.setSelectionMode(0);
        this.list.getTableHeader().setFont(Globals.listFont);
        this.list.setFont(Globals.listFont);
        this.list.setAutoResizeMode(0);
        int[] nArray = new int[]{110, 70, 78};
        int n = 0;
        while (n < nArray.length) {
            serializable = this.list.getColumnModel().getColumn(n);
            ((TableColumn)serializable).setPreferredWidth(nArray[n]);
            ++n;
        }
        serializable = new JScrollPane(this.list);
        ((JScrollPane)serializable).getViewport().setBackground(Color.WHITE);
        this.splitPane = new JSplitPane(1, this.textScrollPane, (Component)serializable);
        this.splitPane.setDividerLocation(Globals.cwDividerLoc);
        this.splitPane.setResizeWeight(1.0);
        Dimension dimension = new Dimension(100, 50);
        this.textScrollPane.setMinimumSize(dimension);
        ((JComponent)serializable).setMinimumSize(dimension);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.buttonPane = new JPanel();
        this.buttonPane.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.buttonPane.add(this.closeButton);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.add((Component)this.buttonPane, "South");
        String[] stringArray2 = new String[]{"Save", "Clear"};
        this.chatPopup = new JPopupMenu();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            jMenuItem = new JMenuItem(stringArray2[n2]);
            jMenuItem.setActionCommand(Integer.toString(n2));
            jMenuItem.addActionListener(this);
            this.chatPopup.add(jMenuItem);
            ++n2;
        }
        String[] stringArray3 = new String[]{"Message", "Whois", "Browse", "Ping", "Op", "DeOp", "Muzzle", "Unmuzzle", "Kick", "Kill", "Ban"};
        this.userPopup = new JPopupMenu();
        int n3 = 0;
        while (n3 < stringArray3.length) {
            jMenuItem = new JMenuItem(stringArray3[n3]);
            jMenuItem.setActionCommand(Integer.toString(n3));
            jMenuItem.addActionListener(this);
            this.userPopup.add(jMenuItem);
            ++n3;
        }
        PopupListener popupListener = new PopupListener();
        this.text.addMouseListener(popupListener);
        this.list.addMouseListener(popupListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            Container container = ((JMenuItem)actionEvent.getSource()).getParent();
            if (container == this.chatPopup) {
                this.handleChatPopup(actionEvent);
            } else {
                this.handleUserPopup(actionEvent);
            }
        } else {
            Chat.partChannel(this.channel);
        }
    }

    private void handleChatPopup(ActionEvent actionEvent) {
        int n = Integer.parseInt(actionEvent.getActionCommand());
        switch (n) {
            case 0: {
                this.saveBuffer();
                break;
            }
            case 1: {
                this.clearBuffer();
            }
        }
    }

    public void saveBuffer() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this.text.getText());
                fileWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void clearBuffer() {
        try {
            this.text.replaceRange("", 0, this.text.getLineEndOffset(this.text.getLineCount() - 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleUserPopup(ActionEvent actionEvent) {
        String string = null;
        String string2 = null;
        ChatSession chatSession = Chat.curSession;
        int n = this.list.getSelectedRow();
        Vector vector = (Vector)this.tableModel.data.get(n);
        String string3 = (String)vector.get(0);
        if (string3 == null) {
            return;
        }
        int n2 = Integer.parseInt(actionEvent.getActionCommand());
        switch (n2) {
            case 0: {
                String string4 = JOptionPane.showInputDialog(null, "Message", "Private Message", -1);
                if (string4 == null) {
                    return;
                }
                string2 = "/msg " + string3 + " " + string4;
                break;
            }
            case 1: {
                string2 = "/whois " + string3;
                break;
            }
            case 2: {
                string2 = "/browse " + string3;
                break;
            }
            case 3: {
                string2 = "/ping " + string3;
                break;
            }
            case 4: {
                string2 = "/op " + chatSession.name + " " + string3;
                break;
            }
            case 5: {
                string2 = "/deop " + chatSession.name + " " + string3;
                break;
            }
            case 6: {
                string = JOptionPane.showInputDialog(null, "Reason", "Muzzle", -1);
                if (string == null) {
                    return;
                }
                string2 = "/muzzle " + string3 + " " + string;
                break;
            }
            case 7: {
                string2 = "/unmuzzle " + string3;
                break;
            }
            case 8: {
                string = JOptionPane.showInputDialog(null, "Reason", "Kick", -1);
                if (string == null) {
                    return;
                }
                string2 = "/kick " + chatSession.name + " " + string3 + " " + string;
                break;
            }
            case 9: {
                string = JOptionPane.showInputDialog(null, "Reason", "Kill", -1);
                if (string == null) {
                    return;
                }
                string2 = "/kill " + string3 + " " + string;
                break;
            }
            case 10: {
                string = JOptionPane.showInputDialog(null, "Reason", "Ban", -1);
                if (string == null) {
                    return;
                }
                string2 = "/ban " + string3 + " " + string;
            }
        }
        Command.parse(string2);
    }

    public void doAddText(String string, boolean bl) {
        JScrollBar jScrollBar = this.textScrollPane.getVerticalScrollBar();
        if (jScrollBar.getValue() + jScrollBar.getVisibleAmount() == jScrollBar.getMaximum()) {
            this.text.setCaretPosition(this.text.getDocument().getLength());
        } else {
            this.text.setCaretPosition(0);
        }
        if (Globals.timeStamp && !bl) {
            this.text.append("[" + Util.getDate("HH:mm") + "] ");
        }
        this.text.append(string + "\n");
        if (this.text.getLineCount() > Globals.chatBufferLines + 100) {
            try {
                this.text.replaceRange("", 0, this.text.getLineStartOffset(100));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addText(final String string, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doAddText(string, bl);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ChannelWindow.this.doAddText(string, bl);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static ChannelWindow create(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                ChannelWindow.channelWindow = new ChannelWindow(string);
                JavaNap.tabbedPane.addTab(string, channelWindow);
                JavaNap.tabbedPane.setSelectedIndex(JavaNap.tabbedPane.indexOfComponent(channelWindow));
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return channelWindow;
    }

    public static void doDestroy(String string) {
        ChatSession chatSession = (ChatSession)Chat.sessions.get(string);
        ChannelWindow channelWindow = (ChannelWindow)chatSession.window;
        JavaNap.tabbedPane.remove(JavaNap.tabbedPane.indexOfComponent(channelWindow));
    }

    public static void destroy(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            ChannelWindow.doDestroy(string);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                ChannelWindow.doDestroy(string);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = ChannelWindow.this.list.getSelectedRow();
                Vector vector = (Vector)ChannelWindow.this.tableModel.data.get(n);
                String string = (String)vector.get(0);
                if (string == null) {
                    return;
                }
                String string2 = JOptionPane.showInputDialog(null, "Message", "Private Message", -1);
                if (string2 == null) {
                    return;
                }
                Command.parse("/msg " + string + " " + string2);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = mouseEvent.getSource() == ChannelWindow.this.text ? ChannelWindow.this.chatPopup : ChannelWindow.this.userPopup;
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

