/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class BrowseWindow
extends JPanel
implements ActionListener,
Constants {
    private static BrowseWindow browseWindow;
    private JTable table;
    private TableCellRenderer fileRenderer;
    private JLabel resultLabel = new JLabel("Getting files...");
    private JPopupMenu popup;
    private String nick;
    public MyTableModel tableModel;
    public TableSorter tableSorter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;

    public BrowseWindow() {
        Serializable serializable;
        this.resultLabel.setBorder(BorderFactory.createEmptyBorder(1, 5, 5, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.resultLabel);
        String[] stringArray = new String[]{"File Name", "Size", "Bitrate", "Freq", "Time"};
        this.tableModel = new MyTableModel(stringArray);
        this.tableSorter = new TableSorter(this.tableModel);
        this.fileRenderer = new FileRenderer();
        this.table = new JTable(this.tableSorter){

            public TableCellRenderer getCellRenderer(int n, int n2) {
                if (n2 == 0) {
                    return BrowseWindow.this.fileRenderer;
                }
                return super.getCellRenderer(n, n2);
            }
        };
        this.table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = BrowseWindow.class$("java.lang.String")) : class$java$lang$String, new StringRenderer());
        this.table.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = BrowseWindow.class$("java.lang.Number")) : class$java$lang$Number, new NumberRenderer());
        this.tableSorter.addMouseListenerToHeaderInTable(this.table);
        this.table.setAutoResizeMode(0);
        int[] nArray = new int[]{550, 85, 45, 58, 58};
        int n = 0;
        while (n < nArray.length) {
            serializable = this.table.getColumnModel().getColumn(n);
            ((TableColumn)serializable).setPreferredWidth(nArray[n]);
            ++n;
        }
        serializable = new JScrollPane(this.table);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        jPanel2.add(jButton);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)serializable, "Center");
        this.add((Component)jPanel2, "South");
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Download");
        jMenuItem.setActionCommand("Download");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        PopupListener popupListener = new PopupListener();
        this.table.addMouseListener(popupListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            int[] nArray = this.table.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                new Download(nArray[n], this.nick);
                ++n;
            }
            return;
        }
        BrowseWindow.destroy(this.nick);
    }

    public static void addResult(String string) {
        String string2 = string.substring(0, string.indexOf(34) - 1);
        BrowseWindow browseWindow = (BrowseWindow)Browse.windows.get(string2.toLowerCase());
        if (browseWindow == null) {
            return;
        }
        if (!browseWindow.nick.equals(string2)) {
            browseWindow.nick = string2;
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = string.substring(string.indexOf(34) + 1, string.lastIndexOf(34));
        String string3 = string.substring(string.lastIndexOf(34) + 2);
        String[] stringArray = string3.split(" ");
        objectArray[1] = new Integer(stringArray[1]);
        objectArray[2] = new Integer(stringArray[2]);
        objectArray[3] = new Integer(stringArray[3]);
        int n = Integer.parseInt(stringArray[4]) / 60;
        String string4 = Integer.toString(n);
        if (n < 10) {
            string4 = "0" + string4;
        }
        int n2 = Integer.parseInt(stringArray[4]) % 60;
        String string5 = Integer.toString(n2);
        if (n2 < 10) {
            string5 = "0" + string5;
        }
        objectArray[4] = string4 + ":" + string5;
        int n3 = browseWindow.tableModel.data.size();
        browseWindow.tableModel.addRowNoUpdate(n3, objectArray);
    }

    public static void showResults(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                BrowseWindow browseWindow = (BrowseWindow)Browse.windows.get(string.toLowerCase());
                if (browseWindow == null) {
                    return;
                }
                browseWindow.tableModel.fireTableRowsInserted(0, browseWindow.tableModel.data.size() - 1);
                browseWindow.resultLabel.setText(browseWindow.table.getRowCount() + " files");
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public static void doCreate(String string) {
        browseWindow = new BrowseWindow();
        BrowseWindow.browseWindow.nick = string;
        JavaNap.tabbedPane.addTab("Browse " + string, browseWindow);
        JavaNap.tabbedPane.setSelectedIndex(JavaNap.tabbedPane.indexOfComponent(browseWindow));
    }

    public static void create(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            BrowseWindow.doCreate(string);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    BrowseWindow.doCreate(string);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
        Browse.windows.put(string.toLowerCase(), browseWindow);
    }

    public static void doDestroy(String string) {
        BrowseWindow browseWindow = (BrowseWindow)Browse.windows.get(string.toLowerCase());
        JavaNap.tabbedPane.remove(JavaNap.tabbedPane.indexOfComponent(browseWindow));
    }

    public static void destroy(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            BrowseWindow.doDestroy(string);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    BrowseWindow.doDestroy(string);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
        Browse.windows.remove(string.toLowerCase());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                new Download(BrowseWindow.this.table.getSelectedRow(), BrowseWindow.this.nick);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                BrowseWindow.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

