/* [file.h]																*/
/*																			*/
/* Copyright(C) 2002-2003, SHARP CORPORATION, All rights reserved.			*/
/*																			*/
/* This file is used for SL-series Zaurus PIM application. 		            */
/* This file is provided AS-IS for those who needs to know the details,		*/
/* and no technical support is assumed.			                            */

#ifndef	_FILE_H_INCLUDED

/***********************************************************************
  include
***********************************************************************/

#include	"sharpgen.h"
#include	"abort.h"
#include	"ioercode.h"

/***********************************************************************

***********************************************************************/

#define FILE_HEADER_SIZE		4

 
#define OFS_FILE_HEADER_ID		0
#define OFS_FILE_ID				(OFS_FILE_HEADER_ID + 2)
#define OFS_FILE_ID_VERSION		(OFS_FILE_ID + 1)

#define FILE_HEADER_ID			0x00ff


#define FILE_ID_OAPPLI			0x0a	
#define FILE_ID_BOX		       	0x10	
#define FILE_ID_OIDX			0x11	
#define FILE_ID_OTDX			0x12	
#define FILE_ID_BRD		       	0x13	
#define FILE_ID_GKS		       	0x14	
#define FILE_ID_MSG		       	0x15	
#define FILE_ID_CLIP			0x16	
#define FILE_ID_SYSTEM			0x17	
#define FILE_ID_CHECK			0x18	
#define FILE_ID_TASK			0x19	
#define FILE_ID_APPLI			0x1a	
#define FILE_ID_IDX		       	0x1b	
#define FILE_ID_TDX		       	0x1c	
#define FILE_ID_ROBJ			0x1d	
#define FILE_ID_GAIJI			0x1e	
#define FILE_ID_FDX		       	0x1f	
#define FILE_ID_EX_APPLI		0x20	
#define FILE_ID_MARKER			0x21	
#define FILE_ID_FLASH_TOOL		0x22	
#define FILE_ID_PRTDRV			0x23	
#define FILE_ID_PREFERENCE		0x24	
#define FILE_ID_LOADBIN			0x25	
#define FILE_ID_DL_ARCH			0x26	
#define	FILE_ID_PATCH_FILE		0x27	
#define	FILE_ID_ZIP_DIC			0x28	
#define	FILE_ID_ERC_FILE		0x29	
#define	FILE_ID_LITEM_FILE		0x2a	
#define	FILE_ID_ARRAYFILE		0x2b	
#define	FILE_ID_ZAM_FILE		0x2c	
#define	FILE_ID_POF_FILE		0x2d	
#define	FILE_ID_ZCRP_SECURE_FILE       	0x2e	


#define FILE_ID_RES				FILE_ID_MSG



#define RES_FVER_OLD			0x00
#define RES_FVER_CRIMSON		0x10
#define RES_FVER_PERIDOT		0x20	
#define	RES_FVER_COLLIE			0x30	


#define DL_ARCH_FVER_01			0x01
#define DL_ARCH_FVER_02			0x02	


typedef struct ZBINFHEAD {
	USHORT	headerMark;			
	UCHAR	fileMagic;			
	UCHAR	fileVersion;		
} ZBINFHEAD;


#define FC_OPEN_USE_CACHE			0x30	/* open */
#define FC_OPEN_NO_USE_CACHE		0x31
#define FC_BLOCK_READ_USE_CACHE		0x32	/* block read */
#define FC_BLOCK_READ_NO_USE_CACHE	0x33
#define FC_BLOCK_WRITE_USE_CACHE	0x34	/* block write */
#define FC_BLOCK_WRITE_NO_USE_CACHE	0x35
#define FC_OFS_READ_USE_CACHE		0x36	/* ofs read */
#define FC_OFS_READ_NO_USE_CACHE	0x37
#define FC_OFS_WRITE_USE_CACHE		0x38	/* ofs write */
#define FC_OFS_WRITE_NO_USE_CACHE	0x39

#define	FC_INIT				0x40	
#define	FC_CREATE			0x41	
#define	FC_OPEN				0x42	
#define	FC_CLOSE			0x43	
#define	FC_BLOCK_READ		        0x44	
#define	FC_BLOCK_WRITE		        0x45	
#define	FC_BYTE_READ		        0x46	/* 1byte read */
#define	FC_BYTE_WRITE		        0x47	/* 1byte write */
#define	FC_VERIFY			0x48	/* block verify */
#define	FC_ND_READ			0x49	
#define	FC_MOVE_PTR			0x4a	
#define	FC_INFO_READ		        0x4b	
#define	FC_DIR_ACC			0x4c	
#define	FC_SEARCH			0x4d	
#define	FC_RENAME			0x4e	
#define	FC_DELETE			0x4f	
#define	FC_FREE				0x50	
#define	FC_FORMAT			0x51	
#define	FC_SWAP_HNDL		0x52	
#define	FC_DUP_HNDL			0x53	
#define	FC_FILE_FLAG		0x54	
#define FC_OFS_READ			0x55	
#define FC_OFS_WRITE		0x56	
#define FC_GET_ABORT_MASK	0x57	
#define FC_SET_ABORT_MASK	0x58	

#define FC_GENERAL_BY_HNDL_WITH_SEMAPHORE	0x59
#define FC_GENERAL_BY_HNDL_NON_SEMAPHORE	0x5a
#define FC_GENERAL_BY_NAME_WITH_SEMAPHORE	0x5b
#define FC_GENERAL_BY_NAME_NON_SEMAPHORE	0x5c


typedef ULONG	FSUBCMD;		


#define FCGEN_COMMON_MAKE_DIR		'nMKD'	
#define FCGEN_COMMON_REMOVE_DIR		'nRMD'	
#define FCGEN_COMMON_SEARCH_DIR		'nSCD'	

#define FCGEN_COMMON_GET_SECTOR		'hGSC'	


#define	FCS_CMP_WILD_DN			0x11	

#define	FCS_CALC_NEW_F_PTR		0x13	
#define	FCS_CNV_DN_FN			0x14	
#define	FCS_CNV_FN_DN			0x15	

#define	FCS_GET_SAME_DV_FCB		0x17	

#define	FCS_IS_WITH_WILD_DN		0x19	
#define	FCS_GET_FIRST_FCB		0x1a	
#define	FCS_GET_NEXT_FCB		0x1b	
#define	FCS_FILE_CHECK			0x1c	
#define FCS_FCB_ADR_TO_FILE_HD	0x1d	
#define FCS_FILE_HD_TO_FCB_ADR	0x1e	
#define	FCS_DRIVE_NUMBER_TO_NAME	0x1f	

#define FCS_F_OPEN_SUB			0x20	
#define FCS_F_CLOSE_SUB			0x21
#define FCS_GET_OPENED_FILE_NUM	0x22
#define	FCS_FILE_HDL_TO_FCB_NO	0x23	

#define	FCS_CACHE_SETUP			0x28	
#define	FCS_CACHE_EXIT			0x29	
#define	FCS_CACHE_SET_WRITE_THROUGH	0x2a	
#define	FCS_CACHE_DELETE_DRIVE	0x2b	
#define	FCS_CACHE_DELETE_FILE	0x2c	
#define	FCS_CACHE_SET_PAGE_SIZE	0x2d	
#define	FCS_CACHE_SET_LIMIT_MEM_SIZE	0x2e
#define	FCS_CACHE_SET_PAGE_NUM	0x2f	

#define	HANDLE_NOT_USE	0x0ff


#define DRIVENAME_LEN	5	
#define	DFNAME_LEN	19

#define LONG_DFNAME_LEN		256
#define LONGFN_DFNAME_LEN	264	


typedef	USHORT	FTIME;		
typedef	USHORT	FDATE;		

typedef long	ERRORCODE;	
typedef	long	FILEHDERROR;	

typedef	USHORT	DIRNO;		
typedef	UCHAR	FILEHD;		


typedef UCHAR	FILEFLAG;

#define	VERIFY_BIT		0x01	
#define	THROUGH_BIT		0x02	


typedef	UCHAR	DEVTYPE;

#define FILECTRL_DEV	0x80	
#define	IRREGL_DEV		0x40	
#define	CHAR_DEV		0x20	
#define DFLT_ASC_DEV	0x10	
#define	CANT_RW_DEV		0x04	
#define CAN_W_DEV		0x02	
#define CAN_R_DEV		0x01	


typedef	UCHAR	FILEATR;

#define	PROTECT_FILE	0x01	
#define	INV_FILE		0x02	
#define	SYSTEM_FILE		0x04	
#define	WRITE_ALREADY	0x20	

#define	USUAL_FILE		0	


typedef	UCHAR	FOPENMODE;

#define	INV_OPEN_MASK	0x80
#define	DUP_OPEN_MASK	0x40
#define RW_OPEN_MASK	0x03

#define	R_OPEN			0x01
#define	W_OPEN			0x02
#define	RW_OPEN			(R_OPEN+W_OPEN)
#define	R_OPEN_INV		(INV_OPEN_MASK+R_OPEN)
#define	W_OPEN_INV		(INV_OPEN_MASK+W_OPEN)
#define	RW_OPEN_INV		(INV_OPEN_MASK+RW_OPEN)


typedef	UCHAR	FREADMODE;

#define	FC_FILE_END_1A		0	
#define	FC_FILE_END_PH		1	

#define	FC_ASCII_FILE_END	0x1A	


typedef	UCHAR	FMOVEMODE;

#define	FC_FROM_FILETOP		0	
#define	FC_FROM_NOWPOS		1	
#define	FC_FROM_FILEEND		2	


typedef	UCHAR	FINFOMODE;

#define	FC_INFO_FCB		0	/* Size,Pointer,DevType,OpenMode */
#define	FC_INFO_DFNAME	1	/* DriveName + FileName */
#define FC_INFO_FILE	2	/* Time,Date,FileAtr */

typedef	UCHAR	FACCMODE;

#define	FC_ACC_READ		0
#define	FC_ACC_WRITE	1


typedef struct FINFOFCB {
	ULONG		Size;
	ULONG		Pointer;
	DEVTYPE		DevType;
	FOPENMODE	OpenMode;
} FINFOFCB;

typedef struct FINFOFILE {
	FTIME	Time;
	FDATE	Date;
	FILEATR	Atr;
#ifndef ZDCX_PADDING
	char	zdcDummy;
#endif
}
#ifndef ZDCX_PADDING
__attribute__((packed))
#endif
FINFOFILE;

typedef	union FINFOBUF {		
	FINFOFCB	iFCB;		
	UCHAR		iDFName[256];	
	FINFOFILE	iFile;		
} FINFOBUF;


typedef	struct FDIRBUF {		
	ULONG	Size;
	FTIME	Time;
	FDATE	Date;
	FILEATR	Atr;
} FDIRBUF;


typedef	UCHAR	FSEARCHBEHAV;	

#define	FC_SEARCH_NEXT			0	
#define	FC_SEARCH_PREV			1	
#define	FC_SEARCH_INV_NEXT		0x80	
#define	FC_SEARCH_INV_PREV		0x81	

typedef	struct FSEARCHMODE {
	DIRNO			DirNo;	
	FSEARCHBEHAV	Behav;		
} FSEARCHMODE;


typedef struct COMMENTINFO {
	ULONG	CommentMax;		
	int		Rsv[3];
} COMMENTINFO;


/* FileSearchDir */
typedef struct FSUBPARAM_SEARCH_DIR {
	FSEARCHMODE	*pSearchMode;
	UCHAR	*sFoundName;
} FSUBPARAM_SEARCH_DIR;

/* FileGetSector */
typedef struct FSUBPARAM_GET_SECTOR {
	ULONG	Offset;			
	ULONG	Address;		
	ULONG	Continuous;		
} FSUBPARAM_GET_SECTOR;

/***********************************************************************

***********************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif

FILEHDERROR FileCreate(UCHAR *,FILEATR);
FILEHDERROR FileOpen(UCHAR *,FOPENMODE);
ERRORCODE FileClose(FILEHD);
ERRORCODE FileBlockRead(FILEHD,FREADMODE,UCHAR *,ULONG *);
ERRORCODE FileBlockWrite(FILEHD,UCHAR *,ULONG *);
ERRORCODE FileByteRead(FILEHD,FREADMODE,UCHAR *);
ERRORCODE FileByteWrite(FILEHD,UCHAR);
ERRORCODE FileVerify(FILEHD,FREADMODE,UCHAR *,ULONG *);
ERRORCODE FileNdRead(FILEHD,FREADMODE,UCHAR *);
ERRORCODE FileMovePtr(FILEHD,FMOVEMODE,long);
ERRORCODE FileInfoRead(FILEHD,FINFOMODE,FINFOBUF *);
ERRORCODE FileDirAcc(UCHAR *,FACCMODE,FDIRBUF *);
ERRORCODE FileSearch(UCHAR *,FSEARCHMODE *,UCHAR *);
ERRORCODE FileRename(UCHAR *,UCHAR *);
ERRORCODE FileDelete(UCHAR *);
long FileFree(UCHAR *);
ERRORCODE FileFormat(UCHAR *);
ERRORCODE FileSwapHndl(FILEHD,FILEHD);
FILEHDERROR FileDupHndl(FILEHD);
FILEFLAG FileFileFlag(FACCMODE,FILEFLAG);
#if MAY_BE_DELETE
ERRORCODE FileGetAbortMask(FILEHD,ABORTMASK*);
ERRORCODE FileSetAbortMask(FILEHD,ABORTMASK);
#endif

FILEHDERROR	FileOpenUseCache( UCHAR sFileName[], FOPENMODE OpenMode );
FILEHDERROR	FileOpenNoUseCache( UCHAR sFileName[], FOPENMODE OpenMode );
ERRORCODE	FileBlockReadUseCache( FILEHD FileHd, FREADMODE ReadMode, UCHAR sBuf[], ULONG *pLen );
ERRORCODE	FileBlockReadNoUseCache( FILEHD FileHd, FREADMODE ReadMode, UCHAR sBuf[],ULONG *pLen );
ERRORCODE	FileBlockWriteUseCache( FILEHD FileHd, UCHAR sBuf[], ULONG *pLen );
ERRORCODE	FileBlockWriteNoUseCache( FILEHD FileHd, UCHAR sBuf[], ULONG *pLen );
ERRORCODE	FileOfsReadUseCache( FILEHD FileHd, long Ofs, UCHAR sBuf[], ULONG *pLen );
ERRORCODE	FileOfsReadNoUseCache( FILEHD FileHd, long Ofs, UCHAR sBuf[], ULONG *pLen );
ERRORCODE	FileOfsWriteUseCache( FILEHD FileHd, long Ofs, UCHAR sBuf[], ULONG *pLen );
ERRORCODE	FileOfsWriteNoUseCahe( FILEHD FileHd, long Ofs, UCHAR sBuf[], ULONG *pLen );


ERRORCODE	FileCacheSetup(ULONG limit_mem_size,ULONG cache_size,UCHAR *select_file,
						  ULONG page_num);
ERRORCODE	FileCacheExit(void);
ERRORCODE	FileCacheSetWriteThrough(UCHAR *file_name,UCHAR wt_mode);
ERRORCODE	FileCacheDeleteDrive(UCHAR *drive_name);
ERRORCODE	FileCacheDeleteFile(UCHAR *file_name);
ULONG		FileCacheSetPageSize(UCHAR *filename,ULONG size);

ERRORCODE	FileMakeDir( UCHAR sDirName[] );
ERRORCODE	FileRemoveDir( UCHAR sDirName[] );
ERRORCODE	FileSearchDir( UCHAR sSearchName[], FSEARCHMODE *pSearchMode, UCHAR sFoundName[] );
ERRORCODE	FileGetSector( FILEHD FileHd, ULONG Offset, ULONG *pAddress, ULONG *pContinuous );

int GetOpenedFileNum(void);
void FileGetRealPath(UCHAR *result,const UCHAR *fName);
ERRORCODE	FileLockForWrite(FILEHD fileHdl);

ERRORCODE FileIncrementSearch(unsigned char *name, 
							  FSEARCHMODE *sm, unsigned char *fname);

/* Do not use these functions in applications                  */
ERRORCODE FileGeneralByHndlWithSemaphore( FILEHD FileHd, FSUBCMD SubCmd, void *pParam );
ERRORCODE FileGeneralByHndlNonSemaphore( FILEHD FileHd, FSUBCMD SubCmd, void *pParam );
ERRORCODE FileGeneralByNameWithSemaphore( UCHAR sName[], FSUBCMD SubCmd, void *pParam );
ERRORCODE FileGeneralByNameNonSemaphore( UCHAR sName[], FSUBCMD SubCmd, void *pParam );

void GetBuiltinStorageDtmPath(char *path);
void GetExternalStorageDtmPath(char *path);

#if defined(__cplusplus)
}
#endif


#define	STD_OUT		0x00
#define	STD_IN		0x01
#define	STD_L		0x02
#define	STD_ER		0x03

#define FC_DIR_READ		FC_ACC_READ
#define FC_DIR_WRITE	FC_ACC_WRITE
#define FC_FFLAG_READ	FC_ACC_READ
#define FC_FFLAG_WRITE	FC_ACC_WRITE
#define INV_OPEN		INV_OPEN_MASK
#define DUP_OPEN		DUP_OPEN_MASK

#define	_FILE_H_INCLUDED
#endif
