/* [dtmlib.h]																*/
/*																			*/
/* Copyright(C) 2002-2003, SHARP CORPORATION, All rights reserved.			*/
/*																			*/
/* This file is a part of DTM (DaTa Manager) used for SL-series Zaurus		*/
/* PIM application. This file is provided AS-IS for those who needs to		*/
/* know the details of DTM, and no technical support is assumed.			*/

#ifndef	_DTM_LIB_DEFINED
#define	_DTM_LIB_DEFINED

/*======================================================================
    include
======================================================================*/

#include "sharpgen.h"
#include "file.h"		

#include "zdtmtypes.h"

/*======================================================================
    Types, Labels definitions
======================================================================*/

#if !defined(_WS_QWS_)
typedef	HANDLE	BOXHANDLE;
typedef	HANDLE	IDXHANDLE;
#else
typedef	void	**BOXHANDLE;
typedef	void	**IDXHANDLE;
#endif

typedef ULONG	DATALEN;		
#if defined(CARDID_32BIT)
typedef	ULONG	CARDID;			/* CardID */
#else
typedef	USHORT	CARDID;			/* CardID */
#endif
typedef CARDID	INDEXNO;		/* IndexNo */
typedef	UCHAR	ITEMNAME[4];	        /* ITEM Name */
typedef UCHAR	ITEMTITLE[38];	        /* ITEM Title */
typedef UCHAR	VOLUMENAME[3];	        /* Volume Name */
typedef UCHAR	DTMFSTAT;		/* DTM File Status */
typedef	UCHAR	CATEGORYID;		/* Category ID */

/* File Name Length */
#define	DTM_FILE_LEN		LONG_DFNAME_LEN		

/* System Card */
#define	DTM_SYSTEM_CARD_ID		0xff00	/* Temporary System card */

#define	RESUME_SYSTEM_CARD_ID	0xff10	/* Resume */

#if defined(CARDID_32BIT)
#define DTM_FROM_TOP_CARDID		(0)
#define DTM_FROM_LAST_CARDID	(0xffffffff)
#else
#define DTM_FROM_TOP_CARDID		(0)
#define DTM_FROM_LAST_CARDID	(0xffff)
#endif

/* CARD Struct */
typedef struct CARD {
	CARDID		CardID;
	ITEMNAME	ItemName;
}
#ifndef ZDCX_PADDING
__attribute__((packed))
#endif
CARD;

/* ITEM Information Definition */
typedef	struct ITEMDATA {
 	DATATYPE	DataID;
 	CONVTYPE	ConvID;
 	ITEMNAME	ItemName;
 	ITEMTITLE	ItemTitle;
} ITEMDATA;

/* Attribute */
#define	ATTR_DELETE			0x40	/* Deleted Data */
#define	ATTR_MARK			0x80	/* SECRET */

/* Index File Type */
typedef UCHAR	IDXFTYPE;
#define	MASTER_INDEX		0x11
#define	TEMP_INDEX			0x12

/* Index File Information */
typedef USHORT IDXINFOTYPE;
#define	INDEX_INFO_NAME		((USHORT)0x01)
#define	INDEX_INFO_SORT		((USHORT)0x02)
#define	INDEX_INFO_INSPECT	((USHORT)0x03)
/* NOTE: Synchronization information used 0x04-0x0d. */

#define	INDEX_INFO_ADD		((USHORT)0x20)	/* Index add mode */
#define INDEX_INFO_LANGUAGE	((USHORT)0x21)	/* Language Mode */
#define INDEX_INFO_SORTVER	((USHORT)0x22)	/* Sort Logic Version */
#define		IDX_SORT_VERSION	(0x01)
/* NOTE: 0x80- is reserved in internal */

/* Do not use the followings */
#define BOX_NAME		INDEX_INFO_NAME
#define SORT_EXPRS		INDEX_INFO_SORT
#define SEARCH_EXPRS	INDEX_INFO_INSPECT

/* Index add mode should use one of the followings. */
#define	IDX_TYPE_MAINTAIN_ON_SORT_AUTO_ADD	0	/* Default*/
#define	IDX_TYPE_MAINTAIN_ON_GROUP	       	1	
#define	IDX_TYPE_MAINTAIN_ON_SORT_DONT_ADD	2	



#define	INDEX_INFO_SEARCH_EX	(USHORT)0x80	        /* Search condition intermediate code */
#define	INDEX_INFO_SORT_EX		(USHORT)0x81	/* Sort condition intermediate code*/

/* File name format*/
#define	IDX_NAME_BASE			1		/* File name only8+'.'+3+00*/
#define	IDX_NAME_PATH			2		/* Path + File Name*/
#define	IDX_NAME_FULL			3		/* Drive Letter + Path + File Name */


#define	IDX_TYPE_ADD_DEFAULT				3

/*======================================================================
    Error ID
======================================================================*/

typedef USHORT	DTMERR;			/* DTM Error */
#define	DTM_NO_ERR		0x00

#define	S_PRT_DRV		0x20	/* PROTECT_CARD_ERROR */
#define	S_DRV_NF		0x21	/* NO_CARD_ERROR */

#define	S_FILE_NF		0x40	/* BLOCK_NOT_FOUND_ERROR */
#define	S_PRT_FILE		0x41	/* PROTECT_BLOCK_ERROR */
#define	S_DATA_NF		0x42	/* DATA_NOT_FOUND_ERROR */
#define	S_SAME_FILE		0x43	/* SAME_BLOCK_EXIST_ERROR */
#define	S_MEM_ERR		0x44	/* NO_ENOUGH_SIZE_ERROR */

#define	S_BAD_FORM		0x45	/* ERROR in condition */
#define	S_BUF_FULL		0x46	/* Buffer size over */
#define S_STACK_OVR		0x47	/* Stack over */
#define	S_SAME_DATA		0x48	/* includes same data */
#define	S_BAD_NAME		0x49	/* ITEM name includes bad character */

#define	S_RNG_OVR		0x23	/* OUT_OF_RANGE_ERROR */
#define	S_QUIT_ERR		0xfe	/* low_battery_error process interrupted */
#define	S_SYS_ERR		0xff	/* SYSTEM_ERROR */

#define	S_PNT_ERR		0xe0
#define	S_EMP_ERR		0xe1

/* DTMFileCheck Error code */
#define	DTM_VERSION_ERR		0x80	/* Version error*/
#define	DTM_SIZE_ERR		0x81	/* memory_block size contradiction*/
#define	DTM_STRUCT_ERR		0x82	/* Pointer contradiction*/
#define	DTM_ITEM_STRUCT_ERR	0x83	/* ITEM infoirmation error */
#define DTM_CARD_STRUCT_ERR	0x84	/* Card struct error */
#define	DTM_INFO_STRUCT_ERR	0x85	/* INDEX information error */
#define DTM_ID_TABLE_ERR	0X86	/* INDEX ID Table error  */

#define DTM_LANGUAGE_ERR	0x87	/* Language mode error */

#define	DTM_INDEX_NO_ERR	0xb1 	/* Number of Card ID table is 00 */
#define	DTM_NO_IDX_ERR		0xb2	

#define	DTM_ALREADY_CONVERTED	0xc0	/* Already converted file */
#define	DTM_ABORTED_FILE	0xc1	/* Aborted convertion file */
#define DTM_OLD_VERSION		0xc2	/* Old version file */	   

#define	DTM_APL_CARD_ID		0x0FFF3	/* Application information Card ID*/

/*======================================================================
    Functions
======================================================================*/
#if defined(__cplusplus)
extern "C" {
#endif
DTMERR		_BoxCreate(UCHAR *BoxFName, APLID AplName);
DTMERR		_BoxDelete(UCHAR *BoxFName);
DTMERR		_BoxItemAppend(UCHAR *BoxFName, ITEMDATA *ItemData,
						  USHORT ItemNum, BOOLEAN  *IsNewItemAdded);

DTMERR		_BoxCardTotal(UCHAR *BoxFName, ULONG *BoxSize, CARDID *CardNum);
DTMERR		_BoxItemDelete(UCHAR *BoxFName, ITEMNAME ItemName);
DTMERR		_BoxItemModify(UCHAR *BoxFName, ITEMNAME ItemName,
						  ITEMDATA *ItemData);
DTMERR		_BoxItemRead(UCHAR *BoxFName, ITEMNAME ItemName,
						ITEMDATA *ItemData, USHORT *Len);
BOXHANDLE	_BoxOpen(UCHAR *BoxFName);
BOXHANDLE	_BoxOpenRwMode(UCHAR *BoxFName,BOOLEAN isReadOnly);
DTMERR		_BoxClose(BOXHANDLE BoxFHd);
DTMERR		_BoxCloseEx(BOXHANDLE BoxFHd,BOOLEAN isForce);

DTMERR		_CardCreate(BOXHANDLE BoxFHd, CARDID *NewCardID);
DTMERR		_CardCopy(BOXHANDLE BoxFHd, CARDID SrcCardID, CARDID *DestCardID);
DTMERR		_CardDelete(BOXHANDLE BoxFHd, CARDID DelCardID);
DTMERR		_CardWrite(BOXHANDLE BoxFHd, CARD *Card, UCHAR* Data, DATALEN Len);
DTMERR		_CardRead(BOXHANDLE BoxFHd, CARD *Card, UCHAR* Data, DATALEN *Len);
DTMERR		_CardAllDelete(BOXHANDLE BoxFHd,
						  UCHAR AttrMask, UCHAR AttrCond, UCHAR AttrFlag);

DTMERR		_IndexCreate(UCHAR *IdxFName, IDXFTYPE Type);
DTMERR		_IndexDelete(UCHAR *IdxFName);
DTMERR		_IndexInfoWrite(UCHAR *IdxFName, IDXINFOTYPE IType,
						   UCHAR* Info, USHORT Len);

DTMERR		_IndexInfoRead(UCHAR *IdxFName, IDXINFOTYPE IType,
						  UCHAR* Info, USHORT *Len);
DTMERR		_IndexInfoDelete(UCHAR *IdxFName, IDXINFOTYPE IType);

DTMERR		_IndexNoDelete(UCHAR *IdxFName, INDEXNO DelIdxNo);
DTMERR		_IndexNoAppend(UCHAR *IdxFName,BOXHANDLE BoxFHd,
						  CARDID AddCardID, INDEXNO *AddedIndexNo);
DTMERR		_IndexNoToCardID(UCHAR *IdxFName,
							INDEXNO IndexNo, CARDID *CardID);
DTMERR		_CardIDToIndexNo(UCHAR *IdxFName,
							CARDID CardID, INDEXNO *IndexNo);
DTMERR		_NextIndexNo(UCHAR *IdxFName,
						UCHAR AttrMask, UCHAR AttrCond, UCHAR AttrFlag,
						INDEXNO *IndexNo);
DTMERR		_PrevIndexNo(UCHAR *IdxFName,
						UCHAR AttrMask, UCHAR AttrCond, UCHAR AttrFlag,
						INDEXNO *IndexNo);
DTMERR		_IndexGroup(UCHAR *SrcIdxFName, UCHAR *DestIdxFName,
					   BOXHANDLE BoxFHd);
DTMERR		_IndexUnGroup(UCHAR *IdxFName,BOXHANDLE BoxFHd);
DTMERR		_IndexSearch(UCHAR *IdxFName,BOXHANDLE BoxFHd,
						UCHAR* SearchCond, UCHAR Direction,
						UCHAR AttrMask, UCHAR AttrCond, UCHAR AttrFlag,
						INDEXNO StartIndexNo, INDEXNO *FoundIndexNo);
DTMERR		_IndexSort(UCHAR *IdxFName,BOXHANDLE BoxFHd);

DTMERR		_DTMFileCheck(UCHAR *DTMFName);

DTMERR		_IndexCount(UCHAR *IdxFName, BOXHANDLE BoxFHd,
					   UCHAR* SearchCond, UCHAR Direction,
					   UCHAR AttrMask, UCHAR AttrCond, UCHAR AttrFlag,
					   INDEXNO StartIndexNo, INDEXNO *FoundIndexNo,
					   INDEXNO *CountNo);
DTMERR		_NumberToIndexNo(UCHAR *IdxFName,
							UCHAR Direction,
							UCHAR AttrMask, UCHAR AttrCond, UCHAR AttrFlag,
							INDEXNO	*IndexNo, INDEXNO Number);
DTMERR		_IndexNoToNumber(UCHAR *IdxFName,
							UCHAR AttrMask, UCHAR AttrCond, UCHAR AttrFlag,
							INDEXNO IndexNo1,INDEXNO IndexNo2,INDEXNO *Number);
DTMERR		_MoveIndexNo(UCHAR *IdxFName, INDEXNO SIndexNo, INDEXNO *TIndexNo);
DTMERR		_GetItemName(UCHAR *BoxFName, USHORT, UCHAR *);	
DTMERR		_DTMFileCheckLevel(UCHAR *DTMFName, UCHAR Level);

DTMERR  	_CardCategoryAppend(BOXHANDLE BoxFHd,CARD *Card,CATEGORYID Data);
DTMERR		_CardCategoryDelete(BOXHANDLE BoxFHd,CARD *Card,CATEGORYID Data);
DTMERR		_CardCategoryClear(BOXHANDLE BoxFHd,CARD *Card);
DTMFSTAT	_DTMGetFileStatus(UCHAR *DTMFName);
DTMERR		_DTMSetFileStatus(UCHAR *DTMFName,DTMFSTAT FStat);
DTMERR		_BoxItemReadHeap(BOXHANDLE BoxFHd,ITEMNAME ItemName,
							ITEMDATA *ItemData,USHORT *Len);
DTMERR		_CardOffsetRead(BOXHANDLE BoxFHd,CARD *Card,UCHAR* Data,
						   DATALEN *Len,DATALEN ReadOffset);
DTMERR		_CardOffsetWrite(BOXHANDLE BoxFHd,CARD *Card,UCHAR* Data,
							DATALEN Len,DATALEN WriteOffset);
UCHAR		_GetItemNum(BOXHANDLE BoxFHd) ;
DTMERR		_WriteSyncBit(BOXHANDLE box_handle , CARDID cardID ,UCHAR syncbit ,UCHAR onoff);
DTMERR		_BoxGarbageCollect(UCHAR *BoxFName);
ULONG		_ReadGarbageSize(UCHAR DriveNo);
DTMERR		_GarbageCollectAll(UCHAR DriveNo);
#ifndef  ZDCX_IMPROVABLE
BOOLEAN		_GarbageCheck(UCHAR DriveNo);
#else
UCHAR		_GarbageCheck(UCHAR DriveNo);
#endif
DTMERR		_GetBoxGarbageSize(UCHAR *BoxFName,ULONG *size);
BOXHANDLE	_BoxOpenEx(UCHAR *BoxFName);
DTMERR		_WriteSystemcardSize(UCHAR *BoxFName,UCHAR size);
DTMERR		_BoxSyncClear(UCHAR *BoxFName);
DTMERR		_BoxSyncStart(UCHAR *BoxFName);
DTMERR		_BoxSyncCheck(UCHAR *BoxFName, BOOLEAN *pIsSync);	
DTMERR		_CardDeletePMSC(BOXHANDLE BoxFHd, CARDID DelCardID);
DTMERR		_CalcGarbageSize(UCHAR DriveNo);

DTMERR		_BoxCategoryCount(BOXHANDLE BoxHandle,USHORT *CountWork,
		    UCHAR AttrMask, UCHAR AttrCond, UCHAR AttrFlag);
DTMERR		_IncCategoryCount(BOXHANDLE BoxHandle, USHORT *CountWork,CARDID	CardID,
		    UCHAR AttrMask, UCHAR AttrCond, UCHAR AttrFlag);
DTMERR		_DecCategoryCount(BOXHANDLE BoxHandle, USHORT *CountWork,CARDID	CardID,
		    UCHAR AttrMask, UCHAR AttrCond, UCHAR AttrFlag);
DTMERR 		_IndexNoDeleteWithNum(UCHAR *IdxFName, CARDID *DelIdxNoStr,CARDID CardNum);
DTMERR		_AplNameRead(UCHAR *BoxFName,APLID *AplName);
DTMERR 		_CardWriteFromFile(BOXHANDLE BoxFHd, UCHAR *FileName, CARD *Card);
DTMERR		_DTMFileCheckAppliID(UCHAR *DTMFName, UCHAR Level, APLID AplName); 
DTMERR		_GetMasterIndex(UCHAR *BoxFName,UCHAR *IdxFName);

DTMERR		_WriteSystemcardSizeL(UCHAR *BoxFName,ULONG size);
DTMERR		_IndexInfoWriteWithCheck(UCHAR *IdxFName,IDXINFOTYPE IType,UCHAR* Info,USHORT Len);
DTMERR		_IndexCopy(UCHAR *SrcIdxFName,UCHAR *DstIdxFName,IDXINFOTYPE IType,UCHAR* Info,
					  USHORT Len);
DTMERR _GetCardImageSize(UCHAR *BoxFName,CARDID CardID,ULONG *pCardLen);
DTMERR _ReadCardImage(UCHAR *BoxFName,CARDID CardID,UCHAR *Buf,ULONG *pLen);
DTMERR _WriteCardImage(UCHAR *BoxFName,CARDID CardID,UCHAR *Buf,ULONG CardSize);
#define	_GetAplCardSize(x,y)		_GetCardImageSize(x,DTM_APL_CARD_ID,y)
#define	_ReadAplCard(x,y,z)			_ReadCardImage(x,DTM_APL_CARD_ID,y,z)
#define	_WriteAplCard(x,y,z)		_WriteCardImage(x,DTM_APL_CARD_ID,y,z)
DTMERR 		_GetIndexName(UCHAR *BoxFName,int FileNo,UCHAR* Buf,ULONG BufLen,
						 BOOLEAN *plsMaster);

DTMERR		_DTMCheckVersion(UCHAR *DTMFName);
DTMERR		_DTMGetErrorFileName(ULONG num,UCHAR *filename);
DTMERR		_DTMGetErrorFileInf(UCHAR *filename,UCHAR *level,UCHAR *buf);
ULONG		_DTMGetErrorFileNum(void);
DTMERR		_DTMSetupDriveWork(UCHAR Drive);
DTMERR		_DTMDeleteErrorFileInf(UCHAR *filename);


/* Do not use these in applications */
BOOLEAN		DTMIsLowerVersion(UCHAR *DriveName,UCHAR *DTMFName);
DTMERR		DTMEstimateBoxSize(UCHAR *DTMFName,ULONG *BoxSize);
DTMERR		DTMEstimateBoxSizeWithIndex(UCHAR *DTMFName,ULONG *AllSize);
DTMERR		DTMEstimateIndexSize(UCHAR *DTMFName,ULONG *IndexSize);
DTMERR		DTMEstimateDriveSize(UCHAR *DriveName,ULONG *DriveSize,long *RestSize);
DTMERR		DTMEstimateDriveSizeWithIndex(UCHAR *DriveName,ULONG *DriveAllSize,long *RestSize);
#ifndef H2EQU
typedef	void (*CONVCB)(PTR wk,ULONG write_size,ULONG total_size,ULONG progress_count,
						 ULONG total_count);
#endif /* H2EQU */
DTMERR		DTMConvertBoxFile(UCHAR *boxfile,CONVCB progress,PTR progresswk);
DTMERR		DTMConvertBoxFileWithIndex(UCHAR *boxfile,CONVCB progress,PTR progresswk);
DTMERR		DTMConvertIndexFile(UCHAR *indexfile);

/* Debug */
void CheckFINFO(void);

/* Synchronization */
DTMERR
_CYBxBoxSyncCheck( UCHAR *sBox, BOOLEAN *pIsSync );
DTMERR
_DtmGetIndexSyncAttrPMSC( IDXHANDLE IdxHd, INDEXNO IndexNo, UCHAR *pAttr );
DTMERR
_DtmSetIndexSyncAttrPMSC( IDXHANDLE IdxHd, INDEXNO IndexNo, UCHAR AttrMask, UCHAR AttrSet );
IDXHANDLE
_DtmIndexOpen( UCHAR *sIdx );
DTMERR
_DtmIndexClose( IDXHANDLE IdxHd );
DTMERR
_CardDeletePMSCWithIndex( BOXHANDLE BoxHd, CARDID CardId );
DTMERR
_ExpectNewCardID( BOXHANDLE BoxHd, CARDID *pCardId );

UCHAR*
DtmGetBaseNamePtr(UCHAR *pathName);

ULONG DtmGetSyncId(BOXHANDLE hdl);
DTMERR DtmUpdateSyncId(BOXHANDLE hdl);

void DtmSetLanguage(const char *lang);
void DtmGetLanguage(char *lang);
BOOLEAN DtmIsLanguageMatch(const char *lang);

void DtmDumpSortCode();

typedef enum {
	DTMOP_SET_DBIT_ALLDELETE = 1
} DTMOPERATION;
BOOLEAN DtmIsEnoughStorageForOperation(BOXHANDLE hdl,DTMOPERATION ope);

#if defined(__cplusplus)
}
#endif

/*======================================================================
    DTMFileCheck ckeck level
======================================================================*/

#define DTM_CHECK_FULL		0x00 	/* Most severe*/
#define DTM_CHECK_HARD		0x02 	/* Severe */
#define DTM_CHECK_NORMAL	0x03 	/* normal */

#define	DTM_CHECK_DEBUG		0xff	

#endif
