# Mailbox name generator
# Copyright (C) 2002 John Goerzen
# <jgoerzen@complete.org>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os.path

def genmbnames(config, boxlist):
    """Takes a configparser object and a boxlist, which is a list of hashes
    containing 'accountname' and 'foldername' keys."""
    if not config.getboolean("mbnames", "enabled"):
        return
    file = open(os.path.expanduser(config.get("mbnames", "filename")), "wt")
    file.write(eval(config.get("mbnames", "header")))
    itemlist = [eval(config.get("mbnames", "peritem", raw=1)) % item for item in boxlist]
    file.write(eval(config.get("mbnames", "sep")).join(itemlist))
    file.write(eval(config.get("mbnames", "footer")))
    file.close()
    
    
    
