/* John Goerzen
 */
/* 	$Id: safesyscall.h,v 1.3 1997/09/29 21:59:48 jgoerzen Exp $	 */

#ifndef __JG_SAFESYSCALL_H__
#define __JG_SAFESYSCALL_H__

#ifndef __JG_SAFESYSCALL_C__
#define EXTERN_ extern
#else
#define EXTERN_
#endif

#include <stdio.h>		/* required for FILE * stuff */
#include <sys/stat.h>		/* required for struct stat stuff */
#include <unistd.h>

EXTERN_ char *safestrdup(const char *s);
EXTERN_ char *safestrncpy(char *dest, const char *src, size_t n);
EXTERN_ char *safestrcat(char *dest, const char *src, size_t n);
EXTERN_ int safekill(pid_t pid, int sig);
EXTERN_ char *safegetenv(const char *name);
EXTERN_ int safechdir(const char *path);
EXTERN_ int safemkdir(const char *path, mode_t mode);
EXTERN_ int safestat(const char *file_name, struct stat *buf);
EXTERN_ int safeopen(const char *pathname, int flags);
EXTERN_ int safeopen2(const char *pathname, int flags, mode_t mode);
EXTERN_ int safepipe(int filedes[2]);
EXTERN_ int safedup2(int oldfd, int newfd);
EXTERN_ int safeexecvp(const char *file, char *const argv[]);
EXTERN_ int saferead(int fd, void *buf, size_t count);
EXTERN_ int safewrite(int fd, const char *buf, size_t count);
EXTERN_ int safeclose(int fd);
EXTERN_ FILE *safefopen(char *path, char *mode);
EXTERN_ size_t safefread(void *ptr, size_t size, size_t nmemb, FILE *stream);
EXTERN_ size_t safefwrite(void *ptr, size_t size, size_t nmemb, FILE *stream);
EXTERN_ int safefclose(FILE *stream);
EXTERN_ int safefflush(FILE *stream);
EXTERN_ void *safemalloc(size_t size);

#undef EXTERN_

#endif
