/*			HANDIN PROGRAM
			John Goerzen
			jgoerzen@complete.org
			jgoerzen@complete.org

Originally for:		CS697L
			   Assignment 2

Modified for:           CS Department, Wichita State University

		MAIN MODULE (program entry point)
			   
*/

/* 	$Id: handin.c,v 1.30 2002/04/24 19:19:05 jgoerzen Exp $	 */

#ifndef lint
static char vcid[] = "$Id: handin.c,v 1.30 2002/04/24 19:19:05 jgoerzen Exp $";
#endif /* lint */

#define __HANDIN_C__

#include <stdio.h>
#include <pwd.h>
#include <time.h>
#include <stdlib.h>
#include "handin.h"			/* "master" include file */

int noreplaceprompt = 0;

void badargs(char *msg);
void loadduedates();
void checkvalidstudent(void);

void main(int argc, char *argv[])
{
struct passwd *pstruct;
int counter;
int addargsval = 0;		/* Offset of remaining arguments */

  initids();			/* Ditch the setuid priviledges ASAP */
  printf("Wichita State University Computer Science Department Electronic Handin\n");
  printf("$Revision: 1.30 $\n");
  printf("Copyright (C) 1997 - 2002 John Goerzen\n");
  printf("Licensed under the GNU General Public License\n");
  printf("For help, see http://happy.cs.twsu.edu/cs/handin\n\n");
  if (argv[1] && (strcmp(argv[1], "-y") == 0)) {
    noreplaceprompt = 1;
    printf("*** Will automatically replace files without prompting.\n");
    addargsval++;
  }
  if (argc < 3 + addargsval)
    badargs("Not enough arguments");
  if (noreplaceprompt)
      printf("*** Will automatically replace files without prompting.\n");

  /* Find the home directory and store it in global variable */
  
  pstruct = getpwuid(getseuid());
  
  if (!pstruct)
    err_quit("Can't get home directory for class account\n");

  safestrncpy(homedir, pstruct->pw_dir, sizeof(homedir) - 1);

  safestrncpy(username, "Not yet determined", sizeof(username));
  
  shouldlogerror = 1;		/* Now are capable of logging errors */

  if (atexit(exitfunc) < 0) {
    printf("WARNING: couldn't install exit handler.\n");
    logerror("WARNING: couldn't install exit handler");
  }

  checkvalidstudent();

  safestrncpy(assign, argv[1 + addargsval], sizeof(assign) - 1);
				                   /* Set global "assignment
						   number"
  					           variable */

  loadduedates();			/* Loads and parses due dates;
  					   rejects handin if past the
  					   late date. */
  					   
  /* Now, for each file or directory specified, attempt to hand it in. */
  
  for (counter = 2 + addargsval; argv[counter]; counter++)
    if (checksecurity(argv[counter]))
      handitin(argv[counter]);
  
  /* All done! */
 					   
}

void badargs(char *msg)
{
  printf("Invalid command-line: %s\n", msg);
  printf("Syntax: ~username/bin/handin assign-number filename [...]\n");
  printf("Or, if you wish to disable prompting on replace, use:\n");
  printf("  ~username/bin/handin -y assign-number filename [...]\n");
  err_quit(msg);
}

void loadduedates()
{
FILE *conf;
char filename[MAXFILENAME + sizeof(homedir)];
char assignnum[40], duedatestr[40], latedatestr[40], thisline[40];
int found = 0;
char *result;
 

  snprintf(filename, sizeof(filename), "%s/handin", homedir);
  classperms(); modckmkdirname(filename, 0700); userperms();
  safestrcat(filename, "/conf", sizeof(filename));
  classperms(); modckmkdirname(filename, 0700); userperms();
  safestrcat(filename, "/handin.conf", sizeof(filename));
  classperms();
  conf = safefopen(filename, "rt");
  userperms();

  do {
    classperms();
    result = fgets(thisline, sizeof(thisline), conf);
    userperms();
    if (!result) break;
    sscanf(thisline, "%s %s %s", assignnum, duedatestr, latedatestr);
    if (strcmp(assign, assignnum) == 0) {
      found = 1;
      break;
    }
  } while (1);			/* We always break out of loop  */
  
  if (!found)
    badargs("Bad assignment number specified.");
  duedate = parsedate(duedatestr);
  latedate = parsedate(latedatestr);
  if (!(duedate && latedate))
    err_quit("ERROR: could not parse duedate and/or latedate");
  printf("Assignment %-3s due by:           %s", assign, ctime(&duedate));
  printf("Late assignments accepted until: %s", ctime(&latedate));
  printf("It is now:                       %s\n", ctime(timeptr(time(NULL))));
  if (time(NULL) > latedate) {
    fprintf(stderr, "NOTE: HANDIN REFUSED!\a\n");
    err_quit("It is too late to hand in your assignment; HANDIN REFUSED.");
  }
  if (time(NULL) > duedate) {	/* Tell user that the files are late. */
    printf("*** It is past the duedate for this assignment               ***\n");
    printf("*** You may hand files in, but your instructor will see that ***\n");
    printf("*** they were handed in late and they will be dealt with in  ***\n");
    printf("*** accordance with the late policy for this class.          ***\n\n");
  }
}

void checkvalidstudent(void)	/* Makes sure student has permission to hand
				   in files for this class. */
{
char thisline[20];
struct passwd *pstruct;
char filename[MAXFILENAME + sizeof(homedir)];
FILE *conf;
char *result;
 

  pstruct = getpwuid(getsuid());
  if (!pstruct) err_quit("Couldn't determine your username");
  
  safestrncpy(username, pstruct->pw_name, sizeof(username));
  snprintf(filename, sizeof(filename), "%s/handin", homedir);
  classperms(); modckmkdirname(filename, 0700); userperms();
  safestrcat(filename, "/conf", sizeof(filename));
  classperms(); modckmkdirname(filename, 0700); userperms();
  safestrcat(filename, "/students", sizeof(filename));
  classperms();			/* CLASS PERMISSIONS */
  conf = safefopen(filename, "rt");
  userperms();			/* user permissions */
  while (1) {			/* Always explicitly break out of loop */
    classperms();
    result = fgets(thisline, sizeof(thisline), conf);
    userperms();
    if (!result) break;
    stripcrlf(thisline);
    if (strcmp(thisline, username) == 0) return;
  }
  
  /* If execution reaches here, username not found. */
  
  err_quit("You are not authorized to hand in files in for this class.");
}

