/*			HANDIN PROGRAM
			John Goerzen
			jgoerzen@complete.org
			jgoerzen@complete.org

			CS697L
			   Assignment 2
			   
$Id: dirmanip.c,v 1.10 2002/04/24 19:19:05 jgoerzen Exp $

*/

#define __JG_DIRMANIP_C__

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>		/* Prototype for mkdir is in here in Linux */
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>
#include "handin.h"

int ckdirname(char *dir)
{
char wd[MAXDIRNAME];			/* Previous working directory */
int exists;
int euid, egid;

  euid = geteuid();
  egid = getegid();
  userperms();				/* CWD will be in user's
  					   directory space; here we
  					   must ensure that we have access
  					   to the directory. */
  if (!getcwd(wd, sizeof(wd)))
    err_quit("FAILURE: UNABLE TO DETERMINE CURRENT DIRECTORY.\n");

  seteuid(euid); setegid(egid);		/* Restore previous settings */
  
  exists = (chdir(dir) == 0) ? 1 : 0;	/* If we can chdir there, it
  					   exists; otherwise, it doesn't.
  					   
  					   Note that this program must
  					   have permissions to chdir to
  					   the given directory! */
  					   
  /* Now chdir back to the original directory. */
  
  userperms();				/* Must have permissions to do that */
  
  safechdir(wd);
  
  seteuid(euid); setegid(egid);		/* Restore previous settings */
  
  return exists;
}

void modckmkdirname(char *dir, int mode)
{
  ckmkdirname(dir, mode);
  if (chmod(dir, mode) != 0)
    err_sys("Couldn't set permissions on directory %s", dir);
}

void ckmkdirname(char *dir, int mode)
{
  if (ckdirname(dir))		/* If it already exists, do nothing. */
    return;
    
  safemkdir(dir, mode);
}
