/*			HANDIN PROGRAM
			John Goerzen
			jgoerzen@complete.org
			jgoerzen@complete.org

			CS697L
			   Assignment 2

Updated for WSU CS Dept. handin
			   
$Id: copyfile.c,v 1.17 2002/04/24 19:19:05 jgoerzen Exp $

*/

#define __JG_COPYFILE_C__

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <stdlib.h>
#include "handin.h"

int do_copy(char *srcname, char *destname);
long copyfd(int in, int out);
int read_buffer(int fd, char *buf, int count);


void copyfile(char *name)
{
char dirname[MAXDIRNAME];
char destname[MAXFILENAME];

  /* First, verify that all directories exist and are proper mode. */
  
  if (!ckdirname(homedir))
    err_quit("copyfile: home directory %s doesn't exist!", homedir);
  
  /* Make sure all necessary directories exist.  Also, force them all to
     mode 0700. */
  
  snprintf(dirname, sizeof(dirname), "%s/handin", homedir);
  classperms(); modckmkdirname(dirname, 0700); userperms();
  safestrcat(dirname, "/assign", sizeof(dirname));
  classperms(); modckmkdirname(dirname, 0700); userperms();
  safestrcat(dirname, "/", sizeof(dirname));
  safestrcat(dirname, assign, sizeof(dirname));
  safestrcat(dirname, (time(NULL) > duedate) ? ".late" : "", sizeof(dirname));
  classperms(); modckmkdirname(dirname, 0700); userperms();
  safestrcat(dirname, "/", sizeof(dirname));
  safestrcat(dirname, username, sizeof(dirname));
  classperms(); modckmkdirname(dirname, 0700); userperms();
  
  /* Now the full directory to copy stuff to is in dirname. */
  
  snprintf(destname, sizeof(destname), "%s/%s", dirname, name);
  
  if (!do_copy(name, destname)) {	/* Perform the copy */
    printf("!!! Failed\a!\n");
    printf("!!!    Handin of %s failed; contact instructor.\n", name);
    logerror("Handin of %s failed", name);
    errors++;
  }
}

int do_copy(char *srcname, char *destname)
{
FILE *infilet;
int infile, outfile;
char inputline[20];
  
  userperms();			/* Just to be sure */
  infile = safeopen(srcname, O_RDONLY);
  if (!noreplaceprompt) {	/* Check to see if overwriting */
    /* Check to see if we can open the file (if it exists) */
    classperms();			/* CLASS PERMISSIONS BEGIN */
    infilet = fopen(destname, "rt");
    userperms();			/* back to user permissions */
    if (infilet) {			/* file exists, so prompt */
      fclose(infilet);
      printf("    You have already handed in the file %s\n", srcname);
      printf("    Would you like to replace the existing file with the\n");
      printf("    one you are attempting to hand in now?  (yes/no)\n>>> ");
      fgets(inputline, sizeof(inputline), stdin);
      if (toupper(inputline[0]) != 'Y') {
        printf("*** Existing %s not modified.\n", srcname);
        overwriteskip++;
        return TRUE;
      }
    }
  }
  printf("*** Attempting handin of file %s...", srcname);
  fflush(stdout);			/* Display it immediately */
  
  classperms();			/* CLASS PERMISSIONS BEGIN */
  outfile = open(destname, O_CREAT | O_TRUNC | O_WRONLY, 0600);
  userperms();			/* back to user perms */
  
  if (!outfile) {
    printf("Couldn't open/create %s\n", destname);
    err_quit("Failure to open/create dest file %s", destname);
  }
  
  
  if (copyfd(infile, outfile) == -1)
    err_quit("Error copying file!\n");
  
  classperms();
  safeclose(outfile);
  userperms();
  
  close(infile);			/* Don't really care if this one
  					   can't close.  There won't be
  					   any data pending in the cache. */
  loghandin(srcname);			/* And log it. */
  printf(" handin successful\n");	/* Let user know it worked. */
  handin++;
  return TRUE;
}

long copyfd(int in, int out)
{
char *buffer = safemalloc(20480);
long numbytes = 0;	/* Number of successfully copied bytes */
int  cin; 

    while ((cin = saferead(in, buffer, 20480)) > 0) {
        classperms();
	write_buffer(out, buffer, cin);
	userperms();
	numbytes += cin;
    }
    free(buffer);
    return (numbytes);
}

/* 
    This function writes certain number bytes from "buf" to a file 
    or socket descriptor specified by "fd". The number of bytes is 
    specified by "count". "fd" SHOULD BE A DESCRIPTOR FOR A FILE, 
    OR A PIPE OR TCP SOCKET. It returns the number of bytes written.
*/

int write_buffer(int fd, char *buf, int count)
{
    char *pts = buf;
    int  status = 0, n; 

    if (count < 0) return (-1);

    while (status != count) { 
        n = safewrite(fd, pts+status, count-status); 
        status += n; 
    } 
    return (status);
} 

/* 
    This function reads certain number bytes from a file or socket 
    descriptor specified by "fd" to "buf". The number of bytes is 
    specified by "count". "fd" SHOULD BE A DESCRIPTOR FOR A FILE, 
    OR A PIPE OR TCP SOCKET. It returns number of bytes read.
*/

int read_buffer(int fd, char *buf, int count)
{
    char *pts = buf;
    int  status = 0, n; 

    if (count < 0) return (-1);

    while (status != count) { 
        n = saferead(fd, pts+status, count-status); 
        status += n; 
    }
    return (status);
}

/* Removes CR and LF from the end of a string. */
void stripcrlf(char *temp)
{
  while ((temp[strlen(temp)-1] == 13) || (temp[strlen(temp)-1] == 10)) {
    temp[strlen(temp)-1] = 0;
  }
}

