###########################################################################################
sub SetCookies
{

$cookie{'cart_id'} = "$cart_id";

# Set the domain to be correct for your domain

$domain = $sc_domain_name_for_cookie;
$secureDomain = $sc_secure_domain_name_for_cookie;

# The path to your 'store' directory

$path = $sc_path_for_cookie;
$securePath = $sc_secure_path_for_cookie;

# Leave this as is.

$secure = "";

# Cookie will expire in 24 hours

$now = time;

# Second in twenty four hours

$twenty_four_hours = "86400";

$expiration = $now+$twenty_four_hours;#number of days until cookie expires


if(!$form_data{'secure'})
{
&set_cookie($expiration,$domain,$path,$secure);
}
else
{
&set_cookie($expiration,$secureDomain,$securePath,$secure);
}

}

############################################################################################

sub StoreHeader
{
open (HEADER, "$sc_store_header_file");

while (<HEADER>)
{
s/%%URLofImages%%/$URL_of_images_directory/g;
s/%%cart_id%%/$cart_id/g;
print $_;
}
close (HEADER);

}

############################################################################################

sub StoreFooter
{
open (FOOTER, "$sc_store_footer_file");

while (<FOOTER>)
{
s/%%URLofImages%%/$URL_of_images_directory/g;
s/%%cart_id%%/$cart_id/g;
print $_;
}

close (FOOTER);
}

############################################################################################

sub SecureStoreHeader
{
open (SECUREHEADER, "$sc_secure_store_header_file");

while (<SECUREHEADER>)
{
s/%%sc_store_url%%/$sc_store_url/g;
s/%%URLofImages%%/$URL_of_images_directory/g;
s/%%cart_id%%/$cart_id/g;
print $_;
}
close (SECUREHEADER);

}

############################################################################################

sub SecureStoreFooter
{
open (SECUREFOOTER, "$sc_secure_store_footer_file");

while (<SECUREFOOTER>)
{
s/%%URLofImages%%/$URL_of_images_directory/g;
s/%%cart_id%%/$cart_id/g;
print $_;
}

close (SECUREFOOTER);
}

############################################################################################

sub define_shipping_logic

{

local ($shipping_price) = @_;
local($upgradeShipLevel, $shipMethod) = split (/\|/,$form_data{upgradeShipping});

# The values defined in this array each represent a percentage
# of the base shipping price. On your orderform, you'll notice code
# like this:
# <SELECT NAME="upgradeShipping">
# <OPTION VALUE="">Please Make Your Selection</OPTION>
# <OPTION VALUE="0|Ground Shipping">Ground Shipping (+0.00)</OPTION>
# <OPTION VALUE="1|U.P.S. Three Day - Upgrade">U.P.S. Two Day (+5%)</OPTION>
# <OPTION VALUE="2|U.P.S. Two Day - Upgrade">U.P.S. Two Day (+10%)</OPTION>
# <OPTION VALUE="3|U.P.S. Overnight - Upgrade">U.P.S. Overnight (+15%)</OPTION>
# Each of the values defined on the left of the | symbol
# correspond to a value below.

@upgradeShipPrice = (0, 5, 10, 15);

$shipping_price += ($shipping_price*($upgradeShipPrice[$upgradeShipLevel]/100));
return $shipping_price;

}
1;