#######################################################################
#                    Order Form Definition Variables                  #
#######################################################################

%sc_order_form_array =('Ecom_BillTo_Postal_Name_First', 'First Name',
                       'Ecom_BillTo_Postal_Name_Last', 'Last Name',
                       'Ecom_BillTo_Postal_Street_Line1', 'Billing Address Street',
                       'Ecom_BillTo_Postal_City', 'Billing Address City',
                       'Ecom_BillTo_Postal_StateProv', 'Billing Address State',
                       'Ecom_BillTo_PostalCode', 'Billing Address Zip',
                       'Ecom_BillTo_Postal_CountryCode', 'Billing Address Country',
                       'Ecom_ShipTo_Postal_Name_First', 'Ship To First Name',
                       'Ecom_ShipTo_Postal_Name_Last', 'Ship To Last Name',
                       'Ecom_ShipTo_Postal_Street_Line1', 'Shipping Address Street',
                       'Ecom_ShipTo_Postal_City', 'Shipping Address City',
                       'Ecom_ShipTo_Postal_StateProv', 'Shipping Address State',
                       'Ecom_ShipTo_Postal_PostalCode', 'Shipping Address Zip',
                       'Ecom_ShipTo_Postal_CountryCode', 'Shipping Address Country',
                       'Ecom_BillTo_Telecom_Phone_Number', 'Phone Number',
                       'Ecom_BillTo_Online_Email', 'Email',
                       'Ecom_Payment_Card_Type', 'Type of Card',
                       'Ecom_Payment_Card_Number', 'Card Number',
                       'Ecom_Payment_Card_ExpDate_Month', 'Card Expiration Month',
                       'Ecom_Payment_Card_ExpDate_Day', 'Card Expiration Day',
                       'Ecom_Payment_Card_ExpDate_Year', 'Card Expiration Year');
                        

@sc_order_form_required_fields = ("Ecom_BillTo_Postal_Name_First",
                                  "Ecom_BillTo_Postal_Name_Last",
                                  "Ecom_BillTo_Postal_Street_Line1",
                                  "Ecom_BillTo_Postal_City",
                                  "Ecom_BillTo_Postal_StateProv",
                                  "Ecom_BillTo_PostalCode",        
                                  "Ecom_BillTo_Telecom_Phone_Number",
                                  "Ecom_BillTo_Online_Email",
                                  "Ecom_Payment_Card_Type",
                                  "Ecom_Payment_Card_Number",
                                  "Ecom_Payment_Card_ExpDate_Month",
                                  "Ecom_Payment_Card_ExpDate_Year");

###############################################################################


if (! $form_data{'Ecom_ShipTo_Postal_Street_Line1'})
{
$form_data{'Ecom_ShipTo_Postal_Street_Line1'} = $form_data{'Ecom_BillTo_Postal_Street_Line1'};
}

if (! $form_data{'Ecom_ShipTo_Postal_City'})
{
$form_data{'Ecom_ShipTo_Postal_City'} = $form_data{'Ecom_BillTo_Postal_City'};
}

if (! $form_data{'Ecom_ShipTo_Postal_StateProv'})
{
$form_data{'Ecom_ShipTo_Postal_StateProv'} = $form_data{'Ecom_BillTo_Postal_StateProv'};
}

if (! $form_data{'Ecom_ShipTo_Postal_PostalCode'})
{
$form_data{'Ecom_ShipTo_Postal_PostalCode'} = $form_data{'Ecom_BillTo_PostalCode'};
}

if (! $form_data{'Ecom_ShipTo_Postal_CountryCode'})
{
$form_data{'Ecom_ShipTo_Postal_CountryCode'} = $form_data{'Ecom_BillTo_Postal_CountryCode'};
}

sub printSubmitPage

{
local($invoice_number, $customer_number);

$invoice_number = time;
$customer_number = $cart_id;
$customer_number =~ s/_/./g;

print <<ENDOFTEXT;
<!--Customer/Order Data-->
<INPUT TYPE=HIDDEN NAME=CUSTID VALUE=\"$customer_number\">
<INPUT TYPE=HIDDEN NAME=INVOICE VALUE=\"$invoice_number\">
<INPUT TYPE=HIDDEN NAME=DESCRIPTION VALUE=\"Online Order\">
<!--Billing Address-->
<INPUT TYPE=HIDDEN NAME=NAME VALUE=\"$form_data{'Ecom_BillTo_Postal_Name_First'} $form_data{'Ecom_BillTo_Postal_Name_Last'}\">
<INPUT TYPE=HIDDEN NAME=ADDRESS VALUE=\"$form_data{'Ecom_BillTo_Postal_Street_Line1'}\">
<INPUT TYPE=HIDDEN NAME=CITY VALUE=\"$form_data{'Ecom_BillTo_Postal_City'}\">
<INPUT TYPE=HIDDEN NAME=STATE VALUE=\"$form_data{'Ecom_BillTo_Postal_StateProv'}\">
<INPUT TYPE=HIDDEN NAME=ZIP VALUE=\"$form_data{'Ecom_BillTo_PostalCode'}\">
<INPUT TYPE=HIDDEN NAME=COUNTRY VALUE=\"$form_data{'Ecom_BillTo_Postal_CountryCode'}\">
<INPUT TYPE=HIDDEN NAME=PHONE VALUE=\"$form_data{'Ecom_BillTo_Telecom_Phone_Number'}\">
<INPUT TYPE=HIDDEN NAME=EMAIL VALUE=\"$form_data{'Ecom_BillTo_Online_Email'}\">
<!--Shipping Address-->
<INPUT TYPE=HIDDEN NAME=SHIPNAME VALUE=\"$form_data{'Ecom_ShipTo_Postal_Name_First'} $form_data{'Ecom_ShipTo_Postal_Name_Last'}\">
<INPUT TYPE=HIDDEN NAME=SHIPTOSTREET VALUE=\"$form_data{'Ecom_ShipTo_Postal_Street_Line1'}\">
<INPUT TYPE=HIDDEN NAME=SHIPTOCITY VALUE=\"$form_data{'Ecom_ShipTo_Postal_City'}\">
<INPUT TYPE=HIDDEN NAME=SHIPTOSTATE VALUE=\"$form_data{'Ecom_ShipTo_Postal_StateProv'}\">
<INPUT TYPE=HIDDEN NAME=SHIPTOZIP VALUE=\"$form_data{'Ecom_ShipTo_Postal_PostalCode'}\">
<INPUT TYPE=HIDDEN NAME=SHIPTOCOUNTRY VALUE=\"$form_data{'Ecom_ShipTo_Postal_CountryCode'}\">
<!--Billing Data-->
<INPUT TYPE=HIDDEN NAME=METHOD VALUE=\"$form_data{'Ecom_Payment_Card_Type'}\">
<INPUT TYPE=HIDDEN NAME=CARDNUM VALUE=\"$form_data{'Ecom_Payment_Card_Number'}\">
<INPUT TYPE=HIDDEN NAME=EXPDATE VALUE=\"Month: $form_data{'Ecom_Payment_Card_ExpDate_Month'} Day: $form_data{'Ecom_Payment_Card_ExpDate_Day'} Year: $form_data{'Ecom_Payment_Card_ExpDate_Year'}\">

<TABLE WIDTH="500" BGCOLOR="#C0FFFF" CELLPADDING="2" CELLSPACING="0">

<TR BGCOLOR="#FFFFFF">
<TD>
&nbsp;
</TD>
</TR>

<TR BGCOLOR="#C0FFFF">
<TD BGCOLOR="#C0FFFF">
<FONT FACE="ARIAL" SIZE="2" COLOR="#000000">
Please verify the following information. When you are confident 
that it is correct, click the 'Submit Order For Processing' button below
</FONT>
</TD>
</TR>
</TABLE>

<FONT FACE=ARIAL SIZE=-1>
<CENTER>
<TABLE WIDTH=500 BORDER=0 BGCOLOR=#C0FFFF>
<TR>
<TD COLSPAN=2>
<FONT FACE=ARIAL SIZE=-1>
<B>Customer Information</B>
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=100>
<FONT FACE=ARIAL SIZE=-1>
Customer Number
</FONT>
</TD>
<TD WIDTH=400>
<FONT FACE=ARIAL SIZE=-1>
$cart_id
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
Order Number
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$time
</FONT>
</TD>
</TR>

<TR>
<TD COLSPAN=2>
<FONT FACE=ARIAL SIZE=-1>
<B>Billing Address</B>
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
Name
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_BillTo_Postal_Name_First'} $form_data{'Ecom_BillTo_Postal_Name_Last'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
Street
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_BillTo_Postal_Street_Line1'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
City
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_BillTo_Postal_City'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
State
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_BillTo_Postal_StateProv'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
Zip
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_BillTo_PostalCode'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
Country
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_BillTo_Postal_CountryCode'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
Phone
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_BillTo_Telecom_Phone_Number'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
E-Mail
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_BillTo_Online_Email'}
</FONT>
</TD>
</TR>

<!--Shipping Address-->

<TR>
<TD COLSPAN=2>
<FONT FACE=ARIAL SIZE=-1>
<B>Shipping Address</B>
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
Name
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_ShipTo_Postal_Name_First'} $form_data{'Ecom_ShipTo_Postal_Name_Last'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
Street
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_ShipTo_Postal_Street_Line1'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
City
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_ShipTo_Postal_City'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
State
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_ShipTo_Postal_StateProv'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
Zip
</FONT>
</TD>
<TD WIDTH=350>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_ShipTo_Postal_PostalCode'}
</FONT>
</TD>
</TR>

<TR>
<TD WIDTH=150>
<FONT FACE=ARIAL SIZE=-1>
Country
</FONT>
<TD>
<FONT FACE=ARIAL SIZE=-1>
$form_data{'Ecom_ShipTo_Postal_CountryCode'}
</FONT>
</TD>
</TR>

<TR>
<TD COLSPAN=2>
<CENTER>
<P>
<INPUT TYPE="HIDDEN" NAME="process_order" VALUE="yes">
<INPUT TYPE=SUBMIT VALUE="Submit Order For Processing">
<P>
</CENTER>
</TD>
</TR>
</TABLE>
</CENTER>
</FONT>
</FONT>
ENDOFTEXT
}
###############################################################

sub processOrder {
local($subtotal, $total_quantity,
      $total_measured_quantity,
      $text_of_cart,
      $required_fields_filled_in, $product, $quantity, $options,
      $text_of_confirm_email, $text_of_admin_email, $emailCCnum, $logCCnum);

$orderDate = &get_date;

$emailCCnum = "XXXXXXXX";
$emailCCnum .= substr($form_data{'CARDNUM'},8,20);

$logCCnum = substr($form_data{'CARDNUM'},0,8);
$logCCnum .= "XXXXXXXX";


# First, we output the header of
# the processing of the order

print qq!
<HTML>
<HEAD>
<TITLE>Thank you for your order</TITLE>
</HEAD>
</BODY>
!;

&SecureStoreHeader;

$text_of_cart .= "New Order: $orderDate\n\n";

$text_of_cart .= "PRODUCT INFORMATION--\n\n";

open (CART, "$sc_cart_path") ||
&file_open_error("$sc_cart_path", "display_cart_contents", __FILE__, __LINE__);

while (<CART>)
	{
	$cartData++;
	@cart_fields = split (/\|/, $_);
	$quantity = $cart_fields[0];
	$product_price = $cart_fields[3];
	$product = $cart_fields[4];
	$options = $cart_fields[7];
	$options =~ s/<br>/ /g;
	$text_of_cart .= "Quantity:      $quantity\nProduct:       $product $sc_money_symbol $product_price (each)\n";
	$text_of_cart .= "Options:       $options\n\n";
	}
close(CART);

$text_of_confirm_email .= "Thank you for your order. We appreciate your business and will do everything we can to meet your expectations. Please visit us again soon!\n\n";
$text_of_confirm_email .= $text_of_cart;
$text_of_confirm_email .= "\n";

$text_of_cart .= "ORDER INFORMATION--\n\n";

$text_of_admin_email .= $text_of_cart;

$text_of_cart .= "CUSTID:        $form_data{'CUSTID'}\n";
$text_of_confirm_email .= "CUSTID:        $form_data{'CUSTID'}\n";
$text_of_admin_email .= "CUSTID:        $form_data{'CUSTID'}\n";

$text_of_cart .= "INVOICE:       $form_data{'INVOICE'}\n\n";
$text_of_confirm_email .= "INVOICE:       $form_data{'INVOICE'}\n\n";
$text_of_admin_email .= "INVOICE:       $form_data{'INVOICE'}\n\n";

$text_of_cart .= "METHOD:        $form_data{'METHOD'}\n";
$text_of_admin_email .= "METHOD:        XXXX\n";

$text_of_cart .= "NUMBER:        $logCCnum\n";
$text_of_admin_email .= "NUMBER:        $emailCCnum\n";

$text_of_cart .= "EXP:           XXXX\n\n";
$text_of_admin_email .= "EXP:           $form_data{'EXPDATE'}\n\n";

$text_of_cart .= "SUBTOTAL:      $form_data{'SUBTOTAL'}\n";
$text_of_confirm_email .= "SUBTOTAL:      $form_data{'SUBTOTAL'}\n";
$text_of_admin_email .= "SUBTOTAL:      $form_data{'SUBTOTAL'}\n";

if ($form_data{'SHIPPING'})
{
$text_of_cart .= "SHIPPING:      $form_data{'SHIPPING'} $form_data{'SHIPMETHOD'}\n";
$text_of_confirm_email .= "SHIPPING:      $form_data{'SHIPPING'} $form_data{'SHIPMETHOD'}\n";
$text_of_admin_email .= "SHIPPING:      $form_data{'SHIPPING'} $form_data{'SHIPMETHOD'}\n";
}

if ($form_data{'SALESTAX'})
{
$text_of_cart .= "SALES TAX:     $form_data{'SALESTAX'}\n";
$text_of_confirm_email .= "SALES TAX:     $form_data{'SALESTAX'}\n";
$text_of_admin_email .= "SALES TAX:     $form_data{'SALESTAX'}\n";
}

$text_of_cart .= "TOTAL:         $form_data{'AMOUNT'}\n\n";
$text_of_confirm_email .= "TOTAL:         $form_data{'AMOUNT'}\n\n";
$text_of_admin_email .= "TOTAL:         $form_data{'AMOUNT'}\n\n";

$text_of_cart .= "BILLING INFORMATION --------------\n\n";
$text_of_admin_email .= "BILLING INFORMATION --------------\n\n";

$text_of_cart .= "NAME:          $form_data{'NAME'}\n";
$text_of_admin_email .= "NAME:          $form_data{'NAME'}\n";

$text_of_cart .= "ADDRESS:       $form_data{'ADDRESS'}\n";
$text_of_admin_email .= "ADDRESS:       $form_data{'ADDRESS'}\n";

$text_of_cart .= "CITY:          $form_data{'CITY'}\n";
$text_of_admin_email .= "CITY:          $form_data{'CITY'}\n";

$text_of_cart .= "STATE:         $form_data{'STATE'}\n";
$text_of_admin_email .= "STATE:         $form_data{'STATE'}\n";

$text_of_cart .= "ZIP:           $form_data{'ZIP'}\n";
$text_of_admin_email .= "ZIP:           $form_data{'ZIP'}\n";

$text_of_cart .= "COUNTRY:       $form_data{'COUNTRY'}\n";
$text_of_admin_email .= "COUNTRY:       $form_data{'COUNTRY'}\n";

$text_of_cart .= "PHONE:         $form_data{'PHONE'}\n";
$text_of_admin_email .= "PHONE:         $form_data{'PHONE'}\n";

$text_of_cart .= "EMAIL:         $form_data{'EMAIL'}\n\n";
$text_of_admin_email .= "EMAIL:         $form_data{'EMAIL'}\n\n";

$text_of_cart .= "SHIPPING INFORMATION --------------\n\n";
$text_of_admin_email .= "SHIPPING INFORMATION --------------\n\n";

$text_of_cart .= "NAME:          $form_data{'SHIPNAME'}\n";
$text_of_admin_email .= "NAME:          $form_data{'SHIPNAME'}\n";

$text_of_cart .= "ADDRESS:       $form_data{'SHIPTOSTREET'}\n";
$text_of_admin_email .= "ADDRESS:       $form_data{'SHIPTOSTREET'}\n";

$text_of_cart .= "CITY:          $form_data{'SHIPTOCITY'}\n";
$text_of_admin_email .= "CITY:          $form_data{'SHIPTOCITY'}\n";

$text_of_cart .= "STATE:         $form_data{'SHIPTOSTATE'}\n";
$text_of_admin_email .= "STATE:         $form_data{'SHIPTOSTATE'}\n";

$text_of_cart .= "ZIP:           $form_data{'SHIPTOZIP'}\n";
$text_of_admin_email .= "ZIP:           $form_data{'SHIPTOZIP'}\n";

$text_of_cart .= "COUNTRY:       $form_data{'SHIPTOCOUNTRY'}\n\n";
$text_of_admin_email .= "COUNTRY:       $form_data{'SHIPTOCOUNTRY'}\n\n";

if ($sc_use_pgp =~ /yes/i)
{
&require_supporting_libraries(__FILE__, __LINE__, "$sc_pgp_lib_path");
$text_of_cart = &make_pgp_file($text_of_cart, "$sc_pgp_temp_file_path/$$.pgp");
$text_of_cart = "\n" . $text_of_cart . "\n";

$text_of_admin_email = &make_pgp_file($text_of_admin_email, "$sc_pgp_temp_file_path/$$.pgp");
$text_of_admin_email = "\n" . $text_of_admin_email . "\n";
}

if ($sc_send_order_to_email =~ /yes/i)
{
&send_mail($sc_order_email, $sc_order_email, "Online Order",$text_of_admin_email);
}

if ($sc_send_order_to_log =~ /yes/i) {
open (ORDERLOG, "+>>./log_files/$sc_order_log_name");
print ORDERLOG "-" x 60 . "\n";
print ORDERLOG $text_of_cart;
print ORDERLOG "-" x 60 . "\n";
close (ORDERLOG);
}

if ($cartData)
{
&send_mail($sc_admin_email, $form_data{'EMAIL'}, "Thank you for your order!", "$text_of_confirm_email");
}
  
print <<ENDOFTEXT;
<CENTER>
<TABLE WIDTH=500>
<TR>
<TD WIDTH=500>
<FONT FACE=ARIAL>
<P>&nbsp;</P>
Thank you for shopping with us. Your order has been received and will be 
shipped as soon as possible. Please visit us again soon!<br>
<P>&nbsp;</P>
<a href=$sc_store_url>Return To Front Page</a>
<P>&nbsp;</P>
<P>&nbsp;</P>
</FONT>
</TD>
</TR>
</TABLE>
<CENTER>  

ENDOFTEXT

# This empties the cart after the order is successful

open (CART, ">$sc_cart_path");
close (CART);

# and the footer is printed

&SecureStoreFooter;

print qq!
</BODY>
</HTML>
!;

} # End of process_order_form

#################################################################

#################################################################

sub display_calculations {

local($upgradeShipPrice, $shipMethod) = split (/\|/,$form_data{upgradeShipping});

local($subtotal,
      $are_we_before_or_at_process_form,
      $total_measured_quantity,
      $text_of_cart) = @_;

local($final_shipping,
	$final_discount,
	$final_sales_tax,$grand_total) =
	&calculate_final_values($subtotal,
	$total_quantity,
	$total_measured_quantity,
	$are_we_before_or_at_process_form);
 
if ($final_shipping > 0)
{
print "<TR>\n";
print "<TD>\n";

$final_shipping = &format_price($final_shipping);

$pass_final_shipping = $final_shipping;

$final_shipping = &display_price($final_shipping);

if($upgradeShipPrice && $shipMethod)
{

print "<CENTER>$cart_font_style $shipMethod: $final_shipping</FONT></CENTER>\n";

$text_of_cart .= &format_text_field("$shipMethod:") . 
"= $final_shipping\n\n";

}
else
{

print "<CENTER>$cart_font_style Shipping: $final_shipping</FONT></CENTER>\n";

$text_of_cart .= &format_text_field("Shipping:") . 
"= $final_shipping\n\n";

}
print "</TD>\n";
print "</TR>\n";


};

if ($final_discount > 0)
{
$final_discount = &format_price($final_discount);

$pass_final_discount = &format_price($final_discount);

$final_discount = &display_price($final_discount);

print "<TR>\n";
print "<TD>\n";
print "<CENTER>$cart_font_style Discount: $final_discount</FONT></CENTER>\n";
print "</TD>\n";
print "</TR>\n";

$text_of_cart .= &format_text_field("Discount:") . 
"= $final_discount\n\n";
}

if ($final_sales_tax > 0)
{
$final_sales_tax = &format_price($final_sales_tax);
$pass_final_sales_tax = $final_sales_tax;

$final_sales_tax = &display_price($final_sales_tax);

print "<TR>\n";
print "<TD>\n";
print "<CENTER>$cart_font_style Sales Tax: $final_sales_tax</FONT></CENTER>\n";
print "</TD>\n";
print "</TR>\n";

$text_of_cart .= &format_text_field("Sales Tax:") . 
"= $final_sales_tax\n\n";
}

$authPrice = $grand_total;
$grand_total = &display_price($grand_total);

print "<TR>\n";
print "<TD>\n";
print "<CENTER>$cart_font_style Grand Total: $grand_total</FONT></CENTER><P>\n";
print "</TD>\n";
print "</TR>\n";
print "</TABLE>\n";

if ($are_we_before_or_at_process_form =~ /at/i) 
{
print <<ENDOFTEXT;

</FORM>

<FORM METHOD=POST ACTION=\"$sc_order_script_url\">

<INPUT TYPE=HIDDEN NAME=cart_id VALUE=\"$cart_id\">

<INPUT TYPE=HIDDEN NAME=\"SUBTOTAL\" VALUE=\"$subtotal\">
<INPUT TYPE=HIDDEN NAME=\"SHIPPING\" VALUE=\"$pass_final_shipping\">
<INPUT TYPE=HIDDEN NAME=\"SHIPMETHOD\" VALUE=\"$shipMethod\">
<INPUT TYPE=HIDDEN NAME=\"SALESTAX\" VALUE=\"$pass_final_sales_tax\">
<INPUT TYPE=HIDDEN NAME=\"AMOUNT\" VALUE=\"$authPrice\">

ENDOFTEXT
}

$text_of_cart .= &format_text_field("Grand Total:") . 
"= $grand_total\n\n";

return ($text_of_cart);

}

1;
