/*
 * readchar, by M. Andreoli (2000)
 *
 * wait for ONE character and send it to stdout
 */

#include <stdio.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/ioctl.h>

#define TRUE 1
#define FALSE 0

int output_char(u_char);

struct termios old_tc; 
struct termios new_tc;
char status_file[64];
char status[128];

main (int argc, char *argv[]) {
    u_char cmd;

	set_raw_term();

	while (1) {
        cmd = getchar();
	output_char(cmd);
	}
tcsetattr(0, TCSANOW, &old_tc);  

}


output_char (u_char c)
{
if ( c !=  (u_char) 255 ) 
	{
	fprintf(stdout,"%c\n",c);
	reset_term();
	exit(0);
	}
}


set_raw_term() {
    tcgetattr(0, &old_tc);
    new_tc = old_tc;
    new_tc.c_lflag &= ~(ECHO | ICANON);		/* raw output */
    new_tc.c_cc[VTIME] = 1; 
    /*new_tc.c_cc[VMIN] = 0; */ 

    tcsetattr(0, TCSANOW, &new_tc);
}

reset_term() {
    tcsetattr(0, TCSANOW, &old_tc);
}			

