GTCOM:	LDA	TOKEN	;GET TOKEN VALUE
	CPI	2
	JNZ	E5
	MVI	D,1	;INITIALIZE CHARACTER COUNT
	LHLD	INDX
	CALL	SSCHK
	PUSH	H	;SAVE COMMAND START
GET2:	CALL	GTOKN	;GET NEXT TOKEN
	LDA	TOKEN
	CPI	2
	JNZ	GET3
	INR	D	;INCREMENT COUNT
	JMP	GET2
GET3:	XRA	A	;RESET FLAG FOR Z COMMANDS
	STA	I
	POP	H
	MOV	A,M
	CPI	'Z'	;SEE IF Z COMMAND
	JNZ	GET31
	INX	H	;MOVE PAST 'Z'
	DCR	D
	MVI	A,1
	STA	I	;SET Z FLAG
GET31:	MOV	C,D
	LDA	I
	ORA	A
	LDA	FNC
	JZ	GET34	;CHECK Z FLAG
	CPI	0	;CHECK FUNCTION FLAG
	JNZ	GET32
	LXI	D,ZCOMM	;Z COMMANDS--NO $
	JMP	GET37
GET32:	CPI	1
	JNZ	GET33
	LXI	D,ZFUNC	;Z COMMAND--$ FUNCTION
	JMP	GET37
GET33:	LXI	D,ZSPEC	;Z COMMAND--$ SPECIAL VARIABLE
	JMP	GET37
GET34:	CPI	0	;CHECK FUNCTION FLAG
	JNZ	GET35
	LXI	D,COMMS	;REGULAR COMMANDS
	JMP	GET37
GET35:	CPI	1	
	JNZ	GET36
	LXI	D,FUNCS	;$ FUNCTIONS
	JMP	GET37
GET36:	LXI	D,SPECS	;$ SPECIAL VARIABLES
GET37:	MOV	A,C
	CPI	1
	JZ	GET9	;IT'S A 1 CHARACTER COMMAND
GET4:	PUSH	H
	LDAX	D
	CPI	CR	;CHECK FOR END OF COMMAND TABLE
	JZ	E5
	MOV	B,A
	CMP	C	;COMPARE LENGTHS
	JNZ	GET75
	INX	D
	MOV	B,C
GET6:	LDAX	D
	CMP	M	;COMPARE LETTERS
	JNZ	GET8
	INX	H
	INX	D
	DCR	B
	JNZ	GET6
	POP	H	;IT'S A MATCH
GET7:	LDA	FNC	;CHECK FUNCTION FLAG
	CPI	1
	JNZ	GET73
	CALL	GTOKN
GET73:	LDAX	D
	MOV	L,A
	INX	D
	LDAX	D
	MOV	H,A
	XRA	A
	STA	LOCKS
	PCHL
GET75:	INX	D
GET8:	INX	D	;NO MATCH--TRY NEXT ENTRY
	DCR	B
	JNZ	GET8
	INX	D
	INX	D
	POP	H
	JMP	GET4
GET9:	LDAX	D	;TRY FIRST CHARACTER MATCHES
	MOV	B,A
	CPI	CR
	JZ	E5
	MOV	B,A
	INX	D
	LDAX	D
	CMP	M
	JNZ	GET12
GET11:	INX	D	;GET LOCATION
	DCR	B
	JNZ	GET11
	JMP	GET7
GET12:	INX	D	;MOVE TO NEXT COMMAND
	DCR	B
	JNZ	GET12
	INX	D
	INX	D
	JMP	GET9
;
;
COMMS:	DB	3,'SET'
	DW	TES
	DB	2,'IF'
	DW	FI
	DB	4,'ELSE'
	DW	ELSE
	DB	3,'FOR'
	DW	FOR
	DB	2,'DO'
	DW	DO
	DB	4,'GOTO'
	DW	GOTO
	DB	5,'WRITE'
	DW	WRITE
	DB	4,'READ'
	DW	READ
	DB	4,'KILL'
	DW	KILL
	DB	4,'LOCK'
	DW	LOCK
	DB	3,'USE'
	DW	USE
	DB	6,'XECUTE'
	DW	XECUT
	DB	5,'CLOSE'
	DW	CLOSE
	DB	4,'OPEN'
	DW	OPEN
	DB	4,'QUIT'
	DW	QUIT
	DB	1,'H'
	DW	HS
	DB	4,'HANG'
	DW	HANG
	DB	5,'BREAK'
	DW	BREAK
	DB	4,'HALT'
	DW	HALT
	DB	4,'VIEW'
	DW	VIEWS
	DB	CR
;
;
FUNCS:	DB	5,'ASCII'
	DW	ASCII
	DB	4,'CHAR'
	DW	CHAR
	DB	4,'DATA'
	DW	DATA
	DB	7,'EXTRACT'
	DW	EXTRA
	DB	4,'FIND'
	DW	FIND
	DB	7,'JUSTIFY'
	DW	JUSTI
	DB	6,'LENGTH'
	DW	LENGT
	DB	4,'NEXT'
	DW	NEXT
	DB	5,'ORDER'
	DW	ORDER
	DB	5,'PIECE'
	DW	PIECE
	DB	6,'RANDOM'
	DW	RANDO
	DB	6,'SELECT'
	DW	SELEC
	DB	4,'TEXT'
	DW	TEXT
	DB	4,'VIEW'
	DW	VIEW
	DB	CR
;
;
SPECS:	DB	7,'HOROLOG'
	DW	HOROL
	DB	2,'IO'
	DW	IO
	DB	3,'JOB'
	DW	JOB
	DB	7,'STORAGE'
	DW	STORA
	DB	4,'TEST'
	DW	TEST
	DB	1,'X'
	DW	X
	DB	1,'Y'
	DW	Y
	DB	CR
;
;
ZCOMM:	DB	4,'SAVE'
	DW	ZSAVE
	DB	4,'LOAD'
	DW	ZLOAD
	DB	5,'PRINT'
	DW	ZPRIN
	DB	6,'DELETE'
	DW	ZDELE
	DB	6,'REMOVE'
	DW	ZREMO
	DB	4,'MOVE'
	DW	ZMOVE
	DB	2,'GO'
	DW	ZGO
	DB	6,'INSERT'
	DW	ZINSE
	DB	6,'OPTION'
	DW	ZOPTI
	DB	4,'CALL'
	DW	ZCALL
	DB	3,'ARG'
	DW	ZARG
	DB	CR
;
;
ZSPEC:	DB	4,'NAME'
	DW	ZNAME
	DB	CR
;
;
ZFUNC:	DB	3,'ARG'
	DW	ZGRA
	DB	CR
;
;
;
GTOKN:	CALL	SSCHK
	PUSH	H	;SAVE REGISTERS
	PUSH	D
	PUSH	B 
	CALL	INCHK	;SEE IF A CHARACTER
	LHLD	INDX	;GET ACTUAL CHARACTER
	INX	H
	SHLD	INDX
	MVI	A,127	;SEE IF LEGAL CHAR
	CMP	M
	JNC	GTOK0
	XRA	A
	JMP	GTOK1
GTOK0:	MOV	C,M
	MVI	B,0
	LXI	H,TKTBL	;FIND IT IN THE TABLE
	DAD	B
	MOV	A,M
GTOK1:	STA	TOKEN
	POP	B	;RESTORE REGISTERS
	POP	D
	POP	H
	RET
;
;
TKTBL:	DB	40,50,50,50,50,50,50,50,50,37
	DB	38,50,39,50,50,50,50,50,50,50
	DB	50,50,50,50,50,50,50,50,50,50
	DB	50,50,31,12,23,09,27,19,11,04
	DB	25,26,07,05,21,06,28,08,03,03
	DB	03,03,03,03,03,03,03,03,22,29
	DB	13,17,14,30,24,02,02,02,02,02
	DB	02,02,02,02,02,02,02,02,02,02
	DB	02,02,02,02,02,02,02,02,02,02
	DB	02,15,10,16,20,18,32,01,01,01
	DB	01,01,01,01,01,01,01,01,01,01
	DB	01,01,01,01,01,01,01,01,01,01
	DB	01,01,01,35,33,36,34,50
;
;
CKCHR:	MVI	A,FALSE
	STA	RESUL
	MVI	L,3	;SEE IF A CHARACTER
	CALL	BIOS
	ORA	A
	RZ
;
	MVI	L,6
	CALL	BIOS
	STA	CHR
	MVI	A,TRUE
	STA	RESUL
	RET
;
;
INCHK:	MVI	L,3	;SEE IF A CHARACTER
	CALL	BIOS
	ORA	A
	RZ		;RETURN IF NOTHING
;
	MVI	L,6	;GET CHARACTER
	CALL	BIOS
;
	CPI	CTRLC
	JZ	ERR25	;RESTART IF CONTROL-C
;
	CPI	CTRLP
	JNZ	INCK1
	LDA	PTOGL	;FLIP PRINT TOGGLE
	XRI	1
	STA	PTOGL
	RET
;
INCK1:	CPI	CTRLS
	RNZ		;IGNORE ALL OTHERS
	MVI	A,1	;SET STOP TOGGLE
	STA	STOGL
	RET
;
;
ERROR:	LHLD	SSTK
	SPHL
	PUSH	PSW
	CALL	CRLF
	LDA	MODE	;SEE IF DIRECT MODE
	ORA	A
	JNZ	ERR2	;IF DIRECT, DON'T WRITE OUT LBUFF
	LHLD	LBUFF
ERR0:	MOV	A,M	;GET CHAR FROM LINE EXECUTION BUFFER
	CPI	EOL	;SEE IF AT END
	JZ	ERR1
	PUSH	H
	CALL	TRMOT	;WRITE OUT CHAR
	POP	H
	INX	H
	JMP	ERR0
ERR1:	CALL	CRLF
ERR2:	POP	PSW
	STA	I1
	LXI	D,ERFCB
	MVI	C,15
	CALL	BDOS	;OPEN ERROR MSG FILE
;
	CPI	255	;SEE IF ERROR MSG FILE PRESENT
	LDA	I1	;RELOAD ERROR NUMBER
	JNZ	ERR22	;JUMP IF FILE PRESENT
;
	LXI	H,ERRMS+5	;JUST WRITE OUT ERROR NUMBER
	MVI	M,'0'-1
ERR21:	INR	M
	SUI	10
	JNC	ERR21
	ADI	10+'0'
	INX	H
	MOV	M,A
	LXI	H,ERRMS	;GET READY TO WRITE IT
	JMP	ERR23
ERR22:	RLC
	MOV	E,A	;SAVE ERROR NUMBER
	MVI	D,0
	LXI	H,ERRS
	DAD	D	;GET OFFSET TO ERROR MESSAGE
	MOV	E,M	;MSG START WITHIN SECTOR TO E
	INX	H
	MOV	D,M	;SECTOR NUMBER TO D
	PUSH	D	;AND SAVE IT
	LXI	D,80H	;DEFAULT BUFFER
	MVI	C,DMAF
	CALL	BDOS
	POP	D
	PUSH	D
	LXI	H,ERFCB+32
	MOV	M,D	;SET SECTOR NUMBER TO READ
	LXI	D,ERFCB
	MVI	C,20
	CALL	BDOS	;READ ERROR MSG SECTOR
;
	POP	D	;RESTORE START OF MSG
	MVI	D,0	;NOW OFFSET IN D,E
	LXI	H,80H	;H,L TO START OF DEFAULT BUFFER
	DAD	D	;H,L TO START OF MSG
;
ERR23:	MOV	A,M	;GET A CHAR TO PRINT
	CPI	CR	;SEE IF DONE
	JZ	ERR24	;GET OUT IF DONE
;
	PUSH	H	;SAVE WHERE WE GOT THE CHAR FROM
	CALL	TRMOT	;PRINT CHAR
	POP	H	;RESTORE CHAR
	INX	H
	JMP	ERR23
;
ERR25:	CALL	CRLF	;ENTRY POINT FROM CONTROL-C
	LDA	FLG1
	ANI	4
	STA	FLG1
	JMP	ERR3
;
ERR24:	CALL	CRLF
ERR3:	LDA	FLG1
	ANI	8
	JZ	ERR35
	LHLD	BKPTR
	SHLD	TOS
	JMP	ERR4
ERR35:	LHLD	XSTK
	SHLD	TOS
ERR4:	XRA	A
	STA	IT
	CALL	SETDE
	LDA	FLG1
	ANI	0CH
	STA	FLG1
	LDA	I1
	CPI	38
	JZ	MMP0
	JMP	MMP1A
;
ERRS:	DW	0000H,001DH,002DH,0042H,005CH
	DW	0100H,0116H,012EH,0145H,015CH
	DW	0200H,021FH,0230H,0247H,0264H
	DW	0300H,031BH,0337H,0349H,035CH
	DW	0400H,0414H,0425H,0434H,044BH
	DW	0500H,051FH,0538H,054CH,056BH
	DW	0600H,0619H,0630H,064CH,065DH
	DW	0700H,071AH,073AH,0753H,0768H
	DW	0800H,0815H,0831H,0849H
	DW	0900H,091FH,093FH,0952H,0965H
	DW	0A00H,0A12H,0A21H,0A48H
;
; SCMP COMPARES TWO STRINGS WITH:
;      H,L AT START OF STRING #1
;      D,E AT START OF STRING #2
;      B   HAS LENGTH OF STRING #1
;      C   HAS LENGTH OF STRING #2
; ON EXIT:
;      IF #1 = #2, Z IS SET
;      IF #1 <= #2, NC IS SET
;      IF #1 > #2, C IS SET
;      IF #1 <> #2, NZ IS SET
;
SCMP:	PUSH	H	;SAVE REGISTERS
	PUSH	D
	PUSH	B
;
SCMP1:	MOV	A,B	;GET LENGTH OF STRING #1
	ORA	A	;SEE IF FINISHED
	JNZ	SCMP2	;JUMP IF MORE LEFT
	ORA	C	;SEE IF ALL DONE
	JZ	SCMP5	;JUMP IF BOTH STRINGS EQUAL
	JMP	SCMP4	;#1 DONE, #2 HAS SOME LEFT (H,L < D,E)
SCMP2:	MOV	A,C	;GET LENGTH OF STRING #2
	ORA	A	;SEE IF FINISHED
	JZ	SCMP4	;#2 DONE, #1 HAS SOME LEFT (H,L > D,E)
	LDAX	D	;GET STRING #2 CHARACTER
	CMP	M	;COMPARE TO STRING #1 CHARACTER
	JNZ	SCMP5	;JUMP IF DIFFERENT CHARACTER
	INX	H	;MOVE TO NEXT IN STRING #1
	INX	D	;MOVE TO NEXT IN STRING #2
	DCR	B	;DECREMENT STRING #1 COUNT
	DCR	C	;DECREMENT STRING #2 COUNT
	JMP	SCMP1	;AND LOOP
SCMP4:	CMP	B	;AND COMPARE TO B (ONE IS ZERO THE OTHER +)
SCMP5:	POP	B	;RESTORE REGISTERS
	POP	D
	POP	H
	RET
;
;
; ARITHMETIC FUNCTIONS
;
;	ON ENTRY:
;	  PTR1 POINTS TO OP #1
;	  PTR2 POINTS TO OP #2
;	  I1   LENGTH OF OP #1
;	  I2   LENGTH OF OP #2
;	  I6   OPERATION TOKEN
;
;	ON EXIT:
;	  RESULT IS ON STACK
;
;
NUMOP:	LDA	I6	;GET OPERATION
	PUSH	PSW	;SAVE OPERATION
	LDA	I1	;GET #1 OPERAND LENGTH
	MOV	C,A
	MVI	B,BCDLN	;LENGTH OF BCD NUMBER IN BYTES
	LHLD	PTR1	;POINTER TO OP #1
	LXI	D,OP1	;DESTINATION
	CALL	BCDPK	;PACK STRING INTO BCD IN OP1
	STA	SGN1	;SAVE SIGN
	LDA	COUNT
	STA	DP1	;SAVE COUNT OF DECIMAL PLACES
;
	LDA	I2	;GET OPERAND #2 LENGTH
	MOV	C,A
	LHLD	PTR2	;GET POINTER TO OP #2
	LXI	D,OP2	;DESTINATION
	CALL	BCDPK	;PACK OPERAND #2 IN OP2 IN BCD
	STA	SGN2	;SAVE OPERAND #2 SIGN
	LDA	COUNT	;SAVE COUNT OF DECCIMAL PLACES
	STA	DP2
;
FOPS3B:	MOV	C,A	;SAVE OP2 DECIMAL PLACES IN C
	LDA	DP1
	MOV	B,A
	POP	PSW	;RESTORE OPERATION
;
	CPI	13
	JNC	FOPS2
;
	CPI	7
	JNC	FOPS9	;JUMP IF NOT + OR -
;
	CPI	5	;SEE IF +
	JZ	FOPS3A
;
FOPS2:	LDA	SGN2	;CHANGE SIGN OF OP2
	XRI	1
	STA	SGN2
;
FOPS3A:	MOV	A,B
	SUB	C	;COMPARE DP1 WITH DP2
	JZ	FOPS6	;JUMP IF BOTH THE SAME
;
	JC	FOPS4	;JUMP IF DP1 < DP2
;
	MOV	C,B	;DP2 > DP1 SO SHIFT OP2
	MOV	B,A	;SAVE RESULT DP IN B
	LXI	H,I2
	MVI	A,BCDLN*2
	SUB	M	;SEE IF ROOM TO SHIFT
	CMP	B
	LXI	H,OP2	;GET READY TO SHIFT OP2
	JNC	FOPS5
;
	LXI	D,OP1
	XCHG
	CALL	BCDST	;SET OP1 TO OP2
	LDA	DP2
	STA	DP1	;SET DECIMAL PLACES
	LDA	S2
	STA	S1
	JMP	FOPS45
;
FOPS4:	CMA
	INR	A	;MAKE # > 0
	MOV	B,A
	LXI	H,I1
	MVI	A,BCDLN*2
	SUB	M
	CMP	B
	JC	FOPS45	;ALL DONE
	JMP	FOPS46
;
FOPS45:	LDA	I6
	CPI	13
	JNC	FOPSD3
	JMP	FOPSE
;
FOPS46:	LXI	H,OP1	;GET READY TO SHIFT OP1
FOPS5:	PUSH	B	;SAVE B,C DURING SHIFT
	MVI	C,BCDLN
FOPS5A:	CALL	TIM10	;SHIFT IT
	DCR	B
	JNZ	FOPS5A
	POP	B	;RESTORE B,C
;
FOPS6:	MOV	A,C	;GET NUMBER OF DECIMAL PLACES IN RESULT
	STA	DP1
;
	LXI	H,SGN1
	LDA	SGN2
	CMP	M	;COMPARE SIGNS
	LXI	H,OP1
	LXI	D,OP2
	MVI	C,BCDLN
	JNZ	FOPS7
	LDA	I6
	CPI	13
	JNC	FOPSD3
;
	CALL	BCDAD	;DO ADDITION
	JMP	FOPSE
FOPS7:	MVI	B,BCDLN
	CALL	SCMP	;COMPARE OPERANDS
	JC	FOPS8
	XCHG		;IF HERE, OP1 <= OP2
	LDA	SGN2
	STA	SGN1
FOPS8:	PUSH	PSW	;SAVE Z AND C FOR < & >
	LDA	I6
	CPI	13
	JNC	FOPSE3
	POP	PSW	;GET RID OF Z AND C
;
	CALL	BCDSB	;SUBTRACT
	JMP	FOPSE
;
FOPS9:	CPI	9	;SEE IF MOD
	JZ	FOPSA	;IF SO, DON'T DO SIGN STUFF
	CPI	11
	JNC	FOPSD1
;
	PUSH	PSW	;SAVE OPERATION
;
	LXI	H,SGN1
	LDA	SGN2	;COMPARE SIGNS
	XRA	M	;SET RESULT SIGN
	STA	SGN1	;SAVE RESULT SIGN
;
	POP	PSW	;RESTORE OPERATION
	CPI	7	;SEE IF *
	JNZ	FOPSA	;JUMP IF NOT MULTIPLICATION
;
	MOV	A,B
	ADD	C	;GET DP IN RESULT
	STA	DP1
;
	LXI	H,OP1
	LXI	D,OP2
	MVI	C,BCDLN
	CALL	BCDML
	LXI	H,TNUMB	;POINT TO ANSWER
	JMP	FOPSE
;
FOPSA:	PUSH	PSW	;SAVE OPERATION
;
	CPI	9	;SEE IF MOD
	JNZ	FOPSA3	;JUMP IF NOT
;
	LXI	H,SOP1
	LXI	D,OP1
	PUSH	B
	MVI	C,BCDLN
	CALL	BCDST	;SAVE OP1 FOR END OF MOD
	POP	B
;
FOPSA3:	MOV	A,B	;GET DECIMAL PLACES IN DIVIDEND
	SUB	C	;GET DIFFERENCE TO DIVISOR
	JC	FOPSA0	;JUMP IF MORE IN DIVISOR
;
	MOV	B,A	;SET D.P. FOR QUOTIENT
	JMP	FOPSA2
;
;
FOPSA0:	LXI	H,OP1	;SET UP FOR SHIFT
	MVI	C,BCDLN
	CMA		;GET NUMBER TO SHIFT POSITIVE
	INR	A
	MOV	B,A
FOPSA1:	CALL	TIM10	;SHIFT DIVIDEND
	DCR	B
	JNZ	FOPSA1
;
FOPSA2:	POP	PSW
	CPI	8	;SEE IF REAL DIVIDE
	JNZ	FOPSC
;
FOPSB:	LXI	H,OP1
	LXI	D,OP2
	MVI	C,BCDLN
	CALL	BCDRD
	LXI	H,RTNUM	;POINT TO ANSWER
	MOV	A,B
	STA	DP1	;SET DECIMAL PLACES
	JMP	FOPSE
;
FOPSC:	CPI	9	;SEE IF MOD
	JNZ	FOPSD
;
	LXI	H,OP1
	LXI	D,OP2
	MVI	C,BCDLN
	CALL	BCDRD	;GET OP1 / OP2
;
	LXI	D,RTNUM
	CALL	ISET	;GET INTEGER ( OP1 / OP2 )
;
	MOV	A,B	;GET # OF DECIMAL PLACES IN RESULT
	ORA	A
	JZ	FOPSC1	;JUMP IF NONE
;
	LDA	SGN1
	LXI	H,SGN2
	CMP	M	;CHECK RESULT SIGN
	LXI	H,OP1
	JZ	FOPSC1	;JUMP IF RESULT POSITIVE
;
	CALL	ADD1
;
FOPSC1:	LXI	D,OP2
	CALL	BCDML	;GET OP1 * FLOOR (OP1 / OP2)
;
	LXI	H,OP1	;PUT OP1 BACK
	LXI	D,SOP1
	CALL	BCDST
;
	LXI	H,OP2
	LXI	D,TNUMB
	CALL	BCDST	;SET OP2 TO OP1 * FLOOR (OP1 / OP2)
;
	LDA	SGN1	;SET SIGN FOR  ABOVE OPERATIONS
	STA	SGN2
	MVI	A,2	;PUT SUBTRACT OPERATOR ON STACK
	PUSH	PSW
	LDA	DP2	;SET UP OP2 DECIMAL PLACE
	JMP	FOPS3B	;NOW GO SUBTRACT
;
FOPSD:	CPI	10	;SEE IF INTEGER DIVISION
	JNZ	FOPSD1
;
	LXI	H,OP1
	LXI	D,OP2
	MVI	C,BCDLN
	CALL	BCDDV
;
	LXI	H,OP1
	LXI	D,TNUMB	;POINT TO ANSWER
	CALL	ISET	;GRAB INTEGER PART
	XRA	A
	STA	DP1	;SET DECIMAL PLACES IN ANSWER
	JMP	FOPSE
;
FOPSD1:	CPI	11	;SEE IF AND
	JNZ	FOPSD2
;
	LXI	H,OP1
	MVI	C,BCDLN
	CALL	ZTEST	;SEE IF OP #1 IS ZERO
	JZ	ZANS	;IF YES, RESULT IF 0
;
	LXI	H,OP2
	CALL	ZTEST	;CHECK OP #2
	JZ	ZANS	;IF ZERO, RESULT IS 0
	JMP	OANS	;BOTH ARE NON-ZERO
;
FOPSD2:	CPI	12	;SEE IF OR
	JNZ	FOPSD3
;
	LXI	H,OP1
	MVI	C,BCDLN
	CALL	ZTEST	;SEE IF OP #1 IS ZERO
	JNZ	OANS	;IF NOT, RESULT IS ONE
;
	LXI	H,OP2
	CALL	ZTEST	;CHECK OP #2
	JZ	ZANS	;BOTH ARE ZERO
	JMP	OANS
;
FOPSE3:	POP	PSW	;GET Z AND C
	JZ	ZANS	;BOTH WERE THE SAME SO ZERO RESULT
	LDA	I6
FOPSD3:	CPI	13	;SEE IF LESS THAN
	JNZ	FOPSD4
;
	LDA	SGN1
	ORA	A
	JZ	ZANS
	JMP	OANS
;
FOPSD4:	LDA	SGN1	;IT'S A GREATER THAN
	ORA	A
	JZ	OANS
;
ZANS:	LDA	FLG1	;CHECK NOT FLAG
	ANI	NOTFL
	JNZ	OANS1
ZANS1:	MVI	A,'0'	;RESULT IS NUMBER 0
	JMP	ENDIT
OANS:	LDA	FLG1	;CHECK NOT FLAG
	ANI	NOTFL
	JNZ	ZANS1
OANS1:	MVI	A,'1'
;
ENDIT:	CALL	SPUSH
	MVI	A,1
	CALL	SPUSH
	MVI	A,3
	CALL	SPUSH
	RET
;
FOPSE:	MVI	C,MAXDG
	CALL	BCDRN	;ROUND OFF NUMBER IN OP1 TO MAXDG PLACES
	CALL	BCDPS	;PUSH RESULT ON STACK
	RET
;
;
;BCDPK PACKS A STRING INTO BCD FORM
;	ON ENTRY:
;	   H,L AT MOST SIGNIFICANT BYTE OF STRING
;	   D,E AT MOST SIGNIFICANT BYTE OF OF BCD PLACE
;	   B   MAX NUMBER OF BYTES ALLOWED (14 FOR REAL, 5 FOR INTEGER)
;	   C   NUMBER OF BYTES IN STRING
;
;	ON EXIT:
;	  A  SIGN OF BCD NUMBER--0 IF POSITIVE, 1 IF NEGATIVE
;	  COUNT  NUMBER OF DECIMAL PLACES
;
;
BCDPK:	PUSH	H	;SAVE REGISTERS
	PUSH	D
;
	MVI	A,'-'	;CHECK FOR NEGATIVE
	CMP	M
	MVI	A,0	;ASSUME >= 0
	JNZ	BCDP0
	INX	H	;SKIP MINUS SIGN
	DCR	C
	MVI	A,1	;SET < 0
BCDP0:	PUSH	B
	PUSH	PSW	;SAVE SIGN INDICATOR
;
	CALL	SKPST	;MOVE H,L OVER (H,L TO LEAST SIGNIF DIGIT)
	XCHG		;H,L AT DESTINATION & D,E AT SOURCE
;
	MOV	A,B	;GET MAX DIGITS
	ADD	A
	DCR	A	;CONVERT TO DIGITS
	CMP	C	;COMPARE TO ACTUAL DIGITS
	JC	E2	;ARITHMETIC OVERFLOW
;
;
	PUSH	B
	MOV	C,B	;SET C TO MAX NUMBER
	CALL	SKPST	;MOVE H,L TO DEST LEAST SIGNIF. DIGIT
	POP	B	;RESTORE OLD B,C
;
	XRA	A
	STA	COUNT	;SET DECIMAL PLACES COUNT
	STA	DFLAG	;RESET DECIMAL PLACE FLAG
;
BCDP1:	CALL	CHKDP	;CHECK FOR DECIMAL PLACE AND COUNT DIGITS
	JZ	BCDP2B
;
	ANI	0FH	;STRIP ASCII BIAS
	MOV	M,A	;SAVE
	DCR	C
	JZ	BCDP2A	;SEE IF DONE
;
	DCX	D	;MOVE TO NEXT (PREVIOUS) DIGIT
	CALL	CHKDP	;CHECK FOR DECIMAL PLACE AND COUNT DIGITS
	JZ	BCDP2A
;
	ANI	0FH	;STRIP ASCII BIAS
	RLC
	RLC
	RLC
	RLC		;SHIFT DIGIT TO HIGH ORDER NIBBLE
;
	ORA	M	;INCLUDE LOW ORDER NIBBLE
BCDP2:	MOV	M,A	;SAVE IN DESTINATION
	DCX	D
	DCX	H
	DCR	B
	DCR	C
	JNZ	BCDP1	;LOOP UNTIL DONE
	JMP	BCDP2B
;
BCDP2A:	DCX	H
	DCR	B
;
BCDP2B:	MOV	A,B	;GET NUMBER OF  DIGITS LEFT
	ORA	A
	JZ	BCDP4	;JUMP IF DONE
BCDP3:	MVI	M,0	;ZERO OUT BYTE
	DCR	B
	DCX	H
	JNZ	BCDP3
BCDP4:	POP	PSW	;GET SIGN
	POP	B
	PUSH	PSW	;SAVE SIGN
	LDA	DFLAG
	ORA	A	;CHECK IF HAD A DECIMAL PLACE
	JZ	BCDP5	;JUMP IF NO
;
	LXI	H,COUNT
	MOV	A,C
	SUB	M	;ADJUST COUNT
	STA	COUNT
;
BCDP5:	POP	PSW	;GET SIGN BACK
	POP	D
	POP	H
	RET
;
;
; CHKDP CHECKS FOR DECIMAL PLACE AND COUNTS THE DECIMAL DIGITS
;
;	ON ENTRY:
;	  D,E IS AT BYTE TO CHECK
;	  C   NUMBER OF DIGITS LEFT IN STRING
;
;	ON EXIT:
;	  D,E IS MOVED IF BYTE WAS DECIMAL PLACE
;	  Z    SET IF DECIMAL PLACE WAS LAST CHARACTER IN STRING
;	  COUNT IS INCREMENTED IF A DECIMAL PLACE FOUND PREVIOUSLY
;	  DFLAG IS SET IF DECIMAL PLACE ENCOUNTERED
;
CHKDP:	PUSH	H	;SAVE H,L
	LDAX	D	;GET THE CHARACTER
	CPI	'.'	;SEE IF A DECIMAL PLACE
	JNZ	CHKD1
	MVI	A,1	;D.P. FOUND SO SET DFLAG
	STA	DFLAG
;
	DCX	D	;SKIP D.P.
	LXI	H,COUNT
	INR	M
	DCR	C	;DECREMENT STRING COUNT
	JZ	CHKD3
;
CHKD1:	LDA	DFLAG	;CHECK DECIMAL PLACE FLAG
	ORA	A
	JZ	CHKD2
;
	LXI	H,COUNT
	INR	M
;
CHKD2:	LDAX	D	;GET CHARACTER BACK
	ORA	A	;RESET Z FLAG
CHKD3:	POP	H	;RESTORE H,L
	RET
;
;
; SKPST SKIPS OVER PARTS OF A STRING
;	ON ENTRY:
;	  H,L IS IN THE STRING
;	  C   IS THE NUMBER OF CHARACTERS TO SKIP
;
;	ON EXIT:
;	  H,L IS MOVED OVER
;	  B,C IS THE SAME AS ON ENTRY
;
SKPST:	PUSH	B	;SAVE B,C
	MVI	B,0
	DAD	B	;MOVE H,L OVER
	DCX	H
	POP	B
	RET
;
;
;
; BCDT2  MULTIPLIES A BCD NUMBER BY 2
;	ON ENTRY:
;	  H,L IS AT MOST SIGNIFICANT DIGIT OF NUMBER
;	  C   IS NUMBER OF BYTES IN BCD NUMBER
;
;	ON EXIT:
;	  RESULT IS IN SAME PLACE
;	  ALL REGISTERS ARE AS AT ENTRY
;
BCDT2:	CALL	SKPST	;MOVE H,L TO LEAST SIGNIFICANT DIGIT
	PUSH	PSW	;SAVE ACCUM
	PUSH	B	;SAVE B,C
	XRA	A
BCDX1:	MOV	A,M	;GET BYTE
	ADC	A	;TIMES 2 PLUS CARRY FROM PREVIOUS BYTE
	DAA		;CONVERT TO BCD
	MOV	M,A	;SAVE IT
	DCX	H
	DCR	C
	JNZ	BCDX1
	INX	H	;BACK UP H,L
	POP	B
	POP	PSW
	RET
;
;
;
; BCDD2 DIVIDES A BCD NUMBER BY 2
;
;	ON ENTRY:
;	  H,L AT MOST SIGNIFICANT BYTE OF BCD NUMBER
;	  C   # OF BYTES IN BCD NUMBER
;
;	ON EXIT:
;	  NUMBER DIVIDED BY TWO AT H,L
;	  ALL REGISTERS SAME AS ON ENTRY (EXCEPT PSW)
;	  IF CARRY SET, THERE WAS A REMAINDER
;
BCDD2:	PUSH	B	;SAVE THE REGISTERS
	PUSH	D
	PUSH	H
	XRA	A	;CLEAR CARRY
	PUSH	PSW	;SAVE CARRY
	MOV	D,A	;ZERO D
BDD1:	POP	PSW	;GET CARRY
	MOV	A,M	;GET NEXT BYTE
	RAR		;DIVIDE BY TWO GRABBING PREVIOUS CARRY
	PUSH	PSW	;SAVE CARRY
	SUB	D	;ADJUST FOR PRIOR CARRY IN
	MOV	E,A	;SAVE SHIFTED BYTE
	POP	PSW
	PUSH	PSW
	JC	BDD2
	MVI	D,0	;NO CARRY ADJUST
	JMP	BDD3
BDD2:	MVI	D,30H	;A CARRY ADJUST
BDD3:	ANI	08H	;CHECK AUX CARRY
	MOV	A,E
	JZ	BDD4	;JUMP IF NO AUX CARRY
	SUI	3	;ADJUST FOR AUX CARRY
BDD4:	MOV	M,A	;SAVE BYTE
	INX	H	;MOVE TO NEXT BYTE
	DCR	C
	JNZ	BDD1
	POP	PSW
	POP	H	;RESTORE REGISTERS
	POP	D
	POP	B
	RET
;
;
;
; BCDAD ADDS THE TWO STRINGS AT H,L AND D,E AND PUTS THE
;	RESULT IN D,E
;
;	ON ENTRY:
;	  H,L IS AT ONE OPERAND
;	  D,E IS AT OTHER OPERAND
;	  C   IS NUMBER OF BYTES IN BCD NUMBER
;
;	ON EXIT:
;	  RESULT IS AT H,L
;	  REGISTERS ARE SAVED
;
BCDAD:	PUSH	B	;SAVE REGISTERS
	PUSH	PSW
	CALL	SKPST	;MOVE H,L TO LEAST SIGNIFICANT BYTE
	XCHG
	CALL	SKPST	;MOVE H,L TO LEAST SIGNIFICANT BYTE
	XRA	A	;CLEAR CARRY
BCDA1:	LDAX	D	;GET A BYTE
	ADC	M	;ADD H,L BYTE + CARRY FROM PREVIOUS
	DAA		;CONVERT BACK TO BCD
	STAX	D	;SAVE SUM
	DCX	H	;MOVE TO NEXT BYTE
	DCX	D
	DCR	C
	JNZ	BCDA1
	JC	E2	;OVERFLOW
	XCHG		;PUT H,L AND D,E BACK WHERE THEY BELONG
	INX	H
	INX	D
	POP	PSW
	POP	B
	RET
;
;
; BCDSB SUBTRACTS BCD NUMBER AT D,E FROM BCD NUMBER AT H,L
;
;	ON ENTRY:
;	  H,L AT MINUEND
;	  D,E AT SUBTRAHEND
;	  C   NUMBER OF BYTES IN BCD NUMBER
;
;	ON EXIT:
;	  H,L AT RESULT
;	  REGISTERS ARE SAVED
;
BCDSB:	PUSH	B	;SAVE REGISTERS
	PUSH	PSW
	CALL	SKPST	;H,L TO LEAST SIGNIFICANT BYTE
	XCHG		;SWAP D,E AND H,L (SO DO D,E - H,L)
	CALL	SKPST	;H,L TO LEAST SIGNIFICANT BYTE
	STC		;INITIAL VALUE FOR CARRY
	PUSH	PSW	;SAVE CARRY
BCDS1:	MVI	A,99H
	SUB	M	;FORM 99 - (H,L)
	MOV	B,A	;SAVE FOR A  MOMENT
	POP	PSW
	LDAX	D
	ADC	B	;FORM 99 - (H,L) + (D,E) + CARRY
	DAA		;CONVERT TO BCD
	STAX	D	;SAVE RESULT
	PUSH	PSW	;SAVE CARRY
	DCX	H
	DCX	D
	DCR	C
	JNZ	BCDS1	;LOOP UNTIL DONE
	POP	PSW	;GET RID OF CARRY
	JNC	E2	;OVERFLOW
	XCHG		;PUT D,E AND H,L BACK
	INX	H
	INX	D
	POP	PSW
	POP	B
	RET
;
;
;
; ADD1 ADDS 1 TO A BCD NUMBER
;
;	ON ENTRY:
;	  H,L IS AT MOST SIGNIFICANT DIGIT OF NUMBER
;	  C   IS NUMBER OF BYTES IN NUMBER
;
;	ON EXIT:
;	  H,L IS AT RESULT
;	  ALL REGISTERS ARE SAVED
;
ADD1:	PUSH	B	;SAVE REGISTERS
	PUSH	PSW
	CALL	SKPST	;H,L TO LEAST SIGNIFICANT BYTE
	XRA	A	;CLEAR CARRY
	MOV	B,A	;ZERO OUT B
	MVI	A,01H
ADD11:	ADC	M
	DAA		;CONVERT TO BCD
	MOV	M,A	;SAVE RESULT
	DCX	H
	DCR	C
	MOV	A,B	;PUT ZERO IN A FOR REST OF SUM
	JNZ	ADD11	;LOOP UNTIL DONE
	JC	E2	;OVERFLOW
	INX	H
	POP	PSW	;RESTORE REGISTERS
	POP	B
	RET
;
;
; SUB1 SUBTRACTS 1 FROM A BCD NUMBER
;
;	ON ENTRY:
;	  H,L IS AT MOST SIGNIFICANT DIGIT OF NUMBER
;	  C   IS NUMBER OF BYTES IN NUMBER
;
;	ON EXIT:
;	  H,L IS AT RESULT
;	  ALL REGISTERS ARE SAVED
;
SUB1:	PUSH	D	;SAVE REGISTERS
	PUSH	B
	PUSH	PSW
;
	CALL	SKPST	;H,L TO LEAST SIGNIFICANT BYTE
	STC		;SET CARRY FOR SUBTRACT
	PUSH	PSW	;SAVE CARRY
	MVI	E,1	;NUMBER SUBTRACTING
;
SUB11:	MVI	A,99H
	SUB	E	;GET 99 - #
	MOV	B,A	;SAVE 99 - #
	POP	PSW	;RESTORE CARRY FROM PREVIOUS DIGIT
	MOV	A,M
	ADC	B	;GET H,L + 99 - # + CARRY
	DAA
	MOV	M,A	;SAVE DIGITS
;
	PUSH	PSW	;SAVE CARRY FOR NEXT DIGITS
	DCX	H
	DCR	C
	MVI	E,0	;SET SUBTRACT NUMBER FOR THE REST
	JNZ	SUB11
;
	POP	PSW	;THROW CARRY AWAY
	INX	H	;H,L BACK TO START
	POP	PSW	;RESTORE REGISTERS
	POP	B
	POP	D
	RET
;
;
; ZTEST TESTS A BCD NUMBER FOR ZERO
;
;	ON ENTRY:
;	  H,L AT MOST SIGNIFICANT BYTE
;	  C   NUMBER OF BYTES IN BCD NUMBER
;
;	ON EXIT:
;	  Z IS SET IF ZERO, ELSE NZ
;	  ALL REGISTERS EXCEPT PSW AS ON ENTRY
;
ZTEST:	PUSH	H	;SAVE REGISTERS
	PUSH	B
ZTST1:	MOV	A,M	;GET A BYTE
	ORA	A
	JNZ	ZTST2	;IF NOT ZERO, GET OUT
	INX	H
	DCR	C
	JNZ	ZTST1
ZTST2:	POP	B	;RESTORE REGISTERS
	POP	H
	RET
;
;
; ISET SETS THE INTEGER PART OF A BCD NUMBER
;
;	ON ENTRY:
;	  H,L POINTES TO DESTINATION
;	  D,E POINTS TO SOURCE
;	  C   # OF BYTES IN BCD NUMBER
;	  B   # OF DECIMAL PLACES IN SOURCE
;
;	ON EXIT:
;	  ALL REGISTERS SAVED
;
ISET:	PUSH	PSW	;SAVE REGISTERS
	PUSH	D
	PUSH	H
	PUSH	B
;
	CALL	SKPST	;MOVE DESTINATION TO LEAST SIGNIFICANT DIGIT
	XCHG		;H,L HAS SOURCE D,E HAS DESTINATION
	CALL	SKPST	;MOVE SOURCE TO LEAST SIGNIFICANT BYTE
;
	ORA	A	;CLEAR  CARRY
	MOV	A,B	;GET DECIMAL PLACES
	RAR		;DIVIDE BY TWO TO GET BYTES
	PUSH	PSW	;SAVE CARRY
	PUSH	D	;SAVE LEAST SIG BYTE OF DESTINATION
	MOV	B,A
	CMA
	MOV	E,A
	MVI	D,0FFH
	INX	D
	DAD	D	;SHIFT SOURCE OVER
;
	MOV	A,C
	SUB	B
	MOV	C,A	;GET NUMBER OF BYTES TO MOVE
;
	POP	D	;GET DESTINATION BACK
	PUSH	D
ISET1:	MOV	A,M
	STAX	D
	DCX	D
	DCX	H
	DCR	C
	JNZ	ISET1
;
	MOV	A,B
	ORA	A
	JZ	ISET1B
;
	XRA	A
ISET1A:	STAX	D	;ZERO OUT REST OF NUMBER
	DCX	D
	DCR	B
	JNZ	ISET1A
;
ISET1B:	POP	H	;RESTORE LEAST SIGNIFICANT BYTE OF DEST
	POP	PSW	;CHECK CARRY
	JNC	ISET4	;JUMP IF EVEN # OF DECIMAL PLACES
;
	MOV	A,M	;NOW HAVE TO SHIFT WHOLE NUMBER DOWN ONE DIGIT
	POP	B	;GET NUMBER OF BYTES IN NUMBER
	PUSH	B
	JMP	ISET3
;
ISET2:	MOV	A,M	;GET TWO DIGITS
	MOV	B,A	;SAVE IN B
	ANI	0FH	;LOOK AT LOW NIBBLE
;
	RLC
	RLC
	RLC
	RLC		;MOVE LOW NIBBLE TO HIGH NIBBLE
	INX	H	;BACK UP H,L ONE
	ORA	M	;SITCK DIGIT IN LOWER BYTE
	MOV	M,A
	DCX	H	;PUT H,L BACK
;
	MOV	A,B	;GET BYTE BACK
ISET3:	ANI	0F0H	;GET HIGH NIBBLE
;
	RRC
	RRC
	RRC
	RRC		;MOVE HIGH NIBBLE TO LOW NIBBLE
	MOV	M,A	;AND STORE IT
;
	DCX	H	;MOVE TO NEXT BYTE
	DCR	C
	JNZ	ISET2
;
ISET4:	POP	B	;RESTORE REGISTERS
	POP	H
	POP	D
	POP	PSW
	RET
;
;
; BCDML MULTIPLIES TWO BCD NUMBERS
;
;	ON ENTRY:
;	  H,L POINTS TO THE MULTIPLICAND
;	  D,E POINTS TO THE MULTIPLIER
;	  C   IS NUMBER OF BYTES IN BCD NUMBER
;
;	ON EXIT:
;	  RESULT IS IN TNUMB
;	  ALL REGISTERS (EXCEPT PSW) ARE SAME
;
BCDML:	PUSH	H	;SAVE REGISTERS
	PUSH	D
	PUSH	B
;
	PUSH	H	;SAVE H,L
	LXI	H,TNUMB
	CALL	BCDZR	;ZERO OUT TNUMB
	POP	H
;
	XCHG		;H,L GETS MULTIPLIER
;
BCDM0:	CALL	ZTEST	;SEE IF MULTIPLIER IS ZERO
	JZ	BCDM2	;IF YES, GET OUT
;
	PUSH	H	;SAVE MULTIPLIER START
	CALL	SKPST	;MOVE H,L TO LEAST SIGNIFICANT DIGIT
	MOV	A,M

	ANI	1	;SEE IF MULTIPLIER IS ODD OR EVEN
	JZ	BCDM1	;JUMP IF EVEN
;
	LXI	H,TNUMB	;H,L TO TEMP. NUMBER
	CALL	BCDAD	;ADD MULTIPLICAND AND TEMP NUMBER
BCDM1:	XCHG		;H,L NOW HAS MULTIPLICAND
	CALL	BCDT2	;MULTIPLICAND TIMES TWO
;
	POP	D	;RESTORE MULTIPLIER
	XCHG
	CALL	BCDD2	;MULTIPLIER DIVIDED BY TWO
;
	JMP	BCDM0
;
BCDM2:	POP	B	;RESTORE REGISTERS
	POP	D
	POP	H
	RET
;
;
; BCDDV DIVIDES TWO BCD NUMBERS
;
;	ON ENTRY:
;	  H,L POINTS AT DIVIDEND
;	  D,E POINTS AT DIVISOR
;	  C   IS COUNT OF # OF BYTES IN BCD NUMBER
;
;	ON EXIT:
;	  QUOTIENT IS IN TNUMB
;	  REMAINDER IS IN H,L
;	  ALL REGISTERS ARE SAVED (EXCEPT PSW)
;
BCDDV:	PUSH	B	;SAVE REGISTERS
	PUSH	H
	PUSH	D
;
	SHLD	REM	;SAVE DIVIDEND (WILL END UP AS REMAINDER)
;
	XCHG
	CALL	ZTEST	;SEE IF DIVISOR IS ZERO
	JZ	E17	;DIVIDE BY ZERO
	XCHG
;
	LXI	H,W
	CALL	BCDST	;SET W FROM D,E
;
	LXI	H,TNUMB
	CALL	BCDZR	;ZERO OUT TNUMB
	MOV	B,C	;SAME NUMBER OF CHARACTERS FOR COMPARE
BCDO1:	LXI	D,W
	LHLD	REM
	XCHG
	CALL	SCMP
	JC	BCDO2	;JUMP IF W > REM
;
	CALL	BCDT2	;MULTIPLY W  BY TWO
	JMP	BCDO1
;
BCDO2:	POP	D	;GET Y ADDRESS
	PUSH	D	;AND SAVE FOR NEXT TIME AROUND
;
	LXI	H,W
	CALL	SCMP
	JZ	BCDO3	;JUMP IF W = Y OR
	JNC	BCDO3	;     IF W < Y
;
	LXI	H,TNUMB
	CALL	BCDT2	;TNUMB TIMES TWO
;
	LXI	H,W
	CALL	BCDD2	;W DIVIDED BY TWO
;
	XCHG
	LHLD	REM
	CALL	SCMP
	JZ	BCDO2A	;JUMP IF W = REM
	JNC	BCDO2	;JUMP IF W > REM
;
BCDO2A:	CALL	BCDSB	;REM := REM - W
;
	LXI	H,TNUMB
	CALL	ADD1
	JMP	BCDO2
;
BCDO3:	POP	D
	POP	H
	POP	B
	RET
;
;
; TIME10 MULTIPLIES A BCD NUMBER BY 10
;
;	ON ENTRY:
;	  H,L POINTS TO MOST SIGNIFICANT BYTE OF BCD NUMBER
;	  C   HAS SIZE IN BYTES OF BCD NUMBER
;
;	ON EXIT:
;	  H,L POINTS TO ANSWER
;	  ALL REGISTERS UNCHANGED
;
TIM10:	PUSH	PSW	;SAVE REGISTERS
	PUSH	B
	PUSH	D
;
	CALL	SKPST	;H,L TO LEAST SIGNIFICANT BYTE
	MVI	D,0	;ZERO CARRY FROM PREVIOUS DIGIT
;
TIMS1:	MOV	A,M	;GET TWO DIGITS
	RLC
	RLC
	RLC
	RLC		;MULTIPLY BY 10
	MOV	E,A	;SAVE IN E
;
	ANI	0F0H	;OLD LOW NIBBLE IS NOW HIGH NIBBLE
	ORA	D	;PUT IN PREVIOUS BYTE'S HIGH NIBBLE
	MOV	M,A	;AND PUT IT BACK
;
	MOV	A,E	;GET SHIFTED BYTE
	ANI	0FH	;NOW GET OLD HIGH NIBBLE
	MOV	D,A	;PUT IN D FOR NEXT TIME
;
	DCX	H
	DCR	C
	JNZ	TIMS1
;
	MOV	A,D	;CHECK FOR OVERFLOW
	ORA	A
	JNZ	E2
;
	INX	H	;ADJUST H,L
	POP	D	;RESTORE REGISTERS
	POP	B
	POP	PSW
	RET
;
;
; GETNM GETS THE NUMBER OF DIGITS IN A BCD NUMBER
;       TRAILING ZEROS ARE INCLUDED
;
;	ON ENTRY:
;	  H,L POINTS TO START OF BCD NUMBER
;	  C   HAS NUMBER OF BYTES IN NUMBER
;
;	ON EXIT:
;	  ALL REGISTERS ARE SAVED
;	  A HAS NUMBER OF DIGITS
;
GETNM:	PUSH	H	;SAVE REGISTERS
	PUSH	B
;
GETN1:	MOV	A,M	;GET A BYTE
	ORA	A
	JNZ	GETN2	;JUMP IF NON-ZERO
;
	INX	H
	DCR	C
	JNZ	GETN1
	JMP	GETN3	;ALL DIGITS ARE ZERO
;
GETN2:	MOV	B,A	;SAVE FIRST NON-ZERO BYTE
;
	MOV	A,C	;GET NUMBER OF BYTES LEFT
	RLC		;CONVERT TO NUMBER OF DIGITS
	MOV	C,A	;AND SAVE FOR LATER
;
	MOV	A,B
	ANI	0F0H	;SEE IF NON-ZERO WAS IN HIGH ORDER NIBBLE
	JNZ	GETN3	;JUMP IF IN HIGH NIBBLE
;
	DCR	C	;LOW ORDER, SO REDUCE DIGIT COUNT
;
GETN3:	MOV	A,C	;RETURN COUNT
	POP	B	;RESTORE REGISTERS
	POP	H
	RET
;
;
; BCDRD IS A BCD DIVIDE WITH FRACTIONAL REMAINDER
;
;	ON ENTRY:
;	  H,L AT DIVIDEND
;	  D,E AT DIVISOR
;	  C   IS COUNT OF BYTES IN BCD NUMBER
;	  B   # OF DECIMAL PLACES IN DIVIDEND
;
;	ON EXIT:
;	  QUOTIENT IS IN RTNUM
;	  B HAS NUMBER OF DECIMAL PLACES IN RTNUM
;	  OTHER REGISTERS SAVED
;
BCDRD:	PUSH	H	;SAVE REGISTERS
	PUSH	D
;
	PUSH	H	;SAVE DIVIDEND
	LXI	H,RTNUM
	CALL	BCDZR	;ZERO OUT RTNUM
	POP	H	;RESTORE DIVIDEND
;
BCDR1:	POP	D	;GET DIVISOR
	PUSH	D
	CALL	BCDDV	;DIVIDE H,L BY D,E
;
	PUSH	H	;SAVE REMAINDER POINTER
	LXI	H,RTNUM	;ACCUMULATE ANSWER
	CALL	TIM10
	LXI	D,TNUMB
	CALL	BCDAD	;RTNUM := RTNUM * 10 + TNUMB
;
	CALL	GETNM	;GET # OF DIGITS IN RTNUM

	POP	H	;RESTORE REMAINDER POINTER
	CPI	MAXDG+1	;COMPARE TO MAX # OF SIGNIFICANT DIGITS
	JNC	BCDR2
;
	CALL	ZTEST	;SEE IF REMAINDER IS ZERO
	JZ	BCDR2	;JUMP IF YES
	CALL	TIM10	;REMAINDER TIMES 10
	INR	B	;INCREMENT # OF DECIMAL PLACES

	JMP	BCDR1
;
BCDR2:	POP	D	;RESTORE REGISTERS
	POP	H
	RET
;
;
; BCDZR ZEROS OUT A BCD NUMBER
;
;	ON ENTRY:
;	  H,L POINTS TO BCD NUMBER
;	  C   HAS NUMBER OF BYTES IN NUMBER
;
;	ON EXIT:
;	  ALL REGISTERS (EXCEPT PSW) ARE SAVED
;
BCDZR:	PUSH	H	;SAVE REGISTERS
	PUSH	B
	XRA	A
;
BCDZ1:	MOV	M,A	;ZERO OUT BYTE
	INX	H
	DCR	C
	JNZ	BCDZ1
;
	POP	B	;RESTORE REGISTERS
	POP	H
	RET
;
;
; BCDST SETS ONE BCD EQUAL TO ANOTHER
;
;	ON ENTRY:
;	  H,L POINTS TO DESTINATION
;	  D,E POINTS TO SOURCE
;	  C   HAS # OF BYTES TO MOVE
;
;	ON EXIT:
;	  ALL REGISTERS SAVED
;
BCDST:	PUSH	H	;SAVE REGISTERS
	PUSH	D
	PUSH	B
	PUSH	PSW
;
BCDG1:	LDAX	D	;GRAB A BYTE
	MOV	M,A	;AND SAVE IT
	INX	H
	INX	D
	DCR	C
	JNZ	BCDG1
;
	POP	PSW	;RESTORE REGISTERS
	POP	B
	POP	D
	POP	H
	RET
;
;
; BCDRN ROUNDS OFF BCD NUMBER IN OP1 TO MAXDG PLACES
;
;	ON ENTRY:
;	   H,L AT BCD NUMBER TO ROUND
;	   C   MAX NUMBER OF DIGITS IN NUMBER
;
;	ON EXIT:
;	   H,L AT MOST SIGNIFICANT DIGIT
;	   B   NUMBER OF INTEGER DIGITS
;	   C   NUMBER OF DECIMAL PLACES
;	   A   1 IF STARTING AT LOW NIBBLE ELSE 0
;
BCDRN:	PUSH	H	;SAVE START OF NUMBER
	MVI	B,BCDLN	;GET SIZE IN BYTES TO B
;
BRND1:	MOV	A,M	;FIND FIRST NON-ZERO BYTE
	ORA	A
	JNZ	BRND2
	INX	H
	DCR	B
	JNZ	BRND1
	LXI	B,0	;ALL DIGITS ARE ZERO
	POP	H
	JMP	BRNDS
;
BRND2:	MVI	E,0	;E WILL BE NUMBER OF BYTES IN BCD NUMBER
;
	MOV	A,B	;GET NUMBER OF BYTES LEFT
	ADD	A	;NOW IT'S DIGITS
	MOV	B,A
;
	LDA	DJ
	ORA	A
	JZ	BRND25
	LDA	DP1
	CMP	B
	JC	BRND25	;JUMP IF FEWER DIGITS THAN DECIMAL PLACES
;
	POP	H	;GET START OF NUMBER
	PUSH	H
	PUSH	B	;SAVE MAX DIGITS
	MOV	C,A	;DECIMAL PLACES TO C
	MVI	A,BCDLN*2
	SUB	C	;GET DIGITS BEFORE NUMBER
	RAR		;CONVERT TO BYTES
	PUSH	PSW	;SAVE CARRY
;
	MOV	C,A
	MVI	B,0
	DAD	B	;H,L TO STARTING PLACE
	POP	PSW
	POP	B
	LDA	DP1
	MOV	B,A	;SET DIGITS LEFT
	JC	BRND26	;AT LOW NIBBLE
	MVI	D,0
	JMP	BRND3	;AT HIGH NIBBLE
;	
BRND25:	MOV	A,M	;GET DIGITS BACK
	ANI	0F0H	;CHECK WHICH NIIBBLE
	MOV	A,B
	MVI	D,0
	JNZ	BRND3
;
BRND26:	DCR	C
	DCR	B
	MOV	A,B
	DCR	A	;SKIP TOP DIGIT
	MVI	D,1
	INX	H
;
BRND3:	PUSH	B	;SAVE DIGIT COUNTS
	SUB	C	;SEE IF ROOM FOR ALL SIGNIFICANCE
	MOV	B,A	;SAVE DIGITS AFTER SIGNIFICANCE
	JC	BRNDT
	JZ	BRNDT
;
	MOV	A,C
	ORA	A	;SEE IF DONE
	MOV	A,D
	JZ	BRND4
;
BRND3A:	XRA	A	;AT HIGH NIBBLE
	DCR	C
	JZ	BRND4
	MVI	A,1	;AT LOW NIBBLE
	INX	H
	INR	E	;ADD  1 TO BYTE COUNT
	DCR	C
	JNZ	BRND3A
;
BRND4:	PUSH	H	;SAVE LOW ORDER BYTE PLACE
	PUSH	PSW	;SAVE WHICH NIBBLE
	ORA	A
	JZ	BRND5	;JUMP IF AT HIGH NIBBLE
	MVI	D,50H	;LAST DIGIT WAS LOW ORDER
	JMP	BRND6
BRND5:	MVI	D,05H	;LAST DIGIT WAS LOW ORDER
BRND6:	INR	E	;ALLOW FOR CARRY OUT OF HIGH DIGIT
	MOV	A,M	;GET A BYTE
	ADD	D	;ADD 5 TO LAST DIGIT
	DAA
	MOV	M,A	;PUT IT BACK
;
BRND7:	DCX	H	;AND CARRY THROUGH REST OF NUMBER
	MOV	A,M
	ACI	0	;ADD IN PREVIOUS CARRY
	DAA
	MOV	M,A	;AND STORE IT
;
	DCR	E
	JNZ	BRND7
;
	POP	PSW	;RESTORE NIBBLE WHERE STARTED
	POP	H	;AND LOCATION
	ORA	A	;CHECK WHICH BYTE
	JNZ	BRND8
	MOV	A,M	;GET LEAST SIGNIFICANT DDIGIT
	ANI	0F0H	;ZERO LOW NIBBLE
	MOV	M,A
	INX	H	;MOVE TO NEXT BYTE
	DCR	B	;ONE LESS DIGIT LEFT
;
BRND8:	MOV	A,B	;CHECK DIGITS AFTER SIG PART
	ORA	A
	JZ	BRND9
;
	MVI	M,0	;ZERO OUT BYTE
	INX	H	;MOVE TO NEXT BYTE
	DCR	B
	DCR	B	;JUST DID TWO DIGITS
	JMP	BRND8
;
BRND9:	POP	B
	POP	H
	MVI	C,BCDLN
	CALL	GETNM	;SEE IF EXTRA DIGIT ADDED
	MOV	B,A
	JMP	BRNDV
;
BRNDT:	POP	B	;GET NUMBER OF DIGITS LEFT
	POP	H
BRNDV:	LXI	D,BCDLN
	DAD	D	;H,L TO LEAST SIGNIFICANT BYTE
;
BRNDU:	DCX	H
	MVI	D,1
	LDA	DP1	;SET NUMBER OF DECIMAL PLACES
	MOV	C,A
	ORA	A
	JZ	BRNDY
;
BRNDX:	MOV	A,M	;GET 2 DIGITS
	ANI	0FH	;SEE IF ANYTHING IN LOW NIBBLE
	JNZ	BRNDY
	DCR	B
	DCR	C
	MVI	D,0
	JZ	BRNDY
;
	MOV	A,M
	ANI	0F0H	;SEE IF ANYTHING IN HIGH NIBBLE
	JNZ	BRNDY
	DCR	B
	DCR	C
	MVI	D,1
	JZ	BRNDZ
	DCX	H
	JMP	BRNDX
;
BRNDZ:	DCX	H
BRNDY:	MOV	A,B	;GET NUMBER OF DIGITS LEFT
	SUB	C
	JNC	BRNDQ
	XRA	A
BRNDQ:	MOV	B,A	;SET NUMBER OF INTEGER DIGITS
;
	MOV	A,C
	ADD	B
	RAR		;CONVERT TO BYTES
	MVI	E,1
	JNC	BRNDR
	DCR	E
BRNDR:	PUSH	D
	CMA
	MOV	E,A
	MVI	D,0FFH
	INX	D
	DAD	D	;MOVE H,L OVER
;
	POP	D
	MOV	A,E
	ANA	D
	JZ	BRNDS
	INX	H
;
BRNDS:	MOV	A,E
	XRA	D
	RET
;
;
; BCDPS  PUSHES BCD NUMBER ON THE STACK
;
;	ON ENTRY:
;	   H,L AT MOST SIGNIFICANT DIGIT TO PUSH
;	   B   COUNT OF INTEGER DIGITS
;	   C   COUNT OF DECIMAL FRACTION DIGITS
;	   A   IF 1 START AT LOW NIBBLE, IF 0 START AT HIGH
;
;	ON EXIT:
;
;
BCDPS:	PUSH	B	;SAVE COUNTS
	MOV	E,A	;SAVE STARTING NIBBLE INDICATOR
	MOV	A,C	;GET DECIMAL FRACTION COUNTT
	ORA	B
	JNZ	BCPSX	;JUMP IF NUMBER IS ZERO
	MVI	A,'0'	;ONLY A ZERO
	CALL	SPUSH
	MVI	D,1
	JMP	BCPS5
;
BCPSX:	MVI	D,0	;ZERO OUT COUNT
	LDA	SGN1	;GET SIGN OF RESULT
	ORA	A
	JZ	BCPSY
;
	MVI	A,'-'
	CALL	SPUSH	;PUSH A MINUS SIGN
	INR	D
;
BCPSY:	LDA	DJ	;SEE IF A $J
	ORA	A
	JZ	BCPS0
	MOV	A,B	;SEE IF AN INTEGER PART
	ORA	A
	JNZ	BCPS1
	MVI	A,'0'
	CALL	SPUSH	;START WITH LEADING ZERO
	INR	D
	JMP	BCPS4A
;
BCPS0:	MOV	A,B	;GET NUMBER OF DIGITS
	ORA	A
	JZ	BCPS4A
;
BCPS1:	MOV	A,E	;GET NIBBLE INDICATOR
	ORA	A
	JNZ	BCPSA
;
BCPS3:	MOV	A,M	;GET 2 DIGITS
	ANI	0F0H	;LOOK AT HIGH NIBBLE
	RAR
	RAR
	RAR
	RAR
	ORI	30H	;CONVERT TO CHARACTER
	INR	D
	CALL	SPUSH	;PUSH ON STACK
	DCR	B
	JZ	BCPS4
;
BCPSA:	MOV	A,M
	ANI	0FH	;LOOK AT LOW NIBBLE
	ORI	30H	;CONVERT TO CHARACTER
	INR	D
	CALL	SPUSH
	INX	H
	DCR	B
	JNZ	BCPS3
	MVI	E,0	;NEXT TIME AT HIGH NIBBLE
	JMP	BCPS4A
;
BCPS4:	MVI	E,1	;NEXT TIME AT LOW NIBBLE
BCPS4A:	MOV	A,C	;CHECK FOR  DECIMAL FRACTION
	ORA	A
	JZ	BCPS5
;
	MVI	A,'.'
	CALL	SPUSH	;PUSH ON DECIMAL PLACE
	INR	D
	MOV	B,C	;MOVE COUNT TO B
	MVI	C,0	;AND FIX SO WE DON'T LOOP FOREVER
	JMP	BCPS0
;
BCPS5:	POP	B	;RESTORE ORIGINAL COUNTS
	LDA	DJ	;CHECK IF $J
	ORA	A
	JZ	BCPS7
;
	LDA	I6	;GET NUMBER OF DECIMAL PLACES WANTED
	SUB	C
	MOV	B,A	;B GETS NUMBER OF TRAILING ZEROS TO ADD
	JZ	BCPS7
;
	MOV	A,C	;SEE IF DECIMAL PLACE PUSHED YET
	ORA	A
	JNZ	BCPS6
;
	MVI	A,'.'
	CALL	SPUSH
	INR	D
;
BCPS6:	MVI	A,'0'
	CALL	SPUSH	;ADD TRAILING ZEROS
	INR	D
	DCR	B
	JNZ	BCPS6
;
BCPS7:	MOV	A,D	;GET STRING LENGTH
	CALL	SPUSH
	MVI	A,3	;IT'S A NUMERIC STRING
	CALL	SPUSH
	RET
;
;
SPUSH:	PUSH	H
	PUSH	D
	PUSH	B
	CALL	CPUSH
	POP	B
	POP	D
	POP	H
	RET
;
;
CRLF:	MVI	A,CR	;WRITE OUT CARRIAGE RETURN
	CALL	TRMOT
	MVI	A,LF	;AND LINE FEED
	CALL	TRMOT
	RET
;
;
WIPE:	MVI	A,BS	;WIPE OUT PREVIOUS CHARACTER
	CALL	TRMOT
	MVI	A,' '
	CALL	TRMOT
	MVI	A,BS
	CALL	TRMOT
	RET
;
;
PTS:	LHLD	TPP	;CONVERT POINTER VALUE IN TPP TO STACK #
	LXI	D,1000	;DIGIT WEIGHT
	LXI	B,0
;
PTS1:	MOV	A,L	;SEE IF DIGIT FITS
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	JC	PTS2	;JUMP IF NO ROOM
	INR	B	;ADD 1 TO DIGIT COUNT
	JMP	PTS1
;
PTS2:	DAD	D	;TAKE CARE OF EXTRA SUBTRACT
	MOV	A,B
	ORA	C	;SEE IF A DIGIT
	JZ	PTS3
;
	MOV	A,B
	ORI	30H	;CONVERT TO CHARACTER
	CALL	SPUSH
	INR	C	;INCREMENT CHARACTER COUNT
PTS3:	MVI	A,100
	CMP	E	;SEE IF DONE
	JZ	PTS4
;
	LXI	D,100	;SET UP FOR NEXT DIGIT
	MVI	B,0
	JMP	PTS1
;
PTS4:	PUSH	D	;SET UP FOR CTS
	PUSH	B
	PUSH	PSW
	MOV	E,C
	MOV	D,L
	JMP	CTS3
;
;
DOLJ:	LHLD	TOS	;$JUSTIFY TO # T-O-S
	DCX	H
	DCX	H	;TO LENGTH
	MOV	A,M
	MOV	C,A	;SAVE LENGTH IN C
	CMA
	MOV	E,A
	MVI	D,0FFH
	INX	D
	DAD	D
	SHLD	TOS	;TOS BELOW STRING
;
	LXI	D,OP1
	MVI	B,BCDLN
	CALL	BCDPK	;PUT STRING # AS BCD IN OP1
;
	STA	SGN1	;SAVE SIGN
	LDA	COUNT
	STA	DP1	;SAVE DECIMAL PLACE COUNT
	MOV	B,A
;
	XCHG		;OP1 TO H,L
	MVI	C,BCDLN
	CALL	GETNM	;GET TOTAL DIGITS IN NUMBER
	SUB	B	;GET INTEGER DIGIT COUNT
	JNC	DOL0
	XRA	A
DOL0:	MOV	D,A	;SAVE IN D
;
	LDA	I6	;GET DECIMAL PLACES TO ROUND TO
	CMP	B
	JC	DOLJ1	;JUMP IF I6 < DP1
	MOV	A,B
;
DOLJ1:	ADD	D	;GET TOTAL DIGITS
	CPI	MAXDG	;SEE IF TOO MANY
	JC	DOLJ2
	MVI	A,MAXDG
;
DOLJ2:	MOV	C,A
	CALL	BCDRN	;ROUND IT
	CALL	BCDPS
	RET
;
;
NXTRN:	LXI	H,OP1	;GET NEXT RANDOM NUMBER
	LXI	D,RNDM
	MVI	C,BCDLN
	CALL	BCDST
;
	LXI	H,OP2
	LXI	D,RNDML
	CALL	BCDST
;
	LXI	D,OP1
	CALL	BCDML	;GET RNDM * RNDML
;
	LXI	H,RNDM+(BCDLN-(RNMOD/2))
	LXI	D,TNUMB+(BCDLN-(RNMOD/2))
	MVI	C,RNMOD/2
	CALL	BCDST	;SET RANDOM NUMBER TO INTEGER PART
;
	LXI	H,OP1+(BCDLN-INTLN)
	LXI	D,INT1
	MVI	C,INTLN
	CALL	BCDST	;SET INT1 INTO OP1
;
	LXI	H,OP2
	LXI	D,RNDM
	MVI	C,BCDLN
	CALL	BCDST	;SET OP2 TO RANDOM NUMBER SEED
;
	LXI	D,OP1
	CALL	BCDML
;
	LXI	H,TNUMB
	CALL	GETNM	;GET NUMBER OF DIGITS
	MOV	B,A
	MVI	A,BCDLN*2	;GET TOTAL POSSIBLE NUMBER OF DIGITS
	SUB	B
	RAR		;NUMBER OF BYTES TO START
	PUSH	PSW	;SAVE CARRY (HIGH OR LOW NIBBLE)
;
	MOV	E,A
	MVI	D,0
	DAD	D	;H,L TO START OF NUMBER
;
	MOV	A,B	;GET DIGITS IN NUMBER
	SUI	RNMOD
	JNC	NXTR0
	XRA	A
NXTR0:	MOV	B,A	;SAVE NUMBER OF INTEGER DIGITS
	MVI	C,0	;SET NUMBER OF DECIMAL DIGITS
;
	POP	PSW	;GET HIGH OR LOW NIBBLE
	MVI	A,0
	JNC	NXTR1
	INR	A
NXTR1:	CALL	BCDPS	;PUSH NUMBER
;
	RET
;
;
GETTI:	LXI	H,DOLH+10
	IN	CLK+4	;GET 1 SECOND
	MOV	M,A
	MOV	B,A	;SAVE FOR LATER ALSO
;
	DCX	H
	IN	CLK+5	;GET 10 SECONDS
	MOV	M,A
;
	DCX	H
	IN	CLK+6	;GET 1 MINUTE
	MOV	M,A
;
	DCX	H
	IN	CLK+7	;GET 10 MINUTE
	MOV	M,A
;
	DCX	H
	IN	CLK+8	;GET 1 HOUR
	MOV	M,A
;
	DCX	H
	IN	CLK+9	;GET 10 HOUR
	MOV	M,A
;
	DCX	H
	IN	CLK+10	;GET 1 DAY
	MOV	M,A
;
	DCX	H
	IN	CLK+11	;GET 10 DAY
	MOV	M,A
;
	DCX	H
	IN	CLK+12	;GET 100 DAY
	MOV	M,A
;
	DCX	H
	IN	CLK+13	;GET 1000 DAY
	MOV	M,A
;
	DCX	H
	IN	CLK+14	;GET 10000 DAY
	MOV	M,A
;
	IN	CLK+4	;GET SECONDS AGAIN
	XRA	B
	ANI	0FH
	JNZ	GETTI	;TIME CHANGED SO GET IT AGAIN
;
	LXI	H,DOLH
	LXI	D,DAYS
	LXI	B,0505H
	CALL	BCDPK	;PACK DAYS
;
	LXI	H,DOLH+5
	LXI	D,SECS
	LXI	B,0502H
	CALL	BCDPK	;PACK HOURS
;
	LXI	H,RTNUM
	LXI	D,I60
	MVI	C,5
	CALL	BCDST	;60 TO RTNUM
;
	LXI	D,SECS
	CALL	BCDML	;HOURS * 60 = MINUTES
;
	LXI	H,DOLH+7
	LXI	D,SECS
	LXI	B,0502H
	CALL	BCDPK	;PACK MINUTES
;
	LXI	H,TNUMB
	XCHG
	MVI	C,5
	CALL	BCDAD	;MINUTES+60*HOURS
;
	LXI	H,RTNUM
	LXI	D,I60
	CALL	BCDST
;
	LXI	D,SECS
	CALL	BCDML	;MINUTES*60=SECONDS
;
	LXI	H,DOLH+9
	LXI	D,SECS
	LXI	B,0502H
	CALL	BCDPK	;PACK SECONDS
;
	LXI	H,TNUMB
	XCHG
	MVI	C,5
	CALL	BCDAD	;ADD ON SECONDS
;
	RET
;
;
TIMTK:	SHLD	HANDL
	LXI	H,0
	JC	TIMT0
;
	DAD	SP
	JMP	TIMT1
TIMT0:	DAD	SP
	STC
;
TIMT1:	LXI	SP,NEWST
	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
;
; CHECK IF TIMEOUT OR HANG
	LDA	WAIT
	ORA	A
	JZ	TIMT2
;
	LXI	H,DTIME
	MVI	C,INTLN
	CALL	SUB1	;A TIMING SO SUBTRACT 1
	CALL	ZTEST	;SEE IF AT ZERO
	JNZ	TIMT2
;
	MVI	A,TRUE	;TIMED OUT
	STA	TIME
;
TIMT2:	POP	PSW
	POP	B
	POP	D
	POP	H
	SPHL
	LHLD	HANDL
	EI
	RET
;
HANDL:	DS	2
	DS	30
NEWST	EQU	$
;
SSCHK:	PUSH	H
	PUSH	D
	PUSH	PSW
	LHLD	TOS	;CHECK IF ROOM ON SYNTAX STACK
	LXI	D,14	;ROOM FOR 7 PUSHES
	DAD	D
	XCHG
	LXI	H,0
	DAD	SP	;GET SP
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	E19
	POP	PSW
	POP	D
	POP	H
	RET
;
RDSEE:	CALL	SSCHK	;SET RANDOM SEED
RDS1:	LXI	H,RNDM	;POINT TO RANDOM NUMBER
	MVI	C,BCDLN
	CALL	ADD1	;INCREMENT NUMBER
	MVI	L,3	;SEE IF CHARACTER TYPED
	CALL	BIOS
	ORA	A
	JZ	RDS1
	LXI	H,RNDM+BCDLN-1
	MOV	A,M
	ANI	0F0H
	ORI	1
	MOV	M,A
	RET
;
;
CPUSH:	LHLD	TOS	;PUSH (A) ONTO STACK
	MOV	M,A
	INX	H
	SHLD	TOS
	JMP	PSH2	;CHECK FOR OVERFLOW
;
;
; CTI CONVERTS A CHARACTER (0-255) TO AN INTEGER
;
CTI:	PUSH	H	;SAVE REGISTERS
	PUSH	B
	PUSH	PSW
;
	MVI	C,INTLN-2
CTI1:	MVI	M,0	;ZERO OUT START OF INTEGER
	INX	H
	DCR	C
	JNZ	CTI1
;
CTI2:	SUI	100	;GET HUNDREDS DIGIT
	JC	CTI3
	INR	C
	JMP	CTI2
;
CTI3:	ADI	100	;FIX UP EXTRA SUBTRACT
	MOV	M,C	;SET HUNDREDS DIGIT
	MVI	C,0
	INX	H	;MOVE TO NEXT DIGITS
;
CTI4:	SUI	10	;GET TENS DIGIT
	JC	CTI5
	INR	C
	JMP	CTI4
;
CTI5:	ADI	10	;FIX UP EXTRA SUBTRACT
	MOV	B,A	;SAVE NUMBER
	MOV	A,C	;GET TENS DIGIT
	RLC
	RLC
	RLC
	RLC		;TENS DIGIT IN CORRECT PLACE
;
	ORA	B	;INCLUDE UNITS DIGIT
	MOV	M,A	;SET IN INTEGER
;
	POP	PSW	;RESTORE REGISTERS
	POP	B
	POP	H
	RET
;
;
; CTS CONVERTS A CHARACTER (0-255) TO A STRING ON THE STACK
;
CTS:	PUSH	D	;SAVE REGISTERS
	PUSH	B
	PUSH	PSW
;
	MVI	E,0	;STRING LENGTH
	MVI	C,100	;GET HUNDREDS DIGIT
;
CTS0:	MVI	B,0	;THE STRING CHARACTER
CTS1:	SUB	C
	JC	CTS2	;JUMP IF CONVERTED
	INR	B	;ADD 1 TO DIGIT
	JMP	CTS1
;
CTS2:	ADD	C	;CORRECT FOR EXTRA SUBTRACTION
	MOV	D,A	;SAVE WHAT'S LEFT OF CHARACTER
	MOV	A,B	;GET DIGIT JUST DONE
	ORA	E
	JZ	CTS3	;SKIP LEADING ZEROS
;
	MOV	A,B
	ORI	30H	;CONVERT TO ASCII DIGIT
	CALL	SPUSH
	INR	E	;COUNT UP LENGTH
;
CTS3:	MVI	A,10
	CMP	C	;SEE IF DONE
	JZ	CTS4
;
	MOV	C,A	;DO TENS DIGIT NEXT
	MOV	A,D	;PUT CHARACTER BACK
	JMP	CTS0
;
CTS4:	MOV	A,D	;GET CHARACTER BACK
	ORI	30H	;CONVERT TO ASCII DIGIT
	CALL	SPUSH
	INR	E
;
	MOV	A,E	;GET LENGTH
	CALL	SPUSH
	MVI	A,3
	CALL	SPUSH
;
	POP	PSW	;RESTORE REGISTERS
	POP	B
	POP	D
	RET
;
;
; ITC CONVERTS AN INTEGER TO A CHARACTER (0-255)
;
ITC:	PUSH	H	;SAVE REGISTERS
	PUSH	D
	PUSH	B
;
	MVI	A,FALSE
	STA	RESUL	;SET RESULT JUST IN CASE
;
	LXI	D,I255
	LXI	B,INTLN*257
	CALL	SCMP	;COMPARE INTEGER AND 255
	JC	ITC5	;RETURN IF INTEGER > 255
;
	MVI	B,0
	DAD	B
	DCX	H	;H,L TO LEAST SIGNIFICANT BYTE
	MOV	A,M
	MOV	B,A	;SAVE BYTE IN B
;
	ANI	0FH	;GET UNITS DIGIT
	MOV	C,A	;SAVE IN C
	MOV	A,B
	ANI	0F0H	;GET TENS DIGIT
	RRC
	RRC
	RRC
	RRC		;SHIFT DIGIT TO LOW NIBBLE
	MVI	B,10
;
ITC1:	ORA	A	;SEE IF NO DIGIT
	JZ	ITC3
	MOV	E,A
	MOV	A,C	;GET PREVIOUS SUM
;
ITC2:	ADD	B	;ADD IN DIGIT WEIGHT
	DCR	E
	JNZ	ITC2
;
	MOV	C,A	;SAVE NEW SUM
ITC3:	MVI	A,100
	CMP	B	;SEE IF DONE
	JZ	ITC4
;
	MOV	B,A	;SET UP FOR HUNDREDS DIGIT
	DCX	H
	MOV	A,M	;GET HUNDREDS DIGIT
	JMP	ITC1
;
ITC4:	MVI	A,TRUE
	STA	RESUL
;
	MOV	A,C	;GET CHARACTER
ITC5:	POP	B	;RESTORE REGISTERS
	POP	D
	POP	H
	RET
;
;
; ITS CONVERTS INTEGER TO STRING ON STACK
;
ITS:	MVI	B,INTLN
	XRA	A
	STA	SGN1	;SET SIGN +
	MOV	A,M	;GET FIRST BYTE
	ANI	0F0H	;CHECK SIGN
	JZ	ITS1
	MVI	A,1
	STA	SGN1	;SET SIGN
	MOV	A,M
        ANI	0FH	;CLEAR SIGN
	JMP	ITS15
ITS1:	MOV	A,M	;FIND FIRST SIGNIFICANT DIGIT
	ORA	A
ITS15:	JNZ	ITS2
	INX	H
	DCR	B
	JNZ	ITS1
	LXI	B,0	;IT'S A ZERO
	JMP	ITS3
;
ITS2:	MOV	A,B	;GET BYTES LEFT IN NUMBER
	ADD	A	;CONVERT TO DIGITS
	MOV	B,A	;AND SAVE
;
	MVI	C,0	;NO DECIMAL PLACES
	MOV	A,M	;GET BYTE (2 DIGITS)
	ANI	0F0H
	MVI	A,0
	JNZ	ITS3	;JUMP IF SOMETHING IN HIGH NIBBLE
;
	INR	A	;SET LOW NIBBLE FLAG FOR BCDPS
	DCR	B	;REDUCE DIGIT COUNT
;
ITS3:	CALL	BCDPS	;PUSH NUMBER ON STACK
	RET
;
;
JDEN:	MVI	C,3
JDEN1:	LDAX	D
	CMP	M
	RNZ
	INX	H
	INX	D
	DCR	C
	JNZ	JDEN1
	RET
;
JPEN:	MOV	A,L	;COMPARE POINTERS
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	ORA	L
	RET
;
JSE:	MOV	A,C	;COMPARE STRINGS
	ORA	A
	RZ
JSE1:	LDAX	D
	CMP	M
	RNZ
	INX	H
	INX	D
	DCR	C
	JNZ	JSE1
	RET
;
LIST:	MOV	E,A
	MVI	C,LISTF
	CALL	BDOS
	RET
;
MOVE:	MOV	A,B
	ORA	A	;CHECK IF ZERO
	RZ
MV1:	LDAX	D	;MOVE STRINGS
	MOV	M,A
	INX	D
	INX	H
	DCR	B
	JNZ	MV1
	RET
;
MSG:	MOV	A,M	;PRINT FROM H,L TO 0
	ORA	A
	RZ
	CALL	TRMOT
	INX	H
	JMP	MSG
;
;
; NTS CONVERTS A NUMBER TO A STRING T-O-S
;
NTS:	DCX	H	;MOVE TO SIGN
	MOV	A,M
	STA	SGN1
	DCX	H
	MOV	C,M	;SET DECIMAL DIGITS
	DCX	H
	MOV	B,M	;SET INTEGER DIGITS
;
	MOV	A,C
	ADD	B	;GET TOTAL DIGITS
	RAR		;GET TOTAL BYTES
	PUSH	PSW	;SAVE CARRY
;
	MOV	E,A
	MVI	A,BCDLN
	SUB	E	;GET STARTING BYTES
	ADI	3	;BECAUSE BACKED UP
	MOV	E,A
	MVI	D,0
	DAD	D	;SHIFT H,L OVER
;
	POP	PSW
	MVI	A,0	;GET READY FOR HI/LO NIBBLE
	JNC	NTS1
	DCX	H	;BACK UP TO LOW NIBBLE
	INR	A
;
NTS1:	CALL	BCDPS	;PUSH #
	RET
;
;
POPIT:	MOV	E,B
	MVI	D,0
	DAD	D
	DCX	H
	XCHG		;POP OFF B CHARACTERS
	LHLD	TOS	;MOVE POINTER TO LEAST SIGNIFICANT PART
	DCX	H
POP1:	MOV	A,M	;TAKE CHARS--ONE AT A TIME
	STAX	D
	DCX	D
	DCX	H
	DCR	B
	JNZ	POP1
	INX	H
	SHLD	TOS	;SAVE T-O-S
	RET
;
PSUB:	MOV	A,L	;SUBTRACT POINTERS
	SUB	E
	MOV	L,A
	MOV	A,H
	SBB	D
	MOV	H,A
	RET
;
PUSHT:	XCHG		;PUSH B CHARACTERS ON STACK
	LHLD	TOS
PSH1:	LDAX	D
	MOV	M,A
	INX	H
	INX	D
	DCR	B
	JNZ	PSH1
	SHLD	TOS
PSH2:	XCHG		;CHECK FOR OVERFLOW
	LXI	H,0
	DAD	SP
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	E1
	RET
;
SETD:	MVI	C,3	;SET DISK BLOCK VALUE
	JMP	SETI1
;
;
SETI:	MVI	C,5	;SET INTEGER VALUE
SETI1:	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	C
	JNZ	SETI1
	RET
;
;
; SHFD SHIFTS THE STACK DOWN TOWARDS ITS BASE
;
SHFD:	PUSH	H	;SAVE REGISTERS
	PUSH	D
	PUSH	B
	PUSH	PSW
;
	MOV	C,A	;SAVE COUNT
;
SHFD1:	MOV	A,C	;GET COUNT
	ORA	A
	JZ	SHFD2
	MOV	A,M	;GET A BYTE
	STAX	D	;AND SAVE IT
	INX	D
	INX	H
	DCR	C
	JMP	SHFD1
;
SHFD2:	XCHG
	SHLD	TOS	;SAVE NEW TOS
;
	POP	PSW	;RESTORE REGISTERS
	POP	B
	POP	D
	POP	H
	RET
;
;
; SHFU SHIFT THE STACK TOWARDS THE TOP
;
SHFU:	PUSH	PSW	;SAVE REGISTERS
	PUSH	B
;
	MVI	B,0
	MOV	C,A
	DAD	B
	DCX	H	;H,L TO FIRST ONE TO GET
	XCHG
	DAD	B
;
	SHLD	TOS
	ORA	A	;SEE IF NO CHARACTERS TO MOVE
	JZ	SHFU2
;
	CALL	SSCHK	;SEE IF ROOM
;
	DCX	H	;H,L TO FIRST PLACE TO PUT
;
SHFU1:	LDAX	D
	MOV	M,A
	DCX	H
	DCX	D
	DCR	C
	JNZ	SHFU1
;
	INX	H
SHFU2:	POP	B	;RESTORE REGISTERS
	POP	PSW
	INX	D
	XCHG
	RET
;
;
; STC0 CONVERTS A STRING ON T-O-S TO A CHARACTER (0-255)
;
STC0:	PUSH	H	;SAVE REGISTERS
	PUSH	D
	PUSH	B
;
	LHLD	TOS	;H,L POINTS ABOVE STACK
	DCX	H	;H,L TO THE 3
	DCX	H	;H,L TO THE LENGTH
	MOV	A,M	;GET LENGTH
;
	PUSH	H	;SAVE LENGTH
	MOV	E,A
	CMA		;FORM 2'S COMPLEMENT
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B	;H,L TO START OF STRING
	SHLD	TOS	;SET NEW TOS POINTER
;
	POP	H	;GET END OF STRING
	MVI	A,FALSE
	STA	RESUL
;
	MOV	A,E	;GET LENGTH
	ORA	A
	JZ	STC5	;DONE--NULL STRING
	CPI	4
	JNC	STC5	;DONE--TOO LONG
;
	DCX	H	;MOVE H,L TO UNITS DIGIT
	MOV	A,M
	ANI	0FH	;GET UNITS DIGIT
	MOV	D,A
;
	DCR	E	;DECREMENT LENGTH
	JZ	STC4	;JUMP IF DONE
	MVI	C,10
;
STC1:	DCX	H	;MOVE TO NEXT DIGIT
	MOV	A,M
	ANI	0FH	;STRIP ASCII BIAS
	JZ	STC3
;
	MOV	B,A
	MOV	A,D	;GET DIGIT WEIGHT
;
STC2:	ADD	C
	JC	STC5	;JUMP IF OVERFLOW
	DCR	B
	JNZ	STC2
;
	MOV	D,A	;SAVE CHARACTER SO FAR
STC3:	DCR	E
	JZ	STC4	;JUMP IF DONE
;
	MVI	C,100
	JMP	STC1
;
STC4:	MVI	A,TRUE
	STA	RESUL
	MOV	A,D	;GET RESULT
;
STC5:	POP	B	;RESTORE REGISTERS
	POP	D
	POP	H
	RET
;
;
; STI CONVERTS STRING ON T-O-S TO INTEGER
;
STI:	PUSH	PSW	;SAVE REGISTERS
	PUSH	D
	PUSH	B
	PUSH	H
;
	LHLD	TOS
	DCX	H	;H,L TO 3
	DCX	H	;H,L TO LENGTH
	MOV	A,M
	MOV	C,A
;
	CMA		;FORM 2'S COMPLEMENT OF LENGTH
	MOV	E,A
	MVI	D,0FFH
	INX	D
	DAD	D
	SHLD	TOS	;NEW TOS POINTER
;
	POP	D	;GET INTEGER START
	MVI	B,INTLN
	CALL	BCDPK
;
	ORA	A	;CHECK SIGN
	JZ	STI1
	LDAX	D	
	ORI	0F0H	;SET SIGN
	STAX	D
STI1:	XCHG
	POP	B	;RESTORE REGISTERS
	POP	D
	POP	PSW
	RET
;
;
; STN CONVERTS STRING T-O-S TO A NUMERIC
;
STN:	PUSH	H	;SAVE REGISTERS
	PUSH	D
	PUSH	B
	PUSH	PSW
;
	XCHG
	LHLD	TOS
	DCX	H	;TO 3
	DCX	H	;TO LENGTH
	MOV	A,M
	PUSH	PSW	;SAVE LENGTH
;
	CMA		;GET 2'S COMPLEMENT
	MOV	C,A
	MVI	B,0FFH
	INX	B
	DAD	B
	SHLD	TOS
;
	POP	PSW	;GET LENGTH BACK
	MOV	C,A
	MVI	B,BCDLN
	CALL	BCDPK
;
	DCX	D
	STAX	D	;SAVE SIGN
	DCX	D
	LDA	COUNT	;NUMBER OF DECIMAL PLACES
	STAX	D
	DCX	D
	MOV	B,A
	ORA	A	;CHECK IF DECIMAL PLACES
	JZ	STN1	;JUMP IF NONE
	DCR	C	;DON'T COUNT '.'
STN1:	MOV	A,C
	SUB	B	;GET INTEGER DIGITS
	STAX	D
;
	POP	PSW	;RESTORE REGISTERS
	POP	B
	POP	D
	POP	H
	RET
;
;
TRMIN:	LXI	H,BDATA	;READ FROM TERMINAL
	LXI	B,0	;B IS RUBOUT FLAG, C IS COUNT
;
TRM1:	PUSH	H	;SAVE REGISTERS
	PUSH	D
	PUSH	B
	MVI	L,6
	CALL	BIOS	;READ A CHARACTER
	POP	B	;RESTORE REGISTERS
	POP	D
	POP	H
;
	CPI	CR	;SEE IF DONE
	JNZ	TRM05
TRM01:	MOV	A,C
	STA	RLENG
	RET
;
TRM05:	CPI	RUB	;A RUBOUT?
	JNZ	TRM0
;
	MOV	A,C	;GET COUNT
	ORA	A
	JZ	TRM1	;IF AT START IGNORE
;
	MOV	A,B
	ORA	A
	JNZ	TRM15	;SEE IF RUBOUT FLAG SET
;
	MVI	A,'\'
	CALL	TRMOT	;WRITE A \
TRM15:	DCR	C	;BACK UP
	DCX	H
	MOV	A,M	;GET CHARACTER
	CPI	CTRLI
	JNZ	TRM16
	MVI	A,' '
TRM16:	CALL	TRMOT	;ECHO CHARACTER BACKED OVER
	MVI	B,1	;SET RUBOUT FLAG
	JMP	TRM1
;
TRM0:	CPI	' '	;SEE IF CONTROL CHARACTER
	JNC	TRM7
;
	CPI	CTRLI
	JZ	TRM7
;
	CPI	CTRLC
	JZ	ERR24	;RE-INITIALIZE MUMPS
;
	CPI	CTRLE
	JNZ	TRM2
	CALL	CRLF	;WRITE CR-LF
	JMP	TRM1
;
TRM2:	CPI	CTRLH
	JNZ	TRM3
	MOV	A,C	;SEE IF ROOM TO BACK UP
	ORA	A
	JZ	TRM1
;
	CALL	WIPE	;WIPE OUT PREVIOUS CHARACTER
	DCX	H
	DCR	C
	JMP	TRM1
;
TRM3:	CPI	CTRLR
	JNZ	TRM4
	CALL	CRLF
	MVI	M,0	;MARK END OF BUFFER
	XCHG
	LXI	H,BDATA
	CALL	MSG	;WRITE OUT BUFFER
	XCHG
	JMP	TRM1
;
TRM4:	CPI	CTRLU
	JNZ	TRM5
	CALL	CRLF
	JMP	TRMIN	;START OVER
;
TRM5:	CPI	CTRLX
	JNZ	TRM61	;IGNORE OTHER CONTROL CHARACTERS
	MOV	A,C
	ORA	A	;SEE IF AT START
	JZ	TRM1
TRM6:	CALL	WIPE	;WIPEOUT PREVIOUS CHARACTER
	DCR	C
	JNZ	TRM6
	JMP	TRMIN
;
TRM61:	CPI	CTRLP
	JNZ	TRM1
	LDA	PTOGL
	XRI	1
	STA	PTOGL
	JMP	TRM1
;
TRM7:	MOV	E,A
	MOV	A,B	;CHECK RUBOUT FLAG
	ORA	A
	JZ	TRM8
;
	MVI	B,0	;RESET RUBOUT FLAG
	MVI	A,'\'
	CALL	TRMOT
TRM8:	MOV	A,E
	CPI	CTRLI	;SEE IF LS
	JNZ	TRM9
;
	MVI	A,' '
TRM9:	CALL	TRMOT	;ECHO CHARACTER
	INR	C
	MOV	M,E
	MVI	A,255
	CMP	C	;SEE IF BUFFER FULL
	JZ	TRM01	;IF SO GET OUT
	INX	H
	JMP	TRM1
;
;
TRMOT:	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	CALL	INCHK
	LDA	STOGL	;SEE IF WANT TO WAIT
	ORA	A
	JZ	TRMO1
	MVI	L,6	;WAIT FOR CHARACTER (ANY)
	CALL	BIOS
	XRA	A
	STA	STOGL	;RESET WAIT TOGGLE
TRMO1:	POP	PSW	;GET CHAR BACK
	PUSH	PSW
	MVI	L,9	;WRITE CHAR OUT
	MOV	C,A
	CALL	BIOS
;
	POP	PSW
	MOV	C,A
	LDA	PTOGL	;CHECK PRINT TOGGLE
	ORA	A
	JZ	TRMO2
;
	MVI	L,12
	CALL	BIOS
;
TRMO2:	POP	B
	POP	D
	POP	H
	RET
;
;
; THE START OF GLOBAL HANDLING ROUTINES
;
;
RECSE:	LHLD	GREC+1
	DAD	H	;* 2
	DAD	H	;* 4
	SHLD	GLFCB+33	;SET RANDOM RECORD NUMBER
	LXI	H,GLFCB+35
	MVI	M,0
	RET
;
;
GREED:	CALL	SSCHK
	CALL	RECSE
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	CALL	RDBLK
	RET
;
;
GWRIT:	CALL	SSCHK
	CALL	RECSE
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	CALL	WTBLK
	CALL	RECSE
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	CALL	WTBLK
	LXI	H,GLFCB
	SHLD	FCB
	LDA	GLBDR
	STA	DRIVE
	CALL	FCLOS
	RET
;
;
ALLOC:	LXI	H,0		;START AT BLOCK 0
	MVI	A,1
	STA	T1		;FIRST TIME THROUGH
	LDA	MAPSZ
	STA	TMPSZ
	LXI	D,0		;HOW FAR INTO THE BIT IS
ALL0:	SHLD	GREC+1
	XRA	A
	STA	GREC
	PUSH	H		;SAVE CURRENT BLOCK
	PUSH	D		;SAVE HOW FAR IN
	CALL	GREAD		;READ IN A MAP BLOCK
;
	LXI	B,BLKSZ		;LOAD BLOCK SIZE
	LHLD	GLBUF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG			;H,L HAS START OF BUFFER
	LDA	T1		;SEE IF FIRST BLOCK
	ORA	A
	JZ	ALL05		;IF NOT THE FIRST TIME IGNORE SKIP
	DCX	B		;SKIP OVER STARTING STUFF
	DCX	B
	DCX	B
	DCX	B
	LXI	D,GVLEN+SHTLN
	DAD	D
ALL05:	POP	D		;RESTORE HOW FAR IN
ALL1:	MOV	A,M
	ORA	A		;LOOK FOR NON-ZERO
	JNZ	ALL2		;(MEANS BLOCK AVAILABLE)
	INX	H
	INX	D		;INCREMENT WORD COUNT
	DCX	B		;DECREMENT SIZE LEFT
	MOV	A,C
	ORA	B		;SEE IF SIZE LEFT IS ZERO
	JZ	ALL15		;NO ROOM IN THIS BLOCK, TRY NEXT
	JMP	ALL1
ALL15:	LXI	H,TMPSZ
	DCR	M
	MOV	A,M
	ORA	A
	JZ	E37		;NO DISK ROOM
	XRA	A
	STA	T1		;ALREADY THROUGH ONCE
	POP	H		;RESTORE CURRENT BLOCK NUMBER
	INX	H
	JMP	ALL0
ALL2:	POP	B		;GET RID OF CURRENT BLOCK
	LXI	B,0
	XCHG
ALL3:	RLC			;GET WHICH BIT WITHIN THE WORD
	JC	ALL4
	INX	B
	JMP	ALL3
ALL4:	DAD	H		;NOW GET WHICH BIT THIS WAS
	DAD	H		;* 4
	DAD	H		;* 8
	DAD	B		;ADD IN THE BITS
	SHLD	GREC+1		;SET GREC
	XRA	A
	STA	GREC
	STC
	XCHG			;RESTORE LOCATION IN TABLE
	INR	C
ALL5:	RAR			;SET UP MASK
	DCR	C
	JNZ	ALL5
	CMA
	ANA	M		;RESET BIT IN MAP
	MOV	M,A
	LHLD	GLDRT		;MARK BUFFER DIRTY
	MVI	M,1
	RET
;
;
DEALL:	LHLD	GREC+1		;GET BLOCK # TO GIVE BACK
	PUSH	H		;SAVE CURRENT BLOCK
	LXI	B,32	;ADJUST FOR STUFF IN FIRS BLOCK
	DAD	B
	MOV	A,H	;GET WHICH BLOCK WE NEED TO READ IN
	ANI	0F0H
	RRC
	RRC
	RRC
	RRC
	PUSH	H	;SAVE H,L FOR A BEFORE PICTURE
	MOV	L,A	;THE BLOCK NUMBER
	MVI	H,0
	SHLD	GREC+1
	XRA	A
	STA	GREC
	CALL	GREAD
	POP	H	;RESTORE H,L NOW THAT WE HAVE THE BLOCK READ
	MOV	A,H
	ANI	0FH	;WIPE OUT BLOCK NUMBER
	MOV	H,A
	MOV	A,L	;GET LOW BYTE
	ANI	7	;GET LOW 3 BITSV
	MOV	E,A	;SAVE IT (BIT #)
	MVI	B,3	;# TO SHIFT
DEA1:	XRA	A	;CLEAR CARRY
	MOV	A,H	;ROTATE H,L SO IT HAS THE BYTE
	RAR
	MOV	H,A
	MOV	A,L
	RAR
	MOV	L,A
	DCR	B
	JNZ	DEA1
	XRA	A
	STC
	INR	E
DEA2:	RAR		;NOW SET UP MASK
	DCR	E
	JNZ	DEA2
	XCHG		;MOVE OFFSET TO D,E
	LHLD	GLBUF
	MOV	C,M
	INX	H
	MOV	B,M	;B,C HAS THE START OF THE BUFFER
	XCHG		;H,L AS OFFSET
	DAD	B
	ORA	M	;SET BIT IN MAP
	MOV	M,A
	LHLD	GLDRT	;BUFFER HAS CHANGED
	MVI	M,1
	POP	H	;RESTORE BLOCK # THAT WAS JUST WIPED OUT
	SHLD	GREC+1
	XRA	A
	STA	GREC
	CALL	GREAD	;MAKE THAT BLOCK CURRENT
	LHLD	GLBNO
	LXI	D,NIL
	CALL	SETD
	LHLD	GLDRT
	MVI	M,0
	RET
;
;
RDBLK:	MVI	L,READF
	JMP	BLKIO
WTBLK:	MVI	L,WRITF
BLKIO:	LDA	GLBDR
	INR	A
	STA	GLFCB
	MVI	B,4	;NUMBER OF SECTORS IN A BLOCK
BLK1:	MVI	C,DMAF
	PUSH	D
	PUSH	B
	PUSH	H
	CALL	BDOS	;SET DMA ADDRESS
	POP	H
	POP	B
	PUSH	B
	PUSH	H
	MVI	A,4
	CMP	B	;SEE IF FIRST TIME THROUGH
	MOV	A,L	;GET READ/WRITE FUNCTION NUMBER
	JNZ	BLK2	;JUMP IF NOT FIRST TIME
	ADI	13	;MAKE THE FUNCTION A RANDOM READ/WRITE
BLK2:	MOV	C,A	;SET THE FUNCTION IN C
	LXI	D,GLFCB
	CALL	BDOS	;DO THE READ/WRITE
	ORA	A
	JNZ	E39
	POP	H
	POP	B
	POP	D
	PUSH	H
	MVI	A,4
	CMP	B	;SEE IF FIRST TIME THROUGH
	JNZ	BLK3	;JUMP IF NOT FIRST TIME
	LXI	H,GLFCB+32
	INR	M	;INCREMENT RECORD COUNT SINCE RANDOMS DON'T
BLK3:	LXI	H,128	;GET NEXT SECTOR ADDRESS
	DAD	D
	XCHG
	POP	H
	DCR	B
	JNZ	BLK1
	RET
;
;
SERCH:	CALL	SSCHK	;SEARCH FOR NAMES (VIEW 3)
	MVI	A,TRUE
	STA	RESUL
;
	MVI	C,DMAF
	LXI	D,80H
	CALL	BDOS
;
	LXI	D,SRFCB
	LDA	RTDRV
	INR	A
	STAX	D	;SELECT DRIVE
;
	MVI	C,SERCF
	LDA	IT
	ADD	C
	MOV	C,A
	CALL	BDOS	;SEARCH FIRST OR NEXT (IT TAKES CARE OF IT)
;
	CPI	0FFH
	JNZ	SERC1
	MVI	A,FALSE
	STA	RESUL
	RET
;
SERC1:	LXI	H,80H
	ADD	A	; * 2
	ADD	A	; * 4
	ADD	A	; * 8
	ADD	A	; * 16
	ADD	A	; * 32
	MOV	E,A
	MVI	D,0
	DAD	D	; H,L TO FCB START
	INX	H	;H,L TO NAME START
	SHLD	PTR
	RET
;
;
FSEAR:	CALL	SSCHK
	CALL	FCBIT
	MVI	C,DMAF
	LXI	D,80H
	CALL	BDOS
	LHLD	FCB
	LDA	DRIVE
	INR	A
	MOV	M,A	;SELECT DRIVE
	XCHG
	MVI	C,SERCF
	CALL	BDOS
	INR	A
	JNZ	SEAR1
	STA	RESUL	;NO MATCH
	RET
SEAR1:	MVI	A,1	;A MATCH
	STA	RESUL
	RET
;
;
MAKE:	CALL	SSCHK
	LHLD	FCB
	LDA	DRIVE
	INR	A
	MOV	M,A	;SELECT DRIVE
	XCHG
	MVI	C,MAKEF
	CALL	BDOS
	INR	A
	RNZ
	JMP	E9	;DIRECTORY FULL
;
;
FWRIT:	CALL	SSCHK
	LHLD	BUFFR
	XCHG
	MVI	C,DMAF
	CALL	BDOS
	LHLD	FCB
	LDA	DRIVE
	INR	A
	MOV	M,A	;SELECT DRIVE
	MVI	B,5	;# OF RETRIES
FWRT1:	LHLD	FCB
	XCHG
	MVI	C,WRITF
	PUSH	B
	CALL	BDOS
	ORA	A
	POP	B
	RZ
	DCR	B
	JZ	E37	;WRITE ERROR
	MVI	L,15H	;HOME DRIVE
	CALL	BIOS
	JMP	FWRT1
	RET
;
;
FCLOS:	CALL	SSCHK
	LHLD	FCB
	LDA	DRIVE
	INR	A
	MOV	M,A	;SELECT DRIVE
	XCHG
	MVI	C,CLOSF
	CALL	BDOS
	RET
;
;
FOPEN:	CALL	SSCHK
	CALL	FCBIT	;SET UP FCB
FOPPL:	LHLD	FCB
	LDA	DRIVE
	INR	A
	MOV	M,A	;SELECT DRIVE
	XCHG
	MVI	C,OPENF
	CALL	BDOS
	INR	A
	RNZ
	LDA	FCBTY	;SEE IF ROUTINE OR GLOBAL
	ORA	A
	JNZ	E38	;ROUTINE NOT IN LIBRARY
	JMP	E37	;NO GLOBALS
;
;
FREAD:	CALL	SSCHK
	LHLD	BUFFR
	XCHG
	MVI	C,DMAF
	CALL	BDOS
	LHLD	FCB
	LDA	DRIVE
	INR	A
	MOV	M,A	;SELECT DRIVE
	XCHG
	MVI	C,READF	;READ BUFFER FULL
	CALL	BDOS
	CPI	0	;NORMAL READ?
	RZ
	CPI	1	;EOF?
	RZ
	JMP	E39	;READ ERROR
;
;
REMOV:	CALL	SSCHK
	LHLD	FCB
	LDA	DRIVE
	INR	A
	MOV	M,A	;SELECT DRIVE
	XCHG
	MVI	C,REMF
	CALL	BDOS
	RET
;
;
BRK:	XRA	A	;SEE IF A CHARACTER IS THERE
	STA	I1
	CALL	SSCHK
	MVI	C,BRAKF
	CALL	BDOS
	RRC
	RNC
	MVI	A,1
	STA	I1
	RET
;
;
READC:	CALL	SSCHK	;READ A CHARACTER
	MVI	C,RD1F
	CALL	BDOS
	STA	CHR
	RET
;
;
FCBIT:	LDA	FCBTY	;SET UP FCB FROM NAME ON STACK
	ORA	A
	JNZ	FCBA	;GLOBALS?
	LXI	H,GLFCB
	SHLD	FCB
	RET
FCBA:	CPI	1
	JNZ	FCBB	;ROUTINE?
	LXI	H,RTFCB
	JMP	FCB0
FCBB:	LHLD	DEVPM	;EXTERNAL
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
FCB0:	SHLD	FCB
	LHLD	TOS
	DCX	H
	MOV	C,M	;SIZE TO C
	MOV	A,C
	CMA
	MOV	E,A
	MVI	D,0FFH
	INX	D
	DAD	D
	SHLD	TOS	;TOS NOW BELOW NAME
	LHLD	FCB
	XCHG
	LHLD	TOS
	XRA	A
	STAX	D	;ZERO FIRST BYTE
	PUSH	D	;SAVE FCB PLACE
	INX	D
	MVI	B,11
	MVI	A,' '	;BLANK OUT NAME PLACE
FCBC:	STAX	D
	INX	D
	DCR	B
	JNZ	FCBC
	ORA	B	;SEE IF DONE
	JZ	FCBD
	MVI	B,21
	XRA	A
	JMP	FCBC
FCBD:	POP	D	;RESTORE FCB PLACE
	MVI	B,NAMLN-1
FCB1:	INX	D	;NAME TO FCB
	MOV	A,M
	CPI	'.'	;FILE TYPE?
	JZ	FCB2
	INX	H
	STAX	D
	DCR	C
	JZ	FCB3
	DCR	B
	JNZ	FCB1
	JMP	FCB3
FCB2:	INX	H	;SKIP .
	DCR	C
	PUSH	B
	MOV	C,B
	MVI	B,0
	XCHG
	DAD	B
	XCHG
	DCX	D
	POP	B
	MVI	B,3
	JMP	FCB1
FCB3:	LDA	FCBTY	;CHECK FCB TYPE
	CPI	2
	RZ
	MOV	C,B
	MVI	B,0
	XCHG
	DAD	B
	MVI	M,'M'
	INX	H
	MVI	M,'M'
	INX	H
	MVI	M,'P'
	RET
;
;
ASROU:	RET
;
;*************************************************************
;*
;*  INSERT ASSEMBLY LANGUAGE ROUTINES HERE
;*
;*************************************************************
;
;
PTR:	DB	0,0
PTR1:	DB	0,0
PTR2:	DB	0,0
PTR3:	DB	0,0
PTR4:	DB	0,0
PTR5:	DB	0,0
PTR6:	DB	0,0
PTR7:	DB	0,0
PTR8:	DB	0,0
PTR9:	DB	0,0
PTRA:	DB	0,0
PTRB:	DB	0,0
PTRX:	DB	0,0
PTRX1:	DB	0,0
PTRX2:	DB	0,0
PPTR2:	DB	0,0
PPTR4:	DB	0,0
SNMPT:	DB	0,0
SVLPT:	DB	0,0
SBSIZ:	DB	0,0
UBSZ:	DB	0,0
PT1:	DB	0,0
NAME:	DB	0,0
TNAME:	DB	0,0
TPP:	DB	0,0
TP1:	DB	0,0
VSZ:	DB	0,0
SETBS:	DB	0,0
TPTR:	DB	0,0
TTPTR:	DB	0,0
LAST:	DB	0,0
DP:	DB	0,0
AP:	DB	0,0
LPTR:	DB	0,0
SPTR:	DB	0,0
TOP:	DB	0,0
LOC:	DB	0,0
TGP:	DB	0,0
BSIZE:	DB	0,0
ADJ:	DB	0,0
GPTR:	DB	0,0
PLEN:	DB	0,0
NLEN:	DB	0,0
SDP:	DB	0,0
SSDP:	DB	0,0
SBOS:	DB	0,0
NSTOS:	DB	0,0
NEXTP:	DB	0,0
NLAST:	DB	0,0
NSIZE:	DB	0,0
NPTR:	DB	0,0
FCB:	DB	0,0
DEVOP:	DB	0,0
DEVRD:	DB	0,0
DEVPM:	DB	0,0
DEVX:	DB	0,0
DEVY:	DB	0,0
DVBSZ:	DB	0,0
DVBST:	DB	0,0
DVPTR:	DB	0,0
DVBSU:	DB	0,0
BUFFR:	DB	0,0
GLBNO:	DB	0,0
GLAGE:	DB	0,0
GLDRT:	DB	0,0
GLBUF:	DB	0,0
GLCNT:	DB	0,0
NMPTR:	DB	0,0
VLPTR:	DB	0,0
TRAIL:	DB	0,0
FPTR:	DB	0,0
TARPT:	DB	0,0
BASE:	DB	0,0
IPTR:	DB	0,0
VPTR:	DB	0,0
TOPTR:	DB	0,0
REM:	DB	0,0
BKPTR:	DB	0,0
GLBTA:	DB	0,0
DRBUF:	DB	0,0
USTAK:	DB	0,0
;
GREC:	DB	0,0,0
GRCC1:	DB	0,0,0
GRCC2:	DB	0,0,0
GRCC3:	DB	0,0,0
GRCC4:	DB	0,0,0
GRCX:	DB	0,0,0
GRCY:	DB	0,0,0
GRCZ:	DB	0,0,0
ROOT:	DB	0,0,0
GRECA:	DB	0,0,0
GRECB:	DB	0,0,0
GRECC:	DB	0,0,0
SGREC:	DB	0,0,0
TGREC:	DB	0,0,0
GRCXX:	DB	0,0,0
;
TIMF:	DB	0
GLOPN:	DB	0
TST:	DB	0
TST1:	DB	0
STCNT:	DB	0
NLENG:	DB	0
SLENG:	DB	0
CHR:	DB	0
STYPE:	DB	0
COUNT:	DB	0
COLD:	DB	0
SETF:	DB	0
SETSW:	DB	0
DT:	DB	0
FORFL:	DB	0
DJ:	DB	0
DN:	DB	0
DOR:	DB	0
KILF:	DB	0
GOTOF:	DB	0
ENDF:	DB	0
FNDF:	DB	0
GTYPE:	DB	0
GARL:	DB	0
RDF:	DB	0
INF:	DB	0
VF:	DB	0
PF:	DB	0
PATF:	DB	0
PLENG:	DB	0
GLB:	DB	0
TYPE:	DB	0
DSF:	DB	0
LEVEL:	DB	0
I:	DB	0
I1:	DB	0
I2:	DB	0
I3:	DB	0
I4:	DB	0
I5:	DB	0
I6:	DB	0
I7:	DB	0
I9:	DB	0
II:	DB	0
IT:	DB	0
ITX:	DB	0
N:	DB	0
CN:	DB	0
SN:	DB	0
TN:	DB	0
FNC:	DB	0
SCNT:	DB	0
SSCNT:	DB	0
SSUB:	DB	0
SDVC:	DB	0
NSUBS:	DB	0
NMSZ:	DB	0
NR:	DB	0
FLG1:	DB	0
IX:	DB	0
DMF:	DB	0
ST:	DB	0
SST:	DB	0
SSLEN:	DB	0
SKTR:	DB	0
SNAME:	DB	0
DRIVE:	DB	0
GLBDR:	DB	0
RTDRV:	DB	0
XTDRV:	DB	0
DEVNO:	DB	0
FCBTY:	DB	0
BUFNO:	DB	0
PASSU:	DB	0
UF:	DB	0
A47:	DB	0
DIF:	DB	0
SPLT:	DB	0
FRMKL:	DB	0
IXT:	DB	0
NX:	DB	0
I1X:	DB	0
I2X:	DB	0
I4X:	DB	0
LVAL:	DB	0
FSZ:	DB	0
ISZ:	DB	0
DP1:	DB	0
DP2:	DB	0
SGN1:	DB	0
SGN2:	DB	0
DFLAG:	DB	0
FCASE:	DB	0
PTOGL:	DB	0
STOGL:	DB	0
NUMBR:	DB	0
DELET:	DB	0
T1:	DB	0
MAPSZ:	DB	0
TMPSZ:	DB	0
SVACT:	DB	0
DRLNG:	DB	0
MODE:	DB	0
FRMDE:	DB	0
INN:	DB	0
;
NIL:	DB	0FFH,0FFH,0FFH
GZERO:	DB	0,0,0
;
INT1:	DB	0,0,0,0,0
INT2:	DB	0,0,0,0,0
INT3:	DB	0,0,0,0,0
;
IZERO:	DB	0,0,0,0,0
IONE:	DB	0,0,0,0,1
I127:	DB	0,0,0,1,27H
IMIN1:	DB	0F0H,0,0,0,1
IMIN2:	DB	0F0H,0,0,0,2
I255:	DB	0,0,0,2,55H
;
DAYS:	DB	0,0,0,0,0
SECS:	DB	0,0,0,0,0
;
OP1:	DS	14
OP2:	DS	14
TNUMB:	DS	14
SOP1:	DS	14
RTNUM:	DS	14
W:	DS	14
;
	DS	3	;ROOM FOR SIGN, INTEGER , AND DECIMAL
FREAL:	DS	14
	DS	3
RNDM:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,1
RNDML:	DB	0,0,0,0,0,0,0,0,23H,45H,67H,89H,87H,63H
RNMOD	EQU	12	;10**RNMOD IS RANDOM NUMBER MODULUS
;
TSTAK:	DS	60	;TEMPORARY SPLIT STACK
;
BLKSZ	EQU	512	;DISK BLOCK SIZE FOR GLOBALS
BLKSH	EQU	248	;MAX LENGTH OF GLOBAL ENTRY
BLKS2	EQU	256	;HALF OF BLOCK SIZE
OVRHD	EQU	15	;OVERHEAD IN EACH GLOBAL NODE
MAXNK	EQU	200	;MAX SIZE FOR NAKED VARIABLE
GBTSZ	EQU	7	;SIZE OF ENTRY IN GLOBAL BUFFER TABLE
DEVSZ	EQU	20	;SIZE OF DEVICE TABLE ENTRY
MAXAR	EQU	50	;MAX NUMBER OF BYTES IN ARGUMENT FOR ASSEM. ROUTINE
GVLEN	EQU	3	;DISK BLOCK POINTER SIZE
BUFSZ	EQU	128	;DISK BUFFER SIZE
MAXDV	EQU	4	;MAX DEVICE NUMBER
STRLN	EQU	255	;MAX STRING LENGTH
NAMLN	EQU	9	;MAX RECOGNIZABLE NAME LENGTH (+1 FOR DELIM)
MXLVL	EQU	20	;MAX NESTING LEVEL
SHTLN	EQU	1	;BYTE LENGTH OF SHORT NUMBER
PTRLN	EQU	2	;BYTE LENGTH OF POINTER
INTLN	EQU	5	;BYTE LENGTH OF INTEGER
BCDLN	EQU	14	;BYTE LENGTH OF BCD NUMBER
MAXDG	EQU	9	;MAX NUMBER OF SIGNIFICANT DIGITS
SYNLN	EQU	300	;SYNTAX STACK LENGTH (BYTES)
STKLN	EQU	500	;EXECUTION STACK LENGTH (BYTES)
EOL	EQU	0AH	;END OF LINE CHARACTER
EOI	EQU	0	;END OF INDIRECTION CHARACTER
PROMT	EQU	'>'	;PROMPT CHARACTER
LS	EQU	09H	;LINE START CHARACTER
EOR	EQU	0	;END OF ROUTINE CHARACTER
DELIM	EQU	0	;END OF STRING DELIMITER
TRUE	EQU	1
FALSE	EQU	0
CTRLC	EQU	03H	;CONTROL C
CTRLE	EQU	05H	;CONTROL E
CTRLH	EQU	08H	;CONTROL H
BS	EQU	08H	;BACK SPACE
CTRLI	EQU	09H	;TAB
CR	EQU	0DH	;CARRIAGE RETURN
LF	EQU	0AH	;LINE FEED
FF	EQU	0CH	;FORM FEED
CTRLP	EQU	10H	;CONTROL P
CTRLR	EQU	12H	;CONTROL R
CTRLS	EQU	13H	;CONTROL S
CTRLU	EQU	15H	;CONTROL U
CTRLX	EQU	18H	;CONTROL X
RUB	EQU	7FH	;RUBOUT
;
EOF	EQU	1AH	;DISK FILE END OF FILE
ESC	EQU	1BH	;ESCAPE CHARACTER
BOOT	EQU	0000
BDOS	EQU	0005H
RD1F	EQU	1
LISTF	EQU	5
BRAKF	EQU	11
SELCT	EQU	14
OPENF	EQU	15
CLOSF	EQU	16
SERCF	EQU	17
SERCN	EQU	18
REMF	EQU	19
READF	EQU	20
WRITF	EQU	21
MAKEF	EQU	22
DMAF	EQU	26
;
NULL	EQU	0000H
BLANK	EQU	' '
STRNG	EQU	1	;STRING BIT IN FLG1
NOTFL	EQU	2	;NOT FLAG BIT IN FLG1
DIRTY	EQU	4	;DIRTY BIT
BRAKE	EQU	8	;BREAK MODE BIT
;
INDIR	EQU	0
DIREC	EQU	1
;
;
PDATA	EQU	$
TOS:	DB	0,0	;TOP OF STACK
RESUL:	DB	0
CASE:	DB	0
ACTFL:	DB	0
TOKEN:	DB	0
INDX:	DB	0,0
LOCKS:	DB	0
INDFL:	DB	0
INDSW:	DB	0
DOSW:	DB	0
FORSW:	DB	0
FLAG:	DB	0
SSTK:	DB	0,0	;POINTER TO BASE OF SYNTAX STACK
XSTK:	DB	0,0	;POINTER TO BASE OF EXECUTION STACK
LBUFF:	DB	0,0	;POINTER TO START OF LINE EXECUTION BUFFER
IODVC:	DB	0
JOBNM:	DB	0
SWIF:	DB	0
PRG:	DS	NAMLN
PRGPT:	DB	0,0	;POINTER TO LINE BEING INTERPRETED
PRGAD:	DB	0,0	;POINTER TO START OF PROGRAM
PRGLS:	DB	0,0	;POINTER TO LINE BEFORE PRGPT
PRGEN:	DB	0,0	;POINTER TO END OF PROGRAM
SYMPT:	DB	0,0	;POINTER TO START OF SYMBOL TABLE
SYMEN:	DB	0,0	;POINTER TO LOWEST MEMORY IN SYMBOL TABLE
PTEND:	DB	0,0	;POINTER TO END OF PARTITION
PBIG:	DB	0FFH,0
;
BRKM:	DB	'B R E A K  ---  ',0
ZOROU:	DB	'ROUTINES ON ',0
ZOGLO:	DB	'GLOBALS ON ',0
SYSF:	DB	'SYSFILE',0
;
NREF:	DS	MAXNK
VAR:	DB	NAMLN
ARGPL:	DS	MAXAR	;ARGUMENT PASSING PLACE
DEVTA:	DB	1,2,0,0,0,0,0,0,0,0,0,0,255	;TERMINAL
	DW	0,BDATA,0
	DB	0
;
	DB	0,1,0,0,0,0,0,0,0,0,0,0,132	;PRINTER
	DW	0,PBUFF,0
	DB	0
;
	DB	0,2,0,0,0,0,0,0,0,0,0,0,128	;DISK #1
	DW	DFCB1,DBUF1,0
	DB	0
;
	DB	0,2,0,0,0,0,0,0,0,0,0,0,128	;DISK #2
	DW	DFCB2,DBUF2,0
	DB	0
;
	DB	0,2,0,0,0,0,0,0,0,0,0,0,128	;DISK #3
	DW	DFCB3,DBUF3,0
	DB	0
;
RTFCB:	DS	36
DFCB1:	DS	36
DFCB2:	DS	36
DFCB3:	DS	36
;
ERRMS:	DB	'ERR:   ',CR
;
SRFCB:	DB	0,'????????MMP',0,0,0,0
	DS	20
;
PBUFF:	DS	132
DBUF1:	DS	128
DBUF2:	DS	128
DBUF3:	DS	128
RTBUF:	DS	128
;
;
;
; CLOCK VARIABLES HERE
;
WAIT:	DB	0
TIME:	DB	0
DTIME:	DB	0,0,0,0,0
DOLH:	DS	11
CLK	EQU	20H
I60:	DB	0,0,0,0,60H
;
FREE	EQU	$
;
; THIS IS WHERE THE CLOCK STUFF GOES
;
;
; MOUNTAIN HARDWARE VERSION
	MVI	A,JMP		;SET UP ADDRESS FOR HANDLER
	STA	INTRPT
	LXI	H,TIMTK
	SHLD	INTRPT+1
;
;	MVI	A,14H
;	OUT	CLK+15		;INTERRUPT ON SECONDS
;	EI
;
; END MOUNTAIN HARDWARE VERSION
;
	JMP	MUMPS
;
INTRPT	EQU	8H		;INTERRUPT HANDLER
;
	END	100H		 
